/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.ontology.swing.CmsElementSwing;
import at.grid.ontology.swing.CmsPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;

public class CmsElementPanel
extends JPanel
implements CmsPanel {
    CmsElement element;
    private boolean readonly;
    private JPanel panelStandard;
    private JPanel panelMeta;
    private JTabbedPane tabPanel;
    private Map<String, JComponent> components;
    private PanelStyle style = new PanelStyle();

    public CmsElementPanel(CmsElement element) {
        this(element, false);
    }

    public CmsElementPanel(CmsElement element, Font fLabel, Font fText, Font fHeading) {
        this(element, false, fLabel, fText, fHeading);
    }

    public CmsElementPanel(CmsElement element, boolean readonly) {
        this(element, readonly, null, null, null);
    }

    public CmsElementPanel(CmsElement element, boolean readonly, Font fLabel, Font fText, Font fHeading) {
        this.element = element;
        this.readonly = readonly;
        this.components = new HashMap<String, JComponent>();
        if (fLabel != null) {
            this.style.fontLabel = fLabel;
        }
        if (fText != null) {
            this.style.fontText = fText;
        }
        if (fHeading != null) {
            this.style.fontHeading = fHeading;
        }
        this.initComponents();
        this.populatePanels();
    }

    public PanelStyle getPanelStyle() {
        return this.style;
    }

    private void initComponents() {
        this.removeAll();
        this.tabPanel = new JTabbedPane();
        JPanel tabPanelStandard = new JPanel();
        tabPanelStandard.setLayout(new BorderLayout());
        this.panelStandard = new JPanel();
        this.panelStandard.setBorder(new LineBorder(new Color(240, 240, 240), 10, true));
        tabPanelStandard.add((Component)this.panelStandard, "North");
        this.tabPanel.addTab("Standard", tabPanelStandard);
        if (this.element.getApplication().isShowMetadata()) {
            JPanel tabPanelMeta = new JPanel();
            tabPanelMeta.setLayout(new BorderLayout());
            this.panelMeta = new JPanel();
            this.panelMeta.setLayout(new GridBagLayout());
            tabPanelMeta.add((Component)this.panelMeta, "North");
            this.tabPanel.addTab("Meta", this.panelMeta);
        }
        this.setLayout(new BorderLayout());
        if (this.element.getApplication().isShowMetadata()) {
            this.add((Component)this.tabPanel, "First");
        } else {
            this.add((Component)this.panelStandard, "First");
        }
    }

    public void populatePanels() {
        GridBagLayout layoutStandard = this.createGridBagLayout();
        if (this.element.getApplication().isShowMetadata()) {
            GridBagLayout layoutMeta = this.createGridBagLayout();
            this.panelMeta.setLayout(layoutMeta);
            this.populateStandardPanel(this.panelMeta, layoutMeta, this.element.getMetaAttributes());
            this.panelMeta.setLayout(layoutStandard);
        }
        this.panelStandard.setLayout(layoutStandard);
        this.populateStandardPanel(this.panelStandard, layoutStandard, this.element.getDataAttributes());
    }

    private GridBagLayout createGridBagLayout() {
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{2};
        layout.rowHeights = new int[]{5};
        return layout;
    }

    private GridBagConstraints createGridBagConstraints(int x, int y, int width, int height) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = width;
        constraints.ipadx = 15;
        constraints.ipady = height;
        constraints.insets.set(3, 0, 3, 0);
        constraints.anchor = 18;
        return constraints;
    }

    private void populateStandardPanel(JPanel panel, GridBagLayout layout, ArrayList<CmsAttribute> atts) {
        int counter = 0;
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        for (CmsAttribute att : atts) {
            ThemisAttribute themisAtt = null;
            if (att.getParent().getElementcode().equals("locationtemplate") || att.getParent().getElementcode().equals("location")) {
                themisAtt = settings.getLocationAttribute(att.getCode());
            } else if (att.getParent().getElementcode().equals("observationtemplate") || att.getParent().getElementcode().equals("observation")) {
                themisAtt = settings.getObservationAttribute(att.getCode());
            }
            if (att.isHidden()) continue;
            String labelStr = att.getLabel();
            if (themisAtt != null) {
                labelStr = themisAtt.getLabel();
            }
            JLabel label = new JLabel(labelStr);
            int width = 1;
            if (att.isOfType(17)) {
                label.setFont(this.style.fontHeading);
                width = 2;
            } else {
                label.setFont(this.style.fontLabel);
            }
            panel.add((Component)label, this.createGridBagConstraints(0, counter, width, 15));
            int height = 15;
            JComponent comp = CmsElementSwing.getAttributeJComponent(att);
            if (comp != null) {
                comp.setFont(this.style.fontText);
                if (att.isReadonly() || !att.isShowEdit()) {
                    comp.setEnabled(false);
                }
            }
            if (att.isOfType(17) && comp != null) {
                comp.setFont(this.style.fontHeading);
            } else if (att.isOfType(13) && comp != null) {
                height = 40;
                ((JScrollPane)comp).getViewport().getView().setFont(this.style.fontText);
            } else if (comp != null) {
                comp.setFont(this.style.fontLabel);
            }
            if (comp == null) {
                comp = new JLabel("");
                comp.setFont(this.style.fontText);
            }
            panel.add((Component)comp, this.createGridBagConstraints(1, counter, 1, height));
            this.components.put(att.getCode(), comp);
            ++counter;
        }
    }

    public void updateElement() {
        CmsElementSwing.update(this.element, this);
    }

    public CmsElement getElement() {
        return this.element;
    }

    @Override
    public JComponent getComponent(Object caller, String attcode) {
        return this.components.get(attcode);
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public void postPopulate(CmsElement ele) {
    }

    @Override
    public void postUpdate(CmsElement ele) {
    }

    @Override
    public void updatePanel(CmsElement e) {
        this.element = e;
        this.initComponents();
        this.populatePanels();
    }

    public class PanelStyle {
        public Font fontHeading = new Font("Verdana", 1, 20);
        public Font fontLabel = new Font("Verdana", 0, 12);
        public Font fontText = new Font("Verdana", 0, 12);
        int componentHeight = 30;
    }
}

