/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing;

import at.grid.cms.attribute.BooleanAttribute;
import at.grid.cms.attribute.ButtonAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.attribute.FloatAttribute;
import at.grid.cms.attribute.IntegerAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.LongAttribute;
import at.grid.cms.attribute.MultikeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.TextAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.ElementUpdateListener;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.ontology.swing.ButtonAction;
import at.grid.ontology.swing.CmsElementDialog;
import at.grid.ontology.swing.CmsPanel;
import at.grid.ontology.swing.component.CmsListPanel;
import at.grid.ontology.swing.component.CmsRelationPanel;
import at.grid.ontology.swing.component.CmsSingleComboPanel;
import at.grid.ontology.swing.component.CmsSingleListPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;

public class CmsElementSwing {
    public static boolean showAsDialog(CmsElement e) {
        CmsElementDialog dlg = new CmsElementDialog(e, null, true);
        dlg.setVisible(true);
        return dlg.isSaved();
    }

    public static void update(CmsElement e, CmsPanel panel) {
        e.preUpdateElement();
        for (CmsAttribute att : e.getDataAttributes()) {
            JComponent comp = panel.getComponent(e, att.getCode());
            if (comp == null) continue;
            if (comp instanceof JScrollPane) {
                CmsElementSwing.setAttributeValue(att, (JComponent)((JScrollPane)comp).getViewport().getView());
                continue;
            }
            CmsElementSwing.setAttributeValue(att, comp);
        }
        panel.postUpdate(e);
        ((DateAttribute)e.getAttribute("meta_lastedit")).setDate(new Date());
        ((RelationAttribute)e.getAttribute("meta_lasteditby")).set((CmsElement)e.getCurrentUser());
        e.postUpdateElement();
        e.setSaved(false);
        for (ElementUpdateListener listener : e.getUpdateListener()) {
            listener.elementUpdated(e);
        }
    }

    public static void setAttributeValue(CmsAttribute a, JComponent component) {
        if (a.isReadonly()) {
            return;
        }
        switch (a.getType()) {
            case 1: {
                if (component instanceof JCheckBox) {
                    ((BooleanAttribute)a).setValue(((JCheckBox)component).isSelected());
                    break;
                }
                if (!(component instanceof JTextField)) break;
                ((BooleanAttribute)a).setValue("ok".equalsIgnoreCase(((JTextField)component).getText()));
                break;
            }
            case 2: {
                if (component instanceof JTextField) {
                    ((DateAttribute)a).setValue(((JTextField)component).getText());
                    break;
                }
                if (component instanceof JXDatePicker) {
                    ((DateAttribute)a).setDate(((JXDatePicker)component).getDate());
                    break;
                }
                throw new IllegalArgumentException("The provided component must be of type JTextField or JXDatePicker!");
            }
            case 3: {
                ((FloatAttribute)a).setValue(((JTextComponent)component).getText());
                break;
            }
            case 7: {
                ((IntegerAttribute)a).setValue(((JTextComponent)component).getText());
                break;
            }
            case 8: {
                if (component instanceof JComboBox) {
                    if (((JComboBox)component).getSelectedItem() == null) break;
                    ((KeyAttribute)a).setValue(((KeytableRecord)((JComboBox)component).getSelectedItem()).id);
                    break;
                }
                if (!(component instanceof JLabel)) break;
                String term = ((JLabel)component).getText();
                long newid = ((KeyAttribute)a).getKeytable().getIdByTerm(term, a.getParent().getCurrentUser().getCurrentLanguage());
                if (newid < 0L) {
                    ((KeyAttribute)a).setValue(term);
                    break;
                }
                ((KeyAttribute)a).setValue(newid);
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                ((LongAttribute)a).setValue(((JTextComponent)component).getText());
                break;
            }
            case 14: {
                List selected = new ArrayList<Object>();
                if (component instanceof CmsListPanel) {
                    return;
                }
                if (component instanceof CmsSingleListPanel) {
                    return;
                }
                if (component instanceof CmsSingleComboPanel) {
                    return;
                }
                if (component instanceof JList) {
                    ListModel m = ((JList)component).getModel();
                    for (int ii = 0; ii < m.getSize(); ++ii) {
                        selected.add(m.getElementAt(ii));
                    }
                } else if (component instanceof JComboBox) {
                    Object o = ((JComboBox)component).getSelectedItem();
                    if (o != null) {
                        selected.add(o);
                    }
                } else {
                    if (component instanceof JTextField) {
                        return;
                    }
                    if (component instanceof JLabel) {
                        return;
                    }
                    if (component instanceof CmsSingleComboPanel) {
                        ((RelationAttribute)a).set(((CmsSingleComboPanel)component).getSelectedElementId());
                        return;
                    }
                    if (component instanceof CmsListPanel) {
                        List sels = ((CmsListPanel)component).getSelection();
                        ((RelationAttribute)a).clear();
                        for (CmsElementSummary ele : sels) {
                            ((RelationAttribute)a).add(ele);
                        }
                    } else if (component instanceof CmsRelationPanel) {
                        selected = ((CmsRelationPanel)component).getSelection();
                    } else {
                        throw new IllegalArgumentException("The provided component must be of type JList or JComboBox!");
                    }
                }
                ArrayList<Long> newIds = new ArrayList<Long>();
                ArrayList<Long> keptIds = new ArrayList<Long>();
                List currentIds = ((RelationAttribute)a).getElementIds();
                for (Object o : selected) {
                    long id;
                    if (o instanceof CmsElement) {
                        id = ((CmsElement)o).getId();
                    } else if (o instanceof CmsBasicElement) {
                        id = ((CmsBasicElement)o).getId();
                    } else {
                        throw new IllegalArgumentException("The provided component model must be of type CmsElement or CmsBasicElement!");
                    }
                    if (currentIds.contains(id)) {
                        keptIds.add(id);
                        continue;
                    }
                    newIds.add(id);
                }
                Iterator iterator = currentIds.iterator();
                while (iterator.hasNext()) {
                    long currentId = (Long)iterator.next();
                    if (keptIds.contains(currentId)) continue;
                    ((RelationAttribute)a).delete(currentId);
                }
                iterator = newIds.iterator();
                while (iterator.hasNext()) {
                    long currentId = (Long)iterator.next();
                    if (currentId < 0L) continue;
                    ((RelationAttribute)a).add(currentId);
                }
                break;
            }
            case 17: {
                break;
            }
            case 12: {
                a.setValue(((JTextComponent)component).getText());
                break;
            }
            case 13: {
                a.setValue(((JTextComponent)component).getText());
                break;
            }
            case 15: {
                File f;
                if (component instanceof CmsListPanel || component instanceof CmsSingleListPanel) {
                    return;
                }
                ArrayList<UploadItem> listitems = new ArrayList<UploadItem>();
                if (component instanceof JList) {
                    ListModel m = ((JList)component).getModel();
                    int sz = m.getSize();
                    for (int ii = 0; ii < sz; ++ii) {
                        listitems.add((UploadItem)m.getElementAt(ii));
                    }
                } else if (component instanceof JTextField && (f = new File(((JTextField)component).getText())).exists()) {
                    UploadItem item = new UploadItem(a.getApplication(), f.getParentFile(), f.getName(), "", f.length(), new Date(), 2);
                    item.setAttributecode(a.getCode());
                    if (a.getParent() != null) {
                        item.setReference(a.getParent().getId(), a.getParent().getElementcode());
                    }
                    listitems.add(item);
                }
                ArrayList<Long> tobedeleted = new ArrayList<Long>();
                for (UploadItem item : ((UploadAttribute)a).getUploadItems()) {
                    if (listitems.contains(item)) continue;
                    tobedeleted.add(item.getId());
                }
                Iterator iterator = tobedeleted.iterator();
                while (iterator.hasNext()) {
                    long idDel = (Long)iterator.next();
                    ((UploadAttribute)a).deleteUpload(idDel);
                }
                for (UploadItem item : listitems) {
                    if (((UploadAttribute)a).getUploadItems().contains(item)) continue;
                    ((UploadAttribute)a).addUpload(item);
                }
                break;
            }
        }
    }

    public static JComponent getAttributeJComponent(CmsAttribute a, int height) {
        JComponent comp = CmsElementSwing.getAttributeJComponent(a);
        comp.setPreferredSize(new Dimension(200, height));
        comp.setMinimumSize(new Dimension(50, height));
        comp.setMaximumSize(new Dimension(1000, height));
        return comp;
    }

    public static JComponent getAttributeJComponent(CmsAttribute a) {
        switch (a.getType()) {
            case 1: {
                JCheckBox checkbox = new JCheckBox();
                checkbox.setSelected(((BooleanAttribute)a).isSet());
                return checkbox;
            }
            case 18: {
                String lbl = ((ButtonAttribute)a).getButtonText();
                JButton jcomp = new JButton(lbl);
                jcomp.setAction(new ButtonAction(a.getParent(), a.getCode()));
                jcomp.setText(lbl);
                return jcomp;
            }
            case 2: {
                JXDatePicker comp = new JXDatePicker();
                comp.setTimeZone(a.getApplication().getTimeZone());
                comp.setDate(((DateAttribute)a).getDate());
                return comp;
            }
            case 3: {
                return new JTextField(a.getValue());
            }
            case 7: {
                return new JTextField(a.getValue());
            }
            case 8: {
                Keytable tbl = ((KeyAttribute)a).getKeytable();
                long id = ((KeyAttribute)a).getId();
                JComboBox<Object> comboBox = new JComboBox<Object>(tbl.toList(a.getParent().getCurrentUser().getCurrentLanguage(), !a.isRequired()).toArray());
                if (id < 0L) {
                    comboBox.setSelectedIndex(0);
                } else {
                    comboBox.setSelectedItem(tbl.getRecord(id, a.getParent().getCurrentUser().getCurrentLanguage()));
                }
                return comboBox;
            }
            case 10: {
                Keytable tbl2 = ((MultikeyAttribute)a).getKeytable();
                ArrayList listData = tbl2.toList(a.getParent().getCurrentUser().getCurrentLanguage());
                JList<String> jlist = new JList<String>((String[])listData.toArray());
                jlist.setSelectionMode(2);
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (String value : ((MultikeyAttribute)a).getValues()) {
                    int idx = listData.indexOf(value);
                    indices.add(idx);
                }
                int[] ints = new int[indices.size()];
                int ii = 0;
                for (Integer i : indices) {
                    ints[ii] = i;
                    ++ii;
                }
                jlist.setSelectedIndices(ints);
                return jlist;
            }
            case 9: {
                return new JTextField(a.getValue());
            }
            case 22: {
                JTextField compCounter = new JTextField(a.getValue());
                compCounter.setEditable(false);
                return compCounter;
            }
            case 14: {
                if (a.isReadonly()) {
                    if (((RelationAttribute)a).isSingle() || ((RelationAttribute)a).isSizeOne()) {
                        JTextField compRel = new JTextField(((RelationAttribute)a).getFirstElementTitle());
                        compRel.setEditable(false);
                        return compRel;
                    }
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (CmsElementSummary e : ((RelationAttribute)a).getElements()) {
                        if (!first) {
                            sb.append("\n");
                        }
                        sb.append(e.getTitle());
                        first = false;
                    }
                    JTextArea compRel = new JTextArea(sb.toString());
                    compRel.setRows(5);
                    compRel.setEditable(false);
                    compRel.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)));
                    return compRel;
                }
                if (((RelationAttribute)a).isSingle() || ((RelationAttribute)a).isSizeOne()) {
                    return new CmsSingleComboPanel((RelationAttribute)a, ((RelationAttribute)a).getFirstElementId());
                }
                CmsRelationPanel compRel = new CmsRelationPanel((RelationAttribute)a);
                return compRel;
            }
            case 17: {
                if (a.getValue() != null && !"".equals(a.getValue())) {
                    JTextArea compSection = new JTextArea(a.getValue());
                    compSection.setLineWrap(true);
                    compSection.setWrapStyleWord(true);
                    compSection.setEditable(false);
                    return compSection;
                }
                return null;
            }
            case 12: {
                if (((TextAttribute)a).isPassword()) {
                    return new JPasswordField();
                }
                return new JTextField(a.getValue());
            }
            case 13: {
                JTextArea textArea = new JTextArea(a.getValue(), 5, 10);
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                JScrollPane scroll = new JScrollPane(textArea, 20, 30);
                return scroll;
            }
            case 15: {
                if (a.isReadonly()) {
                    if (((UploadAttribute)a).isSingle()) {
                        JTextField compUpload = new JTextField(((UploadAttribute)a).getFirstUploadItemName());
                        compUpload.setEditable(false);
                        return compUpload;
                    }
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (UploadItem item : ((UploadAttribute)a).getUploadItems()) {
                        if (!first) {
                            sb.append("\n");
                        }
                        sb.append(item.getName());
                        first = false;
                    }
                    JTextArea compUpload = new JTextArea(sb.toString());
                    compUpload.setRows(5);
                    compUpload.setEditable(false);
                    compUpload.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)));
                    return compUpload;
                }
                if (((UploadAttribute)a).isSingle()) {
                    CmsSingleListPanel compUpload = new CmsSingleListPanel((UploadAttribute)a, a.getApplication().getCurrentDir());
                    compUpload.setText(((UploadAttribute)a).getFirstUploadItemName());
                    return compUpload;
                }
                CmsListPanel compUpload = new CmsListPanel((UploadAttribute)a, a.getApplication().getCurrentDir());
                DefaultListModel model = compUpload.getModel();
                model.removeAllElements();
                for (UploadItem item : ((UploadAttribute)a).getUploadItems()) {
                    model.addElement(item);
                }
                return compUpload;
            }
        }
        return null;
    }

    public static ComboBoxModel getComboBoxModel(Keytable tbl, String lang, boolean withNoneOption, String noneOption) {
        DefaultComboBoxModel<KeytableRecord> m = new DefaultComboBoxModel<KeytableRecord>();
        KeytableRecord nosel = new KeytableRecord(-1L, noneOption, -1);
        if (withNoneOption) {
            m.addElement(nosel);
        }
        if (tbl.getTable().get(lang.toLowerCase()) != null) {
            for (KeytableRecord r : (ArrayList)tbl.getTable().get(lang.toLowerCase())) {
                m.addElement(r);
            }
        }
        if (withNoneOption) {
            m.setSelectedItem(nosel);
        }
        return m;
    }
}

