/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing.component;

import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElementSummary;
import at.grid.ontology.swing.CmsElementSwing;
import at.grid.ontology.swing.CmsRelationSearch;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class CmsListPanel
extends JPanel {
    public static final int UPLOAD = 1;
    public static final int RELATION = 2;
    private int type;
    DefaultListModel model = new DefaultListModel();
    UploadAttribute attUpload;
    RelationAttribute attRelation;
    File currentDir;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnSelect;
    private JButton btnShow;
    private JList list;
    private JScrollPane listPanel;

    public CmsListPanel(UploadAttribute att, File currentDir) {
        this.type = 1;
        this.attUpload = att;
        this.attRelation = null;
        this.currentDir = currentDir;
        this.initComponents();
        this.btnAdd.setVisible(false);
        this.setSize(this.getWidth(), 120);
        this.setPreferredSize(new Dimension(this.getWidth(), 120));
    }

    public CmsListPanel(RelationAttribute att, File currentDir) {
        this.type = 2;
        this.attRelation = att;
        this.attUpload = null;
        this.currentDir = currentDir;
        this.initComponents();
        if (att.isSingle()) {
            this.list.setVisibleRowCount(1);
            this.setSize(this.getWidth(), 20);
        } else {
            this.list.setVisibleRowCount(5);
            this.setSize(this.getWidth(), 60);
        }
    }

    public void setModel(DefaultListModel model) {
        this.model = model;
    }

    public DefaultListModel getModel() {
        return this.model;
    }

    public void addUpload(File f) {
        this.model.addElement(this.attUpload.addUpload(f));
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public List getSelection() {
        return this.list.getSelectedValuesList();
    }

    private void initComponents() {
        this.listPanel = new JScrollPane();
        this.list = new JList();
        this.btnRemove = new JButton();
        this.btnSelect = new JButton();
        this.btnAdd = new JButton();
        this.btnShow = new JButton();
        this.setPreferredSize(new Dimension(300, 70));
        this.setRequestFocusEnabled(false);
        this.list.setModel(this.model);
        this.list.setVisibleRowCount(5);
        this.listPanel.setViewportView(this.list);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/remove24.gif")));
        this.btnRemove.setIconTextGap(0);
        this.btnRemove.setMargin(new Insets(0, 0, 0, 0));
        this.btnRemove.setMaximumSize(new Dimension(26, 26));
        this.btnRemove.setMinimumSize(new Dimension(26, 26));
        this.btnRemove.setPreferredSize(new Dimension(26, 26));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsListPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.btnSelect.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/list_select.gif")));
        this.btnSelect.setIconTextGap(0);
        this.btnSelect.setMargin(new Insets(0, 0, 0, 0));
        this.btnSelect.setMaximumSize(new Dimension(26, 26));
        this.btnSelect.setMinimumSize(new Dimension(26, 26));
        this.btnSelect.setPreferredSize(new Dimension(26, 26));
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsListPanel.this.btnSelectActionPerformed(evt);
            }
        });
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/add2_24.gif")));
        this.btnAdd.setIconTextGap(0);
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnAdd.setMaximumSize(new Dimension(26, 26));
        this.btnAdd.setMinimumSize(new Dimension(26, 26));
        this.btnAdd.setPreferredSize(new Dimension(26, 26));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsListPanel.this.btnAddActionPerformed(evt);
            }
        });
        this.btnShow.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/showRelatedElement.gif")));
        this.btnShow.setIconTextGap(0);
        this.btnShow.setMargin(new Insets(0, 0, 0, 0));
        this.btnShow.setMaximumSize(new Dimension(26, 26));
        this.btnShow.setMinimumSize(new Dimension(26, 26));
        this.btnShow.setPreferredSize(new Dimension(26, 26));
        this.btnShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsListPanel.this.btnShowActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.listPanel, -1, 256, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnRemove, -2, 20, -2).addComponent(this.btnShow, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnSelect, -2, 20, -2).addComponent(this.btnAdd, -2, 20, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnRemove, -2, 20, -2).addComponent(this.btnAdd, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnSelect, -2, 20, -2).addComponent(this.btnShow, -2, 20, -2))).addComponent(this.listPanel, GroupLayout.Alignment.TRAILING, -1, 112, Short.MAX_VALUE));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        for (Object o : this.list.getSelectedValues()) {
            if (this.type == 1) {
                this.attUpload.deleteUpload((UploadItem)o);
            } else if (this.type == 2) {
                this.attRelation.delete(((CmsElementSummary)o).getId());
            }
            this.model.removeElement(o);
        }
    }

    private void btnSelectActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            JFileChooser jfc = new JFileChooser(this.currentDir);
            jfc.setFileSelectionMode(0);
            jfc.showOpenDialog(this);
            File f = jfc.getSelectedFile();
            if (f != null) {
                this.model.addElement(this.attUpload.addUpload(f));
                this.attUpload.getParent().getApplication().setCurrentDir(f.getParentFile());
            }
        } else if (this.type == 2) {
            CmsRelationSearch dlg = new CmsRelationSearch(this, this.attRelation, null, true);
            dlg.setVisible(true);
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
    }

    private void btnShowActionPerformed(ActionEvent evt) {
        Object o = this.list.getSelectedValue();
        if (this.type != 1 && this.type == 2) {
            CmsElementSwing.showAsDialog(((CmsElementSummary)o).getElement());
        }
    }
}

