/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing.component;

import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class CmsRelationPanel
extends JPanel {
    DefaultListModel<CmsBasicElement> modelList = new DefaultListModel();
    DefaultComboBoxModel<CmsBasicElement> modelCombo = new DefaultComboBoxModel();
    RelationAttribute attRelation;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBox<CmsBasicElement> combo;
    private JList list;
    private JScrollPane listPanel;

    public CmsRelationPanel(RelationAttribute att) {
        this.attRelation = att;
        this.initComponents();
        if (att.isSingle()) {
            this.list.setVisibleRowCount(1);
            this.setSize(this.getWidth(), 20);
        } else {
            this.list.setVisibleRowCount(5);
            this.setSize(this.getWidth(), 60);
        }
        this.populate();
    }

    private void populate() {
        CmsSqlSearch s = new CmsSqlSearch(this.attRelation.getParent().getApplication(), this.attRelation.getParent().getCurrentUser());
        s.setElementtypes(this.attRelation.getElementtypes());
        s.addSelectTitle("meta_title");
        s.setSort(this.attRelation.getAutosort() != null ? this.attRelation.getAutosort() : "meta_title");
        SearchResult result = s.search();
        this.modelList.removeAllElements();
        this.modelCombo.removeAllElements();
        for (DataRecord r : result.getResult()) {
            CmsBasicElement ele = new CmsBasicElement(r);
            if (this.attRelation.contains(ele.getId())) {
                this.modelList.addElement(ele);
                continue;
            }
            this.modelCombo.addElement(ele);
        }
    }

    public List getSelection() {
        return Collections.list(this.modelList.elements());
    }

    private void initComponents() {
        this.listPanel = new JScrollPane();
        this.list = new JList();
        this.btnRemove = new JButton();
        this.btnAdd = new JButton();
        this.combo = new JComboBox();
        this.setPreferredSize(new Dimension(300, 70));
        this.setRequestFocusEnabled(false);
        this.list.setModel(this.modelList);
        this.list.setVisibleRowCount(5);
        this.listPanel.setViewportView(this.list);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/remove24.gif")));
        this.btnRemove.setIconTextGap(0);
        this.btnRemove.setMargin(new Insets(0, 0, 0, 0));
        this.btnRemove.setMaximumSize(new Dimension(26, 26));
        this.btnRemove.setMinimumSize(new Dimension(26, 26));
        this.btnRemove.setPreferredSize(new Dimension(26, 26));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsRelationPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/add2_24.gif")));
        this.btnAdd.setIconTextGap(0);
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnAdd.setMaximumSize(new Dimension(26, 26));
        this.btnAdd.setMinimumSize(new Dimension(26, 26));
        this.btnAdd.setPreferredSize(new Dimension(26, 26));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsRelationPanel.this.btnAddActionPerformed(evt);
            }
        });
        this.combo.setModel(this.modelCombo);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.combo, 0, -1, Short.MAX_VALUE).addComponent(this.listPanel, -1, 267, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRemove, GroupLayout.Alignment.TRAILING, -2, 20, -2).addComponent(this.btnAdd, GroupLayout.Alignment.TRAILING, -2, 20, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.combo, -2, -1, -2).addComponent(this.btnAdd, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.listPanel, -1, 103, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnRemove, -2, 20, -2)))));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        List items = this.list.getSelectedValuesList();
        for (Object o : items) {
            this.attRelation.delete(((CmsBasicElement)o).getId());
            this.modelList.removeElement((CmsBasicElement)o);
            this.modelCombo.addElement((CmsBasicElement)o);
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        CmsBasicElement ele = (CmsBasicElement)this.combo.getSelectedItem();
        if (ele != null) {
            this.attRelation.add(ele.getId());
            this.modelCombo.removeElement(ele);
            this.modelList.addElement(ele);
        }
    }
}

