/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing.component;

import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.file.FileExtensionFilter;
import at.grid.ontology.swing.CmsRelationSearch;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class CmsSingleListPanel
extends JPanel {
    public static final int UPLOAD = 1;
    public static final int RELATION = 2;
    private int type;
    UploadAttribute attUpload;
    RelationAttribute attRelation;
    File currentDir;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnSelect;
    private JTextField fldItem;

    public CmsSingleListPanel(UploadAttribute att, File currentDir) {
        this.type = 1;
        this.attUpload = att;
        this.attRelation = null;
        this.currentDir = currentDir;
        this.initComponents();
        this.btnAdd.setVisible(false);
        if (att.isRequired()) {
            this.btnRemove.setVisible(false);
        }
    }

    public CmsSingleListPanel(RelationAttribute att, File currentDir) {
        this.type = 2;
        this.attRelation = att;
        this.attUpload = null;
        this.currentDir = currentDir;
        this.initComponents();
    }

    public void setText(String t) {
        this.fldItem.setText(t);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    private void initComponents() {
        this.btnRemove = new JButton();
        this.btnSelect = new JButton();
        this.btnAdd = new JButton();
        this.fldItem = new JTextField();
        this.setPreferredSize(new Dimension(300, 20));
        this.setRequestFocusEnabled(false);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/list_remove.gif")));
        this.btnRemove.setIconTextGap(0);
        this.btnRemove.setMargin(new Insets(0, 0, 0, 0));
        this.btnRemove.setMaximumSize(new Dimension(26, 26));
        this.btnRemove.setMinimumSize(new Dimension(26, 26));
        this.btnRemove.setPreferredSize(new Dimension(26, 26));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsSingleListPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.btnSelect.setText("Auswahl");
        this.btnSelect.setIconTextGap(0);
        this.btnSelect.setMargin(new Insets(0, 0, 0, 0));
        this.btnSelect.setMaximumSize(new Dimension(26, 26));
        this.btnSelect.setMinimumSize(new Dimension(26, 26));
        this.btnSelect.setPreferredSize(new Dimension(26, 26));
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsSingleListPanel.this.btnSelectActionPerformed(evt);
            }
        });
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/list_add.gif")));
        this.btnAdd.setIconTextGap(0);
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnAdd.setMaximumSize(new Dimension(26, 26));
        this.btnAdd.setMinimumSize(new Dimension(26, 26));
        this.btnAdd.setPreferredSize(new Dimension(26, 26));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CmsSingleListPanel.this.btnAddActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fldItem, -1, 211, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAdd, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelect, -2, 45, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSelect, -2, 20, -2).addComponent(this.btnAdd, -2, 20, -2).addComponent(this.btnRemove, -2, 20, -2).addComponent(this.fldItem, -2, -1, -2));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.fldItem.setText("");
        if (this.type == 1) {
            this.attUpload.clear();
        } else if (this.type == 2) {
            this.attRelation.clear();
        }
    }

    private void btnSelectActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            JFileChooser jfc = new JFileChooser(this.currentDir);
            jfc.setFileSelectionMode(0);
            if (this.attUpload.getExtensions() != null) {
                FileExtensionFilter filter = new FileExtensionFilter(this.attUpload.getExtensions(), this.attUpload.getExtensionDescription());
                jfc.setFileFilter((FileFilter)filter);
            }
            jfc.showOpenDialog(this);
            File f = jfc.getSelectedFile();
            if (f != null) {
                this.fldItem.setText(this.attUpload.addUpload(f).getName());
                this.attUpload.getParent().getApplication().setCurrentDir(f.getParentFile());
            }
        } else if (this.type == 2) {
            CmsRelationSearch dlg = new CmsRelationSearch(this, this.attRelation, null, true);
            dlg.setVisible(true);
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
    }
}

