/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing.component;

import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.element.CmsElement;
import at.grid.cms.storage.DataRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KeytablePanel
extends JPanel {
    DefaultListModel<KeytableRecord> modelRecords = new DefaultListModel();
    DefaultComboBoxModel<String> modelLanguage = new DefaultComboBoxModel();
    Keytable table;
    String language;
    public static Font fontList = new Font("Verdana", 0, 12);
    public static Font fontLabelItalic = new Font("Verdana", 2, 11);
    private JButton btnAddMany;
    private JButton btnDown;
    private JButton btnOk;
    private JButton btnRemove;
    private JButton btnUp;
    private JTextArea fldAddMany;
    private JTextField fldColor;
    private JComboBox fldLanguage;
    private JTextField fldText;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblLanguage;
    private JList list;

    public KeytablePanel(Keytable tbl, String language) {
        this.table = tbl;
        this.language = language;
        this.initComponents();
        ArrayList langs = this.table.getLanguages();
        if (langs.size() > 1) {
            for (String lang : langs) {
                this.modelLanguage.addElement(lang);
            }
            this.fldLanguage.setModel(this.modelLanguage);
            this.fldLanguage.setSelectedItem(language);
        } else {
            this.fldLanguage.setVisible(false);
            this.lblLanguage.setVisible(false);
        }
        if (this.table != null) {
            this.updateRecords();
        }
    }

    public KeytablePanel() {
        this.initComponents();
        this.fldLanguage.setVisible(false);
        this.lblLanguage.setVisible(false);
    }

    public void enableAddEntryButton(Boolean enable) {
        this.btnAddMany.setEnabled(enable);
    }

    public void enableComponents(boolean enable) {
        for (Component c : this.getComponents()) {
            c.setEnabled(enable);
        }
    }

    private void enableComponents() {
        if (!this.modelRecords.isEmpty()) {
            this.btnAddMany.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.fldText.setEnabled(true);
            this.btnOk.setEnabled(true);
            if (this.modelRecords.getSize() > 1) {
                this.btnUp.setEnabled(true);
                this.btnDown.setEnabled(true);
            } else {
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(false);
            }
        } else {
            this.enableComponents(false);
            this.btnAddMany.setEnabled(true);
        }
    }

    private void updateRecords() {
        this.updateRecords(-1L);
    }

    private void updateRecords(long id) {
        ArrayList recs = (ArrayList)this.table.getTable().get(this.language);
        this.modelRecords = new DefaultListModel();
        KeytableRecord selection = null;
        if (recs != null) {
            for (KeytableRecord rec : recs) {
                this.modelRecords.addElement(rec);
                if (rec.id != id) continue;
                selection = rec;
            }
        }
        this.list.setModel(this.modelRecords);
        if (!this.modelRecords.isEmpty()) {
            if (selection == null) {
                this.list.setSelectedIndex(0);
            } else {
                this.list.setSelectedValue(selection, true);
            }
        }
        this.list.revalidate();
        this.list.repaint();
    }

    private void applyKeytableTerm() {
        KeytableRecord oldTerm = (KeytableRecord)this.list.getSelectedValue();
        int idx = this.list.getSelectedIndex();
        String term = this.fldText.getText();
        if ("".equals(term) || term == null) {
            JOptionPane.showMessageDialog(this, "Ein Eintrag muss einen Namen haben", "Information", 1);
            return;
        }
        this.table.getRecord((long)oldTerm.id, (String)this.language).term = term;
        this.updateRecords();
        this.list.setSelectedIndex(idx);
        this.saveTable();
    }

    public void showKeyTable(Keytable tbl, String language) {
        this.table = tbl;
        this.language = language;
        this.updateRecords();
        this.fldAddMany.setText("");
    }

    public void clear() {
        this.table = null;
        this.modelRecords.clear();
        this.updateRecords();
    }

    public void saveTable() {
        this.table.save();
    }

    protected void setColor() {
        KeytableRecord rec = (KeytableRecord)this.list.getSelectedValue();
        if (rec == null) {
            return;
        }
        Color c = JColorChooser.showDialog(this, "Farbauswahl", null);
        if (c != null) {
            this.fldColor.setBackground(c);
            rec.color = c.getRGB();
            this.table.save();
        }
    }

    private void initComponents() {
        this.lblLanguage = new JLabel();
        this.fldLanguage = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.btnRemove = new JButton();
        this.btnUp = new JButton();
        this.btnDown = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.fldText = new JTextField();
        this.btnOk = new JButton();
        this.jLabel6 = new JLabel();
        this.fldColor = new JTextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.fldAddMany = new JTextArea();
        this.btnAddMany = new JButton();
        this.setMinimumSize(new Dimension(150, 200));
        this.setLayout(new GridBagLayout());
        this.lblLanguage.setText("Sprache");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblLanguage, gridBagConstraints);
        this.fldLanguage.setFont(fontList);
        this.fldLanguage.setModel(this.modelLanguage);
        this.fldLanguage.setMinimumSize(new Dimension(100, 30));
        this.fldLanguage.setPreferredSize(new Dimension(100, 30));
        this.fldLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                KeytablePanel.this.fldLanguageItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldLanguage, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Bestehende Eintr\u00e4ge");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.list.setFont(fontList);
        this.list.setModel(this.modelRecords);
        this.list.setMinimumSize(new Dimension(125, 125));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                KeytablePanel.this.listValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/remove.gif")));
        this.btnRemove.setToolTipText("Eintrag l\u00f6schen\n");
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setContentAreaFilled(false);
        this.btnRemove.setMinimumSize(new Dimension(30, 30));
        this.btnRemove.setPreferredSize(new Dimension(30, 30));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/arrow_up24.gif")));
        this.btnUp.setToolTipText("");
        this.btnUp.setBorder(new SoftBevelBorder(0));
        this.btnUp.setContentAreaFilled(false);
        this.btnUp.setMinimumSize(new Dimension(30, 30));
        this.btnUp.setPreferredSize(new Dimension(30, 30));
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.btnUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnUp, gridBagConstraints);
        this.btnDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/arrow_down24.gif")));
        this.btnDown.setToolTipText("");
        this.btnDown.setBorder(new SoftBevelBorder(0));
        this.btnDown.setContentAreaFilled(false);
        this.btnDown.setMinimumSize(new Dimension(30, 30));
        this.btnDown.setPreferredSize(new Dimension(30, 30));
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.btnDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Bearbeiten");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fldText.setFont(fontList);
        this.fldText.setMinimumSize(new Dimension(100, 30));
        this.fldText.setPreferredSize(new Dimension(100, 30));
        this.fldText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.fldTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldText, gridBagConstraints);
        this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/confirm24.gif")));
        this.btnOk.setToolTipText("");
        this.btnOk.setBorder(new SoftBevelBorder(0));
        this.btnOk.setContentAreaFilled(false);
        this.btnOk.setMinimumSize(new Dimension(30, 30));
        this.btnOk.setPreferredSize(new Dimension(30, 30));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.btnOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnOk, gridBagConstraints);
        this.jLabel6.setText("Hintergrundfarbe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.fldColor.setEditable(false);
        this.fldColor.setBackground(new Color(255, 255, 255));
        this.fldColor.setBorder(BorderFactory.createBevelBorder(0));
        this.fldColor.setMaximumSize(new Dimension(30, 30));
        this.fldColor.setMinimumSize(new Dimension(100, 30));
        this.fldColor.setPreferredSize(new Dimension(100, 30));
        this.fldColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                KeytablePanel.this.fldColorMouseClicked(evt);
            }
        });
        this.fldColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.fldColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 5);
        this.add((Component)this.fldColor, gridBagConstraints);
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Neue Eintr\u00e4ge hinzuf\u00fcgen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.fldAddMany.setColumns(20);
        this.fldAddMany.setFont(fontList);
        this.fldAddMany.setRows(5);
        this.jScrollPane2.setViewportView(this.fldAddMany);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.btnAddMany.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/ontology/swing/media/add2_24.gif")));
        this.btnAddMany.setToolTipText("");
        this.btnAddMany.setBorder(new SoftBevelBorder(0));
        this.btnAddMany.setContentAreaFilled(false);
        this.btnAddMany.setMinimumSize(new Dimension(30, 30));
        this.btnAddMany.setPreferredSize(new Dimension(30, 30));
        this.btnAddMany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeytablePanel.this.btnAddManyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnAddMany, gridBagConstraints);
    }

    private void fldLanguageItemStateChanged(ItemEvent evt) {
        this.language = (String)this.fldLanguage.getSelectedItem();
        this.updateRecords();
    }

    private void listValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            KeytableRecord rec = (KeytableRecord)this.list.getSelectedValue();
            this.fldText.setText(rec == null ? "" : rec.term);
            if (rec != null && rec.color != null) {
                this.fldColor.setBackground(new Color(rec.color));
            } else {
                this.fldColor.setBackground(Color.WHITE);
            }
            this.enableComponents();
        }
    }

    private void fldTextActionPerformed(ActionEvent evt) {
        this.applyKeytableTerm();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.applyKeytableTerm();
    }

    private void btnUpActionPerformed(ActionEvent evt) {
        KeytableRecord rec = (KeytableRecord)this.list.getSelectedValue();
        this.table.moveUp(rec.id);
        this.saveTable();
        this.updateRecords(rec.id);
    }

    private void btnDownActionPerformed(ActionEvent evt) {
        KeytableRecord rec = (KeytableRecord)this.list.getSelectedValue();
        this.table.moveDown(rec.id);
        this.saveTable();
        this.updateRecords(rec.id);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        ArrayList removeItems = (ArrayList)this.list.getSelectedValuesList();
        ArrayList elementtypes = this.table.getApplication().getElementtypes();
        StringBuilder sb = new StringBuilder();
        for (String et : elementtypes) {
            CmsElement ele = this.table.getApplication().getDefaultElement(et);
            String eleName = ele.getName();
            int occurence = 0;
            for (KeyAttribute att : ele.getKeyAttributes()) {
                if (!att.getCode().equals(this.table.getCode())) continue;
                String attfield = att.getField();
                String eletable = ele.getTablename();
                for (KeytableRecord removeItem : removeItems) {
                    DataRecord rec = this.table.getApplication().getDatastorage().executeQuery("SELECT count(idelement) AS count FROM " + eletable + " WHERE " + attfield + " = " + removeItem.id, true).firstRow();
                    occurence = Math.max(occurence, rec.getInt("count"));
                }
            }
            if (occurence <= 0) continue;
            sb.append("\n- ").append(eleName).append(": ").append(Integer.toString(occurence)).append("x");
        }
        if (sb.length() > 0) {
            sb.insert(0, "\nEin Eintrag wird bereits verwendet:");
        }
        Object[] options = new String[]{"Ja", "Nein"};
        int option = -1;
        if (removeItems.size() == 1) {
            option = JOptionPane.showOptionDialog(null, "Soll der Eintrag\n'" + ((KeytableRecord)removeItems.get((int)0)).term + "'\ngel\u00f6scht werden?" + sb.toString(), "Eintrag l\u00f6schen", -1, 3, null, options, options[0]);
        } else if (removeItems.size() > 1) {
            option = JOptionPane.showOptionDialog(null, "Sollen die ausgew\u00e4hlten Eintr\u00e4ge gel\u00f6scht werden?", "Eintr\u00e4ge l\u00f6schen", -1, 3, null, options, options[0]);
        }
        if (option == 0) {
            for (KeytableRecord removeItem : removeItems) {
                this.table.remove(removeItem.id);
                this.updateRecords();
                this.saveTable();
            }
        }
    }

    private void btnAddManyActionPerformed(ActionEvent evt) {
        String[] lines;
        if ("".equals(this.fldAddMany.getText())) {
            return;
        }
        String input = this.fldAddMany.getText();
        for (String line : lines = input.split("\n")) {
            long newid = this.table.createNewId();
            this.table.addTerm(newid, this.language, line);
            this.updateRecords(newid);
        }
        this.saveTable();
        this.fldAddMany.setText("");
    }

    private void fldColorMouseClicked(MouseEvent evt) {
        this.setColor();
    }

    private void fldColorActionPerformed(ActionEvent evt) {
        this.setColor();
    }
}

