/*
 * Decompiled with CFR 0.152.
 */
package at.grid.ontology.swing.search;

import at.grid.cms.search.depricated.CmsSearchCore;
import at.grid.cms.storage.DataRecord;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SwingSearchResult
extends JPanel {
    private boolean DEBUG = false;

    public SwingSearchResult(CmsSearchCore search) {
        super(new GridLayout(1, 0));
        String[] cols = search.getTableCols();
        Object[] columnNames = search.getTableColHeaders();
        int rowcount = 0;
        Object[][] data = new Object[search.size()][cols.length];
        while (search.hasNextRow()) {
            DataRecord record = search.nextRow();
            for (int ii = 0; ii < cols.length; ++ii) {
                data[rowcount][ii] = record.get(cols[ii]);
            }
            ++rowcount;
        }
        final JTable table = new JTable(data, columnNames);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        table.setFillsViewportHeight(true);
        if (this.DEBUG) {
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingSearchResult.this.printDebugData(table);
                }
            });
        }
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
    }

    private void printDebugData(JTable table) {
        int numRows = table.getRowCount();
        int numCols = table.getColumnCount();
        TableModel model = table.getModel();
        System.out.println("Value of data: ");
        for (int i = 0; i < numRows; ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < numCols; ++j) {
                System.out.print("  " + model.getValueAt(i, j));
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }
}

