/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.libraries.LibrariesFxPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AboutPanel
extends JPanel {
    private JButton btnLizenzen;
    private JPanel jPanel1;
    private JLabel lblCopyright;
    private JLabel lblLizenzen;
    private JLabel lblLogo;
    private JLabel lblMail;
    private JLabel lblMail1;
    private JLabel lblPhone;
    private JLabel lblPhone1;
    private JLabel lblQRcode;
    private JLabel lblVersion;
    private JLabel lblWebsite;
    private JLabel lblWebsite1;

    public AboutPanel() {
        this.initComponents();
        this.populate();
    }

    private void populate() {
        Calendar cal = Calendar.getInstance(ThemisApplication.getInstance().getTimeZone(), ThemisApplication.getInstance().getLocale());
        cal.setTime(new Date());
        int y = cal.get(1);
        this.lblCopyright.setText("<html>Copyright &copy; 2010 - " + y + " THEMIS Software GmbH</html>");
        this.lblVersion.setText("THEMIS Version " + ThemisProject.VERSION);
        String url = "http://www.themis-software.com";
        this.lblWebsite.setText("<html><a href=\"http://www.themis-software.com\">www.themis-software.com</a></html>");
        this.lblWebsite.setCursor(new Cursor(12));
        this.lblWebsite.addMouseListener(this.getMouseListenerOpenURL("http://www.themis-software.com"));
        String urlMail = "mailto:info@themis-software.com?subject=THEMIS_6.1";
        this.lblMail.setText("<html><a href=\"http://www.themis-software.com\">info@themis-software.com</a></html>");
        this.lblMail.setCursor(new Cursor(12));
        this.lblMail.addMouseListener(this.getMouseListenerOpenURL("mailto:info@themis-software.com?subject=THEMIS_6.1"));
    }

    private MouseAdapter getMouseListenerOpenURL(final String url) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        };
    }

    private void initComponents() {
        this.lblLogo = new JLabel();
        this.lblQRcode = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblVersion = new JLabel();
        this.lblCopyright = new JLabel();
        this.lblPhone = new JLabel();
        this.lblPhone1 = new JLabel();
        this.lblMail1 = new JLabel();
        this.lblMail = new JLabel();
        this.lblWebsite1 = new JLabel();
        this.lblWebsite = new JLabel();
        this.lblLizenzen = new JLabel();
        this.btnLizenzen = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblLogo.setHorizontalAlignment(2);
        this.lblLogo.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/themis-logo-4c.png")));
        Mnemonics.setLocalizedText((JLabel)this.lblLogo, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblLogo.text"));
        this.lblLogo.setToolTipText(NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblLogo.toolTipText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(25, 25, 25, 25);
        this.add((Component)this.lblLogo, gridBagConstraints);
        this.lblQRcode.setHorizontalAlignment(4);
        this.lblQRcode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/themis_qrcode.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblQRcode, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblQRcode.text"));
        this.lblQRcode.setToolTipText(NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblQRcode.toolTipText"));
        this.lblQRcode.setMaximumSize(new Dimension(150, 150));
        this.lblQRcode.setMinimumSize(new Dimension(150, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblQRcode, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblVersion.setFont(THEMIS.fontSubheading);
        this.lblVersion.setForeground(new Color(174, 174, 174));
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblVersion.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblVersion, gridBagConstraints);
        this.lblCopyright.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblCopyright, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblCopyright.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblCopyright, gridBagConstraints);
        this.lblPhone.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblPhone, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblPhone.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblPhone, gridBagConstraints);
        this.lblPhone1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPhone1, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblPhone1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblPhone1, gridBagConstraints);
        this.lblMail1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblMail1, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblMail1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblMail1, gridBagConstraints);
        this.lblMail.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblMail, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblMail.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblMail, gridBagConstraints);
        this.lblWebsite1.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblWebsite1, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblWebsite1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblWebsite1, gridBagConstraints);
        this.lblWebsite.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblWebsite, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblWebsite.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblWebsite, gridBagConstraints);
        this.lblLizenzen.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLizenzen, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.lblLizenzen.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.jPanel1.add((Component)this.lblLizenzen, gridBagConstraints);
        this.btnLizenzen.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnLizenzen, (String)NbBundle.getMessage(AboutPanel.class, (String)"AboutPanel.btnLizenzen.text"));
        this.btnLizenzen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutPanel.this.btnLizenzenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 5, 5);
        this.jPanel1.add((Component)this.btnLizenzen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnLizenzenActionPerformed(ActionEvent evt) {
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("librariespanel", 960, 500).setParentFrame(THEMIS.getMainWindow());
        LibrariesFxPanel fx = new LibrariesFxPanel();
        fx.setCloseAction(() -> {
            dlg.close();
            return false;
        });
        dlg.setContent((Node)fx).show();
    }
}

