/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsCompany;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ContactPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    CmsCompany contact;
    private Dimension labelDimension = new Dimension(80, 30);
    JDialog dlg = null;
    boolean saved = false;
    private JButton btnCancel;
    private JButton btnSaveAndClsoe;
    private JTextField fldEmail;
    private JTextField fldName;
    private JTextField fldTel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane3;
    private JLabel lblEmail;
    private JLabel lblName;
    private JLabel lblTel;

    public ContactPanel(CmsCompany c) {
        if (c == null) {
            return;
        }
        this.contact = c;
        this.initComponents();
        this.populateContact();
        this.initialiseDialog();
    }

    private void populateContact() {
        if (this.project != null && this.project.isOpen()) {
            this.fldName.setText(this.contact.getAttributeValue("name"));
            this.fldEmail.setText(this.contact.getAttributeValue("email"));
            this.fldTel.setText(this.contact.getAttributeValue("tel"));
        } else {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
        }
    }

    private boolean saveContact() {
        if (this.project != null && this.project.isOpen()) {
            String title = this.fldName.getText();
            if (title == null || title.isEmpty()) {
                Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("contact.name-empty.text", this.app.getLocale()));
                return false;
            }
            this.contact.setAttributeValue("name", this.fldName.getText());
            this.contact.setAttributeValue("email", this.fldEmail.getText());
            this.contact.setAttributeValue("tel", this.fldTel.getText());
            this.contact.save();
            this.saved = true;
            this.project.createActionLog("contact_create", this.contact.getId(), "");
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.COMPANY_SAVED.from((Object)this, "contact saved after edit"));
            return true;
        }
        Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
        return false;
    }

    private void initialiseDialog() {
        if (this.project.isOpen() && this.project != null && this.contact != null) {
            String title = "Kontakt";
            this.dlg = THEMIS.createDialog(title, this, false, true);
            this.dlg.setVisible(true);
        } else {
            Dialogs.getInstance().showErrorDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this.lblEmail = new JLabel();
        this.fldEmail = new JTextField();
        this.lblTel = new JLabel();
        this.fldTel = new JTextField();
        this.jPanel2 = new JPanel();
        this.btnSaveAndClsoe = new JButton();
        this.btnCancel = new JButton();
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblName.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.lblName.text"));
        this.lblName.setPreferredSize(this.labelDimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.jPanel1.add((Component)this.lblName, gridBagConstraints);
        this.fldName.setFont(THEMIS.fontTextfield);
        this.fldName.setText(NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.fldName.text"));
        this.fldName.setPreferredSize(new Dimension(50, 30));
        this.fldName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                ContactPanel.this.fldNameInputMethodTextChanged(evt);
            }
        });
        this.fldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ContactPanel.this.fldNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldName, gridBagConstraints);
        this.lblEmail.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblEmail, (String)NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.lblEmail.text"));
        this.lblEmail.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.jPanel1.add((Component)this.lblEmail, gridBagConstraints);
        this.fldEmail.setFont(THEMIS.fontTextfield);
        this.fldEmail.setText(NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.fldEmail.text"));
        this.fldEmail.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldEmail, gridBagConstraints);
        this.lblTel.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblTel, (String)NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.lblTel.text"));
        this.lblTel.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 15);
        this.jPanel1.add((Component)this.lblTel, gridBagConstraints);
        this.fldTel.setFont(THEMIS.fontTextfield);
        this.fldTel.setText(NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.fldTel.text"));
        this.fldTel.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldTel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnSaveAndClsoe.setFont(THEMIS.fontButton);
        this.btnSaveAndClsoe.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAndClsoe, (String)NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.btnSaveAndClsoe.text"));
        this.btnSaveAndClsoe.setBorder(new SoftBevelBorder(0));
        this.btnSaveAndClsoe.setPreferredSize(new Dimension(190, 35));
        this.btnSaveAndClsoe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContactPanel.this.btnSaveAndClsoeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnSaveAndClsoe, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(ContactPanel.class, (String)"ContactPanel.btnCancel.text"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setPreferredSize(new Dimension(190, 35));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContactPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 467, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 229, Short.MAX_VALUE));
    }

    private void btnSaveAndClsoeActionPerformed(ActionEvent evt) {
        if (this.saveContact()) {
            this.dlg.dispose();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dlg.dispose();
    }

    private void fldNameInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldNameKeyReleased(KeyEvent evt) {
    }
}

