/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.SimpleActionWithReturn;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.themis.ontology.template.TemplateDescription;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateProjectPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File parentFolder;
    File templateFile;
    private JDialog dlg;
    private SimpleActionWithReturn createProjectAction;
    private ThemisFolder projectFolder;
    DefaultComboBoxModel<TemplateDescription> modelTemplate = new DefaultComboBoxModel();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    String forceUUID = null;
    private JButton btnCancel;
    private JButton btnCreate;
    private JButton btnSetProjectFolder;
    private JButton btnSetTemplate;
    private JTextField fldFolderName;
    private JTextArea fldProjectClient;
    private JTextField fldProjectFolder;
    private JTextArea fldProjectInfo;
    private JTextArea fldProjectLocation;
    private JTextField fldProjectNumber;
    private JTextField fldProjectTitle;
    private JTextField fldTemplate;
    private JComboBox<TemplateDescription> fldTemplateSource;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblFolderInfo;
    private JLabel lblTemplate;
    private JPanel panelTemplate;

    public CreateProjectPanel() {
        this((File)null);
    }

    public CreateProjectPanel(File projectRoot) {
        this.initComponents();
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.APP)) {
            this.panelTemplate.setVisible(false);
            this.lblTemplate.setVisible(false);
        } else {
            DemoPackManager demo = DemoPackManager.getInstance();
            this.project.getTemplateManger().readInternalTemplates();
            TemplateDescription noSource = TemplateDescription.createNoSource();
            this.modelTemplate.addElement(noSource);
            this.modelTemplate.addElement(TemplateDescription.createFileSource());
            for (TemplateDescription td : demo.getProjectTemplates()) {
                this.modelTemplate.addElement(td);
            }
            this.fldTemplateSource.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.fldTemplateSource.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (CreateProjectPanel.this.fldTemplateSource.getSelectedIndex() == 1) {
                            CreateProjectPanel.this.fldTemplate.setVisible(true);
                            CreateProjectPanel.this.btnSetTemplate.setVisible(true);
                        } else {
                            CreateProjectPanel.this.fldTemplate.setVisible(false);
                            CreateProjectPanel.this.btnSetTemplate.setVisible(false);
                        }
                        CreateProjectPanel.this.dlg.pack();
                        CreateProjectPanel.this.dlg.setVisible(true);
                    }
                }
            });
            this.fldTemplateSource.setSelectedIndex(0);
            this.fldTemplate.setVisible(false);
            this.btnSetTemplate.setVisible(false);
        }
        File f = projectRoot;
        if (f == null) {
            f = this.app.getSettings().getFolderOpenProject().getValue(true);
        }
        if (!Util.canWrite((File)f)) {
            f = null;
        }
        if (f != null && !ThemisProject.isProjectFolder((File)f) && f.isDirectory()) {
            this.parentFolder = f;
            this.fldProjectFolder.setText(f.getName());
        }
        this.templateFile = this.app.getPathTemplateLocationObservation();
        this.fldTemplate.setText(this.app.getPathTemplateLocationObservation().getName());
        THEMIS.removeUsualTabBehavior(this.fldProjectLocation);
        THEMIS.removeUsualTabBehavior(this.fldProjectInfo);
        THEMIS.removeUsualTabBehavior(this.fldProjectClient);
        new DropTarget(this.fldTemplate, new ThemisDropTargetListener(false, false){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent evt) {
                CreateProjectPanel.this.templateFile = f;
                CreateProjectPanel.this.fldTemplate.setText(f.getName());
                CreateProjectPanel.this.app.setPathTemplateLocationObservation(CreateProjectPanel.this.templateFile);
            }
        });
        this.checkProjectFolder(null);
    }

    public void populate(Properties props) {
        this.fldProjectTitle.setText(props.getProperty("projecttitle", ""));
        this.fldProjectNumber.setText(props.getProperty("projectnumber", ""));
        this.fldProjectClient.setText(props.getProperty("projectcustomer", ""));
        this.fldProjectInfo.setText(props.getProperty("projectinfo", ""));
        this.fldProjectLocation.setText(props.getProperty("projectlocation", ""));
    }

    public void setFordedUUID(String uuid) {
        this.forceUUID = uuid;
    }

    public String getForcedUUID() {
        return this.forceUUID;
    }

    public void setProjectFolder(ThemisFolder projectFolder) {
        this.projectFolder = projectFolder;
    }

    public ThemisFolder initialiseDialog(SimpleActionWithReturn createProjectAction) {
        this.createProjectAction = createProjectAction;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        this.dlg = THEMIS.createDialog(this.bundle.getString("CreateProjectPanel.createProject.text"), this, false, true);
        this.dlg.setVisible(true);
        return this.projectFolder;
    }

    public void setProjectFolder(File f) {
        if (ThemisProject.isProjectFolder((File)f)) {
            Dialogs.getInstance().showErrorDialog(MessageFormat.format(this.bundle.getString("CreateProjectPanel.isAlreadyProjectNotif.text"), f.getAbsolutePath()));
        } else if (f != null && f.isDirectory()) {
            this.parentFolder = f;
            this.fldProjectFolder.setText(f.getName());
            this.app.getSettings().getFolderOpenProject().setValue(f);
        } else if (f != null) {
            Dialogs.getInstance().showErrorDialog(this.bundle.getString("CreateProjectPanel.noValidDirectoryNotif.text"));
            f = this.app.getSettings().getFolderProjectRoot().getValue(true);
            if (f != null) {
                this.parentFolder = f;
                this.fldProjectFolder.setText(f.getName());
                this.app.getSettings().getFolderOpenProject().setValue(f);
            }
        }
        this.checkProjectFolder(f);
    }

    public boolean hasValidProjectFolder() {
        return this.checkProjectFolder(this.parentFolder);
    }

    private boolean checkProjectFolder(File f) {
        if (this.hasProjectFilename() && f != null) {
            File proj = new File(f, this.getProjectFilename());
            if (proj.exists()) {
                this.lblFolderInfo.setText(this.bundle.getString("CreateProjectPanel.unvalidAlreadyExistsNotif.text"));
                this.lblFolderInfo.setVisible(true);
                return false;
            }
            this.lblFolderInfo.setVisible(false);
            this.lblFolderInfo.setText("");
            return true;
        }
        if (this.hasProjectFilename()) {
            this.lblFolderInfo.setText(this.bundle.getString("CreateProjectPanel.directoryNotDefinedNotif.text"));
            this.lblFolderInfo.setVisible(true);
        } else {
            this.lblFolderInfo.setText(this.bundle.getString("CreateProjectPanel.missingFileName.text"));
            this.lblFolderInfo.setVisible(true);
        }
        return false;
    }

    public String getFolderInfo() {
        if (this.lblFolderInfo != null) {
            return this.lblFolderInfo.getText();
        }
        return "";
    }

    public File getProjectFolder() {
        if (this.hasProjectFilename() && this.parentFolder != null) {
            return new File(this.parentFolder, this.getProjectFilename());
        }
        return null;
    }

    public boolean hasProjectFilename() {
        return !"".equals(this.fldFolderName.getText());
    }

    public String getProjectFilename() {
        String t = this.fldFolderName.getText();
        t = t.replaceAll("/", "_");
        t = t.replaceAll("\\\\", "_");
        return t;
    }

    public String getProjectTitle() {
        return this.fldProjectTitle.getText();
    }

    public String getProjectClient() {
        return this.fldProjectClient.getText();
    }

    public String getProjectNumber() {
        return this.fldProjectNumber.getText();
    }

    public String getProjectInfo() {
        return this.fldProjectInfo.getText();
    }

    public String getProjectLocation() {
        return this.fldProjectLocation.getText();
    }

    public String getPathTemplateFile() {
        return this.fldTemplate.getText();
    }

    public File getTemplateFile() {
        switch (this.fldTemplateSource.getSelectedIndex()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.templateFile;
            }
        }
        TemplateDescription td = (TemplateDescription)this.fldTemplateSource.getSelectedItem();
        File tempFile = ThemisApplication.getInstance().getProject().getTempfileLocation();
        boolean success = td.saveToFile(tempFile);
        if (success) {
            String fn = td.file;
            if (fn.toLowerCase().endsWith(".zip")) {
                fn = Util.getFileNameWithoutExtension((File)new File(tempFile, td.file)) + ".xlsx";
            }
            return new File(tempFile, fn);
        }
        return null;
    }

    private void initComponents() {
        this.fldProjectNumber = new JTextField();
        this.jLabel8 = new JLabel();
        this.fldProjectTitle = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldProjectInfo = new JTextArea();
        this.lblTemplate = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.fldProjectFolder = new JTextField();
        this.btnSetProjectFolder = new JButton();
        this.jLabel14 = new JLabel();
        this.fldFolderName = new JTextField();
        this.lblFolderInfo = new JLabel();
        this.panelTemplate = new JPanel();
        this.fldTemplate = new JTextField();
        this.btnSetTemplate = new JButton();
        this.fldTemplateSource = new JComboBox();
        this.jLabel15 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.fldProjectLocation = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.fldProjectClient = new JTextArea();
        this.btnCancel = new JButton();
        this.btnCreate = new JButton();
        this.fldProjectNumber.setFont(THEMIS.fontTextfield);
        this.fldProjectNumber.setText(NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.fldProjectNumber.text"));
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel8.text"));
        this.fldProjectTitle.setFont(THEMIS.fontTextfield);
        this.fldProjectTitle.setText(NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.fldProjectTitle.text"));
        this.fldProjectTitle.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                CreateProjectPanel.this.fldProjectTitleInputMethodTextChanged(evt);
            }
        });
        this.fldProjectTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CreateProjectPanel.this.fldProjectTitleKeyReleased(evt);
            }
        });
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel7.text"));
        this.jLabel6.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel6.text"));
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel9.text"));
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel10.text"));
        this.fldProjectInfo.setColumns(20);
        this.fldProjectInfo.setFont(THEMIS.fontTextfield);
        this.fldProjectInfo.setLineWrap(true);
        this.fldProjectInfo.setRows(5);
        this.fldProjectInfo.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.fldProjectInfo);
        this.lblTemplate.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblTemplate, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.lblTemplate.text"));
        this.jLabel12.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel12.text"));
        this.jLabel13.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel13.text"));
        this.fldProjectFolder.setEditable(false);
        this.fldProjectFolder.setFont(THEMIS.fontTextfield);
        this.fldProjectFolder.setText(NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.fldProjectFolder.text"));
        this.btnSetProjectFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetProjectFolder, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.btnSetProjectFolder.text"));
        this.btnSetProjectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSetProjectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateProjectPanel.this.btnSetProjectFolderActionPerformed(evt);
            }
        });
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel14.text"));
        this.fldFolderName.setFont(THEMIS.fontTextfield);
        this.fldFolderName.setText(NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.fldFolderName.text"));
        this.fldFolderName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CreateProjectPanel.this.fldFolderNameFocusLost(evt);
            }
        });
        this.fldFolderName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                CreateProjectPanel.this.fldFolderNameInputMethodTextChanged(evt);
            }
        });
        this.fldFolderName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateProjectPanel.this.fldFolderNameActionPerformed(evt);
            }
        });
        this.fldFolderName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CreateProjectPanel.this.fldFolderNameKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                CreateProjectPanel.this.fldFolderNameKeyTyped(evt);
            }
        });
        this.lblFolderInfo.setFont(new Font("Tahoma", 1, 11));
        this.lblFolderInfo.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.lblFolderInfo, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.lblFolderInfo.text"));
        this.panelTemplate.setName("");
        this.fldTemplate.setFont(THEMIS.fontTextfield);
        this.fldTemplate.setText(NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.fldTemplate.text"));
        this.btnSetTemplate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetTemplate, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.btnSetTemplate.text"));
        this.btnSetTemplate.setBorder(new SoftBevelBorder(0));
        this.btnSetTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateProjectPanel.this.btnSetTemplateActionPerformed(evt);
            }
        });
        this.fldTemplateSource.setFont(THEMIS.fontList);
        this.fldTemplateSource.setModel(this.modelTemplate);
        GroupLayout panelTemplateLayout = new GroupLayout(this.panelTemplate);
        this.panelTemplate.setLayout(panelTemplateLayout);
        panelTemplateLayout.setHorizontalGroup(panelTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTemplateLayout.createSequentialGroup().addContainerGap().addGroup(panelTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldTemplateSource, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelTemplateLayout.createSequentialGroup().addComponent(this.fldTemplate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSetTemplate, -2, 69, -2))).addContainerGap()));
        panelTemplateLayout.setVerticalGroup(panelTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTemplateLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.fldTemplateSource, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelTemplateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldTemplate, -2, 30, -2).addComponent(this.btnSetTemplate, -2, 30, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel15.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.jLabel15.text"));
        this.fldProjectLocation.setColumns(20);
        this.fldProjectLocation.setFont(THEMIS.fontTextfield);
        this.fldProjectLocation.setLineWrap(true);
        this.fldProjectLocation.setRows(5);
        this.fldProjectLocation.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.fldProjectLocation);
        this.fldProjectClient.setColumns(20);
        this.fldProjectClient.setFont(THEMIS.fontTextfield);
        this.fldProjectClient.setLineWrap(true);
        this.fldProjectClient.setRows(5);
        this.fldProjectClient.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.fldProjectClient);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.btnCancel.text"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setPreferredSize(new Dimension(190, 35));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateProjectPanel.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnCreate.setFont(THEMIS.fontButton);
        this.btnCreate.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreate, (String)NbBundle.getMessage(CreateProjectPanel.class, (String)"CreateProjectPanel.btnCreate.text"));
        this.btnCreate.setBorder(new SoftBevelBorder(0));
        this.btnCreate.setPreferredSize(new Dimension(190, 35));
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateProjectPanel.this.btnCreateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.lblTemplate, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14, -2, 100, -2).addComponent(this.jLabel13, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldFolderName).addComponent(this.lblFolderInfo).addGroup(layout.createSequentialGroup().addComponent(this.fldProjectFolder, -2, 225, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSetProjectFolder, -2, 69, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addGap(222, 222, 222)).addComponent(this.panelTemplate, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel8, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel15, GroupLayout.Alignment.LEADING, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fldProjectNumber, GroupLayout.Alignment.LEADING, -2, 302, -2).addComponent(this.fldProjectTitle, GroupLayout.Alignment.LEADING, -2, 302, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2))).addGroup(layout.createSequentialGroup().addComponent(this.btnCreate, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnCancel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13, -2, 30, -2).addComponent(this.fldProjectFolder, -2, 30, -2).addComponent(this.btnSetProjectFolder, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14, -2, 30, -2).addComponent(this.fldFolderName, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFolderInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, 30, -2).addComponent(this.fldProjectTitle, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, -2, 30, -2).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, -1, -2).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9, -2, 30, -2).addComponent(this.fldProjectNumber, -2, 30, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel15, -2, 30, -2).addGap(65, 65, 65).addComponent(this.jLabel10)).addComponent(this.jScrollPane2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblTemplate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelTemplate, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnCancel, -1, -1, Short.MAX_VALUE).addComponent(this.btnCreate, -2, -1, -2)).addContainerGap()));
    }

    private void btnSetProjectFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.bundle.getString("CreateProjectPanel.chooseProjectDirectory.text"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, this.app.getSettings().getFolderOpenProject().getValue(true), null, null, null, false).getSelectedFile();
        if (f != null) {
            this.setProjectFolder(f);
        }
    }

    private void btnSetTemplateActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog(this.bundle.getString("CreateProjectPanel.loadTemplateFile.text"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getPathTemplateLocationObservation(), this.templateFile, new FileNameExtensionFilter("Projektvorlage", "xlsx", "themis"), null, false).getSelectedFile();
        if (f != null) {
            this.templateFile = f;
            this.fldTemplate.setText(f.getName());
            this.app.setPathTemplateLocationObservation(this.templateFile);
        }
    }

    private void fldFolderNameFocusLost(FocusEvent evt) {
        this.checkProjectFolder(this.parentFolder);
    }

    private void fldFolderNameActionPerformed(ActionEvent evt) {
        this.checkProjectFolder(this.parentFolder);
    }

    private void fldFolderNameInputMethodTextChanged(InputMethodEvent evt) {
        this.checkProjectFolder(this.parentFolder);
    }

    private void fldFolderNameKeyTyped(KeyEvent evt) {
    }

    private void fldFolderNameKeyReleased(KeyEvent evt) {
        this.checkProjectFolder(this.parentFolder);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dlg.dispose();
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        if (this.createProjectAction != null && this.createProjectAction.execute()) {
            this.dlg.dispose();
        }
    }

    private void fldProjectTitleInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldProjectTitleKeyReleased(KeyEvent evt) {
    }
}

