/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.swingx.JXDatePicker;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EventPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    CmsElement event;
    private Dimension labelDimension = new Dimension(130, 30);
    JDialog dlg = null;
    private JButton btnCancel;
    private JButton btnSaveAndClsoe;
    private JXDatePicker fldDate;
    private JTextArea fldDescription;
    private JTextField fldLocation;
    private JTextArea fldParticipants;
    private JTextField fldTime;
    private JTextField fldTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblDate;
    private JLabel lblDescription;
    private JLabel lblLocation;
    private JLabel lblParticipants;
    private JLabel lblTime;
    private JLabel lblTitle;
    private JPanel panelContacts;

    public EventPanel() {
        this.initComponents();
        this.fldDate.setFont(THEMIS.fontTextfield);
        THEMIS.removeUsualTabBehavior(this.fldDescription);
        THEMIS.removeUsualTabBehavior(this.fldParticipants);
    }

    public void createEvent() {
        this.createEvent(this.project.createElement("event"));
    }

    public void createEvent(CmsElement newEvent) {
        this.event = newEvent;
        this.event.getDateAttribute("date").setDate(new Date());
        this.fldDate.setDate(this.event.getDateAttribute("date").getDate());
        if (!newEvent.hasAttributeValue("title")) {
            this.event.setAttributeValue("title", this.app.getSettings().getTerm(ThemisSettings.Term.NewEventTitle));
        }
        this.populateEvent();
        this.initialiseDialog(false);
    }

    public void editEvent(long idelement) {
        this.editEvent((CmsEvent)this.project.loadElement(idelement, this.project.getUser()));
    }

    public void editEvent(CmsEvent ev) {
        this.event = ev;
        this.populateEvent();
        this.initialiseDialog(true);
    }

    private void populateEvent() {
        if (this.project != null && this.project.isOpen()) {
            this.fldTitle.setText(this.event.getAttributeValue("title"));
            this.fldDescription.setText(this.event.getAttributeValue("comment"));
            this.fldParticipants.setText(this.event.getAttributeValue("participants"));
            this.fldLocation.setText(this.event.getAttributeValue("place"));
            this.fldTime.setText(this.event.getAttributeValue("time"));
            this.fldDate.setDate(this.event.getDateAttribute("date").getDate());
            CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "company");
            s.addSelectMeta();
            s.setSort(this.project.getDefaultElement("company").getAttribute("name"));
            s.search().getResultAsElementSummary();
            this.panelContacts.add((Component)THEMIS.getContactListWithAddOption(s.search().getResultAsElementSummary(), this.fldParticipants, true, false), "Center");
        } else {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
        }
    }

    private boolean saveEvent() {
        if (this.project != null && this.project.isOpen()) {
            String title = this.fldTitle.getText();
            if (title == null || title.isEmpty()) {
                Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("event.title-empty.text", this.app.getLocale()));
                return false;
            }
            this.event.setAttributeValue("title", this.fldTitle.getText());
            this.event.setAttributeValue("comment", this.fldDescription.getText());
            this.event.setAttributeValue("participants", this.fldParticipants.getText());
            this.event.setAttributeValue("place", this.fldLocation.getText());
            this.event.setAttributeValue("time", this.fldTime.getText());
            this.event.getDateAttribute("date").setDate(this.fldDate.getDate());
            if (this.event.isNew()) {
                this.project.setCurrentEvent((CmsEvent)this.event);
                this.event.save();
                this.project.createActionLog("event_create", this.event.getId(), "");
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.EVENT_SAVED.setId(this.event.getId()));
            } else {
                this.event.save();
                this.project.createActionLog("event_edit", this.event.getId(), "");
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.EVENT_SAVED);
            }
            return true;
        }
        Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
        return false;
    }

    private void initialiseDialog(boolean isEdit) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app)) {
            return;
        }
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            for (Component c : this.jPanel1.getComponents()) {
                c.setEnabled(false);
            }
            this.btnCancel.setEnabled(true);
        }
        if (this.project.isOpen() && this.project != null) {
            String title = isEdit ? ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("EventPanel.editEvent.text") : ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("EventPanel.createEvent.text");
            this.dlg = THEMIS.createDialog(title, this, false, true);
            this.dlg.setVisible(true);
        } else {
            Dialogs.getInstance().showErrorDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
        }
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.lblTitle = new JLabel();
        this.fldTitle = new JTextField();
        this.lblDate = new JLabel();
        this.fldDate = new JXDatePicker();
        this.lblDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldDescription = new JTextArea();
        this.lblParticipants = new JLabel();
        this.jPanel3 = new JPanel();
        this.panelContacts = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.fldParticipants = new JTextArea();
        this.lblLocation = new JLabel();
        this.fldLocation = new JTextField();
        this.lblTime = new JLabel();
        this.fldTime = new JTextField();
        this.jPanel2 = new JPanel();
        this.btnSaveAndClsoe = new JButton();
        this.btnCancel = new JButton();
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblTitle.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.lblTitle.text"));
        this.lblTitle.setPreferredSize(this.labelDimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblTitle, gridBagConstraints);
        this.fldTitle.setFont(THEMIS.fontTextfield);
        this.fldTitle.setText(NbBundle.getMessage(EventPanel.class, (String)"EventPanel.fldTitle.text"));
        this.fldTitle.setMinimumSize(new Dimension(100, 30));
        this.fldTitle.setPreferredSize(new Dimension(100, 30));
        this.fldTitle.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                EventPanel.this.fldTitleInputMethodTextChanged(evt);
            }
        });
        this.fldTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                EventPanel.this.fldTitleKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldTitle, gridBagConstraints);
        this.lblDate.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblDate, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.lblDate.text"));
        this.lblDate.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDate, gridBagConstraints);
        this.fldDate.setMinimumSize(new Dimension(100, 30));
        this.fldDate.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldDate, gridBagConstraints);
        this.lblDescription.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.lblDescription.text"));
        this.lblDescription.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblDescription, gridBagConstraints);
        this.fldDescription.setColumns(20);
        this.fldDescription.setFont(THEMIS.fontTextfield);
        this.fldDescription.setLineWrap(true);
        this.fldDescription.setRows(5);
        this.fldDescription.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.fldDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblParticipants.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblParticipants, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.lblParticipants.text"));
        this.lblParticipants.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblParticipants, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.panelContacts.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.panelContacts, gridBagConstraints);
        this.fldParticipants.setColumns(20);
        this.fldParticipants.setFont(THEMIS.fontTextfield);
        this.fldParticipants.setLineWrap(true);
        this.fldParticipants.setRows(5);
        this.fldParticipants.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.fldParticipants);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.lblLocation.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocation, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.lblLocation.text"));
        this.lblLocation.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblLocation, gridBagConstraints);
        this.fldLocation.setFont(THEMIS.fontTextfield);
        this.fldLocation.setText(NbBundle.getMessage(EventPanel.class, (String)"EventPanel.fldLocation.text"));
        this.fldLocation.setMinimumSize(new Dimension(100, 30));
        this.fldLocation.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldLocation, gridBagConstraints);
        this.lblTime.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblTime, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.lblTime.text"));
        this.lblTime.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblTime, gridBagConstraints);
        this.fldTime.setFont(THEMIS.fontTextfield);
        this.fldTime.setText(NbBundle.getMessage(EventPanel.class, (String)"EventPanel.fldTime.text"));
        this.fldTime.setMinimumSize(new Dimension(100, 30));
        this.fldTime.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldTime, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(1, 0, 10, 0));
        this.btnSaveAndClsoe.setFont(THEMIS.fontButton);
        this.btnSaveAndClsoe.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAndClsoe, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.btnSaveAndClsoe.text"));
        this.btnSaveAndClsoe.setBorder(new SoftBevelBorder(0));
        this.btnSaveAndClsoe.setPreferredSize(new Dimension(190, 35));
        this.btnSaveAndClsoe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventPanel.this.btnSaveAndClsoeActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnSaveAndClsoe);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(EventPanel.class, (String)"EventPanel.btnCancel.text"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setPreferredSize(new Dimension(190, 35));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventPanel.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 462, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 510, Short.MAX_VALUE));
    }

    private void btnSaveAndClsoeActionPerformed(ActionEvent evt) {
        if (this.saveEvent()) {
            this.dlg.dispose();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dlg.dispose();
    }

    private void fldTitleInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldTitleKeyReleased(KeyEvent evt) {
    }
}

