/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.SearchResult;
import at.grid.themis.application.EventPanel;
import at.grid.themis.application.MigrateEventPanel;
import at.grid.themis.application.SignaturePanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisUserAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.ui.IconItemRenderer;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.FontUIResource;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EventSelectionPanel2
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    HashMap<String, ThemisUserAction> userActions = new HashMap();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    private JButton btnCancel;
    private JButton btnEditEvent;
    private JButton btnEventSelect;
    private JButton btnEventYearClear;
    private JButton btnEventYearOk;
    private JButton btnNewEventEdit;
    private JButton btnUserAction;
    private JTextField fldCurrentEvent;
    private JTextField fldEventMonth;
    private JTextField fldEventYear;
    private JComboBox<ThemisUserAction> fldUserAction;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel lblEvents;
    private JLabel lblEvents1;
    private JList lstEvents;
    private String DIALOG_CODE = "eventselection";
    public static final int DIALOG_WIDTH = 510;
    public static final int DIALOG_HEIGHT = 660;
    public static final int DIALOG_WIDTH_MIN = 400;
    public static final int DIALOG_HEIGHT_MIN = 500;

    public EventSelectionPanel2() {
        this.initComponents();
        this.lstEvents.setCellRenderer(new EventListRenderer(5));
        this.fldUserAction.setRenderer(IconItemRenderer.getInstanceNoBorder());
        this.createUserActions();
        this.populate();
    }

    private void createUserActions() {
        this.userActions.put("copy", new ThemisUserAction(this.app.getProject().getResourceText("user-action.event.copy"), "key_duplicate"){

            @Override
            public void execute() {
                EventSelectionPanel2.this.copyEvent(true);
            }
        });
        this.userActions.put("copy2", new ThemisUserAction(this.app.getProject().getResourceText("user-action.event.copy-without-planned"), "key_duplicate"){

            @Override
            public void execute() {
                EventSelectionPanel2.this.copyEvent(false);
            }
        });
        this.userActions.put("edit", new ThemisUserAction(this.app.getProject().getResourceText("user-action.event.edit"), "key_rename"){

            @Override
            public void execute() {
                CmsElementSummary ev = (CmsElementSummary)EventSelectionPanel2.this.lstEvents.getSelectedValue();
                if (ev != null) {
                    EventSelectionPanel2.this.editEvent((CmsEvent)ev.getElement());
                }
            }
        });
        this.userActions.put("migrate", new ThemisUserAction(this.app.getProject().getResourceText("user-action.event.merge-with-active"), "key_merge"){

            @Override
            public void execute() {
                EventSelectionPanel2.this.migrateEvent();
            }
        });
        this.userActions.put("delete", new ThemisUserAction(this.app.getProject().getResourceText("user-action.event.delete"), "key_delete"){

            @Override
            public void execute() {
                EventSelectionPanel2.this.deleteEvent();
            }
        });
        this.userActions.put("seal", new ThemisUserAction(this.app.getProject().getResourceText("user-action.event.seal"), "key_seal"){

            @Override
            public void execute() {
                EventSelectionPanel2.this.sealEvent();
            }
        });
    }

    private void updateActions() {
        boolean hasActions;
        boolean isViewer = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE);
        ThemisUserAction selectedAction = (ThemisUserAction)this.fldUserAction.getSelectedItem();
        long currentEventId = this.project.getCurrentEventId();
        DefaultComboBoxModel modelAction = (DefaultComboBoxModel)this.fldUserAction.getModel();
        modelAction.removeAllElements();
        CmsElementSummary ele = (CmsElementSummary)this.lstEvents.getSelectedValue();
        if (ele != null) {
            if (this.project.isEventSigned(ele.getId())) {
                if (!isViewer) {
                    modelAction.addElement(this.userActions.get("copy"));
                }
            } else if (!isViewer) {
                modelAction.addElement(this.userActions.get("plan"));
                modelAction.addElement(this.userActions.get("unplan"));
                modelAction.addElement(this.userActions.get("seal"));
                modelAction.addElement(this.userActions.get("copy"));
                modelAction.addElement(this.userActions.get("copy2"));
                modelAction.addElement(this.userActions.get("edit"));
                if (currentEventId >= 0L && ele.getId() != currentEventId) {
                    modelAction.addElement(this.userActions.get("migrate"));
                }
                modelAction.addElement(this.userActions.get("delete"));
            }
        }
        boolean bl = hasActions = modelAction.getSize() != 0;
        if (selectedAction != null) {
            this.fldUserAction.setSelectedItem(selectedAction);
        } else if (hasActions) {
            this.fldUserAction.setSelectedIndex(0);
        }
        this.fldUserAction.setEnabled(hasActions);
        this.btnUserAction.setEnabled(hasActions);
    }

    private void populate() {
        CmsEvent currentEvent = this.app.getProject().getCurrentEvent();
        this.fldCurrentEvent.setText(currentEvent == null ? "<kein aktuelles Ereignis>" : currentEvent.getTitle());
        CmsElementSummary oldSel = (CmsElementSummary)this.lstEvents.getSelectedValue();
        CmsElementSummary sel = null;
        ((DefaultListModel)this.lstEvents.getModel()).removeAllElements();
        int year = Util.parseInt((String)this.fldEventYear.getText(), (int)-1);
        int month = Util.parseInt((String)this.fldEventMonth.getText(), (int)-1);
        SearchResult result = this.project.getEventSearchResult(year, month, false);
        ArrayList events = result.getResultAsElementSummary();
        for (CmsElementSummary ev : events) {
            if (oldSel != null && oldSel.getId() == ev.getId()) {
                sel = ev;
            }
            ((DefaultListModel)this.lstEvents.getModel()).addElement(ev);
        }
        this.lstEvents.setSelectedValue(sel, true);
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.updateActions();
        this.btnEventSelect.setEnabled(false);
        CmsElementSummary eve = (CmsElementSummary)this.lstEvents.getSelectedValue();
        if (eve != null) {
            if (this.project.isEventSigned(eve.getId())) {
                this.btnEventSelect.setEnabled(false);
            } else {
                this.btnEventSelect.setEnabled(true);
            }
        }
    }

    private void createNewEvent(boolean edit) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsEvent ev = (CmsEvent)this.project.createElement("event");
        Date dt = new Date();
        ev.getDateAttribute("date").setDate(dt);
        ev.setAttributeValue("title", this.settings.getTerm(ThemisSettings.Term.NewEventTitle));
        EventPanel event = new EventPanel();
        event.editEvent(ev);
        if (!ev.isSaved()) {
            return;
        }
        this.project.setCurrentEvent(ev);
        this.closeDialog();
    }

    private void copyEvent(boolean withPlanung) {
        CmsElementSummary ele;
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen() && (ele = (CmsElementSummary)this.lstEvents.getSelectedValue()) != null) {
            CmsElement event = this.project.loadElement(ele.getId(), this.project.getUser());
            EventPanel eventPanel = new EventPanel();
            CmsElement newEvent = event.copy("histories");
            if (!withPlanung) {
                newEvent.getRelationAttribute("plannedobservations").clear();
            }
            eventPanel.createEvent(newEvent);
            this.populate();
        }
    }

    private void setSelectedEvent(boolean doClose) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsElementSummary ev = (CmsElementSummary)this.lstEvents.getSelectedValue();
        if (ev != null) {
            CmsEvent event = (CmsEvent)ev.getElement();
            if (event.isSigned()) {
                this.app.getDialog().showErrorDialog("error.event-is-signed");
            } else {
                this.project.setCurrentEvent(event);
                if (doClose) {
                    this.closeDialog();
                } else {
                    this.populate();
                }
            }
        }
    }

    private void editEvent(CmsEvent event) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || event == null) {
            return;
        }
        EventPanel eventPanel = new EventPanel();
        eventPanel.editEvent(event.getId());
        if (this.project.getSelectionManager().getCurrentEventId() == event.getId()) {
            this.project.getSelectionManager().updateCurrentEvent();
        }
        this.populate();
    }

    private void migrateEvent() {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen()) {
            final CmsEvent currentEvent = this.project.getSelectionManager().getCurrentEvent();
            if (currentEvent == null) {
                Dialogs.getInstance().showErrorDialog("no-event");
                return;
            }
            CmsElementSummary ele = (CmsElementSummary)this.lstEvents.getSelectedValue();
            if (ele == null) {
                Dialogs.getInstance().showErrorDialog("error.migrateEvent.noEventSelected");
                return;
            }
            if (ele.getId() == currentEvent.getId()) {
                Dialogs.getInstance().showErrorDialog("error.migrateEvent.selectionIsCurrent");
                return;
            }
            final CmsEvent event = (CmsEvent)ele.getElement();
            ArrayList obsIds = event.getObservationIds();
            ArrayList currentObsIds = currentEvent.getObservationIds();
            final ArrayList<Long> obsIdsMigrate = new ArrayList<Long>();
            ArrayList<Long> obsIdsConflict = new ArrayList<Long>();
            Iterator iterator = obsIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (currentObsIds.contains(id)) {
                    obsIdsConflict.add(id);
                    continue;
                }
                obsIdsMigrate.add(id);
            }
            final MigrateEventPanel panel = new MigrateEventPanel(currentEvent.getTitle(), event.getTitle(), obsIdsConflict);
            if (Dialogs.getInstance().showDialog(panel, this.bundle.getString("EventTopComponent.migrateEventTitle"), new String[]{this.project.getResourceText("dialog.ok"), this.project.getResourceText("dialog.cancel")}) == 0) {
                String progressTitle = this.bundle.getString("EventTopComponent.migrateEventTitle");
                BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

                    public String run(ProgressHandle ph) {
                        int maxcounter = obsIdsMigrate.size();
                        ph.switchToDeterminate(maxcounter);
                        int counter = 0;
                        String[] stringArray = obsIdsMigrate.iterator();
                        while (stringArray.hasNext()) {
                            long id = (Long)stringArray.next();
                            CmsObservation observation = (CmsObservation)EventSelectionPanel2.this.project.loadElement(id, EventSelectionPanel2.this.project.getUser());
                            CmsHistory history = observation.getHistory(event);
                            observation.applyHistory(history);
                            observation.save();
                            history.moveToTrash();
                            ph.setDisplayName("Integration l\u00e4uft");
                            ph.progress("Beobachtungen werden \u00fcbernommen", counter);
                            ++counter;
                        }
                        if (panel.deleteSelectedEvent()) {
                            EventSelectionPanel2.this.deleteEvent(true, false);
                        }
                        if (panel.copyDescription()) {
                            currentEvent.reload();
                            for (String code : new String[]{"comment", "participants", "place", "time"}) {
                                String t1 = currentEvent.getAttributeValue(code);
                                if (!event.hasAttributeValue(code)) continue;
                                String t2 = event.getAttributeValue(code);
                                String lb = event.getAttribute(code).isOfType(13) ? "\n" : ", ";
                                currentEvent.setAttributeValue(code, (currentEvent.hasAttributeValue(code) ? t1 + lb + event.getTitle() + ": " : "") + t2);
                            }
                            currentEvent.save();
                        }
                        ph.finish();
                        THEMIS.dismissNotify(5, THEMIS.notify(5, EventSelectionPanel2.this.bundle.getString("EventTopComponent.migrateDoneTitle"), EventSelectionPanel2.this.bundle.getString("EventTopComponent.migrateDoneText")));
                        return null;
                    }
                }, (String)progressTitle, (boolean)true);
            }
        }
    }

    private void deleteEvent() {
        this.deleteEvent(false, true);
    }

    private void deleteEvent(boolean force, boolean askDeleteLocation) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen()) {
            boolean doremove;
            CmsElementSummary ele = (CmsElementSummary)this.lstEvents.getSelectedValue();
            if (ele == null) {
                return;
            }
            final CmsEvent event = (CmsEvent)ele.getElement(this.project.getUser());
            int countHistories = event.getRelationAttribute("histories").getElements(false).size();
            boolean bl = doremove = force || countHistories == 0 || ThemisApplication.getInstance().getDialog().showConfirmDialog("Sie haben " + countHistories + " Beobachtungen im Rahmen dieses Ereignisses bearbeitet bzw. erfasst. Diese Informationen werden ebenfalls gel\u00f6scht. Wollen Sie fortfahren?");
            if (doremove) {
                CmsEvent currentEvent = this.project.getCurrentEvent();
                if (currentEvent != null && event.getId() == currentEvent.getId()) {
                    currentEvent = null;
                }
                BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

                    public String run(ProgressHandle ph) {
                        ThemisProgressHandler p = new ThemisProgressHandler(ph);
                        p.switchToDeterminate(event.getRelationAttribute("histories").size());
                        event.moveToTrash((ProgressHandler)p);
                        return null;
                    }
                }, (String)this.project.getResourceText("progress.event-delete.title"), (boolean)true);
                this.project.createActionLog("event_delete", ele.getId(), "");
                this.app.getFilter().resetSearchResult();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.EVENT_DELETED.setId(ele.getId()));
                this.populate();
            }
        }
    }

    private void sealEvent() {
        CmsElementSummary ele = (CmsElementSummary)this.lstEvents.getSelectedValue();
        if (ele != null && !this.project.isEventSigned(ele.getId())) {
            SignaturePanel p = new SignaturePanel();
            UIManager.put("OptionPane.buttonFont", new FontUIResource(THEMIS.fontButton));
            if (Dialogs.getInstance().showDialog(p, this.app.getProject().getResourceText("app.core.text.signature", this.app.getLocale()), new String[]{this.app.getProject().getResourceText("app.core.text.apply", this.app.getLocale()), this.app.getProject().getResourceText("app.core.text.cancel", this.app.getLocale())}) == 0) {
                try {
                    if (!Dialogs.getInstance().showOptionDialog(this.app.getProject().getResourceText("app.text.event.reallysealevent", this.app.getLocale()), "", new Object[]{this.app.getProject().getResourceText("app.core.text.yes", this.app.getLocale()), this.app.getProject().getResourceText("app.core.text.no", this.app.getLocale())})) {
                        return;
                    }
                    CmsEvent e = (CmsEvent)ele.getElement();
                    File f = new File(this.project.getTempfileLocation(), "signatur.jpg");
                    p.writeToFile(f);
                    e.sign(f);
                    this.project.createActionLog("event_sign", e.getId(), "signed by user " + e.getCurrentUser().getUsername());
                    this.populate();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel6 = new JLabel();
        this.btnNewEventEdit = new JButton();
        this.jLabel7 = new JLabel();
        this.fldCurrentEvent = new JTextField();
        this.btnEditEvent = new JButton();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.lblEvents = new JLabel();
        this.fldEventYear = new JTextField();
        this.lblEvents1 = new JLabel();
        this.fldEventMonth = new JTextField();
        this.btnEventYearOk = new JButton();
        this.btnEventYearClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstEvents = new JList();
        this.jPanel1 = new JPanel();
        this.btnEventSelect = new JButton();
        this.jPanel3 = new JPanel();
        this.fldUserAction = new JComboBox();
        this.btnUserAction = new JButton();
        this.jPanel2 = new JPanel();
        this.btnCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel6.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.jLabel6.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.btnNewEventEdit.setFont(THEMIS.fontButton);
        this.btnNewEventEdit.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_createEvent24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewEventEdit, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnNewEventEdit.text"));
        this.btnNewEventEdit.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnNewEventEdit.toolTipText"));
        this.btnNewEventEdit.setBorder(new SoftBevelBorder(0));
        this.btnNewEventEdit.setMaximumSize(new Dimension(400, 30));
        this.btnNewEventEdit.setMinimumSize(new Dimension(55, 35));
        this.btnNewEventEdit.setPreferredSize(new Dimension(55, 35));
        this.btnNewEventEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnNewEventEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnNewEventEdit, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.fldCurrentEvent.setEditable(false);
        this.fldCurrentEvent.setFont(THEMIS.fontSubheading);
        this.fldCurrentEvent.setHorizontalAlignment(0);
        this.fldCurrentEvent.setText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.fldCurrentEvent.text"));
        this.fldCurrentEvent.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.fldCurrentEvent, gridBagConstraints);
        this.btnEditEvent.setFont(THEMIS.fontButton);
        this.btnEditEvent.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_editObs24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEditEvent, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEditEvent.text"));
        this.btnEditEvent.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEditEvent.toolTipText"));
        this.btnEditEvent.setBorder(new SoftBevelBorder(0));
        this.btnEditEvent.setMinimumSize(new Dimension(55, 35));
        this.btnEditEvent.setPreferredSize(new Dimension(55, 35));
        this.btnEditEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnEditEventActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnEditEvent, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.lblEvents.setFont(THEMIS.fontLabelBig);
        Mnemonics.setLocalizedText((JLabel)this.lblEvents, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.lblEvents.text"));
        this.lblEvents.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblEvents, gridBagConstraints);
        this.fldEventYear.setFont(THEMIS.fontTextfield);
        this.fldEventYear.setHorizontalAlignment(0);
        this.fldEventYear.setText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.fldEventYear.text"));
        this.fldEventYear.setMinimumSize(new Dimension(30, 35));
        this.fldEventYear.setPreferredSize(new Dimension(50, 35));
        this.fldEventYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.fldEventYearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldEventYear, gridBagConstraints);
        this.lblEvents1.setFont(THEMIS.fontLabelBig);
        Mnemonics.setLocalizedText((JLabel)this.lblEvents1, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.lblEvents1.text"));
        this.lblEvents1.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.lblEvents1, gridBagConstraints);
        this.fldEventMonth.setFont(THEMIS.fontTextfield);
        this.fldEventMonth.setHorizontalAlignment(0);
        this.fldEventMonth.setText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.fldEventMonth.text"));
        this.fldEventMonth.setMinimumSize(new Dimension(30, 35));
        this.fldEventMonth.setPreferredSize(new Dimension(50, 35));
        this.fldEventMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.fldEventMonthActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldEventMonth, gridBagConstraints);
        this.btnEventYearOk.setFont(THEMIS.fontButton);
        this.btnEventYearOk.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEventYearOk, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEventYearOk.text"));
        this.btnEventYearOk.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEventYearOk.toolTipText"));
        this.btnEventYearOk.setBorder(new SoftBevelBorder(0));
        this.btnEventYearOk.setMinimumSize(new Dimension(5, 30));
        this.btnEventYearOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnEventYearOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEventYearOk, gridBagConstraints);
        this.btnEventYearClear.setFont(THEMIS.fontButton);
        this.btnEventYearClear.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEventYearClear, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEventYearClear.text"));
        this.btnEventYearClear.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEventYearClear.toolTipText"));
        this.btnEventYearClear.setBorder(new SoftBevelBorder(0));
        this.btnEventYearClear.setMinimumSize(new Dimension(5, 30));
        this.btnEventYearClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnEventYearClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEventYearClear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.lstEvents.setFont(THEMIS.fontList);
        this.lstEvents.setModel(new DefaultListModel());
        this.lstEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EventSelectionPanel2.this.lstEventsMousePressed(evt);
            }
        });
        this.lstEvents.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EventSelectionPanel2.this.lstEventsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstEvents);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnEventSelect.setFont(THEMIS.fontButton);
        this.btnEventSelect.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEventSelect, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEventSelect.text"));
        this.btnEventSelect.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnEventSelect.toolTipText"));
        this.btnEventSelect.setBorder(new SoftBevelBorder(0));
        this.btnEventSelect.setMaximumSize(new Dimension(400, 30));
        this.btnEventSelect.setMinimumSize(new Dimension(55, 35));
        this.btnEventSelect.setPreferredSize(new Dimension(55, 35));
        this.btnEventSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnEventSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnEventSelect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.fldUserAction.setFont(THEMIS.fontList);
        this.fldUserAction.setModel(new DefaultComboBoxModel());
        this.fldUserAction.setMinimumSize(new Dimension(5, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanel3.add(this.fldUserAction, gridBagConstraints);
        this.btnUserAction.setFont(THEMIS.fontButton);
        this.btnUserAction.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUserAction, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnUserAction.text"));
        this.btnUserAction.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnUserAction.toolTipText"));
        this.btnUserAction.setBorder(new SoftBevelBorder(0));
        this.btnUserAction.setMinimumSize(new Dimension(55, 35));
        this.btnUserAction.setPreferredSize(new Dimension(55, 35));
        this.btnUserAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnUserActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnUserAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnCancel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnCancel.text"));
        this.btnCancel.setToolTipText(NbBundle.getMessage(EventSelectionPanel2.class, (String)"EventSelectionPanel2.btnCancel.toolTipText"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setMaximumSize(new Dimension(400, 30));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventSelectionPanel2.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 35;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnEventSelectActionPerformed(ActionEvent evt) {
        this.setSelectedEvent(false);
    }

    private void btnNewEventEditActionPerformed(ActionEvent evt) {
        this.createNewEvent(true);
    }

    private void fldEventYearActionPerformed(ActionEvent evt) {
        this.populate();
    }

    private void fldEventMonthActionPerformed(ActionEvent evt) {
        this.populate();
    }

    private void btnEventYearOkActionPerformed(ActionEvent evt) {
        this.populate();
    }

    private void btnEventYearClearActionPerformed(ActionEvent evt) {
        this.fldEventYear.setText("");
        this.fldEventMonth.setText("");
        this.populate();
    }

    private void lstEventsMousePressed(MouseEvent evt) {
        int count;
        if (this.lstEvents.getModel().getSize() > 0 && (count = evt.getClickCount()) == 2 && !ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            this.setSelectedEvent(true);
        }
    }

    private void lstEventsValueChanged(ListSelectionEvent evt) {
        this.updateButtonStates();
    }

    private void btnEditEventActionPerformed(ActionEvent evt) {
        this.editEvent(this.project.getSelectionManager().getCurrentEvent());
    }

    private void btnUserActionActionPerformed(ActionEvent evt) {
        ThemisUserAction action = (ThemisUserAction)this.fldUserAction.getSelectedItem();
        if (action != null) {
            action.execute();
        }
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(this.project.getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 510, 660);
        dlg.setMinimumSize(new Dimension(400, 500));
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }

    private class EventListRenderer
    extends SimpleTextRenderer {
        public EventListRenderer() {
        }

        public EventListRenderer(int border) {
            super(border);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CmsElementSummary ele = (CmsElementSummary)value;
            if (EventSelectionPanel2.this.project.isEventSigned(ele.getId())) {
                lbl.setForeground(Color.red);
            } else if (EventSelectionPanel2.this.app.getProject().getSelectionManager().getCurrentEventId() == ele.getId()) {
                lbl.setForeground(Color.BLUE);
                lbl.setFont(THEMIS.fontListBold);
                lbl.setBackground(Color.LIGHT_GRAY);
            } else {
                lbl.setForeground(Color.black);
            }
            return lbl;
        }
    }
}

