/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.OntologyFileAccess;
import at.grid.cms.OntologyFileAccessImpl;
import at.grid.themis.application.OntologyImageHandlerImpl;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.ThemisLocalProjectsPanel;
import at.grid.themis.application.UpdateManager;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileAccess;
import at.grid.themis.application.api.ThemisGUImanager;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.application.welcome.ThemisWelcomeTopComponent;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisProjectUpdater;
import at.grid.themis.ontology.action.ActionProvider;
import at.grid.themis.ontology.api.OntologyGUImanager;
import at.grid.themis.ontology.api.OntologyImageHandler;
import at.grid.themis.ontology.communication.ThemisDialog;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.server.ThemisDatabaseServer;
import at.grid.themis.ontology.template.DemoPackManager;
import at.grid.util.Util;
import com.github.jaiimageio.jpeg2000.impl.J2KImageReaderSpi;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    public static boolean ask = true;

    public void restored() {
        System.setProperty("netbeans.buildnumber", ThemisProject.VERSION + " [" + 2146 + "] - " + "18.06.2024");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Installer.deleteModuleConfig();
                Frame f = WindowManager.getDefault().getMainWindow();
                f.addWindowListener(new Listener());
                ThemisApplication.getInstance();
                if (OntologyFileAccessImpl.doForceDebug()) {
                    ThemisApplication.getInstance().setDebug(true);
                }
                ThemisApplication.getInstance().setActionProvider((ActionProvider)ThemisActionProvider.getInstance());
                THEMIS.setAssistantMoveListener(f);
                ViewHelper.showStartScreen();
            }
        });
    }

    public boolean closing() {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        boolean doClose = true;
        ThemisWelcomeTopComponent tc = (ThemisWelcomeTopComponent)WindowManager.getDefault().findTopComponent("ThemisWelcomeTopComponent");
        if (tc != null) {
            tc.saveSplitSettings();
        }
        String result = ThemisApplication.getInstance().getSettings().saveToFile();
        if (ask) {
            if (project.isOpen()) {
                Closing closing = THEMIS.getCloseProjectFeedback(new Closing());
                if (closing.dontClose) {
                    return false;
                }
                ThemisTaskWithDialog.createTask("progress.saving-project", ph -> ProjectHelper.closeProject(closing, ph));
                if (project.isOpen()) {
                    return false;
                }
                doClose = true;
            } else {
                doClose = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("Installer.reallyCloseTHEMISNotif.text"), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("Installer.closeTHEMIS.text"), new String[]{ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("Installer.close.text"), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("Installer.cancel.text")});
            }
        }
        if (doClose) {
            ViewHelper.showStartScreen();
            BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThemisDatabaseServer server = ThemisDatabaseServer.getInstance();
                    try {
                        server.stopServer();
                        ThemisLicense license = ThemisApplication.getInstance().getLicense();
                        if (license.isFloatingLicense()) {
                            license.releaseFloatingLicense();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }, (String)ThemisApplication.getInstance().getProject().getResourceText("progress.closing-project"));
            Installer.deleteModuleConfig();
        }
        return doClose;
    }

    public static void readSetupConfig() {
        File f = new File("setup.properties");
        Properties p = new Properties();
        if (f.isFile()) {
            try {
                FileReader fr = new FileReader(f);
                p.load(fr);
                fr.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String k : p.stringPropertyNames()) {
            String v = p.getProperty(k);
            switch (k) {
                case "license.floating": {
                    ThemisApplication.getInstance().getLicense().setFloatingServer(v);
                    ThemisApplication.getInstance().getLicense().activateLicense();
                    break;
                }
                case "license.key": {
                    ThemisApplication.getInstance().getLicense().activateLicenseOnServer(v);
                    break;
                }
                case "folder.root": {
                    File fRoot = new File(v);
                    if (!fRoot.isDirectory()) {
                        fRoot.mkdirs();
                    }
                    if (!fRoot.isDirectory()) break;
                    ThemisApplication.getInstance().getSettings().getFolderProjectRoot().setValue(fRoot);
                    break;
                }
                case "system.ram": {
                    int ram = Util.parseInt((String)v, (int)0);
                    if (ram <= 0) break;
                    Properties prop = new Properties();
                    prop.setProperty("system.system.ram", v);
                    ThemisApplication.getInstance().setConfiguration(prop);
                    THEMIS.updateThemisConf();
                    break;
                }
                case "update.source": {
                    if ("themis".equalsIgnoreCase(v)) {
                        ThemisApplication.getInstance().getSettings().setProperty("system.update.source.selection", "0");
                        break;
                    }
                    File updateFolder = new File(v);
                    if (!updateFolder.isDirectory()) break;
                    ThemisApplication.getInstance().getSettings().setProperty("system.update.source.selection", "1");
                    ThemisApplication.getInstance().setPathUpdateFolder(updateFolder);
                }
            }
        }
        f.renameTo(new File(f.getParentFile(), "setup" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)TimeZone.getDefault()) + ".properties"));
    }

    public static void deleteModuleConfig() {
        Logger.getAnonymousLogger().info("Deleting module configuration");
        File file = new File(System.getProperty("user.home"), "AppData/Roaming/.themis/dev/config/Modules");
        Util.delete((File)file);
        file = new File(System.getProperty("user.home"), ".themis/dev/config/Modules");
        Util.delete((File)file);
    }

    public class Listener
    extends WindowAdapter {
        @Override
        public void windowOpened(WindowEvent event) {
            ThemisWelcomeTopComponent tc;
            DemoPackManager demo;
            ThemisApplication app = ThemisApplication.getInstance();
            app.setThemisDialog((ThemisDialog)Dialogs.getInstance());
            app.setImageHandler((OntologyImageHandler)new OntologyImageHandlerImpl());
            app.getProject().setFileAccess((OntologyFileAccess)new ThemisFileAccess());
            app.setGUImanager((OntologyGUImanager)new ThemisGUImanager(app));
            app.getGUImanager().setTitle();
            boolean lastSystemStartError = app.checkLastSystemStartTime(new BigInteger("" + System.currentTimeMillis()));
            if (!lastSystemStartError) {
                THEMIS.getLicense().removeLicense();
            }
            if (THEMIS.getLicense().checkServerConnection()) {
                THEMIS.getLicense().activateLicense();
            }
            System.setProperty("java.library.path", "./javafx/bin");
            Installer.readSetupConfig();
            ThemisProjectUpdater.getInstance().update(ThemisProjectUpdater.Phase.SYSTEM, null);
            ViewHelper.showStartScreen();
            final boolean confChanged = THEMIS.updateThemisConf();
            if (THEMIS.getLicense().hasMaintenance()) {
                SwingWorker sw2 = new SwingWorker(){

                    protected Integer doInBackground() throws Exception {
                        ThemisApplication.getInstance().getProject().getLogger().info("checking for updates ...");
                        UpdateManager um = new UpdateManager();
                        boolean jreChanged = um.updateJRE(confChanged);
                        if (!jreChanged) {
                            ThemisApplication.getInstance().setUpdateRunning(true);
                            try {
                                um.execute(false, true, null);
                            }
                            catch (Exception e) {
                                ThemisApplication.getInstance().getProject().getLogger().severe(e.getMessage());
                            }
                            ThemisApplication.getInstance().setUpdateRunning(false);
                        }
                        return 0;
                    }
                };
                sw2.execute();
            }
            if ((demo = DemoPackManager.getInstance()).isNewVersionAvailable()) {
                if (app.getDialog().showConfirmDialog("Es stehen neue Vorlagen zum Download zur Verf\u00fcgung. Sollen diese heruntergeladen werden?")) {
                    ThemisTaskWithDialog.createTaskWithCounterAndCancel("Vorlagen werden heruntergeladen", ph -> demo.downloadTemplates(ph));
                } else {
                    demo.setIgnoreNewVersion();
                }
            }
            IIORegistry registry = IIORegistry.getDefaultInstance();
            registry.registerServiceProvider(new J2KImageReaderSpi());
            registry.registerServiceProvider(new JBIG2ImageReaderSpi());
            ArrayList localProjects = app.getProject().checkLocalProjects();
            if (!localProjects.isEmpty()) {
                ThemisLocalProjectsPanel panel = new ThemisLocalProjectsPanel();
                panel.showDialog();
                if (panel.doOpenProject() && panel.getSelectedProject() != null) {
                    ThemisFolder f = panel.getSelectedProject();
                    ProjectHelper.openProject(f);
                }
            }
            if ((tc = (ThemisWelcomeTopComponent)WindowManager.getDefault().findTopComponent("ThemisWelcomeTopComponent")) != null) {
                tc.applySplitSettings();
            }
        }
    }
}

