/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LocationIconChooser
extends JPanel {
    List<DataRecord> iconRecords = null;
    long idSel = -1L;
    private JButton btnLocationIconSet;
    private JButton btnLocationIconSet1;
    private JTextField fldIconFilter;
    private JList<CmsBasicElement> fldLocationIconList;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel lblIcon;

    public LocationIconChooser() {
        this.initComponents();
    }

    public void populate(List<DataRecord> iconRecords, long iconId) {
        this.iconRecords = iconRecords;
        this.idSel = iconId;
        this.filterIcons();
    }

    private void filterIcons() {
        String t = this.fldIconFilter.getText().toLowerCase();
        DefaultListModel model = (DefaultListModel)this.fldLocationIconList.getModel();
        model.removeAllElements();
        model.addElement(new CmsBasicElement(-1L, "-"));
        CmsBasicElement sel = null;
        for (DataRecord rec : this.iconRecords) {
            if (!"".equals(t) && !rec.getString("meta_title").toLowerCase().contains(t)) continue;
            CmsBasicElement item = new CmsBasicElement(rec);
            item.setAttribute("file", rec.getString("filepath"));
            model.addElement(item);
            if (item.getId() != this.idSel) continue;
            sel = item;
        }
        if (sel != null) {
            this.fldLocationIconList.setSelectedValue(sel, true);
        }
    }

    public CmsBasicElement getSelection() {
        return this.fldLocationIconList.getSelectedValue();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fldIconFilter = new JTextField();
        this.btnLocationIconSet1 = new JButton();
        this.btnLocationIconSet = new JButton();
        this.lblIcon = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldLocationIconList = new JList();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LocationIconChooser.class, (String)"LocationIconChooser.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.fldIconFilter.setText(NbBundle.getMessage(LocationIconChooser.class, (String)"LocationIconChooser.fldIconFilter.text"));
        this.fldIconFilter.setMinimumSize(new Dimension(100, 35));
        this.fldIconFilter.setPreferredSize(new Dimension(100, 35));
        this.fldIconFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationIconChooser.this.fldIconFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldIconFilter, gridBagConstraints);
        this.btnLocationIconSet1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationIconSet1, (String)NbBundle.getMessage(LocationIconChooser.class, (String)"LocationIconChooser.btnLocationIconSet1.text"));
        this.btnLocationIconSet1.setBorder(new SoftBevelBorder(0));
        this.btnLocationIconSet1.setMinimumSize(new Dimension(35, 35));
        this.btnLocationIconSet1.setPreferredSize(new Dimension(35, 35));
        this.btnLocationIconSet1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationIconChooser.this.btnLocationIconSet1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnLocationIconSet1, gridBagConstraints);
        this.btnLocationIconSet.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationIconSet, (String)NbBundle.getMessage(LocationIconChooser.class, (String)"LocationIconChooser.btnLocationIconSet.text"));
        this.btnLocationIconSet.setBorder(new SoftBevelBorder(0));
        this.btnLocationIconSet.setMinimumSize(new Dimension(35, 35));
        this.btnLocationIconSet.setPreferredSize(new Dimension(35, 35));
        this.btnLocationIconSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationIconChooser.this.btnLocationIconSetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnLocationIconSet, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblIcon, (String)NbBundle.getMessage(LocationIconChooser.class, (String)"LocationIconChooser.lblIcon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblIcon, gridBagConstraints);
        this.fldLocationIconList.setModel(new DefaultListModel());
        this.fldLocationIconList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationIconChooser.this.fldLocationIconListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fldLocationIconList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void btnLocationIconSetActionPerformed(ActionEvent evt) {
        this.filterIcons();
    }

    private void btnLocationIconSet1ActionPerformed(ActionEvent evt) {
        this.fldIconFilter.setText("");
        this.filterIcons();
    }

    private void fldIconFilterActionPerformed(ActionEvent evt) {
        this.filterIcons();
    }

    private void fldLocationIconListValueChanged(ListSelectionEvent evt) {
        CmsBasicElement item = this.fldLocationIconList.getSelectedValue();
        if (item == null) {
            this.lblIcon.setIcon(null);
        } else {
            String fn = item.getAttribute("file");
            if (fn != null) {
                try {
                    File iconFile = ThemisApplication.getInstance().getProject().getUploadFile("icon", fn);
                    if (iconFile.exists() && iconFile.isFile()) {
                        BufferedImage img = ImageHelper.loadImage((File)iconFile);
                        this.lblIcon.setIcon(new ImageIcon(Util.resizeImage((BufferedImage)img, (int)35, (int)35)));
                    }
                }
                catch (IOException ex) {
                    this.lblIcon.setIcon(null);
                    ex.printStackTrace();
                }
            } else {
                this.lblIcon.setIcon(null);
            }
        }
    }
}

