/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.observer.FolderListener;
import at.grid.cms.observer.FolderObserver;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.gui.SimpleGeometry;
import at.grid.ontology.swing.CmsElementPanel;
import at.grid.ontology.swing.CmsElementSwing;
import at.grid.ontology.swing.ui.PDControlScrollPane;
import at.grid.themis.application.ContactPanel;
import at.grid.themis.application.LocationIconChooser;
import at.grid.themis.application.PhotoViewerPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisPanelInterface;
import at.grid.themis.application.audio.ThemisAudioRecorder;
import at.grid.themis.application.camera.QRCodeDetector;
import at.grid.themis.application.camera.WebcamFrame2;
import at.grid.themis.application.files.UploadItemFilePanel;
import at.grid.themis.application.image.ImageReference;
import at.grid.themis.application.image.ImageRotateLeft;
import at.grid.themis.application.image.ImageRotateRight;
import at.grid.themis.application.ui.IconItemRenderer;
import at.grid.themis.application.ui.ObservationCellRenderer;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsMeasureTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsObservationTemplate;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.interfaces.IconItem;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PlanSnippetGenerator;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class LocationObservationDialog
extends JPanel
implements ThemisPanelInterface {
    public static final String DIALOG_CODE = "locationobservationdialog";
    public static final int DIALOG_WIDTH = 1130;
    public static final int DIALOG_HEIGHT = 860;
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    CmsLocation location;
    private CmsObservation observation = null;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisSettings settings = this.app.getSettings();
    String currentPanel = "";
    CmsElement currentElement = null;
    int idxTemplateLocation = -1;
    int idxTemplateLocationgroup = -1;
    int idxTemplateObservation = -1;
    int idxTemplateMeasure = -1;
    int idxObservation = -1;
    FolderObserver observer;
    CmsElement observationlog;
    boolean observationChanged;
    boolean locationChanged;
    boolean fotoDisabled = false;
    int imageSize;
    HashMap<Long, CmsObservation> observations = new HashMap();
    boolean editObservationOnly = false;
    boolean addFotosToObs = true;
    boolean canEdit = false;
    HashMap<CmsObservation, ArrayList<UploadItem>> itemsToBeDeleted = new HashMap();
    HashMap<String, JComponent> locationAttributeComponentMap = new HashMap();
    HashMap<String, JComponent> observationAttributeComponentMap = new HashMap();
    ArrayList<Long> deletedObservations = new ArrayList();
    ArrayList<Long> templateFavourites = new ArrayList();
    HashMap<Long, ArrayList<ImageReference>> imageReferences = new HashMap();
    boolean templatesChanged = false;
    boolean templateFavoritesChanged = false;
    List<DataRecord> iconRecords = null;
    boolean userAdministrator = this.app.isUserAdministrator();
    public static final int RECORDING = 1;
    public static final int PLAYBACK = 2;
    public static final int STOPPED = 3;
    public static final int PAUSED = 4;
    private int audiostate;
    private boolean recordDone;
    private int type = 1;
    private File audiofile = null;
    private ThemisAudioRecorder recorder;
    private Position curPosition;
    private boolean updateComponentVisibilityFlag = true;
    private long observationType;
    private UploadItem selectedObservationImage;
    private UploadItem selectedLocationImage;
    JDialog dlg = null;
    ImageIcon iconUp = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif"));
    ImageIcon iconDown = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif"));
    ImageIcon iconAudio = new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/audio48.gif"));
    private Dimension labelDimension = new Dimension(100, 26);
    DragScrollHandler dragScrollHandlerObservationImages;
    DragScrollHandler dragScrollHandlerLocationImages;
    private JButton btnAddContact;
    private JButton btnAddDescription;
    private JButton btnAddLocationTemplate;
    private JButton btnAddLocationWithChecks;
    private JButton btnAddTemplateObservation;
    private JButton btnAddTemplateObservations;
    private JButton btnApplyTemplateLocation;
    private JButton btnApplyTemplateMeasure;
    private JButton btnApplyTemplateObservation;
    private JButton btnBarcode;
    private JButton btnLocationAddDocument;
    private JButton btnLocationAddFile;
    private JButton btnLocationAddObservation;
    private JButton btnLocationCancel;
    private JButton btnLocationCaptureImage;
    private JButton btnLocationEditDocument;
    private JButton btnLocationEditImage;
    private JButton btnLocationEditObservation;
    private JButton btnLocationIconRemove;
    private JButton btnLocationIconSet;
    private JButton btnLocationObsDown;
    private JButton btnLocationObsUp;
    private JButton btnLocationRemoveDocument;
    private JButton btnLocationRemoveFile;
    private JButton btnLocationRemoveObservation;
    private JButton btnLocationSaveClose;
    private JButton btnLocationSaveNew;
    private JButton btnMigrageUploadToObservation;
    private JButton btnObservationAddDocument;
    private JButton btnObservationAddFile;
    private JButton btnObservationAddFile2;
    private JButton btnObservationAddPlansnippet;
    private JButton btnObservationCamera;
    private JButton btnObservationCancel;
    private JButton btnObservationCleareDescription;
    private JButton btnObservationCleareMeasure;
    private JButton btnObservationEditDocument;
    private JButton btnObservationEditImage;
    private JButton btnObservationMeasureCalendar;
    private JButton btnObservationMeasureCalendar1;
    private JButton btnObservationRemoveDocument;
    private JButton btnObservationRemoveFile;
    private JButton btnObservationRotateImageCCW;
    private JButton btnObservationRotateImageCCW1;
    private JButton btnObservationRotateImageCW;
    private JButton btnObservationRotateImageCW1;
    private JButton btnObservationSaveClose;
    private JButton btnObservationToItem;
    private JButton btnQuicksearchClear;
    private JButton btnRemoveAudio;
    private JButton btnRemoveAudio1;
    private JButton btnRepeat;
    private JButton btnSaveTemplateLocation;
    private JButton btnSaveTemplateObservation;
    private JToggleButton btnTemplateFavourite;
    private JToggleButton btnTypeAufgabe;
    private JToggleButton btnTypeInfo;
    private JToggleButton btnTypeKontrolle;
    private JToggleButton btnTypeMangel;
    private ButtonGroup buttonGroupKategorie;
    private JCheckBox chkLocationShowalways;
    private JLabel emptyLabel;
    private Box.Filler filler6;
    private Box.Filler filler7;
    private Box.Filler filler8;
    private Box.Filler filler9;
    private JTextField fldLocationBarcode;
    private JTextField fldLocationDimArea;
    private JTextField fldLocationDimDiameter;
    private JTextField fldLocationDimHeight;
    private JTextField fldLocationDimWidth;
    private JComboBox<CmsElementSummary> fldLocationDocumentLibrary;
    private JComboBox<CmsElementSummary> fldLocationDocumentLibraryType;
    private JComboBox<CmsBasicElement> fldLocationGroup;
    private JTextField fldLocationName;
    private JTextField fldLocationNumber;
    private JTextField fldLocationPostnumber;
    private JTextField fldLocationPrenumber;
    private JTextField fldLocationQuantity;
    private JTextField fldLocationTitleOnObs;
    private JComboBox fldObservationContact;
    private JTextArea fldObservationDescription;
    private JComboBox fldObservationDocumentLibrary;
    private JComboBox fldObservationDocumentLibraryType;
    private JXDatePicker fldObservationDueDate;
    private JTextArea fldObservationMeasure;
    private JTextField fldObservationNumber;
    private JComboBox fldObservationRepeat;
    private JTextField fldObservationRepeatCount;
    private JTextField fldObservationRisk;
    private JCheckBox fldObservationStatus;
    private JTextField fldObservationTitle;
    private JComboBox<CmsBasicElement> fldTemplateLocationgroup;
    private JComboBox fldTemplateMeasure;
    private JTextField fldTemplateQuicksearch;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel33;
    private JLabel jLabel35;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel25;
    private JPanel jPanel26;
    private JPanel jPanel3;
    private JPanel jPanel32;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane12;
    private JScrollPane jScrollPane13;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JLabel lblAttLocBarcode;
    private JLabel lblEmpty1;
    private JLabel lblFileInfo;
    private JLabel lblFileInfo1;
    private JLabel lblGegenstandTitle;
    private JLabel lblLocationAllgemeinTitle;
    private JLabel lblLocationAllgemeinTitle1;
    private JLabel lblLocationAllgemeinTitle2;
    private JLabel lblLocationAllgemeinTitle4;
    private JLabel lblLocationAllgemeinTitle5;
    private JLabel lblLocationGroup;
    private JLabel lblLocationIconGraphics;
    private JLabel lblLocationIconTitle;
    private JLabel lblLocationMerkmaleTitle;
    private JLabel lblLocationMerkmaleTitle1;
    private JLabel lblLocationMerkmaleTitle2;
    private JLabel lblLocationMerkmaleTitle3;
    private JLabel lblLocationMerkmaleTitle4;
    private JLabel lblLocationNumber;
    private JLabel lblLocationTitle;
    private JLabel lblNoCurrentEvent;
    private JLabel lblObservationContact;
    private JLabel lblObservationContact1;
    private JLabel lblObservationDescription;
    private JLabel lblObservationDuedate;
    private JLabel lblObservationHead;
    private JLabel lblObservationMeasure;
    private JLabel lblObservationRisk;
    private JLabel lblObservationStatus;
    private JLabel lblTemplateLocationGroup;
    private JList lstLocationDocuments;
    private JList lstLocationFiles;
    private JList lstLocationObservation;
    private JList lstObservationDocuments;
    private JList lstObservationFiles;
    private JList lstTemplateLocation;
    private JList lstTemplateObservation;
    private JPanel panelEditor;
    private JPanel panelGroupTemplate;
    private JPanel panelLocation;
    private JPanel panelLocationAllgemein;
    private JPanel panelLocationAllgemeinOuter;
    private JPanel panelLocationAllgemeinTitle;
    private JPanel panelLocationAufmass;
    private JPanel panelLocationAufmassOuter;
    private JPanel panelLocationAufmassTitle;
    private JPanel panelLocationButtons;
    private JPanel panelLocationDocuments;
    private JPanel panelLocationDocumentsOuter;
    private JPanel panelLocationDocumentsTitle;
    private JPanel panelLocationFiles;
    private JPanel panelLocationFilesButtons;
    private JPanel panelLocationFilesOuter;
    private JPanel panelLocationFilesTitle;
    private JPanel panelLocationIcon;
    private JPanel panelLocationImages;
    private JPanel panelLocationMasse;
    private JPanel panelLocationMerkmale;
    private JPanel panelLocationMerkmaleOuter;
    private JPanel panelLocationMerkmaleTitle;
    private JPanel panelLocationObservations;
    private JPanel panelLocationObservationsOuter;
    private JPanel panelLocationObservationsTitle;
    private JPanel panelLocationOuter;
    private JPanel panelLocationQuantity;
    private JScrollPane panelLocationScroll;
    private JPanel panelLocationTemplate;
    private JPanel panelLocationTitle;
    private JPanel panelMeasureTemaplate;
    private JPanel panelObservation;
    private JPanel panelObservationButtons;
    private JPanel panelObservationContact;
    private JPanel panelObservationDescription;
    private JPanel panelObservationDescriptionOuter;
    private JPanel panelObservationDescriptionTitle;
    private JPanel panelObservationDocuments;
    private JPanel panelObservationDocumentsOuter;
    private JPanel panelObservationDuedate;
    private JPanel panelObservationFiles;
    private JPanel panelObservationFilesButtons;
    private JPanel panelObservationFilesOuter;
    private JPanel panelObservationFilesTitle;
    private JPanel panelObservationFilesTitle1;
    private JPanel panelObservationHeader;
    private JPanel panelObservationImages;
    private JPanel panelObservationMangelDetails;
    private JPanel panelObservationMeasure;
    private JPanel panelObservationOuter;
    private JPanel panelObservationProperties;
    private JPanel panelObservationPropertiesOuter;
    private JPanel panelObservationPropertiesTitle;
    private JPanel panelObservationRepeat;
    private JPanel panelObservationRisk;
    private JScrollPane panelObservationScroll;
    private JPanel panelObservationStatus;
    private JPanel panelObservationTemplate;
    private JPanel panelObservationTitle;
    private JPanel panelQuicksearch;
    private JPanel panelTemplate;
    private JButton playButton;
    private JButton playButton1;
    private JButton playExternal;
    private JButton playExternalLoc;
    private JProgressBar progressAudioLevel;
    private JProgressBar progressAudioLevel1;
    private JButton recordButton;
    private JButton recordButton1;
    private JScrollPane scrollMeasure;
    private JScrollPane scrollObsDescription;
    private JSplitPane splitPane;
    private JButton stopButton;
    private JButton stopButton1;

    public LocationObservationDialog() {
        this.initComponents();
        this.templateFavourites = this.app.getSettings().getTemplateFavourites();
        this.fldTemplateLocationgroup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                Accessible popup = comboBox.getUI().getAccessibleChild(comboBox, 0);
                Component c = ((Container)((Object)popup)).getComponent(0);
                if (c instanceof JScrollPane) {
                    JScrollPane scrollpane = (JScrollPane)c;
                    JScrollBar scrollBar = scrollpane.getVerticalScrollBar();
                    Dimension scrollBarDim = new Dimension(40, scrollBar.getPreferredSize().height);
                    scrollBar.setPreferredSize(scrollBarDim);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addObservationChangeListener(this.fldObservationMeasure);
        this.addObservationChangeListener(this.fldObservationDueDate.getEditor());
        new DropTarget(this.lstObservationFiles, new LocationTCDnDListener(false, ""));
        new DropTarget(this.lstLocationFiles, new LocationTCDnDListener(false, ""));
        ThemisDropTargetListener dndImageObs = new ThemisDropTargetListener(false, false, new String[]{"jpg"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
                ArrayList<File> files = new ArrayList<File>();
                files.add(f);
                LocationObservationDialog.this.dropFileImage(files);
            }

            @Override
            public boolean dropFileAction(List<File> files, DropTargetDropEvent event) {
                return LocationObservationDialog.this.dropFileImage(files);
            }
        };
        new DropTarget(this.panelLocationImages, dndImageObs);
        new DropTarget(this.panelObservationImages, dndImageObs);
        new DropTarget(this.lstObservationDocuments, new LocationTCDnDListener(true, "obs"));
        new DropTarget(this.lstLocationDocuments, new LocationTCDnDListener(true, "loc"));
        this.addFotosToObs = this.settings.getImageForObservation();
        if (this.addFotosToObs) {
            this.panelLocationFilesOuter.setVisible(false);
        } else {
            this.panelObservationFilesOuter.setVisible(false);
            this.btnObservationCamera.setVisible(false);
        }
        this.btnLocationSaveNew.setVisible(true);
        this.fldObservationMeasure.setRows(this.app.getSettings().getDisplayTextareaSize());
        this.fldObservationDescription.setRows(this.app.getSettings().getDisplayTextareaSize());
        this.imageSize = this.app.getSettings().getImageUploadSize();
        if (!this.userAdministrator) {
            this.btnSaveTemplateLocation.setVisible(false);
            this.btnSaveTemplateObservation.setVisible(false);
        }
        this.fldLocationDocumentLibraryType.setModel(CmsElementSwing.getComboBoxModel(this.project.getKeytable("documenttype"), this.project.getUser().getCurrentLanguage(), true, "-"));
        this.fldObservationDocumentLibraryType.setModel(CmsElementSwing.getComboBoxModel(this.project.getKeytable("documenttype"), this.project.getUser().getCurrentLanguage(), true, "-"));
        THEMIS.removeUsualTabBehavior(this.fldObservationMeasure);
        this.lstTemplateLocation.setCellRenderer(new SimpleTextRenderer());
        this.lstTemplateObservation.setCellRenderer(new ObservationCellRenderer());
        this.lstLocationObservation.setCellRenderer(IconItemRenderer.getInstance());
        this.canEdit = ThemisLicense.isLicenseLevelAtLeast((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.APP);
        if (!this.canEdit) {
            this.btnLocationAddObservation.setEnabled(false);
            this.btnLocationRemoveObservation.setEnabled(false);
            this.btnLocationAddFile.setEnabled(false);
            this.btnLocationRemoveFile.setEnabled(false);
            this.recordButton1.setEnabled(false);
            this.btnLocationAddDocument.setEnabled(false);
            this.btnLocationRemoveDocument.setEnabled(false);
            this.btnLocationSaveNew.setEnabled(false);
            this.btnLocationSaveClose.setEnabled(false);
            this.btnObservationSaveClose.setEnabled(false);
            this.btnLocationSaveNew.setEnabled(false);
            this.btnTypeMangel.setEnabled(false);
            this.btnTypeAufgabe.setEnabled(false);
            this.btnTypeKontrolle.setEnabled(false);
            this.btnRepeat.setEnabled(false);
            this.btnObservationAddFile.setEnabled(false);
            this.btnObservationRemoveFile.setEnabled(false);
            this.btnObservationAddDocument.setEnabled(false);
            this.btnObservationRemoveDocument.setEnabled(false);
            this.btnSaveTemplateLocation.setEnabled(false);
            this.btnApplyTemplateLocation.setEnabled(false);
            this.btnSaveTemplateObservation.setEnabled(false);
            this.btnAddTemplateObservation.setEnabled(false);
            this.btnApplyTemplateMeasure.setEnabled(false);
            this.panelTemplate.setVisible(false);
        }
        int w = 50;
        if (this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed()) {
            w += 40;
        }
        if (this.app.getSettings().getLocationAttribute("suffix").isUsed()) {
            w += 40;
        }
        this.fldObservationNumber.setMinimumSize(new Dimension(w, 30));
        this.fldObservationNumber.setPreferredSize(new Dimension(w, 30));
        new DragScrollHandler(this.lstTemplateLocation, true, true);
        new DragScrollHandler(this.lstTemplateObservation, true, true);
        DragScrollHandler dragScrollHandlerObservation = new DragScrollHandler(this.panelObservation, false, true);
        dragScrollHandlerObservation.addDragComponent(this.fldObservationRepeat);
        dragScrollHandlerObservation.addDragComponent(this.fldObservationRepeatCount);
        dragScrollHandlerObservation.addDragComponent((JComponent)this.fldObservationDueDate);
        dragScrollHandlerObservation.addDragComponent(this.lstObservationFiles);
        dragScrollHandlerObservation.addDragComponent(this.fldObservationDocumentLibrary);
        dragScrollHandlerObservation.addDragComponent(this.lstObservationDocuments);
        this.dragScrollHandlerObservationImages = new DragScrollHandler(this.panelObservationImages, true, false);
        this.dragScrollHandlerLocationImages = new DragScrollHandler(this.panelLocationImages, true, false);
        DragScrollHandler dragScrollHandlerLocation = new DragScrollHandler(this.panelLocation, false, true);
        dragScrollHandlerLocation.addDragComponent(this.panelLocationAllgemeinOuter);
        dragScrollHandlerLocation.addDragComponent(this.fldLocationGroup);
        dragScrollHandlerLocation.addDragComponent(this.fldLocationDimArea);
        dragScrollHandlerLocation.addDragComponent(this.fldLocationDimDiameter);
        dragScrollHandlerLocation.addDragComponent(this.fldLocationDimHeight);
        dragScrollHandlerLocation.addDragComponent(this.fldLocationQuantity);
        dragScrollHandlerLocation.addDragComponent(this.panelLocationMerkmaleOuter);
        dragScrollHandlerLocation.addDragComponent(this.lstLocationObservation);
        dragScrollHandlerLocation.addDragComponent(this.lstLocationDocuments);
        this.initialiseFolderObserver();
    }

    private void initialiseDialog() {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)this.app)) {
            return;
        }
        if (this.project.isOpen()) {
            this.dlg = THEMIS.createDialog(this.project.getResourceText("dialog.locationobservationdialog.title"), this, true, true);
            THEMIS.setAssistantMoveListener(this.dlg);
            THEMIS.applyWindowSizeAndLocation(DIALOG_CODE, this.dlg, 1130, 860);
            String dividerPosition = this.project.getProjectProperty("display.loc-obs-dialog.divider", "");
            this.splitPane.setDividerLocation(!"".equals(dividerPosition) ? Integer.parseInt(dividerPosition) : 500);
            this.dlg.setDefaultCloseOperation(0);
            this.dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    LocationObservationDialog.this.closeDialog();
                }
            });
            this.dlg.setVisible(true);
            if (this.lstTemplateLocation.getModel().getSize() > 0 || !this.fldTemplateLocationgroup.isVisible() || this.fldTemplateLocationgroup.getModel().getSize() > 0) {
                // empty if block
            }
        }
    }

    public void editLocation(CmsElement loc, boolean openNewDialog) {
        if (this.app.getSettings().getNotificationNoEventInfo() && !this.project.checkForCurrentEvent(false)) {
            int response = Dialogs.getInstance().showInfoOptionDialog(this.app.getProject().getResourceText("app.warning.text.noevent.info", this.app.getLocale()), this.app.getProject().getResourceText("app.core.text.noevent.title", this.app.getLocale()), ThemisProject.OPTIONS_OK_DONTSHOW);
            if (response == 1) {
                this.app.getSettings().setNotificationNoEventInfo(false);
            }
        }
        this.reset();
        this.location = (CmsLocation)loc;
        if (this.location.isNew()) {
            this.location.createNewNumber();
        }
        for (CmsElement o : this.location.getObservations()) {
            this.observations.put(o.getId(), (CmsObservation)o);
        }
        this.currentPanel = "location";
        this.currentElement = this.location;
        if (openNewDialog) {
            this.initialiseTopComponent();
        }
        this.populateLocationPanel();
        this.editObservationOnly = false;
        if (openNewDialog) {
            this.showLocationDialog();
            this.initialiseDialog();
        }
    }

    public void editLocation(CmsElement loc) {
        this.editLocation(loc, true);
    }

    public void editObservation(CmsElement loc, long idobs) {
        this.editObservationOnly = true;
        this.reset();
        this.location = (CmsLocation)loc;
        if (this.location.isNew()) {
            this.location.createNewNumber();
        }
        this.initialiseTopComponent();
        this.populateLocationPanel();
        this.populateObservationList(idobs);
        this.editObservation();
        this.initialiseDialog();
    }

    public void editObservation(CmsElement loc, CmsObservation obs) {
        if (THEMIS.checkAndCreateEvent()) {
            this.editObservationOnly = true;
            this.reset();
            this.location = (CmsLocation)loc;
            if (this.location.isNew()) {
                this.location.createNewNumber();
            }
            this.initialiseTopComponent();
            this.populateLocationPanel();
            this.populateObservationList(-1L);
            this.observations.put(obs.getId(), obs);
            this.observation = obs;
            this.showObservationDialog();
            this.editObservation();
            this.initialiseDialog();
        }
    }

    private void editObservation() {
        ObservationListItem ele;
        if (THEMIS.checkAndCreateEvent() && (ele = (ObservationListItem)this.lstLocationObservation.getSelectedValue()) != null) {
            if (this.observations.containsKey(ele.id)) {
                this.observation = this.observations.get(ele.id);
            } else {
                this.observation = (CmsObservation)this.project.loadElement(ele.id, this.project.getUser());
                this.observations.put(this.observation.getId(), this.observation);
            }
            this.showObservationDialog();
        }
    }

    private void reset() {
        this.observations.clear();
        this.location = null;
        this.observation = null;
        this.locationChanged = false;
        this.observationChanged = false;
        this.itemsToBeDeleted.clear();
        this.deletedObservations.clear();
    }

    private ArrayList<UploadItem> getItemsToBeDeleted(CmsObservation obs) {
        return this.itemsToBeDeleted.getOrDefault(obs, new ArrayList());
    }

    @Override
    public boolean preClose() {
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        if ("location".equals(this.currentPanel)) {
            if (this.closeLocationPanel(false)) {
                return true;
            }
        } else if (this.editObservationOnly) {
            boolean doClose = true;
            if (this.observationChanged()) {
                doClose = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.ObsNotSavedNotification.text"));
            }
            if (doClose) {
                this.closeObservationPanel();
                this.editObservationOnly = false;
                return true;
            }
        } else if (Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("ObsLocNotSavedNotification"))) {
            return true;
        }
        return false;
    }

    @Override
    public void setDialog(JDialog dlg) {
        this.dlg = dlg;
        this.dlg.setLocationByPlatform(true);
    }

    @Override
    public JDialog getDialog() {
        return this.dlg;
    }

    private void closeDialog() {
        THEMIS.saveWindowSizeAndLocation(DIALOG_CODE, this.dlg);
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        if ("location".equals(this.currentPanel)) {
            if (this.closeLocationPanel(false)) {
                this.dlg.dispose();
                this.stopFolderObserver();
            }
        } else if (this.editObservationOnly) {
            boolean doClose = true;
            if (this.observationChanged()) {
                doClose = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.ObsNotSavedNotification.text"));
            }
            if (doClose) {
                this.closeObservationPanel();
                this.editObservationOnly = false;
                this.dlg.dispose();
                this.stopFolderObserver();
            }
        } else if (Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("ObsLocNotSavedNotification"))) {
            this.dlg.dispose();
            this.stopFolderObserver();
        }
    }

    private void initialiseTopComponent() {
        this.loadLocationTemplates();
        if (this.idxTemplateLocation >= 0) {
            this.btnApplyTemplateLocation.setEnabled(this.canEdit);
            this.lstTemplateLocation.setSelectedIndex(this.idxTemplateLocation);
            this.loadObservationTemplates();
        } else {
            this.btnApplyTemplateLocation.setEnabled(false);
        }
        this.updateComponentVisibility();
    }

    private void updateComponentVisibility() {
        boolean hasDocumentSelected;
        boolean hasCurrentEvent;
        boolean bl = hasCurrentEvent = this.project.getCurrentEvent() != null;
        if (this.settings.getDoAutoGenerateEvent()) {
            hasCurrentEvent = true;
        }
        this.btnApplyTemplateLocation.setEnabled(this.canEdit && this.lstTemplateLocation.getSelectedIndex() >= 0 && "location".equals(this.currentPanel));
        this.btnSaveTemplateLocation.setEnabled(this.canEdit && "location".equals(this.currentPanel) && "location".equals(this.currentPanel));
        this.btnApplyTemplateObservation.setEnabled(this.canEdit && hasCurrentEvent && this.lstTemplateObservation.getSelectedIndex() >= 0 && "observation".equals(this.currentPanel));
        this.btnAddDescription.setEnabled(this.canEdit && hasCurrentEvent && this.lstTemplateObservation.getSelectedIndex() >= 0 && "observation".equals(this.currentPanel));
        this.btnAddTemplateObservation.setEnabled(this.canEdit && hasCurrentEvent && this.lstTemplateObservation.getSelectedIndex() >= 0 && this.location != null && "location".equals(this.currentPanel));
        this.btnAddTemplateObservations.setEnabled(this.canEdit && hasCurrentEvent && this.location != null && "location".equals(this.currentPanel));
        this.btnSaveTemplateObservation.setEnabled(this.canEdit && hasCurrentEvent && this.observation != null && "observation".equals(this.currentPanel));
        this.btnApplyTemplateMeasure.setEnabled(this.canEdit && hasCurrentEvent && "observation".equals(this.currentPanel));
        if (this.location != null) {
            boolean hasObservationSelected = this.lstLocationObservation.getSelectedIndex() >= 0;
            this.btnLocationAddObservation.setEnabled(this.canEdit && hasCurrentEvent);
            this.btnLocationRemoveObservation.setEnabled(this.canEdit && hasCurrentEvent && hasObservationSelected);
            this.btnLocationEditObservation.setEnabled(this.canEdit && hasCurrentEvent && hasObservationSelected);
            this.lblNoCurrentEvent.setVisible(!hasCurrentEvent);
            this.btnLocationAddDocument.setEnabled(this.canEdit && this.fldLocationDocumentLibrary.getSelectedItem() != null);
            hasDocumentSelected = this.lstLocationDocuments.getSelectedIndex() >= 0;
            this.btnLocationEditDocument.setEnabled(this.canEdit && hasDocumentSelected);
            this.btnLocationRemoveDocument.setEnabled(this.canEdit && hasDocumentSelected);
        }
        if (this.observation != null && "observation".equals(this.currentPanel) && hasCurrentEvent) {
            this.btnObservationAddFile.setEnabled(this.canEdit && hasCurrentEvent);
            boolean hasFileSelected = this.lstObservationFiles.getSelectedIndex() >= 0;
            this.btnObservationRemoveFile.setEnabled(this.canEdit && hasFileSelected);
            this.btnObservationAddDocument.setEnabled(this.canEdit && hasCurrentEvent);
            hasDocumentSelected = this.lstObservationDocuments.getSelectedIndex() >= 0;
            this.btnObservationEditDocument.setEnabled(this.canEdit && hasDocumentSelected);
            this.btnObservationRemoveDocument.setEnabled(this.canEdit && hasDocumentSelected);
        }
        if (this.addFotosToObs) {
            this.panelLocationFilesOuter.setVisible(false);
        } else {
            this.panelObservationFilesOuter.setVisible(false);
        }
        this.setAudioFileSelection();
        this.updateAudioComponents();
    }

    private void setAudioFileSelection() {
        UploadItem item = null;
        item = "observation".equals(this.currentPanel) ? (UploadItem)this.lstObservationFiles.getSelectedValue() : (UploadItem)this.lstLocationFiles.getSelectedValue();
        this.audiofile = item != null && item.isAudio() ? item.getFile() : null;
    }

    private void showLocationDialog() {
        ((CardLayout)this.panelEditor.getLayout()).show(this.panelEditor, "cardLocation");
        this.panelObservationOuter.setVisible(false);
        this.currentPanel = "location";
        this.currentElement = this.location;
        this.startElementEditLog((CmsElement)this.location);
    }

    private void loadKeytable(JComboBox fld, String tbl) {
        fld.removeAllItems();
        fld.addItem("-");
        if (this.project != null && this.project.isOpen()) {
            ArrayList recs = this.project.getKeytable(tbl).toList(this.app.getSystemLanguage());
            for (KeytableRecord rec : recs) {
                fld.addItem(rec.term);
            }
        }
    }

    private void setKeyAttribute(CmsElement ele, String tbl, JComboBox fld) {
        if (fld.getSelectedIndex() == 0) {
            ele.getKeyAttribute(tbl).clear();
        } else {
            ele.getKeyAttribute(tbl).setValue(this.app.getProject().getKeytable(tbl).getIdByTerm((String)fld.getSelectedItem(), this.app.getProject().getUser().getLang()));
        }
    }

    private void loadDocumentLibrary(JComboBox fldDocumentType, JComboBox fldDocumentLibrary, JList lstDocuments, RelationAttribute infoAttribute) {
        if (this.project != null && this.project.isOpen()) {
            List infoIds = infoAttribute.getElementIds();
            List infos = infoAttribute.getElements();
            ((DefaultListModel)lstDocuments.getModel()).removeAllElements();
            ((DefaultComboBoxModel)fldDocumentLibrary.getModel()).removeAllElements();
            for (CmsElementSummary ele : infos) {
                if (ele.isTrash()) continue;
                ((DefaultListModel)lstDocuments.getModel()).addElement(ele);
            }
            CmsElement info = this.project.getDefaultElement("info");
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("info");
            s.addSelectMeta();
            s.addSelectAttribute(info.getAttribute("hasfiles"));
            s.setSort("el.title");
            if (fldDocumentType != null && fldDocumentType.getSelectedIndex() > 0) {
                long keyId = ((KeytableRecord)fldDocumentType.getSelectedItem()).id;
                s.addWhere("ele.iddocumenttype=" + keyId);
            }
            SearchResult result = s.search();
            ArrayList recs = result.getResultAsElementSummary();
            for (CmsElementSummary rec : recs) {
                if (infoIds.contains(rec.getId())) continue;
                ((DefaultComboBoxModel)fldDocumentLibrary.getModel()).addElement(rec);
            }
        }
    }

    private void addObservationChangeListener(JTextComponent comp) {
        comp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                LocationObservationDialog.this.observationChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LocationObservationDialog.this.observationChanged = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LocationObservationDialog.this.observationChanged = true;
            }
        });
    }

    private int handleClickEventOnList(JList list, MouseEvent evt) {
        list = (JList)evt.getSource();
        if (evt.getClickCount() == 2) {
            return 2;
        }
        return -1;
    }

    private void openSelectedDocument(JList list) {
        try {
            CmsElementSummary selectedItem = (CmsElementSummary)list.getSelectedValue();
            CmsInfo info = (CmsInfo)this.project.loadElement(selectedItem.getId(), this.project.getUser());
            List uploadItems = info.getUploadAttribute("files").getUploadItems();
            if (uploadItems.size() == 1) {
                Desktop dt = Desktop.getDesktop();
                dt.open(new File(((UploadItem)uploadItems.get(0)).getAbsolutePath()));
            } else if (uploadItems.size() > 1) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.moreThanOneDoc.text"));
            } else if (uploadItems.isEmpty()) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noDocumentAssigned.text"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadLocationTemplates() {
        List locationGroupTemplates = this.project.getTemplateManger().getLocationGroups(-99L);
        ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).addElement(new CmsBasicElement(-1L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.none.text")));
        ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).addElement(new CmsBasicElement(-2L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.favourites")));
        for (DataRecord rec : locationGroupTemplates) {
            ((DefaultComboBoxModel)this.fldTemplateLocationgroup.getModel()).addElement(new CmsBasicElement(rec));
        }
        if (this.fldTemplateLocationgroup.getModel().getSize() == 1) {
            this.fldTemplateLocationgroup.setSelectedIndex(0);
        } else if (this.fldTemplateLocationgroup.getModel().getSize() == 0) {
            List locationTemplates = this.project.getTemplateManger().getLocationTemplates(-1L);
            ((DefaultListModel)this.lstTemplateLocation.getModel()).removeAllElements();
            for (DataRecord rec : locationTemplates) {
                if (this.templateFavourites.contains(rec.getLong("meta_id"))) {
                    rec.add("meta_title", "*" + rec.getString("meta_title"));
                }
                ((DefaultComboBoxModel)this.lstTemplateLocation.getModel()).addElement(new CmsBasicElement(rec));
            }
        }
    }

    private void loadObservationTemplates() {
        DataRecord rec;
        long idLocation;
        CmsBasicElement ele = (CmsBasicElement)this.fldTemplateLocationgroup.getSelectedItem();
        long idGroup = ele == null ? -1L : ele.getId();
        ele = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        long l = idLocation = ele == null ? -1L : ele.getId();
        if (idGroup == -2L && (rec = this.project.getDatastorage().executeQuery("SELECT idgroup FROM tdtaEleLocationTemplate WHERE idElement=" + idLocation, true).firstRow()) != null) {
            idGroup = rec.getLong("idgroup");
        }
        List observationTemplates = this.project.getTemplateManger().getObservationTemplates(idGroup, idLocation);
        ((DefaultListModel)this.lstTemplateObservation.getModel()).removeAllElements();
        for (DataRecord rec2 : observationTemplates) {
            ((DefaultListModel)this.lstTemplateObservation.getModel()).addElement(new CmsBasicElement(rec2).setAttribute("type", rec2.getString("type")));
        }
    }

    private void updateTemplateQuicksearch() {
        String quicksearch = this.fldTemplateQuicksearch.getText();
        if ("".equals(quicksearch)) {
            this.updateTemplatesByGroup();
        } else {
            this.loadTemplates("locationtemplate", this.lstTemplateLocation, null, -1L, quicksearch);
        }
    }

    private void updateTemplatesByGroup() {
        CmsBasicElement eleLoc = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        long selId = -1L;
        if (eleLoc != null) {
            selId = eleLoc.getId();
        }
        this.fldTemplateQuicksearch.setText("");
        CmsBasicElement ele = (CmsBasicElement)this.fldTemplateLocationgroup.getSelectedItem();
        long id = ele == null ? -1L : ele.getId();
        String relationattribute = ele == null ? null : "locationgroup";
        this.loadTemplates("locationtemplate", this.lstTemplateLocation, relationattribute, id, null, selId);
        if (selId >= 0L) {
            this.loadObservationTemplates();
        } else {
            ((DefaultListModel)this.lstTemplateObservation.getModel()).removeAllElements();
        }
        if (this.updateComponentVisibilityFlag) {
            this.updateComponentVisibility();
        }
    }

    private void loadTemplates(String elementtype, JList lst, String relationattribute, long parentId, String quicksearch) {
        this.loadTemplates(elementtype, lst, relationattribute, parentId, quicksearch, -1L);
    }

    private void loadTemplates(String elementtype, JList lst, String relationattribute, long parentId, String quicksearch, long selId) {
        CmsBasicElement selItem = null;
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes(elementtype);
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(this.project.getDefaultElement(elementtype).getAttribute("itemsort"));
        s.setSort("ele.itemsort,el.title");
        if (relationattribute != null) {
            if (parentId == -2L) {
                s.addWhere("e.idelement IN " + Util.toSqlString(this.templateFavourites, (boolean)false));
            } else if (parentId < 0L) {
                s.addWhereRelationNone((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute));
            } else {
                s.addWhereRelationId((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute), "=", Long.toString(parentId));
            }
        } else if (quicksearch != null) {
            s.addWhereFreetext(quicksearch);
        }
        SearchResult result = s.search();
        ((DefaultListModel)lst.getModel()).removeAllElements();
        for (DataRecord rec : result.getResult()) {
            if (this.templateFavourites.contains(rec.getLong("meta_id"))) {
                rec.add("meta_title", "*" + rec.getString("meta_title"));
            }
            CmsBasicElement item = new CmsBasicElement(rec);
            ((DefaultListModel)lst.getModel()).addElement(item);
            if (item.getId() != selId) continue;
            selItem = item;
        }
        if (selItem != null) {
            lst.setSelectedValue(selItem, true);
        }
        if ("observationtemplate".equals(elementtype)) {
            s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes(elementtype);
            s.addSelectTitle("meta_title");
            s.addSelectAttribute(this.project.getDefaultElement(elementtype).getAttribute("itemsort"));
            s.addSelect("ele.itemsort", "itemsort");
            s.setSort("ele.itemsort,el.title");
            s.addWhereRelationNone((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute));
            result = s.search();
            for (DataRecord rec : result.getResult()) {
                ((DefaultListModel)lst.getModel()).addElement(new CmsBasicElement(rec));
            }
        }
    }

    private int loadTemplates(String elementtype, JComboBox cBox, String relationattribute, long parentId) {
        this.updateComponentVisibilityFlag = false;
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes(elementtype);
        s.addSelectTitle("meta_title");
        s.addSelectAttribute(this.project.getDefaultElement(elementtype).getAttribute("itemsort"));
        s.setSort("ele.itemsort,el.title");
        if (relationattribute != null) {
            if (parentId < 0L) {
                s.addWhereRelationNone((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute));
            } else {
                s.addWhereRelationId((CmsAttribute)this.app.getProject().getDefaultElement(elementtype).getRelationAttribute(relationattribute), "=", Long.toString(parentId));
            }
        }
        SearchResult result = s.search();
        ((DefaultComboBoxModel)cBox.getModel()).removeAllElements();
        ((DefaultComboBoxModel)cBox.getModel()).addElement(new CmsBasicElement(-1L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.none.text")));
        for (DataRecord rec : result.getResult()) {
            ((DefaultComboBoxModel)cBox.getModel()).addElement(new CmsBasicElement(rec));
        }
        this.updateComponentVisibilityFlag = true;
        this.updateComponentVisibility();
        return result.size();
    }

    private void toggleTemplateFavourite() {
        CmsBasicElement grp = (CmsBasicElement)this.fldTemplateLocationgroup.getSelectedItem();
        CmsBasicElement eleLoc = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        if (eleLoc != null) {
            boolean sel = this.templateFavourites.contains(eleLoc.getId());
            boolean but = this.btnTemplateFavourite.isSelected();
            if (sel && !but) {
                this.templateFavourites.remove(eleLoc.getId());
                this.btnTemplateFavourite.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/favoriten24.gif")));
            } else if (!sel && but) {
                this.templateFavourites.add(eleLoc.getId());
                this.btnTemplateFavourite.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/favoriten_selected24.gif")));
            }
            this.updateTemplatesByGroup();
            this.templateFavoritesChanged = true;
        }
    }

    private void applyLocationTemplate(boolean askForOverwrite) {
        if (!this.canEdit) {
            return;
        }
        CmsBasicElement ele = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        if (ele == null) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.selectTemplateFirstNotification.text"));
            return;
        }
        this.applyLocationPanel();
        if (!this.location.isNew() || this.location.hasChanged()) {
            if (askForOverwrite) {
                if (!Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.aksOverwriteLocationWithTemplate"))) {
                    return;
                }
            } else {
                return;
            }
        }
        CmsLocationTemplate template = (CmsLocationTemplate)this.project.loadElement(ele.getId(), this.project.getUser());
        template.applyTo(this.location);
        this.location.getLongAttribute("templateid").setValue(template.getId());
        this.project.setProjectProperty("lastlocationtemplateid", template.getId() + "");
        this.project.updateRecentLocTemplatesList(Long.valueOf(template.getId()), false);
        this.populateLocationPanel();
    }

    public void selectLocationTemplate(CmsLocation loc) {
        long templateid = loc.getLongAttribute("templateid").getLong();
        this.selectLocationTemplate(templateid, loc.getAttributeValue("title"));
    }

    private long setAndCheckLocationTemplateId(long id) {
        if (!"locationtemplate".equals(this.project.getDatastorage().getElementtypeById(id))) {
            return -1L;
        }
        return id;
    }

    public void selectLocationTemplate(long templateid, String title) {
        CmsBasicElement sel = null;
        if (templateid <= 0L && this.location != null) {
            templateid = this.setAndCheckLocationTemplateId(this.location.getLongAttribute("templateid").getLong());
        }
        if (templateid <= 0L) {
            templateid = this.setAndCheckLocationTemplateId(Long.parseLong(this.project.getProjectProperty("lastlocationtemplateid", "-1")));
        }
        if (templateid > 0L) {
            CmsElement template = this.project.loadElement(templateid, this.project.getUser());
            if (template != null && template instanceof CmsLocationTemplate) {
                long groupid = template.getRelationAttribute("locationgroup").getFirstElementId();
                for (int ii = 0; ii < this.fldTemplateLocationgroup.getModel().getSize(); ++ii) {
                    CmsBasicElement be = (CmsBasicElement)this.fldTemplateLocationgroup.getModel().getElementAt(ii);
                    if (be.getId() != groupid) continue;
                    sel = be;
                    break;
                }
            }
        } else {
            for (int ii = 0; ii < this.fldTemplateLocationgroup.getModel().getSize(); ++ii) {
                CmsBasicElement be = (CmsBasicElement)this.fldTemplateLocationgroup.getModel().getElementAt(ii);
                List locTemplates = this.project.getTemplateManger().getLocationTemplates(be.getId());
                if (locTemplates == null || locTemplates.isEmpty()) continue;
                sel = be;
                break;
            }
        }
        if (sel != null) {
            this.fldTemplateLocationgroup.setSelectedItem(sel);
        }
        for (int ii = 0; ii < this.lstTemplateLocation.getModel().getSize(); ++ii) {
            CmsBasicElement be = (CmsBasicElement)this.lstTemplateLocation.getModel().getElementAt(ii);
            if (templateid > 0L) {
                if (be.getId() != templateid) continue;
                sel = be;
                break;
            }
            if (!be.getTitle().equals(title)) continue;
            sel = be;
            break;
        }
        if (sel != null) {
            this.lstTemplateLocation.setSelectedValue(sel, true);
        } else {
            this.lstTemplateLocation.setSelectedIndex(0);
        }
        this.loadObservationTemplates();
        this.updateComponentVisibility();
    }

    private void applyObservationTemplate() {
        if (!this.canEdit) {
            return;
        }
        CmsBasicElement obsTemplate = (CmsBasicElement)this.lstTemplateObservation.getSelectedValue();
        if (!this.project.checkForCurrentEvent(false)) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.chooseEventFirstNotif.text"));
            return;
        }
        if (obsTemplate != null && this.observation != null && "observationtemplate".equals(this.project.getDatastorage().getElementtypeById(obsTemplate.getId()))) {
            this.idxTemplateLocation = this.lstTemplateLocation.getSelectedIndex();
            this.applyLocationPanel();
            this.idxTemplateObservation = this.lstTemplateObservation.getSelectedIndex();
            if (this.observation != null && (!this.observation.isNew() || this.observation.hasChanged())) {
                int result = this.app.getDialog().showInfoOptionDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.aksOverwriteObservationWithTemplate"), "title", (Object[])new String[]{"Inhalte \u00fcbernehmen", "Nur verkn\u00fcpfen", "Abbrechen"});
                switch (result) {
                    case 0: {
                        CmsObservationTemplate template = (CmsObservationTemplate)this.project.loadElement(obsTemplate.getId(), this.project.getUser());
                        template.applyTo(this.observation);
                        this.observation.setLocation(this.location);
                        this.observation.getRelationAttribute("plan").add(this.location.getRelationAttribute("plan").getFirstElement());
                        this.observations.put(this.observation.getId(), this.observation);
                        this.showObservationDialog();
                        this.observation.getLongAttribute("templateid").setValue(template.getId());
                        int c = this.loadTemplates("measuretemplate", this.fldTemplateMeasure, "observationtemplate", template.getId());
                        this.panelMeasureTemaplate.setVisible(c > 0);
                        break;
                    }
                    case 1: {
                        this.observation.getLongAttribute("templateid").setValue(obsTemplate.getId());
                        int c = this.loadTemplates("measuretemplate", this.fldTemplateMeasure, "observationtemplate", obsTemplate.getId());
                        this.panelMeasureTemaplate.setVisible(c > 0);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                return;
            }
        }
    }

    private void addObsDescriptionFromTemplate() {
        CmsObservationTemplate template;
        if (!this.canEdit) {
            return;
        }
        CmsBasicElement obsTemplate = (CmsBasicElement)this.lstTemplateObservation.getSelectedValue();
        if (!this.project.checkForCurrentEvent(false)) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.chooseEventFirstNotif.text"));
            return;
        }
        ThemisAttribute att = this.app.getSettings().getObservationAttribute("description");
        if (obsTemplate != null && this.observation != null && (template = (CmsObservationTemplate)this.project.loadElement(obsTemplate.getId(), this.project.getUser())) != null) {
            JTextArea fld = this.fldObservationDescription;
            String m = fld.getText();
            String newText = template.getAttributeValue(att.getCmsCode());
            if (!"".equals(m) && !"".equals(newText)) {
                m = m + "\n";
            }
            m = m + newText;
            fld.setText(m);
            this.observation.setSaved(false);
        }
    }

    private void addNewTemplateObservation() {
        if (!this.canEdit) {
            return;
        }
        if (this.project.checkForCurrentEvent(false) && this.project.isEditFutureData()) {
            return;
        }
        CmsBasicElement ele = (CmsBasicElement)this.lstTemplateObservation.getSelectedValue();
        if (ele == null) {
            return;
        }
        if (THEMIS.checkAndCreateEvent()) {
            this.idxTemplateLocation = this.lstTemplateLocation.getSelectedIndex();
            int[] idxObservations = this.lstTemplateObservation.getSelectedIndices();
            if (!(this.location != null && this.location.isSaved() || this.location.hasAttributeValue("templateid") || this.location.hasAttributeValue("title") || this.location.hasAttributeValue("description"))) {
                this.applyLocationTemplate(false);
            }
            this.applyLocationPanel();
            long lastObservationNumber = this.getLastObservationNumber();
            int[] nArray = idxObservations;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int idx;
                this.idxTemplateObservation = idx = nArray[i];
                ele = (CmsBasicElement)this.lstTemplateObservation.getModel().getElementAt(idx);
                CmsObservationTemplate template = (CmsObservationTemplate)this.project.loadElement(ele.getId(), this.project.getUser());
                this.observation = (CmsObservation)this.project.createElement("observation");
                template.applyTo(this.observation);
                this.observation.setLocation(this.location);
                this.observation.setNumber(++lastObservationNumber);
                this.observation.getRelationAttribute("plan").add(this.location.getRelationAttribute("plan").getFirstElement());
                this.observation.getLongAttribute("templateid").setValue(template.getId());
                this.observations.put(this.observation.getId(), this.observation);
                this.location.getRelationAttribute("observations").add((CmsElement)this.observation);
            }
            if (idxObservations.length > 1) {
                this.populateObservationList();
            } else {
                this.showObservationDialog();
            }
        }
    }

    private void addNewTemplateObservations(boolean onlyChecks) {
        if (!this.canEdit) {
            return;
        }
        if (this.project.checkForCurrentEvent(false) && this.project.isEditFutureData()) {
            return;
        }
        if (THEMIS.checkAndCreateEvent()) {
            this.idxTemplateLocation = this.lstTemplateLocation.getSelectedIndex();
            if (!(this.location != null && this.location.isSaved() || this.location.hasAttributeValue("templateid") || this.location.hasAttributeValue("title") || this.location.hasAttributeValue("description"))) {
                this.applyLocationTemplate(false);
            }
            this.applyLocationPanel();
            long lastObservationNumber = this.getLastObservationNumber();
            for (int ii = 0; ii < this.lstTemplateObservation.getModel().getSize(); ++ii) {
                this.idxTemplateObservation = ii;
                CmsBasicElement ele = (CmsBasicElement)this.lstTemplateObservation.getModel().getElementAt(ii);
                CmsObservationTemplate template = (CmsObservationTemplate)this.project.loadElement(ele.getId(), this.project.getUser());
                if (onlyChecks && template.getKeyAttribute("type").getId() != 2L) continue;
                this.observation = (CmsObservation)this.project.createElement("observation");
                template.applyTo(this.observation);
                this.observation.setLocation(this.location);
                this.observation.setNumber(++lastObservationNumber);
                this.observation.getRelationAttribute("plan").add(this.location.getRelationAttribute("plan").getFirstElement());
                this.observation.getLongAttribute("templateid").setValue(template.getId());
                this.observations.put(this.observation.getId(), this.observation);
                this.location.getRelationAttribute("observations").add((CmsElement)this.observation);
            }
            this.populateObservationList();
        }
    }

    public void selectObservationTemplate(CmsObservation obs) {
        CmsElement template;
        CmsBasicElement sel = null;
        long templateid = obs.getLongAttribute("templateid").getLong();
        if (templateid > 0L && (template = this.project.loadElement(templateid, this.project.getUser())) != null && template instanceof CmsObservationTemplate) {
            long locTemplateId = template.getRelationAttribute("location").getFirstElementId();
            this.selectLocationTemplate(locTemplateId, null);
        }
        for (int ii = 0; ii < this.lstTemplateObservation.getModel().getSize(); ++ii) {
            CmsBasicElement be = (CmsBasicElement)this.lstTemplateObservation.getModel().getElementAt(ii);
            if (templateid > 0L) {
                if (be.getId() != templateid) continue;
                sel = be;
                break;
            }
            if (!be.getTitle().equals(obs.getAttributeValue("description"))) continue;
            sel = be;
            break;
        }
        if (sel != null) {
            this.lstTemplateObservation.setSelectedValue(sel, true);
        } else {
            this.lstTemplateObservation.setSelectedIndex(0);
        }
    }

    private void applyMeasureTemplate() {
        CmsMeasureTemplate template;
        if (!this.canEdit) {
            return;
        }
        CmsBasicElement ele = (CmsBasicElement)this.fldTemplateMeasure.getSelectedItem();
        if (!this.project.checkForCurrentEvent(false)) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.chooseEventFirstNotif.text"));
            return;
        }
        if (ele != null && this.observation != null && (template = (CmsMeasureTemplate)this.project.loadElement(ele.getId(), this.project.getUser())) != null) {
            String m = this.fldObservationMeasure.getText();
            this.applyObservationPanel(false, this.observation);
            this.observation.setAttributeValue("measure", m);
            template.applyTo(this.observation);
            this.fldObservationMeasure.setText(this.observation.getAttributeValue("measure"));
            this.observation.setSaved(false);
            this.showObservationDialog();
        }
    }

    private void populateLocationPanel() {
        CmsElement icon;
        this.updateComponentVisibility();
        boolean isBuilding = this.location != null && this.location.isBuilding();
        boolean useDefaultLocation = false;
        if (this.location == null) {
            useDefaultLocation = true;
            this.location = (CmsLocation)this.project.getDefaultElement("location");
        }
        this.locationAttributeComponentMap = new HashMap();
        int panelRow = 0;
        int inset = 2;
        JComponent comp = null;
        this.panelLocationMerkmale.removeAll();
        for (ThemisAttribute ta : this.app.getSettings().getLocationAttributesUsed()) {
            comp = THEMIS.addAttributeToPanel(inset, panelRow, ta, (CmsElement)this.location, this.panelLocationMerkmale);
            if (comp == null) continue;
            this.locationAttributeComponentMap.put(ta.getCmsCode(), comp);
            ++panelRow;
        }
        this.panelLocationMerkmale.revalidate();
        this.panelLocationMerkmale.repaint();
        this.panelLocationMerkmaleOuter.setVisible(panelRow > 0);
        if (isBuilding) {
            this.lblGegenstandTitle.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblGegenstandTitle.text_gebaude"));
        }
        boolean visibleGroup = this.app.getSettings().getLocationAttribute("group").isUsed();
        this.lblLocationGroup.setVisible(visibleGroup);
        this.fldLocationGroup.setVisible(visibleGroup);
        this.loadLocationGroups();
        this.fldLocationGroup.setEnabled(!this.settings.getLocationAttribute("group").isWriteprotected() || this.userAdministrator);
        this.fldLocationNumber.setText(this.location.getAttributeValue("number"));
        this.fldLocationNumber.setEnabled(this.settings.getLocNumberIndividual() && (!this.settings.getLocationAttribute("number").isWriteprotected() || this.userAdministrator));
        this.fldLocationPrenumber.setVisible(this.app.getSettings().getLocationAttribute("prefixsuffix").isUsed());
        this.fldLocationPrenumber.setText(this.location.getAttributeValue("prenumber"));
        this.fldLocationPrenumber.setEnabled(!this.settings.getLocationAttribute("prefixsuffix").isWriteprotected() || this.userAdministrator);
        this.fldLocationPostnumber.setVisible(this.app.getSettings().getLocationAttribute("suffix").isUsed());
        this.fldLocationPostnumber.setText(this.location.getAttributeValue("postnumber"));
        this.fldLocationPostnumber.setEnabled(!this.settings.getLocationAttribute("suffix").isWriteprotected() || this.userAdministrator);
        this.fldLocationName.setText(this.location.getAttributeValue("title"));
        this.fldLocationTitleOnObs.setText(this.location.getTitle());
        this.fldLocationName.setEnabled(!this.settings.getLocationAttribute("title").isWriteprotected() || this.userAdministrator);
        boolean visibleBarcode = !isBuilding && this.app.getSettings().getLocationAttribute("barcode").isUsed();
        this.lblAttLocBarcode.setVisible(visibleBarcode);
        this.fldLocationBarcode.setVisible(visibleBarcode);
        this.btnBarcode.setVisible(visibleBarcode);
        this.lblAttLocBarcode.setText(this.app.getSettings().getLocationAttribute("barcode").getLabel());
        this.fldLocationBarcode.setText(this.location.getAttributeValue("barcode"));
        this.fldLocationBarcode.setEnabled(!this.settings.getLocationAttribute("barcode").isWriteprotected() || this.userAdministrator);
        this.fldLocationQuantity.setText(this.location.getAttributeValue("quantity"));
        this.fldLocationQuantity.setEnabled(!this.settings.getLocationAttribute("quantity").isWriteprotected() || this.userAdministrator);
        this.panelLocationAufmassOuter.setVisible(!isBuilding && (this.app.getSettings().getLocationAttribute("size").isUsed() || this.app.getSettings().getLocationAttribute("quantity").isUsed()));
        this.fldLocationDimWidth.setText(this.location.getAttributeValue("dimwidth"));
        this.fldLocationDimWidth.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || this.userAdministrator);
        this.fldLocationDimHeight.setText(this.location.getAttributeValue("dimheight"));
        this.fldLocationDimHeight.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || this.userAdministrator);
        this.fldLocationDimDiameter.setText(this.location.getAttributeValue("dimdiameter"));
        this.fldLocationDimDiameter.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || this.userAdministrator);
        this.fldLocationDimArea.setText(this.location.getAttributeValue("dimarea"));
        this.fldLocationDimArea.setEnabled(!this.settings.getLocationAttribute("size").isWriteprotected() || this.userAdministrator);
        this.chkLocationShowalways.setVisible(this.settings.getDisplayHideDoneTask() > 0);
        this.chkLocationShowalways.setSelected(this.location.getBooleanAttribute("showalways").isSet());
        this.chkLocationShowalways.setEnabled(!this.settings.getLocationAttribute("showalways").isWriteprotected() || this.userAdministrator);
        this.populateObservationList();
        boolean visibleIcon = !isBuilding && this.app.getSettings().getLocationAttribute("icon").isUsed();
        this.lblLocationIconTitle.setVisible(visibleIcon);
        this.panelLocationIcon.setVisible(visibleIcon);
        long iconId = this.location.getRelationAttribute("icon").getFirstElementId();
        this.updateLocationIconDisplay(null);
        if (iconId > 0L && (icon = this.project.loadElement(iconId, this.project.getUser())) != null) {
            File iconFile = icon.getUploadAttribute("file").getFirstUploadItemFile();
            this.updateLocationIconDisplay(iconFile);
        }
        this.panelLocationDocumentsOuter.setVisible(this.app.getSettings().getLocationAttribute("documents").isUsed());
        this.loadDocumentLibrary(this.fldLocationDocumentLibraryType, this.fldLocationDocumentLibrary, this.lstLocationDocuments, this.location.getRelationAttribute("infos"));
        this.btnLocationAddDocument.setEnabled(!this.settings.getLocationAttribute("documents").isWriteprotected() || this.userAdministrator);
        this.btnLocationRemoveDocument.setEnabled(!this.settings.getLocationAttribute("documents").isWriteprotected() || this.userAdministrator);
        this.populateLocationUploads();
        this.selectLocationTemplate(this.location);
        if (useDefaultLocation) {
            this.location = null;
        }
    }

    private void populateObservationList() {
        this.populateObservationList(-1L);
    }

    private void populateObservationList(long obsId) {
        ((DefaultListModel)this.lstLocationObservation.getModel()).removeAllElements();
        String locnr = this.location == null ? null : this.location.getFullNumber();
        List ids = this.location.getRelationAttribute("observations").getElementIds(false);
        HashMap<Long, ObservationListItem> eleMap = new HashMap<Long, ObservationListItem>();
        String sql = "SELECT idelement,number,title,idtype,done FROM tdtaEleObservation WHERE idelement in " + Util.toSqlString((Iterable)ids);
        List recs = this.project.getDatastorage().executeQuery(sql, true).getResult();
        ObservationListItem sel = null;
        for (DataRecord rec : recs) {
            long id = rec.getLong("idelement");
            String number = rec.getString("number");
            if (this.observations.containsKey(id)) {
                number = this.observations.get(id).getAttributeValue("number");
            }
            String title = locnr == null ? "" : "[" + locnr + "." + number + "] " + rec.getString("title");
            boolean status = rec.getBoolean("done");
            int type = rec.getInt("idtype");
            ObservationListItem item = null;
            if (this.observations.containsKey(id)) {
                CmsObservation obs = this.observations.get(id);
                item = new ObservationListItem(obs.getId(), title, obs.getBooleanAttribute("done").isSet(), (int)obs.getKeyAttribute("type").getId());
            } else {
                item = new ObservationListItem(id, title, status, type);
            }
            eleMap.put(id, item);
        }
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (eleMap.containsKey(id)) continue;
            String number = "";
            if (this.observations.containsKey(id)) {
                number = this.observations.get(id).getAttributeValue("number");
            }
            String title = locnr == null ? "" : "[" + locnr + "." + number + "] " + this.observations.get(id).getAttributeValue("title");
            ObservationListItem item = null;
            if (this.observations.containsKey(id)) {
                CmsObservation obs = this.observations.get(id);
                item = new ObservationListItem(obs.getId(), title, obs.getBooleanAttribute("done").isSet(), (int)obs.getKeyAttribute("type").getId());
            }
            eleMap.put(id, item);
        }
        iterator = ids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (this.deletedObservations.contains(id)) continue;
            ObservationListItem item = (ObservationListItem)eleMap.get(id);
            ((DefaultListModel)this.lstLocationObservation.getModel()).addElement(item);
            if (item.id != obsId) continue;
            sel = item;
        }
        if (sel != null) {
            this.lstLocationObservation.setSelectedValue(sel, true);
        }
    }

    private void applyLocationPanel() {
        if (!this.canEdit) {
            return;
        }
        if (this.location != null) {
            long idGroup;
            String t = this.fldLocationNumber.getText();
            if (this.settings.getLocNumberIndividual() && !"".equals(t)) {
                try {
                    long tval = Long.parseLong(t);
                    this.location.setAttributeValue("number", t);
                }
                catch (Exception e) {
                    Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.itHasToBeNumberNotif.text"));
                }
            }
            this.location.setAttributeValue("prenumber", this.fldLocationPrenumber.getText());
            this.location.setAttributeValue("postnumber", this.fldLocationPostnumber.getText());
            this.location.setAttributeValue("title", this.fldLocationName.getText());
            this.location.setAttributeValue("barcode", this.fldLocationBarcode.getText());
            THEMIS.applyAttribute(this.locationAttributeComponentMap, (CmsElement)this.location);
            this.location.setAttributeValue("quantity", this.fldLocationQuantity.getText());
            this.location.setAttributeValue("dimwidth", this.fldLocationDimWidth.getText());
            this.location.setAttributeValue("dimheight", this.fldLocationDimHeight.getText());
            this.location.setAttributeValue("dimdiameter", this.fldLocationDimDiameter.getText());
            this.location.setAttributeValue("dimarea", this.fldLocationDimArea.getText());
            this.location.getBooleanAttribute("showalways").setValue(this.chkLocationShowalways.isSelected());
            CmsBasicElement groupSel = (CmsBasicElement)this.fldLocationGroup.getSelectedItem();
            long l = idGroup = groupSel == null ? -1L : groupSel.getId();
            if (idGroup >= 0L) {
                this.location.getRelationAttribute("locationgroup").set(idGroup);
            } else {
                this.location.getRelationAttribute("locationgroup").clear();
            }
        }
    }

    private void saveLocation() {
        if (this.location != null) {
            this.applyLocationPanel();
            boolean locationHasChanged = this.location.hasChanged();
            this.location.save(true, true);
            boolean warningNewerHistoryShown = false;
            for (CmsObservation obs : this.observations.values()) {
                if (obs.hasChanged()) {
                    if (!warningNewerHistoryShown && this.isNewerHistoryForObservation(obs)) {
                        Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.newerObsNotif.text"));
                        warningNewerHistoryShown = true;
                    }
                    for (UploadItem item : this.getItemsToBeDeleted(obs)) {
                        CmsElement hist = obs.getHistoryForUpload(item);
                        if (hist == null) continue;
                        ((CmsHistory)hist).getUploadAttribute("files").deleteUpload(item.getId());
                        hist.save();
                    }
                    obs.save();
                }
                this.location.getRelationAttribute("observations").getElement(obs.getId()).setSaved(true);
            }
            this.location.save(locationHasChanged);
            this.app.getProject().updateCurrentEvent();
            if (!this.deletedObservations.isEmpty()) {
                Iterator<Object> iterator = this.deletedObservations.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    CmsElement.moveToTrash((CmsApplication)this.project, (long)id, (CmsUser)this.project.getUser());
                }
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.OBSERVATION_DELETED.setReference(this.deletedObservations));
            }
            this.app.getFilter().resetSearchResult();
            if (!this.location.isBuilding() && !this.app.getFilter().getFilteredLocationIds().contains(this.location.getId())) {
                Dialogs.getInstance().showWarningDialog("warning.new-locatin-hidden-by-filter");
            }
            ArrayList currentSel = new ArrayList(this.project.getSelectionManager().getSelectedObservationIds());
            this.project.getSelectionManager().setSelectedLocation(this.location.getId(), true, (Object)this);
            if (currentSel.size() == 1 && this.location.getRelationAttribute("observations").getElementIds(false).contains(currentSel.get(0))) {
                this.project.getSelectionManager().setSelectedObservations(currentSel, true, (Object)this);
            } else {
                long obsId = this.location.getRelationAttribute("observations").getFirstElementId();
                if (obsId > 0L) {
                    this.project.getSelectionManager().setSelectedObservation(obsId, true, (Object)this);
                }
            }
            if (this.templateFavoritesChanged) {
                this.app.getSettings().setTemplateFavourite(this.templateFavourites);
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.TEMPLATES_CHANGED);
            } else if (this.templatesChanged) {
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.TEMPLATES_CHANGED);
            }
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("location").setId(this.location.getId()));
        }
    }

    private void loadIcons() {
        if (this.project != null && this.project.isOpen()) {
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("icon");
            s.setSort("el.title");
            s.addSelectMeta();
            s.addSelectAttribute((CmsAttribute)this.project.getDefaultElement("icon").getUploadAttribute("file"));
            SearchResult result = s.search();
            this.iconRecords = result.getResult();
        }
    }

    private void loadLocationGroups() {
        if (this.project != null && this.project.isOpen()) {
            long groupId = this.location.getRelationAttribute("locationgroup").getFirstElementId();
            List locationGroupTemplates = this.project.getTemplateManger().getLocationGroups(-99L);
            ((DefaultComboBoxModel)this.fldLocationGroup.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.fldLocationGroup.getModel()).addElement(new CmsBasicElement(-1L, ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.none.text")));
            for (DataRecord rec : locationGroupTemplates) {
                CmsBasicElement ele = new CmsBasicElement(rec);
                ((DefaultComboBoxModel)this.fldLocationGroup.getModel()).addElement(ele);
                if (rec.getLong("meta_id") != groupId) continue;
                this.fldLocationGroup.setSelectedItem(ele);
            }
        }
    }

    private void updateIcon(JLabel lbl, ArrayList<SimpleGeometry> drawings, File imagefile, int width, int height) {
        if (lbl == null || imagefile == null) {
            return;
        }
        try {
            lbl.setText("");
            if (imagefile.isFile()) {
                BufferedImage bi = null;
                int counter = 0;
                while (bi == null && counter < 5) {
                    bi = THEMIS.createImage(drawings, imagefile, width);
                    ++counter;
                    if (bi != null) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BufferedImage bi2 = Util.resizeImage(bi, (int)width, (int)height, (int)2);
                if (bi2 != null) {
                    ImageIcon icon = new ImageIcon(bi2);
                    lbl.setIcon(icon);
                    return;
                }
            }
            lbl.setText(imagefile.getName());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateIcon(JLabel lbl, String lblText, ImageReference icr, int width, int height) {
        if (lbl == null || icr == null || icr.getImage() == null) {
            lbl.setText("[" + lblText + "]");
            return;
        }
        try {
            BufferedImage bi;
            lbl.setText("");
            if (width <= 0 && height > 0 && icr.getImage().getHeight() > 0) {
                width = icr.getImage().getWidth() * height / icr.getImage().getHeight();
            }
            if ((bi = THEMIS.createImage(icr.getDrawings(), icr.getImage(), width)) != null) {
                ImageIcon icon = new ImageIcon(bi);
                lbl.setIcon(icon);
                return;
            }
            lbl.setText(lblText);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void addNewObservation() {
        if (!this.canEdit) {
            return;
        }
        if (!this.project.isOpen()) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noProjectNotif.text"));
            return;
        }
        if (this.project.checkForCurrentEvent(false) && this.project.isEditFutureData()) {
            return;
        }
        if (THEMIS.checkAndCreateEvent()) {
            this.applyLocationPanel();
            long lastObservationNumber = this.getLastObservationNumber();
            this.observation = (CmsObservation)this.project.createElement("observation");
            this.observation.setLocation(this.location);
            this.observation.setNumber(++lastObservationNumber);
            this.observation.getRelationAttribute("plan").add(this.location.getRelationAttribute("plan").getFirstElement());
            this.observations.put(this.observation.getId(), this.observation);
            this.showObservationDialog();
        }
    }

    public long getLastObservationNumber() {
        long lastObservationNumber = 0L;
        if (this.location == null) {
            return 0L;
        }
        for (CmsElementSummary o : this.location.getRelationAttribute("observations").getElements()) {
            if (o.isTrash()) continue;
            CmsObservation obs = this.observations.get(o.getId());
            if (obs == null) {
                obs = (CmsObservation)o.getElement();
                this.observations.put(o.getId(), obs);
            }
            if (obs == null || obs.getAttributeValueLong("number") <= lastObservationNumber) continue;
            lastObservationNumber = obs.getAttributeValueLong("number");
        }
        return lastObservationNumber;
    }

    public void addObservation(CmsObservation o) {
        if (!this.canEdit) {
            return;
        }
        this.observations.put(o.getId(), o);
    }

    public void moveObservationUp() {
        this.moveObservation(-1);
    }

    public void moveObservation(int dir) {
        ObservationListItem selObs = (ObservationListItem)this.lstLocationObservation.getSelectedValue();
        int selIndex = this.lstLocationObservation.getSelectedIndex();
        if (selIndex >= 0 && selObs != null) {
            this.location.getRelationAttribute("observations").move(selObs.id, dir > 0 ? "down" : "up");
            this.updateObservationNumbers();
            this.populateObservationList(selObs.id);
        }
    }

    public void moveObservationDown() {
        this.moveObservation(1);
    }

    private void updateObservationNumbers() {
        List obsids = this.location.getRelationAttribute("observations").getElementIds(false);
        int number = 1;
        Iterator iterator = obsids.iterator();
        while (iterator.hasNext()) {
            long obsid = (Long)iterator.next();
            if (!this.observations.containsKey(obsid)) {
                this.observations.put(obsid, (CmsObservation)this.project.loadElement(obsid, this.project.getUser()));
            }
            this.observations.get(obsid).setNumber((long)number);
            this.location.getRelationAttribute("observations").add(new CmsElementSummary((CmsElement)this.observations.get(obsid)));
            ++number;
        }
    }

    private void populateLocationUploads() {
        DefaultListModel model = (DefaultListModel)this.lstLocationFiles.getModel();
        model.clear();
        List uploadItems = this.location.getUploadAttribute("files").getUploadItems();
        ArrayList refs = this.imageReferences.getOrDefault(this.location.getId(), new ArrayList());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.gridx = -1;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        gbc0.weightx = 1.0;
        gbc0.insets = new Insets(2, 2, 2, 2);
        this.panelLocationImages.removeAll();
        int idx = 0;
        for (final UploadItem item : uploadItems) {
            if (item.isImage()) {
                final int imageIndex = idx;
                JLabel lbl = new JLabel();
                if (this.selectedLocationImage != null && item.getId() == this.selectedLocationImage.getId()) {
                    lbl.setBorder(BorderFactory.createLineBorder(Color.red, 2));
                } else {
                    lbl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
                lbl.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        LocationObservationDialog.this.setSelectedLocationImage(item, imageIndex);
                    }
                });
                boolean foundImageReference = false;
                for (ImageReference ref : refs) {
                    if (ref.getUploadItem().getId() != item.getId()) continue;
                    ArrayList<SimpleGeometry> drawings = ref.getDrawings();
                    this.updateIcon(lbl, ref.getImageFile().getName(), ref, 0, 100);
                    foundImageReference = true;
                }
                if (!foundImageReference) {
                    ArrayList drawings = ThemisApplication.getInstance().getProject().getDrawings(item.getId());
                    this.updateIcon(lbl, drawings, item.getFile(), 0, 100);
                }
                this.panelLocationImages.add((Component)lbl, gbc);
                this.dragScrollHandlerLocationImages.addDragComponent(lbl);
            } else {
                model.addElement(item);
            }
            ++idx;
        }
        this.panelLocationImages.add((Component)new JLabel(""), gbc0);
        this.panelLocationImages.revalidate();
        this.panelLocationImages.repaint();
        if (!model.isEmpty()) {
            this.lstLocationFiles.setSelectedIndex(model.size() - 1);
        }
    }

    private void calculateLocationDimensionArea(boolean useDiam) {
        String bStr = this.fldLocationDimWidth.getText().replaceAll(",", ".");
        String hStr = this.fldLocationDimHeight.getText().replaceAll(",", ".");
        String dStr = this.fldLocationDimDiameter.getText().replaceAll(",", ".");
        double b = 0.0;
        double h = 0.0;
        double d = 0.0;
        double f = 0.0;
        try {
            b = Double.parseDouble(bStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            h = Double.parseDouble(hStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d = Double.parseDouble(dStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        f = useDiam ? Math.PI * (d / 2.0) * (d / 2.0) : b * h;
        this.fldLocationDimArea.setText(Double.toString(Util.round((double)f, (int)2)));
    }

    private boolean closeLocationPanel(boolean cancel) {
        boolean doClose = true;
        if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            boolean hasChanged = this.location != null && this.location.hasChanged();
            for (CmsObservation o : this.observations.values()) {
                hasChanged = hasChanged || o.hasChanged();
            }
            if (hasChanged) {
                doClose = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("ObsLocNotSavedNotification"));
            }
        }
        if (doClose) {
            this.stopFolderObserver();
            if (!cancel) {
                this.stopElementEditLog();
            }
        }
        return doClose;
    }

    private void showObservationDialog() {
        if (this.project.checkForCurrentEvent(false) && this.project.isEditFutureData()) {
            return;
        }
        this.currentPanel = "observation";
        this.currentElement = this.observation;
        this.observationChanged = false;
        this.populateObservationPanel();
        ((CardLayout)this.panelEditor.getLayout()).show(this.panelEditor, "cardObservation");
        this.panelLocationOuter.setVisible(false);
        if (this.settings.getImageForObservation()) {
            this.startElementEditLog((CmsElement)this.observation);
        }
    }

    private void populateObservationPanel() {
        this.updateComponentVisibility();
        if (this.observation != null) {
            this.panelObservationDocumentsOuter.setVisible(this.app.getSettings().getObservationAttribute("documents").isUsed());
            this.loadDocumentLibrary(null, this.fldObservationDocumentLibrary, this.lstObservationDocuments, this.observation.getRelationAttribute("infos"));
            this.populateObservationContacts();
            this.updateAudioComponents();
            this.populateObservationUploads();
            this.fldObservationDescription.setText(this.observation.getAttributeValue("description"));
            this.panelObservationProperties.removeAll();
            this.observationAttributeComponentMap = new HashMap();
            int panelRow = 0;
            int inset = 2;
            JComponent comp = null;
            for (ThemisAttribute ta : this.app.getSettings().getObservationAttributesUsed()) {
                if (!ta.doShow(this.observation.getKeyAttribute("type").getId()) || (comp = THEMIS.addAttributeToPanel(inset, panelRow, ta, (CmsElement)this.observation, this.panelObservationProperties)) == null) continue;
                this.observationAttributeComponentMap.put(ta.getCmsCode(), comp);
                if (comp instanceof JTextComponent) {
                    this.addObservationChangeListener((JTextComponent)comp);
                }
                ++panelRow;
            }
            this.panelObservationPropertiesOuter.setVisible(panelRow > 0);
            this.panelObservationProperties.revalidate();
            this.panelObservationProperties.repaint();
            this.loadKeytable(this.fldObservationRepeat, "repeat");
            this.fldObservationRepeat.setSelectedItem(this.observation.getAttributeValue("repeat"));
            this.fldObservationRepeatCount.setText(this.observation.getAttributeValue("repeatcount"));
            this.fldLocationTitleOnObs.setText(this.location.getTitle());
            this.fldObservationTitle.setText(this.observation.getAttributeValue("title"));
            this.fldObservationNumber.setText(this.location.getFullNumber() + "." + this.observation.getAttributeValue("number"));
            this.fldObservationDueDate.setDate(this.observation.getDateAttribute("duedate").getDate());
            this.fldObservationDueDate.setEnabled(!this.settings.getObservationAttribute("duedate").isWriteprotected() || this.userAdministrator);
            this.fldObservationStatus.setSelected(this.observation.getAttributeValueBoolean("done"));
            this.fldObservationStatus.setEnabled(!this.settings.getObservationAttribute("done").isWriteprotected() || this.userAdministrator);
            int c = this.loadTemplates("measuretemplate", this.fldTemplateMeasure, "observationtemplate", this.observation.getLongAttribute("templateid").getLong());
            this.panelMeasureTemaplate.setVisible(c > 0);
            this.panelObservationMeasure.setVisible(this.app.getSettings().getObservationAttribute("measure").isUsed());
            this.fldObservationMeasure.setText(this.observation.getAttributeValue("measure"));
            this.fldObservationMeasure.setEnabled(!this.settings.getObservationAttribute("measure").isWriteprotected() || this.userAdministrator);
            this.panelObservationRisk.setVisible(this.app.getSettings().getObservationAttribute("assessment").isUsed());
            this.lblObservationRisk.setText(this.app.getSettings().getObservationAttribute("assessment").getLabel());
            this.fldObservationRisk.setText(this.observation.getIntegerAttribute("risk").getValue());
            this.selectObservationTemplate(this.observation);
            this.updateObservationType(true);
        }
    }

    private void populateObservationContacts() {
        this.panelObservationContact.setVisible(this.app.getSettings().getObservationAttribute("responsible").isUsed());
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.setElementtypes("company");
        s.addSelectAttribute(this.project.getDefaultElement("company").getAttribute("name"));
        s.addSelectTitle("meta_title");
        s.setSort("ele.name");
        SearchResult result = s.search();
        this.fldObservationContact.removeAllItems();
        this.fldObservationContact.addItem(new CmsBasicElement(-1L, "-"));
        for (DataRecord rec : result.getResult()) {
            this.fldObservationContact.addItem(new CmsBasicElement(rec));
        }
        long contactId = this.observation.getRelationAttribute("responsible").getFirstElementId();
        boolean foundSelectedContact = false;
        for (int ii = 1; ii < this.fldObservationContact.getItemCount(); ++ii) {
            if (((CmsBasicElement)this.fldObservationContact.getItemAt(ii)).getId() != contactId) continue;
            this.fldObservationContact.setSelectedIndex(ii);
            foundSelectedContact = true;
            break;
        }
        if (!foundSelectedContact) {
            this.fldObservationContact.setSelectedIndex(0);
        }
    }

    private void setSelectedObservationImage(UploadItem item, int idxSel) {
        this.selectedObservationImage = item;
        boolean allowEdit = this.project.isUploadImageEditable(item);
        this.btnObservationRemoveFile.setEnabled(allowEdit);
        this.btnObservationRotateImageCCW.setEnabled(allowEdit);
        this.btnObservationRotateImageCW.setEnabled(allowEdit);
        int idx = 0;
        for (Component c : this.panelObservationImages.getComponents()) {
            if (c instanceof JLabel) {
                if (idx == idxSel) {
                    ((JLabel)c).setBorder(BorderFactory.createLineBorder(Color.red, 2));
                } else {
                    ((JLabel)c).setBorder(null);
                }
            }
            ++idx;
        }
    }

    private void setSelectedLocationImage(UploadItem item, int idxSel) {
        this.selectedLocationImage = item;
        int idx = 0;
        for (Component c : this.panelLocationImages.getComponents()) {
            if (c instanceof JLabel) {
                if (idx == idxSel) {
                    ((JLabel)c).setBorder(BorderFactory.createLineBorder(Color.red, 2));
                } else {
                    ((JLabel)c).setBorder(null);
                }
            }
            ++idx;
        }
    }

    private void populateObservationUploads() {
        DefaultListModel model = (DefaultListModel)this.lstObservationFiles.getModel();
        model.clear();
        List uploadItems = this.observation.getUploadAttribute("files").getUploadItems();
        ArrayList<ImageReference> refs = this.imageReferences.getOrDefault(this.observation.getId(), new ArrayList());
        boolean createRefs = !refs.isEmpty();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.gridx = -1;
        gbc0.gridy = 0;
        gbc0.fill = 2;
        gbc0.weightx = 1.0;
        gbc0.insets = new Insets(2, 2, 2, 2);
        this.panelObservationImages.removeAll();
        boolean foundSelection = false;
        int idx = 0;
        for (final UploadItem item : uploadItems) {
            if (item.isImage()) {
                final int imageIndex = idx;
                JLabel lbl = new JLabel();
                if (this.selectedObservationImage != null && item.getId() == this.selectedObservationImage.getId()) {
                    lbl.setBorder(BorderFactory.createLineBorder(Color.red, 2));
                } else {
                    lbl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                }
                lbl.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        LocationObservationDialog.this.setSelectedObservationImage(item, imageIndex);
                    }
                });
                boolean foundImageReference = false;
                for (ImageReference ref : refs) {
                    if (ref.getUploadItem().getId() != item.getId()) continue;
                    this.updateIcon(lbl, ref.getImageFile().getName(), ref, 0, 100);
                    foundImageReference = true;
                }
                if (!foundImageReference) {
                    ArrayList drawings = ThemisApplication.getInstance().getProject().getDrawings(item.getId());
                    this.updateIcon(lbl, drawings, item.getFile(), 0, 100);
                    if (createRefs) {
                        ImageReference imgref = new ImageReference((CmsElement)this.observation, item);
                        imgref.setImageInfo(item.getFileInfo());
                        refs.add(imgref);
                    }
                }
                Icon icon = lbl.getIcon();
                this.panelObservationImages.add((Component)lbl, gbc);
                this.dragScrollHandlerObservationImages.addDragComponent(lbl);
            } else {
                model.addElement(item);
            }
            ++idx;
        }
        this.imageReferences.put(this.observation.getId(), refs);
        this.panelObservationImages.add((Component)new JLabel(""), gbc0);
        this.panelObservationImages.revalidate();
        this.panelObservationImages.repaint();
        if (!model.isEmpty()) {
            this.lstObservationFiles.setSelectedIndex(model.size() - 1);
        }
    }

    private void applyObservationPanel(boolean isTemplate, CmsObservation obs) {
        if (!this.canEdit) {
            return;
        }
        if (obs != null) {
            String obsMD5 = obs.getMD5();
            obs.getKeyAttribute("type").setValue(this.observationType);
            CmsBasicElement ele = (CmsBasicElement)this.fldObservationContact.getSelectedItem();
            obs.getRelationAttribute("responsible").set(ele != null ? ele.getId() : -1L);
            this.setKeyAttribute((CmsElement)obs, "repeat", this.fldObservationRepeat);
            try {
                int c = 0;
                if (!"".equals(this.fldObservationRepeatCount.getText())) {
                    c = Integer.parseInt(this.fldObservationRepeatCount.getText());
                }
                obs.getIntegerAttribute("repeatcount").setValue(c);
            }
            catch (Exception e) {
                Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noIntegerNotif.text") + " " + this.fldObservationRepeatCount.getText());
            }
            obs.setAttributeValue("title", this.fldObservationTitle.getText());
            obs.setAttributeValue("description", this.fldObservationDescription.getText());
            THEMIS.applyAttribute(this.observationAttributeComponentMap, (CmsElement)obs);
            obs.setDone(this.fldObservationStatus.isSelected());
            obs.getDateAttribute("duedate").setDate(this.fldObservationDueDate.getDate());
            obs.setAttributeValue("measure", this.fldObservationMeasure.getText());
            try {
                obs.getIntegerAttribute("risk").setValue(Integer.parseInt(this.fldObservationRisk.getText()));
            }
            catch (Exception e) {
                // empty catch block
            }
            String newMd5 = obs.getMD5();
            if (!newMd5.equals(obsMD5)) {
                obs.setSaved(false);
            }
            if (!isTemplate) {
                this.location.getRelationAttribute("observations").add((CmsElement)obs);
                this.populateObservationList();
            }
        }
    }

    private void captureImage() {
        if (this.fotoDisabled) {
            Dialogs.getInstance().showWarningDialog("Es k\u00f6nnen keine Bilder aufgenommen werden. Der Speicherort f\u00fcr die Bilder ist nicht korrekt gesetzt. Pr\u00fcfen Sie diesen in den Systemeinstellungen.");
            return;
        }
        WebcamFrame2 webcamFrame = new WebcamFrame2(THEMIS.getMainWindow());
        SwingUtilities.invokeLater(webcamFrame);
    }

    private boolean observationChanged() {
        if (this.observation == null) {
            return false;
        }
        if (this.observation.isNew()) {
            return true;
        }
        CmsObservation obsNew = (CmsObservation)this.project.loadElement(this.observation.getId(), this.project.getUser());
        this.applyObservationPanel(false, obsNew);
        boolean isChanged = !this.observation.getMD5().equals(obsNew.getMD5());
        isChanged = isChanged || this.observation.getUploads(false).size() != obsNew.getUploads(false).size();
        ArrayList refs = this.imageReferences.getOrDefault(this.observation.getId(), new ArrayList());
        for (ImageReference ref : refs) {
            isChanged = isChanged || ref.isChanged();
        }
        return isChanged;
    }

    private boolean closeObservationPanel() {
        if (this.settings.getImageForObservation()) {
            this.stopElementEditLog();
        }
        if (!this.editObservationOnly) {
            this.showLocationDialog();
            this.observation = null;
            this.updateComponentVisibility();
        }
        return true;
    }

    public boolean isNewerHistoryForObservation(CmsObservation o) {
        CmsEvent event = this.project.getCurrentEvent();
        if (event == null) {
            return false;
        }
        CmsHistory latestHistory = o.getLatestHistory();
        return latestHistory != null && latestHistory.isLaterThan(event);
    }

    public void setAudioState(int s) {
        this.audiostate = s;
        this.updateAudioComponents();
    }

    public int getAudioState() {
        return this.audiostate;
    }

    public File getFile() {
        return this.audiofile;
    }

    public ThemisAudioRecorder getRecorder() {
        return this.recorder;
    }

    private void updateAudioComponents() {
        if (this.audiostate == 1) {
            this.recordButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.playButton.setEnabled(false);
            this.recordButton1.setEnabled(false);
            this.stopButton1.setEnabled(true);
            this.playButton1.setEnabled(false);
            this.progressAudioLevel.setVisible(true);
            this.progressAudioLevel1.setVisible(true);
        } else if (this.audiostate == 2) {
            this.recordButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.playButton.setEnabled(false);
            this.recordButton1.setEnabled(false);
            this.stopButton1.setEnabled(true);
            this.playButton1.setEnabled(false);
            this.progressAudioLevel.setVisible(false);
        } else {
            this.recordButton.setEnabled(this.canEdit);
            this.stopButton.setEnabled(false);
            this.playButton.setEnabled(this.audiofile != null);
            this.recordButton1.setEnabled(this.canEdit);
            this.stopButton1.setEnabled(false);
            this.playButton1.setEnabled(this.audiofile != null);
            this.progressAudioLevel.setVisible(false);
            this.progressAudioLevel1.setVisible(false);
        }
        if (this.type == 2) {
            this.recordButton.setEnabled(false);
            this.recordButton1.setEnabled(false);
        }
    }

    public void stopAudio() throws IOException {
        if (this.audiostate == 1) {
            this.recorder.stopRecording();
            this.setAudioState(3);
            if (this.audiofile != null && this.audiofile.isFile()) {
                if (this.addFotosToObs) {
                    this.observation.getUploadAttribute("files").addUpload(this.audiofile);
                    this.populateObservationUploads();
                } else {
                    this.location.getUploadAttribute("files").addUpload(this.audiofile);
                    this.populateLocationUploads();
                }
            }
        } else if (this.audiostate == 2) {
            this.setAudioState(3);
        }
    }

    private void captureAudio() {
        int count;
        if (!this.canEdit) {
            return;
        }
        this.audiofile = null;
        for (count = 0; (this.audiofile == null || this.audiofile.exists()) && count < 10; ++count) {
            this.audiofile = new File(this.app.getProject().getTempfileLocation(), Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.app.getProject().getTimeZone()) + ".wav");
        }
        if (count == 10) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noAudioStreamNotif.text"));
            return;
        }
        this.recorder = new ThemisAudioRecorder(this.audiofile);
        this.recorder.addListener(event -> {
            if (event instanceof ThemisAudioRecorder.SilenceDetectionEvent) {
                SwingUtilities.invokeLater(() -> {
                    if (((ThemisAudioRecorder.SilenceDetectionEvent)event).getDuration() > 5000L) {
                        this.recorder.setPaused(true);
                        this.setAudioState(4);
                        boolean cont = Dialogs.getInstance().showConfirmDialog(this.bundle.getString("LocationObservationDialog.audioRecording.microfoneMuted"));
                        if (cont) {
                            this.recorder.resetSilenceDetection();
                            this.recorder.setPaused(false);
                            this.setAudioState(1);
                        } else {
                            this.recorder.stopRecording();
                            this.setAudioState(3);
                        }
                    }
                });
            } else if (event instanceof ThemisAudioRecorder.AudioLevelEvent) {
                double level = ((ThemisAudioRecorder.AudioLevelEvent)event).getLevel();
                int progress = level > 0.0 ? (int)(level * 100.0) : 0;
                this.progressAudioLevel.setValue(progress);
                this.progressAudioLevel1.setValue(progress);
            } else if (event instanceof ThemisAudioRecorder.MicrophoneUnavailable) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.stopAudio();
                        Dialogs.getInstance().showWarningDialog(this.bundle.getString("LocationObservationDialog.audioRecording.microfoneDisconnected"));
                    }
                    catch (IOException ex) {
                        Dialogs.getInstance().showErrorDialog("recording-error", ex);
                        this.recorder.stopRecording();
                        this.setAudioState(3);
                    }
                });
            }
        });
        this.lblFileInfo.setText("0");
        this.lblFileInfo1.setText("0");
        this.setAudioState(1);
        try {
            this.recorder.startRecording();
        }
        catch (LineUnavailableException ex) {
            Dialogs.getInstance().showErrorDialog("recording-error", ex);
            this.recorder.stopRecording();
            this.setAudioState(3);
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                while (LocationObservationDialog.this.getAudioState() != 3) {
                    Thread.sleep(100L);
                    double seconds = LocationObservationDialog.this.recorder.getDurationInSeconds();
                    LocationObservationDialog.this.lblFileInfo.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time.text"), Double.toString(seconds)));
                    LocationObservationDialog.this.lblFileInfo1.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time.text"), Double.toString(seconds)));
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
            }
        };
        worker.execute();
    }

    private void playAudio() {
        if (this.audiofile == null) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.noAudioSelectedNotif.text"));
            return;
        }
        this.audiostate = 2;
        this.updateAudioComponents();
        this.lblFileInfo.setText("");
        try {
            final AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.audiofile);
            final AudioFormat format = audioInputStream.getFormat();
            long frames = audioInputStream.getFrameLength();
            final double durationInSeconds = Util.round((double)(((double)frames + 0.0) / (double)format.getFrameRate()), (int)1);
            SwingWorker<Void, Void> worker2 = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Date dt = new Date();
                    long mili0 = dt.getTime();
                    while (LocationObservationDialog.this.getAudioState() == 2) {
                        Thread.sleep(100L);
                        dt = new Date();
                        long seconds = (dt.getTime() - mili0) / 100L;
                        LocationObservationDialog.this.lblFileInfo.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time2.text"), Float.toString((float)seconds / 10.0f), durationInSeconds));
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                }
            };
            worker2.execute();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void doInBackground() throws Exception {
                    Date dt = new Date();
                    long mili0 = dt.getTime();
                    SourceDataLine auline = null;
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    try {
                        auline = (SourceDataLine)AudioSystem.getLine(info);
                        auline.open(format);
                    }
                    catch (LineUnavailableException e) {
                        Dialogs.getInstance().showErrorDialog("Line unavailable", e);
                        LocationObservationDialog.this.setAudioState(3);
                        return null;
                    }
                    catch (Exception e) {
                        Dialogs.getInstance().showErrorDialog("ERROR : " + e.getMessage(), e);
                        return null;
                    }
                    if (auline.isControlSupported(FloatControl.Type.PAN)) {
                        FloatControl pan = (FloatControl)auline.getControl(FloatControl.Type.PAN);
                        if (LocationObservationDialog.this.curPosition == Position.RIGHT) {
                            pan.setValue(1.0f);
                        } else if (LocationObservationDialog.this.curPosition == Position.LEFT) {
                            pan.setValue(-1.0f);
                        }
                    }
                    try {
                        auline.start();
                        int nBytesRead = 0;
                        int buffer_size = 128000;
                        byte[] abData = new byte[buffer_size];
                        while (nBytesRead != -1 && LocationObservationDialog.this.audiostate == 2) {
                            nBytesRead = audioInputStream.read(abData, 0, abData.length);
                            if (nBytesRead >= 0) {
                                auline.write(abData, 0, nBytesRead);
                            }
                            dt = new Date();
                            long seconds = (dt.getTime() - mili0) / 100L;
                            LocationObservationDialog.this.lblFileInfo.setText(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.time.text"), Float.toString((float)seconds / 10.0f)));
                        }
                        LocationObservationDialog.this.setAudioState(3);
                        LocationObservationDialog.this.lblFileInfo.setText("");
                    }
                    catch (IOException e) {
                        Dialogs.getInstance().showErrorDialog("error.cannot-read-file", e);
                        LocationObservationDialog.this.setAudioState(3);
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        auline.drain();
                        auline.close();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                }
            };
            worker.execute();
        }
        catch (UnsupportedAudioFileException e) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.audioNotSupportedNotif.text"), e);
            return;
        }
        catch (IOException e) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.errorReadingFileNotif.text"), e);
            this.setAudioState(3);
            return;
        }
    }

    private void createLocationTemplate(CmsElement ele) {
        CmsBasicElement group;
        if (ele == null) {
            ele = this.project.createElement("locationtemplate");
        }
        if ((group = (CmsBasicElement)this.fldTemplateLocationgroup.getSelectedItem()).getId() > 0L) {
            ele.getRelationAttribute("locationgroup").set(group.getId());
        }
        ele.getAttribute("locationgroup").setHidden(true);
        CmsElementPanel p = new CmsElementPanel(ele, THEMIS.fontLabel, THEMIS.fontTextfield, THEMIS.fontLabelBigBold);
        if (Dialogs.getInstance().showDialog(p, this.project.getResourceText("template.create-new"), new String[]{this.project.getResourceText("dialog.save"), this.project.getResourceText("dialog.cancel")}) == 0) {
            p.updateElement();
            CmsElement e = p.getElement();
            if (!e.hasAttributeValue("title")) {
                Dialogs.getInstance().showWarningDialog(this.project.getResourceText("template.title-mandatory"));
                this.createLocationTemplate(e);
                return;
            }
            CmsBasicElement selLoc = this.getLocationTemplate(e.getTitle());
            if (selLoc != null) {
                ArrayList<String> locTitles = new ArrayList<String>();
                for (CmsBasicElement be : this.getLocationTemplates()) {
                    locTitles.add(be.getTitle());
                }
                int count = 1;
                String newTitle = e.getTitle();
                while (locTitles.contains(newTitle)) {
                    newTitle = e.getTitle() + " (" + ++count + ")";
                }
                e.getAttribute("title").setValue(newTitle);
            }
            boolean save = e.save();
            ((DefaultListModel)this.lstTemplateLocation.getModel()).addElement(new CmsBasicElement(e));
            this.lstTemplateLocation.setSelectedIndex(this.lstTemplateLocation.getModel().getSize() - 1);
        }
    }

    private File loadFileForObservation(File f) throws IOException {
        boolean success = false;
        if (f != null && (f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".jpeg") || f.getName().toLowerCase().endsWith(".png") || f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".wav"))) {
            File tmpFolder = this.app.getProject().getTempfileLocation();
            File outputfile = new File(tmpFolder, f.getName());
            try {
                int counter = 1;
                String name = Util.getFileNameWithoutExtension((File)f);
                String extension = Util.getFileExtension((File)f);
                while (outputfile.exists()) {
                    outputfile = new File(tmpFolder, name + "_" + counter + "." + extension);
                    ++counter;
                }
                if (f.getName().toLowerCase().endsWith(".wav")) {
                    Util.copy((File)f, (File)outputfile);
                    success = outputfile.isFile();
                } else {
                    BufferedImage image = this.imageSize == 0 ? ImageIO.read(f) : Util.resizeImage((BufferedImage)ImageIO.read(f), (int)this.imageSize, (int)0, (int)1, (boolean)false);
                    success = THEMIS.createImageFile(image, outputfile, this.app.getSettings().getImageUploadQuality());
                }
            }
            catch (IOException ex) {
                this.project.getLogger().fine("Cannot process observation upload: " + ex.getMessage());
            }
            return outputfile;
        }
        Dialogs.getInstance().showErrorDialog("error.cannot-read-fileformat");
        return null;
    }

    private boolean dropFileImage(List<File> files) {
        boolean result = true;
        for (File f : files) {
            try {
                UploadItem item;
                File outputfile = this.loadFileForObservation(f);
                if (outputfile == null) continue;
                if (this.addFotosToObs) {
                    this.observationChanged = true;
                    item = this.observation.getUploadAttribute("files").addUpload(outputfile);
                    this.populateObservationUploads();
                } else {
                    this.locationChanged = true;
                    item = this.location.getUploadAttribute("files").addUpload(outputfile);
                    this.populateLocationUploads();
                }
                if (item == null || !this.app.getSettings().getImageKeepOriginal()) continue;
                Util.copy((File)f, (File)new File(this.project.getImagefileLocation(), item.createFilename()));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                result = false;
            }
        }
        return result;
    }

    private void rotateImage(CmsElement ele, UploadItem item, double angle) {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        if (item == null) {
            return;
        }
        ArrayList<Object> refs = this.imageReferences.getOrDefault(ele.getId(), new ArrayList());
        if (refs.isEmpty()) {
            refs = this.createImageReferences(ele, ele.getUploadAttribute("files").getImageUploadItems());
        }
        ImageReference img = null;
        for (ImageReference ref : refs) {
            if (ref.getUploadItem().getId() != item.getId()) continue;
            img = ref;
            break;
        }
        if (img != null) {
            switch ((int)angle) {
                case 90: {
                    img.applyImageCorrection(new ImageRotateRight());
                    break;
                }
                case -90: 
                case 270: {
                    img.applyImageCorrection(new ImageRotateLeft());
                    break;
                }
                case 180: {
                    img.applyImageCorrection(new ImageRotateLeft());
                    img.applyImageCorrection(new ImageRotateLeft());
                }
            }
            if (ele instanceof CmsLocation) {
                this.populateLocationUploads();
            } else {
                this.populateObservationUploads();
            }
        }
    }

    private ArrayList<ImageReference> createImageReferences(CmsElement ref, ArrayList<UploadItem> items) {
        ArrayList<ImageReference> references = new ArrayList<ImageReference>();
        for (UploadItem item : items) {
            if (!item.isImage()) continue;
            ImageReference imgref = new ImageReference(ref, item.getFile(), item.getFileComment(), item.getUploadDetail(), item.getFileInfo(), item.getIdelement());
            if (item.getFileInfo() == null || "".equals(item.getFileInfo())) {
                imgref.setImageInfo(item.getFileInfo());
            }
            imgref.setUploadItem(item);
            references.add(imgref);
        }
        this.imageReferences.put(ref.getId(), references);
        return references;
    }

    private void startElementEditLog(CmsElement ele) {
        if (this.observationlog != null && this.observationlog.getLongAttribute("observationid").getLong() == ele.getId()) {
            return;
        }
        this.stopElementEditLog();
        this.observationlog = this.project.createElement("log", this.project.getUser());
        this.observationlog.getDateAttribute("startedit").setDate(new Date());
        this.observationlog.getLongAttribute("observationid").setValue(ele.getId());
        this.observationlog.getLongAttribute("eventid").setValue(this.app.getProject().getCurrentEventId());
    }

    private void stopElementEditLog() {
        if (this.observationlog != null) {
            this.observationlog.getDateAttribute("endedit").setDate(new Date());
            this.observationlog.save();
            this.observationlog = null;
        }
    }

    private void initialiseFolderObserver() {
        File folder = this.app.getSettings().getFolderImageObserver().getValue(true);
        if (this.observer != null && this.observer.isRunning()) {
            ThemisLogger.logger.warning("Intialising folder observer, but observer is already running");
            this.observer.stopRunning();
            while (!this.observer.isTerminated()) {
            }
            ThemisLogger.logger.info("Folder observer stopped");
        }
        if (folder == null || !folder.exists()) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("LocationObservationDialog.uploadFolderNotExistingNotif.text"));
            this.fotoDisabled = true;
            return;
        }
        if (!Util.canWrite((File)folder)) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("LocationObservationDialog.uploadFolderNoWritePermission.text"));
            this.fotoDisabled = true;
            return;
        }
        this.observer = new FolderObserver(ThemisLogger.logger, this.app.getSettings().getFolderImageObserver().getValue(true));
        ThemisLogger.logger.info("Folder observer created");
        this.observer.registerListener(new FolderListener(){

            public void onNewFiles(FolderObserver observer, ArrayList<String> filenames) {
                for (String filename : filenames) {
                    if (!filename.toLowerCase().endsWith(".jpg") && !filename.toLowerCase().endsWith(".png")) continue;
                    if (LocationObservationDialog.this.currentElement != null && (LocationObservationDialog.this.currentElement instanceof CmsObservation ? !LocationObservationDialog.this.app.getLicense().hasLicenseFull() && ((CmsObservation)LocationObservationDialog.this.currentElement).getCurrentHistory().hasImages() : !LocationObservationDialog.this.app.getLicense().hasLicenseFull() && !((CmsLocation)LocationObservationDialog.this.currentElement).getImageUploadItems().isEmpty())) {
                        return;
                    }
                    File outputfile = null;
                    try {
                        BufferedImage image = null;
                        int counter = 0;
                        File originalFile = new File(observer.getFolder(), filename);
                        for (counter = 0; image == null && counter < 50; ++counter) {
                            try {
                                image = ImageIO.read(originalFile);
                                if (image == null || LocationObservationDialog.this.imageSize == 0) continue;
                                image = Util.resizeImage((BufferedImage)image, (int)LocationObservationDialog.this.imageSize, (int)0, (int)1, (boolean)false);
                                continue;
                            }
                            catch (Exception e) {
                                ThemisLogger.logger.info("Could not load image " + originalFile + ". Reason: " + e.getLocalizedMessage());
                            }
                            if (image != null) continue;
                            try {
                                ThemisLogger.logger.info("Waiting for image " + originalFile + " to be loaded.");
                                Thread.sleep(200L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                return;
                            }
                        }
                        if (image == null) {
                            Dialogs.getInstance().showErrorDialog("error.load-photos-repeat");
                            return;
                        }
                        if (LocationObservationDialog.this.currentElement == null) continue;
                        File tmpFolder = LocationObservationDialog.this.app.getProject().getTempfileLocation();
                        outputfile = new File(tmpFolder, filename);
                        int c = 1;
                        String name = Util.getFileNameWithoutExtension((File)outputfile);
                        String extension = Util.getFileExtension((File)outputfile);
                        while (outputfile.exists()) {
                            outputfile = new File(tmpFolder, name + "_" + c + "." + extension);
                            ++c;
                        }
                        THEMIS.createImageFile(image, outputfile, LocationObservationDialog.this.app.getSettings().getImageUploadQuality());
                        UploadItem item = LocationObservationDialog.this.currentElement.getUploadAttribute("files").addUpload(outputfile);
                        item.setStatus(1);
                        CmsEvent currentEvent = LocationObservationDialog.this.project.getCurrentEvent();
                        item.setFileInfo(LocationObservationDialog.this.currentElement.getTitle() + (currentEvent == null ? "" : "[" + LocationObservationDialog.this.project.getCurrentEvent().getTitle() + "]"));
                        LocationObservationDialog.this.currentElement.setSaved(false);
                        if (LocationObservationDialog.this.currentElement instanceof CmsObservation) {
                            LocationObservationDialog.this.populateObservationUploads();
                        } else {
                            LocationObservationDialog.this.populateLocationUploads();
                        }
                        if (item == null || !LocationObservationDialog.this.app.getSettings().getImageKeepOriginal()) continue;
                        File f = new File(LocationObservationDialog.this.project.getImagefileLocation(), item.createFilename());
                        Util.copy((File)originalFile, (File)f);
                    }
                    catch (IOException ex) {
                        ThemisLogger.logger.severe("Faled to load image. Reason: " + ex.getLocalizedMessage());
                        Dialogs.getInstance().showErrorDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.errReadingFileNotif.text"), filename));
                    }
                }
            }
        });
        this.observer.start();
        ThemisLogger.logger.info("Folder observer started");
    }

    public void stopFolderObserver() {
        if (this.observer != null) {
            ThemisLogger.logger.info("Stopping folder observer ...");
            this.observer.unregisterListener();
            this.observer.stopRunning();
            this.observer.interrupt();
        } else {
            ThemisLogger.logger.warning("Trying to stop folder observer, but no folder observer is defined");
        }
    }

    private void updateObservationType(boolean setButton) {
        Color bkSel = Color.BLACK;
        Color bkUnsel = Color.LIGHT_GRAY;
        Color txtSel = Color.BLACK;
        Color txtUnsel = Color.DARK_GRAY;
        Font fSel = THEMIS.fontLabelBold;
        Font fUnsel = THEMIS.fontLabel;
        this.observationType = this.observation.getKeyAttribute("type").getId();
        boolean showDueDate = this.app.getSettings().getObservationAttribute("duedate").isUsed();
        boolean showDone = this.app.getSettings().getObservationAttribute("done").isUsed();
        switch ((int)this.observationType) {
            case 2: {
                this.panelObservationStatus.setVisible(false);
                this.panelObservationDuedate.setVisible(showDueDate);
                this.panelObservationRepeat.setVisible(showDueDate);
                this.lblObservationHead.setBackground(THEMIS.COLOR_CHECK);
                this.lblObservationHead.setText(this.project.getResourceText("element.observation") + " - " + this.settings.getTerm(ThemisSettings.Term.TypKontrolle));
                if (setButton) {
                    this.btnTypeKontrolle.setSelected(true);
                }
                this.panelObservationStatus.setVisible(false);
                this.lblObservationDuedate.setText(this.bundle.getString("LocationObservationDialog.lblObservationDuedate.check.text"));
                break;
            }
            case 3: {
                this.panelObservationStatus.setVisible(false);
                this.panelObservationDuedate.setVisible(false);
                this.panelObservationRepeat.setVisible(false);
                this.lblObservationHead.setBackground(THEMIS.COLOR_INFO);
                this.lblObservationHead.setText(this.project.getResourceText("element.observation") + " - " + this.settings.getTerm(ThemisSettings.Term.TypInformation));
                if (!setButton) break;
                this.btnTypeInfo.setSelected(true);
                break;
            }
            case 4: {
                this.panelObservationStatus.setVisible(showDone);
                this.panelObservationDuedate.setVisible(showDueDate);
                this.panelObservationRepeat.setVisible(showDueDate);
                this.lblObservationHead.setBackground(THEMIS.COLOR_TASK);
                this.lblObservationHead.setText(this.project.getResourceText("element.observation") + " - " + this.settings.getTerm(ThemisSettings.Term.TypAufgabe));
                this.lblObservationDuedate.setText(this.bundle.getString("LocationObservationDialog.lblObservationDuedate.defect.text"));
                if (!setButton) break;
                this.btnTypeAufgabe.setSelected(true);
                break;
            }
            default: {
                this.panelObservationStatus.setVisible(showDone);
                this.panelObservationDuedate.setVisible(showDueDate);
                this.panelObservationRepeat.setVisible(showDueDate);
                this.lblObservationHead.setBackground(THEMIS.COLOR_DEFECT);
                this.lblObservationHead.setText(this.project.getResourceText("element.observation") + " - " + this.settings.getTerm(ThemisSettings.Term.TypMangel));
                this.lblObservationDuedate.setText(this.bundle.getString("LocationObservationDialog.lblObservationDuedate.defect.text"));
                if (!setButton) break;
                this.btnTypeMangel.setSelected(true);
            }
        }
        this.btnTypeInfo.setBackground(this.btnTypeInfo.isSelected() ? bkSel : bkUnsel);
        this.btnTypeInfo.setFont(this.btnTypeInfo.isSelected() ? fSel : fUnsel);
        this.btnTypeInfo.setForeground(this.btnTypeInfo.isSelected() ? txtSel : txtUnsel);
        this.btnTypeInfo.setText(this.settings.getTerm(ThemisSettings.Term.TypInformation));
        this.btnTypeKontrolle.setBackground(this.btnTypeKontrolle.isSelected() ? bkSel : bkUnsel);
        this.btnTypeKontrolle.setFont(this.btnTypeKontrolle.isSelected() ? fSel : fUnsel);
        this.btnTypeKontrolle.setForeground(this.btnTypeKontrolle.isSelected() ? txtSel : txtUnsel);
        this.btnTypeKontrolle.setText(this.settings.getTerm(ThemisSettings.Term.TypKontrolle));
        this.btnTypeMangel.setBackground(this.btnTypeMangel.isSelected() ? bkSel : bkUnsel);
        this.btnTypeMangel.setFont(this.btnTypeMangel.isSelected() ? fSel : fUnsel);
        this.btnTypeMangel.setForeground(this.btnTypeMangel.isSelected() ? txtSel : txtUnsel);
        this.btnTypeMangel.setText(this.settings.getTerm(ThemisSettings.Term.TypMangel));
        this.btnTypeAufgabe.setBackground(this.btnTypeAufgabe.isSelected() ? bkSel : bkUnsel);
        this.btnTypeAufgabe.setFont(this.btnTypeAufgabe.isSelected() ? fSel : fUnsel);
        this.btnTypeAufgabe.setForeground(this.btnTypeAufgabe.isSelected() ? txtSel : txtUnsel);
        this.btnTypeAufgabe.setText(this.settings.getTerm(ThemisSettings.Term.TypAufgabe));
        boolean enableTypeButtons = true;
        this.btnTypeInfo.setEnabled(enableTypeButtons);
        this.btnTypeKontrolle.setEnabled(enableTypeButtons);
        this.btnTypeMangel.setEnabled(enableTypeButtons);
        this.btnTypeAufgabe.setEnabled(enableTypeButtons);
    }

    private void editImages(CmsElement e) {
        if (e == null) {
            return;
        }
        UploadItem selectedImage = null;
        if (e instanceof CmsLocation) {
            if (e.getUploadAttribute("files").getImageUploadItems().isEmpty()) {
                return;
            }
            selectedImage = this.selectedLocationImage;
        }
        if (e instanceof CmsObservation) {
            if (((CmsObservation)e).getUploads(true).isEmpty()) {
                return;
            }
            selectedImage = this.selectedObservationImage;
        }
        PhotoViewerPanel panel = new PhotoViewerPanel(false);
        ArrayList<ImageReference> refs = this.imageReferences.getOrDefault(e.getId(), new ArrayList());
        if (refs.isEmpty()) {
            panel.updateImageForElement(e, selectedImage);
        } else {
            panel.setImageReference(e);
            panel.updateImage(refs, false, selectedImage);
        }
        Dialogs.getInstance().showDialog(panel, panel, true, "photoviewerdialog", 800, 600, "Fotos bearbeiten");
        this.imageReferences.put(e.getId(), panel.getImages());
        if (e instanceof CmsLocation) {
            this.populateLocationUploads();
        } else {
            this.populateObservationUploads();
        }
    }

    private void addDateToTextarea(JTextArea fld) {
        String txt = fld.getText();
        if (!("".equals(txt) || txt.endsWith(" ") || txt.endsWith("\n"))) {
            txt = txt + " ";
        }
        String dt = Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)this.project.getTimeZone()) + " ";
        int idx = fld.getCaretPosition();
        txt = idx >= 0 ? txt.substring(0, idx) + dt + txt.substring(idx) : txt + dt;
        fld.setText(txt);
        fld.setCaretPosition(idx + dt.length());
        fld.requestFocus();
    }

    private void initComponents() {
        this.buttonGroupKategorie = new ButtonGroup();
        this.jProgressBar1 = new JProgressBar();
        this.splitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.panelTemplate = new JPanel();
        this.jLabel18 = new JLabel();
        this.panelQuicksearch = new JPanel();
        this.fldTemplateQuicksearch = new JTextField();
        this.btnQuicksearchClear = new JButton();
        this.panelGroupTemplate = new JPanel();
        this.lblTemplateLocationGroup = new JLabel();
        this.fldTemplateLocationgroup = new JComboBox();
        this.panelLocationTemplate = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.lstTemplateLocation = new JList();
        this.jPanel2 = new JPanel();
        this.btnSaveTemplateLocation = new JButton();
        this.btnApplyTemplateLocation = new JButton();
        this.btnAddLocationTemplate = new JButton();
        this.btnAddLocationWithChecks = new JButton();
        this.btnTemplateFavourite = new JToggleButton();
        this.jLabel15 = new JLabel();
        this.panelObservationTemplate = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lstTemplateObservation = new JList();
        this.jPanel32 = new JPanel();
        this.btnSaveTemplateObservation = new JButton();
        this.btnAddTemplateObservation = new JButton();
        this.btnApplyTemplateObservation = new JButton();
        this.btnAddTemplateObservations = new JButton();
        this.btnAddDescription = new JButton();
        this.jLabel16 = new JLabel();
        this.panelEditor = new JPanel();
        this.panelLocationOuter = new JPanel();
        this.jPanel9 = new JPanel();
        this.lblGegenstandTitle = new JLabel();
        this.panelLocationScroll = new JScrollPane();
        this.panelLocation = new JPanel();
        this.panelLocationAllgemeinOuter = new JPanel();
        this.panelLocationAllgemeinTitle = new JPanel();
        this.lblLocationAllgemeinTitle = new JLabel();
        this.panelLocationAllgemein = new JPanel();
        this.lblLocationGroup = new JLabel();
        this.fldLocationGroup = new JComboBox();
        this.lblLocationNumber = new JLabel();
        this.panelLocationTitle = new JPanel();
        this.fldLocationNumber = new JTextField();
        this.fldLocationPostnumber = new JTextField();
        this.fldLocationPrenumber = new JTextField();
        this.lblLocationTitle = new JLabel();
        this.fldLocationName = new JTextField();
        this.lblAttLocBarcode = new JLabel();
        this.fldLocationBarcode = new JTextField();
        this.btnBarcode = new JButton();
        this.lblLocationIconTitle = new JLabel();
        this.panelLocationIcon = new JPanel();
        this.lblLocationIconGraphics = new JLabel();
        this.btnLocationIconRemove = new JButton();
        this.btnLocationIconSet = new JButton();
        this.chkLocationShowalways = new JCheckBox();
        this.panelLocationAufmassOuter = new JPanel();
        this.panelLocationAufmass = new JPanel();
        this.panelLocationMasse = new JPanel();
        this.jLabel30 = new JLabel();
        this.fldLocationDimWidth = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.fldLocationDimHeight = new JTextField();
        this.jLabel9 = new JLabel();
        this.fldLocationDimDiameter = new JTextField();
        this.jLabel12 = new JLabel();
        this.fldLocationDimArea = new JTextField();
        this.panelLocationQuantity = new JPanel();
        this.jLabel29 = new JLabel();
        this.fldLocationQuantity = new JTextField();
        this.panelLocationAufmassTitle = new JPanel();
        this.lblLocationAllgemeinTitle1 = new JLabel();
        this.panelLocationMerkmaleOuter = new JPanel();
        this.panelLocationMerkmaleTitle = new JPanel();
        this.lblLocationMerkmaleTitle = new JLabel();
        this.panelLocationMerkmale = new JPanel();
        this.panelLocationObservationsOuter = new JPanel();
        this.panelLocationObservations = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.lstLocationObservation = new JList();
        this.lblNoCurrentEvent = new JLabel();
        this.jPanel8 = new JPanel();
        this.btnLocationAddObservation = new JButton();
        this.btnLocationRemoveObservation = new JButton();
        this.btnLocationEditObservation = new JButton();
        this.btnLocationObsUp = new JButton();
        this.btnLocationObsDown = new JButton();
        this.panelLocationObservationsTitle = new JPanel();
        this.lblLocationAllgemeinTitle2 = new JLabel();
        this.panelLocationFilesOuter = new JPanel();
        this.panelLocationFiles = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.panelLocationImages = new JPanel();
        this.panelLocationFilesButtons = new JPanel();
        this.btnLocationCaptureImage = new JButton();
        this.btnLocationAddFile = new JButton();
        this.btnLocationRemoveFile = new JButton();
        this.btnLocationEditImage = new JButton();
        this.btnObservationRotateImageCW1 = new JButton();
        this.btnObservationRotateImageCCW1 = new JButton();
        this.lblEmpty1 = new JLabel();
        this.btnMigrageUploadToObservation = new JButton();
        this.jLabel35 = new JLabel();
        this.jScrollPane13 = new JScrollPane();
        this.lstLocationFiles = new JList();
        this.jPanel26 = new JPanel();
        this.recordButton1 = new JButton();
        this.playButton1 = new JButton();
        this.stopButton1 = new JButton();
        this.playExternalLoc = new JButton();
        this.btnRemoveAudio1 = new JButton();
        this.lblFileInfo1 = new JLabel();
        this.progressAudioLevel = new JProgressBar();
        this.panelLocationFilesTitle = new JPanel();
        this.lblLocationAllgemeinTitle4 = new JLabel();
        this.panelLocationDocumentsOuter = new JPanel();
        this.panelLocationDocuments = new JPanel();
        this.jPanel19 = new JPanel();
        this.fldLocationDocumentLibraryType = new JComboBox();
        this.fldLocationDocumentLibrary = new JComboBox();
        this.btnLocationAddDocument = new JButton();
        this.jPanel22 = new JPanel();
        this.jPanel20 = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.lstLocationDocuments = new JList();
        this.jPanel21 = new JPanel();
        this.btnLocationRemoveDocument = new JButton();
        this.btnLocationEditDocument = new JButton();
        this.panelLocationDocumentsTitle = new JPanel();
        this.lblLocationAllgemeinTitle5 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel7 = new JLabel();
        this.emptyLabel = new JLabel();
        this.panelLocationButtons = new JPanel();
        this.btnLocationSaveNew = new JButton();
        this.btnLocationSaveClose = new JButton();
        this.btnLocationCancel = new JButton();
        this.panelObservationOuter = new JPanel();
        this.panelObservationHeader = new JPanel();
        this.lblObservationHead = new JLabel();
        this.panelObservationScroll = new JScrollPane();
        this.panelObservation = new JPanel();
        this.panelObservationTitle = new JPanel();
        this.jLabel41 = new JLabel();
        this.fldLocationTitleOnObs = new JTextField();
        this.jLabel38 = new JLabel();
        this.fldObservationNumber = new JTextField();
        this.jLabel40 = new JLabel();
        this.btnTypeMangel = new JToggleButton();
        this.btnTypeAufgabe = new JToggleButton();
        this.btnTypeKontrolle = new JToggleButton();
        this.btnTypeInfo = new JToggleButton();
        this.btnObservationCamera = new JButton();
        this.jLabel39 = new JLabel();
        this.fldObservationTitle = new JTextField();
        this.filler6 = new Box.Filler(new Dimension(0, 6), new Dimension(0, 6), new Dimension(0, 6));
        this.panelObservationPropertiesOuter = new JPanel();
        this.panelObservationProperties = new JPanel();
        this.panelObservationPropertiesTitle = new JPanel();
        this.lblLocationMerkmaleTitle1 = new JLabel();
        this.filler7 = new Box.Filler(new Dimension(0, 6), new Dimension(0, 6), new Dimension(0, 6));
        this.panelObservationDescriptionOuter = new JPanel();
        this.panelObservationMangelDetails = new JPanel();
        this.panelObservationDuedate = new JPanel();
        this.lblObservationDuedate = new JLabel();
        this.fldObservationDueDate = new JXDatePicker();
        this.panelObservationStatus = new JPanel();
        this.lblObservationStatus = new JLabel();
        this.fldObservationStatus = new JCheckBox();
        this.panelObservationMeasure = new JPanel();
        this.lblObservationMeasure = new JLabel();
        this.panelMeasureTemaplate = new JPanel();
        this.fldTemplateMeasure = new JComboBox();
        this.btnApplyTemplateMeasure = new JButton();
        this.scrollMeasure = new PDControlScrollPane();
        this.fldObservationMeasure = new JTextArea();
        this.btnObservationCleareMeasure = new JButton();
        this.btnObservationMeasureCalendar = new JButton();
        this.panelObservationRepeat = new JPanel();
        this.lblObservationContact1 = new JLabel();
        this.fldObservationRepeatCount = new JTextField();
        this.fldObservationRepeat = new JComboBox();
        this.btnRepeat = new JButton();
        this.panelObservationRisk = new JPanel();
        this.lblObservationRisk = new JLabel();
        this.fldObservationRisk = new JTextField();
        this.panelObservationContact = new JPanel();
        this.lblObservationContact = new JLabel();
        this.fldObservationContact = new JComboBox();
        this.btnAddContact = new JButton();
        this.panelObservationDescription = new JPanel();
        this.lblObservationDescription = new JLabel();
        this.scrollObsDescription = new PDControlScrollPane();
        this.fldObservationDescription = new JTextArea();
        this.btnObservationCleareDescription = new JButton();
        this.btnObservationMeasureCalendar1 = new JButton();
        this.panelObservationDescriptionTitle = new JPanel();
        this.lblLocationMerkmaleTitle2 = new JLabel();
        this.filler8 = new Box.Filler(new Dimension(0, 6), new Dimension(0, 6), new Dimension(0, 6));
        this.panelObservationFilesOuter = new JPanel();
        this.panelObservationFiles = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.panelObservationImages = new JPanel();
        this.panelObservationFilesButtons = new JPanel();
        this.btnObservationAddFile2 = new JButton();
        this.btnObservationAddPlansnippet = new JButton();
        this.btnObservationAddFile = new JButton();
        this.btnObservationRemoveFile = new JButton();
        this.btnObservationEditImage = new JButton();
        this.btnObservationRotateImageCW = new JButton();
        this.btnObservationRotateImageCCW = new JButton();
        this.jLabel33 = new JLabel();
        this.jScrollPane11 = new JScrollPane();
        this.lstObservationFiles = new JList();
        this.jPanel25 = new JPanel();
        this.recordButton = new JButton();
        this.playButton = new JButton();
        this.stopButton = new JButton();
        this.playExternal = new JButton();
        this.btnRemoveAudio = new JButton();
        this.lblFileInfo = new JLabel();
        this.progressAudioLevel1 = new JProgressBar();
        this.panelObservationFilesTitle = new JPanel();
        this.lblLocationMerkmaleTitle3 = new JLabel();
        this.filler9 = new Box.Filler(new Dimension(0, 6), new Dimension(0, 6), new Dimension(0, 6));
        this.panelObservationDocumentsOuter = new JPanel();
        this.panelObservationDocuments = new JPanel();
        this.fldObservationDocumentLibraryType = new JComboBox();
        this.fldObservationDocumentLibrary = new JComboBox();
        this.btnObservationAddDocument = new JButton();
        this.jScrollPane12 = new JScrollPane();
        this.lstObservationDocuments = new JList();
        this.btnObservationRemoveDocument = new JButton();
        this.btnObservationEditDocument = new JButton();
        this.jLabel20 = new JLabel();
        this.panelObservationFilesTitle1 = new JPanel();
        this.lblLocationMerkmaleTitle4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel14 = new JLabel();
        this.panelObservationButtons = new JPanel();
        this.btnObservationToItem = new JButton();
        this.btnObservationSaveClose = new JButton();
        this.btnObservationCancel = new JButton();
        this.setPreferredSize(new Dimension(1000, 800));
        this.setLayout(new BorderLayout());
        this.splitPane.setDividerLocation(410);
        this.splitPane.setOpaque(false);
        this.splitPane.setPreferredSize(new Dimension(800, 600));
        this.jScrollPane1.setPreferredSize(new Dimension(390, 1000));
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.panelTemplate.setBackground(new Color(204, 204, 204));
        this.panelTemplate.setPreferredSize(new Dimension(349, 800));
        this.panelTemplate.setRequestFocusEnabled(false);
        this.panelTemplate.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel18.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelTemplate.add((Component)this.jLabel18, gridBagConstraints);
        this.panelQuicksearch.setBackground(new Color(204, 204, 204));
        this.panelQuicksearch.setLayout(new GridBagLayout());
        this.fldTemplateQuicksearch.setFont(THEMIS.fontTextfield);
        this.fldTemplateQuicksearch.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldTemplateQuicksearch.text"));
        this.fldTemplateQuicksearch.setMinimumSize(new Dimension(200, 40));
        this.fldTemplateQuicksearch.setPreferredSize(new Dimension(200, 35));
        this.fldTemplateQuicksearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.fldTemplateQuicksearchActionPerformed(evt);
            }
        });
        this.fldTemplateQuicksearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldTemplateQuicksearchKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelQuicksearch.add((Component)this.fldTemplateQuicksearch, gridBagConstraints);
        this.btnQuicksearchClear.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnQuicksearchClear, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnQuicksearchClear.text"));
        this.btnQuicksearchClear.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnQuicksearchClear.toolTipText"));
        this.btnQuicksearchClear.setBorder(new SoftBevelBorder(0));
        this.btnQuicksearchClear.setMinimumSize(new Dimension(35, 35));
        this.btnQuicksearchClear.setPreferredSize(new Dimension(35, 35));
        this.btnQuicksearchClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnQuicksearchClearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelQuicksearch.add((Component)this.btnQuicksearchClear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTemplate.add((Component)this.panelQuicksearch, gridBagConstraints);
        this.panelGroupTemplate.setBackground(new Color(204, 204, 204));
        this.lblTemplateLocationGroup.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblTemplateLocationGroup, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblTemplateLocationGroup.text"));
        this.fldTemplateLocationgroup.setFont(THEMIS.fontList);
        this.fldTemplateLocationgroup.setModel(new DefaultComboBoxModel());
        this.fldTemplateLocationgroup.setMinimumSize(new Dimension(28, 35));
        this.fldTemplateLocationgroup.setPreferredSize(new Dimension(220, 35));
        this.fldTemplateLocationgroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldTemplateLocationgroupItemStateChanged(evt);
            }
        });
        GroupLayout panelGroupTemplateLayout = new GroupLayout(this.panelGroupTemplate);
        this.panelGroupTemplate.setLayout(panelGroupTemplateLayout);
        panelGroupTemplateLayout.setHorizontalGroup(panelGroupTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldTemplateLocationgroup, 0, 388, Short.MAX_VALUE).addComponent(this.lblTemplateLocationGroup, -1, -1, Short.MAX_VALUE));
        panelGroupTemplateLayout.setVerticalGroup(panelGroupTemplateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGroupTemplateLayout.createSequentialGroup().addComponent(this.lblTemplateLocationGroup).addGap(10, 10, 10).addComponent(this.fldTemplateLocationgroup, -2, -1, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTemplate.add((Component)this.panelGroupTemplate, gridBagConstraints);
        this.panelLocationTemplate.setBackground(new Color(204, 204, 204));
        this.panelLocationTemplate.setPreferredSize(new Dimension(390, 291));
        this.panelLocationTemplate.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontSubheading);
        this.jLabel3.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelLocationTemplate.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(40, 200));
        this.jScrollPane4.setPreferredSize(new Dimension(250, 250));
        this.lstTemplateLocation.setFont(THEMIS.fontList);
        this.lstTemplateLocation.setModel(new DefaultListModel());
        this.lstTemplateLocation.setPreferredSize(null);
        this.lstTemplateLocation.setVisibleRowCount(6);
        this.lstTemplateLocation.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LocationObservationDialog.this.lstTemplateLocationMousePressed(evt);
            }
        });
        this.lstTemplateLocation.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstTemplateLocationValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.lstTemplateLocation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelLocationTemplate.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel2.setBackground(new Color(204, 204, 204));
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnSaveTemplateLocation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nexLleft_plus24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveTemplateLocation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnSaveTemplateLocation.text"));
        this.btnSaveTemplateLocation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnSaveTemplateLocation.toolTipText"));
        this.btnSaveTemplateLocation.setBorder(new SoftBevelBorder(0));
        this.btnSaveTemplateLocation.setPreferredSize(new Dimension(40, 45));
        this.btnSaveTemplateLocation.setVerifyInputWhenFocusTarget(false);
        this.btnSaveTemplateLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnSaveTemplateLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnSaveTemplateLocation, gridBagConstraints);
        this.btnApplyTemplateLocation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTemplateLocation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnApplyTemplateLocation.text"));
        this.btnApplyTemplateLocation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnApplyTemplateLocation.toolTipText"));
        this.btnApplyTemplateLocation.setBorder(new SoftBevelBorder(0));
        this.btnApplyTemplateLocation.setPreferredSize(new Dimension(40, 45));
        this.btnApplyTemplateLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnApplyTemplateLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnApplyTemplateLocation, gridBagConstraints);
        this.btnAddLocationTemplate.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddLocationTemplate, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddLocationTemplate.text"));
        this.btnAddLocationTemplate.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddLocationTemplate.toolTipText"));
        this.btnAddLocationTemplate.setBorder(new SoftBevelBorder(0));
        this.btnAddLocationTemplate.setPreferredSize(new Dimension(40, 45));
        this.btnAddLocationTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnAddLocationTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnAddLocationTemplate, gridBagConstraints);
        this.btnAddLocationWithChecks.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight_check24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddLocationWithChecks, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddLocationWithChecks.text"));
        this.btnAddLocationWithChecks.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddLocationWithChecks.toolTipText"));
        this.btnAddLocationWithChecks.setBorder(new SoftBevelBorder(0));
        this.btnAddLocationWithChecks.setMaximumSize(new Dimension(40, 45));
        this.btnAddLocationWithChecks.setMinimumSize(new Dimension(40, 45));
        this.btnAddLocationWithChecks.setPreferredSize(new Dimension(40, 45));
        this.btnAddLocationWithChecks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnAddLocationWithChecksActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnAddLocationWithChecks, gridBagConstraints);
        this.btnTemplateFavourite.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/favoriten24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnTemplateFavourite, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnTemplateFavourite.text"));
        this.btnTemplateFavourite.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnTemplateFavourite.toolTipText"));
        this.btnTemplateFavourite.setBorder(new SoftBevelBorder(0));
        this.btnTemplateFavourite.setPreferredSize(new Dimension(40, 45));
        this.btnTemplateFavourite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnTemplateFavouriteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnTemplateFavourite, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel15.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelLocationTemplate.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelTemplate.add((Component)this.panelLocationTemplate, gridBagConstraints);
        this.panelObservationTemplate.setBackground(new Color(204, 204, 204));
        this.panelObservationTemplate.setLayout(new GridBagLayout());
        this.jLabel2.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTemplate.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(250, 250));
        this.lstTemplateObservation.setFont(THEMIS.fontList);
        this.lstTemplateObservation.setModel(new DefaultListModel());
        this.lstTemplateObservation.setPreferredSize(null);
        this.lstTemplateObservation.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LocationObservationDialog.this.lstTemplateObservationMousePressed(evt);
            }
        });
        this.lstTemplateObservation.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstTemplateObservationValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstTemplateObservation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTemplate.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel32.setBackground(new Color(204, 204, 204));
        this.jPanel32.setLayout(new GridBagLayout());
        this.btnSaveTemplateObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nexLleft_plus24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveTemplateObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnSaveTemplateObservation.text"));
        this.btnSaveTemplateObservation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnSaveTemplateObservation.toolTipText"));
        this.btnSaveTemplateObservation.setBorder(new SoftBevelBorder(0));
        this.btnSaveTemplateObservation.setMaximumSize(new Dimension(40, 45));
        this.btnSaveTemplateObservation.setMinimumSize(new Dimension(40, 45));
        this.btnSaveTemplateObservation.setPreferredSize(new Dimension(40, 45));
        this.btnSaveTemplateObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnSaveTemplateObservationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel32.add((Component)this.btnSaveTemplateObservation, gridBagConstraints);
        this.btnAddTemplateObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight_plus24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddTemplateObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddTemplateObservation.text"));
        this.btnAddTemplateObservation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddTemplateObservation.toolTipText"));
        this.btnAddTemplateObservation.setBorder(new SoftBevelBorder(0));
        this.btnAddTemplateObservation.setMaximumSize(new Dimension(40, 45));
        this.btnAddTemplateObservation.setMinimumSize(new Dimension(40, 45));
        this.btnAddTemplateObservation.setPreferredSize(new Dimension(40, 45));
        this.btnAddTemplateObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnAddTemplateObservationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel32.add((Component)this.btnAddTemplateObservation, gridBagConstraints);
        this.btnApplyTemplateObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTemplateObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnApplyTemplateObservation.text"));
        this.btnApplyTemplateObservation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnApplyTemplateObservation.toolTipText"));
        this.btnApplyTemplateObservation.setBorder(new SoftBevelBorder(0));
        this.btnApplyTemplateObservation.setMaximumSize(new Dimension(40, 45));
        this.btnApplyTemplateObservation.setMinimumSize(new Dimension(40, 45));
        this.btnApplyTemplateObservation.setPreferredSize(new Dimension(40, 45));
        this.btnApplyTemplateObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnApplyTemplateObservationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel32.add((Component)this.btnApplyTemplateObservation, gridBagConstraints);
        this.btnAddTemplateObservations.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/doublerightPlus24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddTemplateObservations, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddTemplateObservations.text"));
        this.btnAddTemplateObservations.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddTemplateObservations.toolTipText"));
        this.btnAddTemplateObservations.setBorder(new SoftBevelBorder(0));
        this.btnAddTemplateObservations.setMaximumSize(new Dimension(40, 45));
        this.btnAddTemplateObservations.setMinimumSize(new Dimension(40, 45));
        this.btnAddTemplateObservations.setPreferredSize(new Dimension(40, 45));
        this.btnAddTemplateObservations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnAddTemplateObservationsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel32.add((Component)this.btnAddTemplateObservations, gridBagConstraints);
        this.btnAddDescription.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/addText.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddDescription, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddDescription.text"));
        this.btnAddDescription.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddDescription.toolTipText"));
        this.btnAddDescription.setBorder(new SoftBevelBorder(0));
        this.btnAddDescription.setMaximumSize(new Dimension(40, 45));
        this.btnAddDescription.setMinimumSize(new Dimension(40, 45));
        this.btnAddDescription.setPreferredSize(new Dimension(40, 45));
        this.btnAddDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnAddDescriptionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel32.add((Component)this.btnAddDescription, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel16.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel32.add((Component)this.jLabel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTemplate.add((Component)this.jPanel32, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panelTemplate.add((Component)this.panelObservationTemplate, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.panelTemplate);
        this.splitPane.setLeftComponent(this.jScrollPane1);
        this.panelEditor.setMinimumSize(new Dimension(400, 25));
        this.panelEditor.setPreferredSize(new Dimension(551, 1300));
        this.panelEditor.setLayout(new CardLayout());
        this.panelLocationOuter.setLayout(new BorderLayout(10, 10));
        this.lblGegenstandTitle.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.lblGegenstandTitle, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblGegenstandTitle.text_2"));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.lblGegenstandTitle).addContainerGap(571, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.lblGegenstandTitle).addGap(0, 0, 0)));
        this.panelLocationOuter.add((Component)this.jPanel9, "North");
        this.panelLocationScroll.setBorder(null);
        this.panelLocationScroll.setHorizontalScrollBar(null);
        this.panelLocationScroll.setMaximumSize(null);
        this.panelLocationScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelLocation.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panelLocation.setMinimumSize(new Dimension(10, 10));
        this.panelLocation.setLayout(new GridBagLayout());
        this.panelLocationAllgemeinOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelLocationAllgemeinOuter.setLayout(new GridBagLayout());
        this.panelLocationAllgemeinTitle.setBackground(new Color(220, 220, 220));
        this.panelLocationAllgemeinTitle.setPreferredSize(new Dimension(200, 26));
        this.lblLocationAllgemeinTitle.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationAllgemeinTitle.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationAllgemeinTitle, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationAllgemeinTitle.text"));
        GroupLayout panelLocationAllgemeinTitleLayout = new GroupLayout(this.panelLocationAllgemeinTitle);
        this.panelLocationAllgemeinTitle.setLayout(panelLocationAllgemeinTitleLayout);
        panelLocationAllgemeinTitleLayout.setHorizontalGroup(panelLocationAllgemeinTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 604, Short.MAX_VALUE).addGroup(panelLocationAllgemeinTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationAllgemeinTitleLayout.createSequentialGroup().addGap(0, 235, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle).addGap(0, 235, Short.MAX_VALUE))));
        panelLocationAllgemeinTitleLayout.setVerticalGroup(panelLocationAllgemeinTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelLocationAllgemeinTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationAllgemeinTitleLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle).addGap(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationAllgemeinOuter.add((Component)this.panelLocationAllgemeinTitle, gridBagConstraints);
        this.panelLocationAllgemein.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.panelLocationAllgemein.setLayout(new GridBagLayout());
        this.lblLocationGroup.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationGroup, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationGroup.text_1"));
        this.lblLocationGroup.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.lblLocationGroup, gridBagConstraints);
        this.fldLocationGroup.setBackground(new Color(240, 240, 240));
        this.fldLocationGroup.setFont(THEMIS.fontList);
        this.fldLocationGroup.setModel(new DefaultComboBoxModel());
        this.fldLocationGroup.setPreferredSize(new Dimension(56, 30));
        this.fldLocationGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldLocationGroupItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add(this.fldLocationGroup, gridBagConstraints);
        this.lblLocationNumber.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationNumber, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationNumber.text"));
        this.lblLocationNumber.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.lblLocationNumber, gridBagConstraints);
        this.fldLocationNumber.setFont(THEMIS.fontTextfield);
        this.fldLocationNumber.setHorizontalAlignment(0);
        this.fldLocationNumber.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationNumber.text"));
        this.fldLocationNumber.setEnabled(false);
        this.fldLocationNumber.setPreferredSize(new Dimension(6, 30));
        this.fldLocationNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.fldLocationNumberActionPerformed(evt);
            }
        });
        this.fldLocationNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationNumberKeyTyped(evt);
            }
        });
        this.fldLocationPostnumber.setFont(THEMIS.fontTextfield);
        this.fldLocationPostnumber.setHorizontalAlignment(0);
        this.fldLocationPostnumber.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationPostnumber.text"));
        this.fldLocationPostnumber.setPreferredSize(new Dimension(6, 30));
        this.fldLocationPostnumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationPostnumberKeyTyped(evt);
            }
        });
        this.fldLocationPrenumber.setFont(THEMIS.fontTextfield);
        this.fldLocationPrenumber.setHorizontalAlignment(0);
        this.fldLocationPrenumber.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationPrenumber.text"));
        this.fldLocationPrenumber.setPreferredSize(new Dimension(6, 30));
        this.fldLocationPrenumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationPrenumberKeyTyped(evt);
            }
        });
        GroupLayout panelLocationTitleLayout = new GroupLayout(this.panelLocationTitle);
        this.panelLocationTitle.setLayout(panelLocationTitleLayout);
        panelLocationTitleLayout.setHorizontalGroup(panelLocationTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationTitleLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.fldLocationPrenumber, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldLocationNumber, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldLocationPostnumber, -2, 60, -2).addGap(0, 0, 0)));
        panelLocationTitleLayout.setVerticalGroup(panelLocationTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationTitleLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelLocationTitleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldLocationNumber, -2, -1, -2).addComponent(this.fldLocationPostnumber, -2, -1, -2).addComponent(this.fldLocationPrenumber, -2, -1, -2))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.panelLocationTitle, gridBagConstraints);
        this.lblLocationTitle.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationTitle, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationTitle.text"));
        this.lblLocationTitle.setPreferredSize(new Dimension(50, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.lblLocationTitle, gridBagConstraints);
        this.fldLocationName.setFont(THEMIS.fontTextfield);
        this.fldLocationName.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationName.text"));
        this.fldLocationName.setPreferredSize(new Dimension(6, 30));
        this.fldLocationName.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                LocationObservationDialog.this.fldLocationNameInputMethodTextChanged(evt);
            }
        });
        this.fldLocationName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.fldLocationName, gridBagConstraints);
        this.lblAttLocBarcode.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblAttLocBarcode, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblAttLocBarcode.text"));
        this.lblAttLocBarcode.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.lblAttLocBarcode, gridBagConstraints);
        this.fldLocationBarcode.setFont(THEMIS.fontTextfield);
        this.fldLocationBarcode.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationBarcode.text"));
        this.fldLocationBarcode.setPreferredSize(new Dimension(6, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.fldLocationBarcode, gridBagConstraints);
        this.btnBarcode.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/qr-code.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBarcode, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnBarcode.text"));
        this.btnBarcode.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnBarcode.toolTipText"));
        this.btnBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnBarcodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.btnBarcode, gridBagConstraints);
        this.lblLocationIconTitle.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationIconTitle, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationIconTitle.text_1"));
        this.lblLocationIconTitle.setPreferredSize(this.labelDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.lblLocationIconTitle, gridBagConstraints);
        this.panelLocationIcon.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblLocationIconGraphics, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationIconGraphics.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationIcon.add((Component)this.lblLocationIconGraphics, gridBagConstraints);
        this.btnLocationIconRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationIconRemove, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationIconRemove.text"));
        this.btnLocationIconRemove.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationIconRemove.toolTipText"));
        this.btnLocationIconRemove.setBorder(new SoftBevelBorder(0));
        this.btnLocationIconRemove.setMinimumSize(new Dimension(35, 35));
        this.btnLocationIconRemove.setPreferredSize(new Dimension(35, 35));
        this.btnLocationIconRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationIconRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationIcon.add((Component)this.btnLocationIconRemove, gridBagConstraints);
        this.btnLocationIconSet.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationIconSet, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationIconSet.text"));
        this.btnLocationIconSet.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationIconSet.toolTipText"));
        this.btnLocationIconSet.setBorder(new SoftBevelBorder(0));
        this.btnLocationIconSet.setMinimumSize(new Dimension(35, 35));
        this.btnLocationIconSet.setPreferredSize(new Dimension(35, 35));
        this.btnLocationIconSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationIconSetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationIcon.add((Component)this.btnLocationIconSet, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelLocationAllgemein.add((Component)this.panelLocationIcon, gridBagConstraints);
        this.chkLocationShowalways.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkLocationShowalways, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.chkLocationShowalways.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationAllgemein.add((Component)this.chkLocationShowalways, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationAllgemeinOuter.add((Component)this.panelLocationAllgemein, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.panelLocationAllgemeinOuter, gridBagConstraints);
        this.panelLocationAufmassOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelLocationAufmassOuter.setLayout(new BorderLayout());
        this.jLabel30.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel30, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel30.text"));
        this.jLabel30.setPreferredSize(this.labelDimension);
        this.fldLocationDimWidth.setFont(THEMIS.fontTextfield);
        this.fldLocationDimWidth.setHorizontalAlignment(0);
        this.fldLocationDimWidth.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationDimWidth.text"));
        this.fldLocationDimWidth.setPreferredSize(new Dimension(70, 30));
        this.fldLocationDimWidth.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LocationObservationDialog.this.fldLocationDimWidthPropertyChange(evt);
            }
        });
        this.fldLocationDimWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationDimWidthKeyReleased(evt);
            }
        });
        this.jLabel1.setFont(THEMIS.fontLabel);
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel1.text"));
        this.jLabel5.setFont(THEMIS.fontLabel);
        this.jLabel5.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel5.text_2"));
        this.fldLocationDimHeight.setFont(THEMIS.fontTextfield);
        this.fldLocationDimHeight.setHorizontalAlignment(0);
        this.fldLocationDimHeight.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationDimHeight.text"));
        this.fldLocationDimHeight.setPreferredSize(new Dimension(70, 30));
        this.fldLocationDimHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationDimHeightKeyReleased(evt);
            }
        });
        this.jLabel9.setFont(THEMIS.fontLabel);
        this.jLabel9.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel9.text_1"));
        this.fldLocationDimDiameter.setFont(THEMIS.fontTextfield);
        this.fldLocationDimDiameter.setHorizontalAlignment(0);
        this.fldLocationDimDiameter.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationDimDiameter.text"));
        this.fldLocationDimDiameter.setPreferredSize(new Dimension(70, 30));
        this.fldLocationDimDiameter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationDimDiameterKeyReleased(evt);
            }
        });
        this.jLabel12.setFont(THEMIS.fontLabel);
        this.jLabel12.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel12.text"));
        this.fldLocationDimArea.setFont(THEMIS.fontTextfield);
        this.fldLocationDimArea.setHorizontalAlignment(0);
        this.fldLocationDimArea.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationDimArea.text"));
        this.fldLocationDimArea.setPreferredSize(new Dimension(70, 30));
        GroupLayout panelLocationMasseLayout = new GroupLayout(this.panelLocationMasse);
        this.panelLocationMasse.setLayout(panelLocationMasseLayout);
        panelLocationMasseLayout.setHorizontalGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationMasseLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel30, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(panelLocationMasseLayout.createSequentialGroup().addComponent(this.jLabel9, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldLocationDimDiameter, -1, -1, Short.MAX_VALUE)).addGroup(panelLocationMasseLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldLocationDimWidth, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, 29, -2).addComponent(this.jLabel12, GroupLayout.Alignment.TRAILING, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fldLocationDimHeight, -1, -1, Short.MAX_VALUE).addComponent(this.fldLocationDimArea, -2, -1, -2))));
        panelLocationMasseLayout.setVerticalGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationMasseLayout.createSequentialGroup().addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldLocationDimHeight, -2, -1, -2).addComponent(this.jLabel5)).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel30, -2, -1, -2).addComponent(this.fldLocationDimWidth, -2, -1, -2).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldLocationDimDiameter, -2, -1, -2).addComponent(this.jLabel9)).addGroup(panelLocationMasseLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldLocationDimArea, -2, -1, -2).addComponent(this.jLabel12)))));
        this.jLabel29.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel29, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel29.text"));
        this.jLabel29.setPreferredSize(this.labelDimension);
        this.fldLocationQuantity.setFont(THEMIS.fontTextfield);
        this.fldLocationQuantity.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationQuantity.text"));
        this.fldLocationQuantity.setPreferredSize(new Dimension(6, 30));
        GroupLayout panelLocationQuantityLayout = new GroupLayout(this.panelLocationQuantity);
        this.panelLocationQuantity.setLayout(panelLocationQuantityLayout);
        panelLocationQuantityLayout.setHorizontalGroup(panelLocationQuantityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationQuantityLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel29, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fldLocationQuantity, -1, -1, Short.MAX_VALUE)));
        panelLocationQuantityLayout.setVerticalGroup(panelLocationQuantityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationQuantityLayout.createSequentialGroup().addGroup(panelLocationQuantityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel29, -2, -1, -2).addComponent(this.fldLocationQuantity, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout panelLocationAufmassLayout = new GroupLayout(this.panelLocationAufmass);
        this.panelLocationAufmass.setLayout(panelLocationAufmassLayout);
        panelLocationAufmassLayout.setHorizontalGroup(panelLocationAufmassLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationAufmassLayout.createSequentialGroup().addContainerGap().addGroup(panelLocationAufmassLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelLocationQuantity, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(panelLocationAufmassLayout.createSequentialGroup().addComponent(this.panelLocationMasse, -2, -1, -2).addGap(0, 248, Short.MAX_VALUE))).addContainerGap()));
        panelLocationAufmassLayout.setVerticalGroup(panelLocationAufmassLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationAufmassLayout.createSequentialGroup().addContainerGap().addComponent(this.panelLocationMasse, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelLocationQuantity, -2, -1, -2).addContainerGap()));
        this.panelLocationAufmassOuter.add((Component)this.panelLocationAufmass, "Center");
        this.panelLocationAufmassTitle.setBackground(new Color(220, 220, 220));
        this.panelLocationAufmassTitle.setPreferredSize(new Dimension(200, 26));
        this.lblLocationAllgemeinTitle1.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationAllgemeinTitle1.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationAllgemeinTitle1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationAllgemeinTitle1.text"));
        GroupLayout panelLocationAufmassTitleLayout = new GroupLayout(this.panelLocationAufmassTitle);
        this.panelLocationAufmassTitle.setLayout(panelLocationAufmassTitleLayout);
        panelLocationAufmassTitleLayout.setHorizontalGroup(panelLocationAufmassTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationAufmassTitleLayout.createSequentialGroup().addGap(0, 280, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle1).addGap(0, 281, Short.MAX_VALUE)));
        panelLocationAufmassTitleLayout.setVerticalGroup(panelLocationAufmassTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationAufmassTitleLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle1).addGap(0, 6, Short.MAX_VALUE)));
        this.panelLocationAufmassOuter.add((Component)this.panelLocationAufmassTitle, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.panelLocationAufmassOuter, gridBagConstraints);
        this.panelLocationMerkmaleOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelLocationMerkmaleOuter.setLayout(new BorderLayout());
        this.panelLocationMerkmaleTitle.setBackground(new Color(220, 220, 220));
        this.panelLocationMerkmaleTitle.setPreferredSize(new Dimension(200, 26));
        this.lblLocationMerkmaleTitle.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationMerkmaleTitle.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationMerkmaleTitle, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationMerkmaleTitle.text"));
        GroupLayout panelLocationMerkmaleTitleLayout = new GroupLayout(this.panelLocationMerkmaleTitle);
        this.panelLocationMerkmaleTitle.setLayout(panelLocationMerkmaleTitleLayout);
        panelLocationMerkmaleTitleLayout.setHorizontalGroup(panelLocationMerkmaleTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 604, Short.MAX_VALUE).addGroup(panelLocationMerkmaleTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationMerkmaleTitleLayout.createSequentialGroup().addGap(0, 244, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle).addGap(0, 245, Short.MAX_VALUE))));
        panelLocationMerkmaleTitleLayout.setVerticalGroup(panelLocationMerkmaleTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelLocationMerkmaleTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationMerkmaleTitleLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle).addGap(0, 6, Short.MAX_VALUE))));
        this.panelLocationMerkmaleOuter.add((Component)this.panelLocationMerkmaleTitle, "North");
        this.panelLocationMerkmale.setLayout(new GridBagLayout());
        this.panelLocationMerkmaleOuter.add((Component)this.panelLocationMerkmale, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.panelLocationMerkmaleOuter, gridBagConstraints);
        this.panelLocationObservationsOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelLocationObservationsOuter.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(318, 150));
        this.jPanel3.setLayout(new BorderLayout(10, 10));
        this.jScrollPane7.setMaximumSize(null);
        this.jScrollPane7.setMinimumSize(null);
        this.lstLocationObservation.setFont(THEMIS.fontListBig);
        this.lstLocationObservation.setModel(new DefaultListModel());
        this.lstLocationObservation.setPreferredSize(null);
        this.lstLocationObservation.setVisibleRowCount(7);
        this.lstLocationObservation.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LocationObservationDialog.this.lstLocationObservationMousePressed(evt);
            }
        });
        this.lstLocationObservation.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstLocationObservationValueChanged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.lstLocationObservation);
        this.jPanel3.add((Component)this.jScrollPane7, "Center");
        this.lblNoCurrentEvent.setFont(THEMIS.fontInfo);
        this.lblNoCurrentEvent.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.lblNoCurrentEvent, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblNoCurrentEvent.text"));
        this.jPanel3.add((Component)this.lblNoCurrentEvent, "South");
        this.btnLocationAddObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationAddObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationAddObservation.text_2"));
        this.btnLocationAddObservation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationAddObservation.toolTipText"));
        this.btnLocationAddObservation.setBorder(new SoftBevelBorder(0));
        this.btnLocationAddObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationAddObservationActionPerformed(evt);
            }
        });
        this.btnLocationRemoveObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationRemoveObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationRemoveObservation.text"));
        this.btnLocationRemoveObservation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationRemoveObservation.toolTipText"));
        this.btnLocationRemoveObservation.setBorder(new SoftBevelBorder(0));
        this.btnLocationRemoveObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationRemoveObservationActionPerformed(evt);
            }
        });
        this.btnLocationEditObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationEditObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationEditObservation.text_2"));
        this.btnLocationEditObservation.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationEditObservation.toolTipText"));
        this.btnLocationEditObservation.setBorder(new SoftBevelBorder(0));
        this.btnLocationEditObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationEditObservationActionPerformed(evt);
            }
        });
        this.btnLocationObsUp.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationObsUp, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationObsUp.text"));
        this.btnLocationObsUp.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationObsUp.toolTipText"));
        this.btnLocationObsUp.setBorder(new SoftBevelBorder(0));
        this.btnLocationObsUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationObsUpActionPerformed(evt);
            }
        });
        this.btnLocationObsDown.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_down24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationObsDown, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationObsDown.text"));
        this.btnLocationObsDown.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationObsDown.toolTipText"));
        this.btnLocationObsDown.setBorder(new SoftBevelBorder(0));
        this.btnLocationObsDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationObsDownActionPerformed(evt);
            }
        });
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLocationEditObservation, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.btnLocationRemoveObservation, GroupLayout.Alignment.TRAILING, -2, 50, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnLocationObsUp, -2, 50, -2).addComponent(this.btnLocationObsDown, -2, 50, -2))).addComponent(this.btnLocationAddObservation, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.btnLocationAddObservation, -2, 46, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.btnLocationRemoveObservation, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLocationEditObservation, -2, 35, -2)).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.btnLocationObsUp, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnLocationObsDown, -2, 35, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.add((Component)this.jPanel8, "East");
        GroupLayout panelLocationObservationsLayout = new GroupLayout(this.panelLocationObservations);
        this.panelLocationObservations.setLayout(panelLocationObservationsLayout);
        panelLocationObservationsLayout.setHorizontalGroup(panelLocationObservationsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationObservationsLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, 592, Short.MAX_VALUE).addContainerGap()));
        panelLocationObservationsLayout.setVerticalGroup(panelLocationObservationsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationObservationsLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, 163, Short.MAX_VALUE).addContainerGap()));
        this.panelLocationObservationsOuter.add((Component)this.panelLocationObservations, "Center");
        this.panelLocationObservationsTitle.setBackground(new Color(220, 220, 220));
        this.panelLocationObservationsTitle.setPreferredSize(new Dimension(200, 26));
        this.lblLocationAllgemeinTitle2.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationAllgemeinTitle2.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationAllgemeinTitle2, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationAllgemeinTitle2.text"));
        GroupLayout panelLocationObservationsTitleLayout = new GroupLayout(this.panelLocationObservationsTitle);
        this.panelLocationObservationsTitle.setLayout(panelLocationObservationsTitleLayout);
        panelLocationObservationsTitleLayout.setHorizontalGroup(panelLocationObservationsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 604, Short.MAX_VALUE).addGroup(panelLocationObservationsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationObservationsTitleLayout.createSequentialGroup().addGap(0, 260, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle2).addGap(0, 260, Short.MAX_VALUE))));
        panelLocationObservationsTitleLayout.setVerticalGroup(panelLocationObservationsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelLocationObservationsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationObservationsTitleLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle2).addGap(0, 6, Short.MAX_VALUE))));
        this.panelLocationObservationsOuter.add((Component)this.panelLocationObservationsTitle, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.panelLocationObservationsOuter, gridBagConstraints);
        this.panelLocationFilesOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelLocationFilesOuter.setLayout(new BorderLayout());
        this.panelLocationFiles.setPreferredSize(new Dimension(300, 314));
        this.panelLocationFiles.setLayout(new GridBagLayout());
        this.jScrollPane5.setHorizontalScrollBarPolicy(32);
        this.jScrollPane5.setVerticalScrollBarPolicy(21);
        this.jScrollPane5.setMinimumSize(new Dimension(100, 115));
        this.jScrollPane5.setPreferredSize(new Dimension(200, 120));
        this.panelLocationImages.setMinimumSize(new Dimension(0, 100));
        this.panelLocationImages.setLayout(new GridBagLayout());
        this.jScrollPane5.setViewportView(this.panelLocationImages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelLocationFiles.add((Component)this.jScrollPane5, gridBagConstraints);
        this.panelLocationFilesButtons.setLayout(new GridBagLayout());
        this.btnLocationCaptureImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/showPictures_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationCaptureImage, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationCaptureImage.text"));
        this.btnLocationCaptureImage.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationCaptureImage.toolTipText"));
        this.btnLocationCaptureImage.setBorder(new SoftBevelBorder(0));
        this.btnLocationCaptureImage.setPreferredSize(new Dimension(35, 35));
        this.btnLocationCaptureImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationCaptureImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationCaptureImage, gridBagConstraints);
        this.btnLocationAddFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationAddFile, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationAddFile.text"));
        this.btnLocationAddFile.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationAddFile.toolTipText"));
        this.btnLocationAddFile.setBorder(new SoftBevelBorder(0));
        this.btnLocationAddFile.setPreferredSize(new Dimension(35, 35));
        this.btnLocationAddFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationAddFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationAddFile, gridBagConstraints);
        this.btnLocationRemoveFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationRemoveFile, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationRemoveFile.text"));
        this.btnLocationRemoveFile.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationRemoveFile.toolTipText"));
        this.btnLocationRemoveFile.setBorder(new SoftBevelBorder(0));
        this.btnLocationRemoveFile.setPreferredSize(new Dimension(35, 35));
        this.btnLocationRemoveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationRemoveFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationRemoveFile, gridBagConstraints);
        this.btnLocationEditImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationEditImage, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationEditImage.text"));
        this.btnLocationEditImage.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationEditImage.toolTipText"));
        this.btnLocationEditImage.setBorder(new SoftBevelBorder(0));
        this.btnLocationEditImage.setPreferredSize(new Dimension(35, 35));
        this.btnLocationEditImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationEditImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnLocationEditImage, gridBagConstraints);
        this.btnObservationRotateImageCW1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCW24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationRotateImageCW1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCW1.text"));
        this.btnObservationRotateImageCW1.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCW1.toolTipText"));
        this.btnObservationRotateImageCW1.setBorder(new SoftBevelBorder(0));
        this.btnObservationRotateImageCW1.setMinimumSize(new Dimension(35, 35));
        this.btnObservationRotateImageCW1.setPreferredSize(new Dimension(35, 35));
        this.btnObservationRotateImageCW1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationRotateImageCW1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnObservationRotateImageCW1, gridBagConstraints);
        this.btnObservationRotateImageCCW1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCCW24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationRotateImageCCW1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCCW1.text"));
        this.btnObservationRotateImageCCW1.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCCW1.toolTipText"));
        this.btnObservationRotateImageCCW1.setBorder(new SoftBevelBorder(0));
        this.btnObservationRotateImageCCW1.setMinimumSize(new Dimension(35, 35));
        this.btnObservationRotateImageCCW1.setPreferredSize(new Dimension(35, 35));
        this.btnObservationRotateImageCCW1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationRotateImageCCW1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationFilesButtons.add((Component)this.btnObservationRotateImageCCW1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblEmpty1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelLocationFilesButtons.add((Component)this.lblEmpty1, gridBagConstraints);
        this.btnMigrageUploadToObservation.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/arrow_up24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMigrageUploadToObservation, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnMigrageUploadToObservation.text"));
        this.btnMigrageUploadToObservation.setBorder(new SoftBevelBorder(0));
        this.btnMigrageUploadToObservation.setPreferredSize(new Dimension(35, 35));
        this.btnMigrageUploadToObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnMigrageUploadToObservationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelLocationFilesButtons.add((Component)this.btnMigrageUploadToObservation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.panelLocationFiles.add((Component)this.panelLocationFilesButtons, gridBagConstraints);
        this.jLabel35.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel35, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel35.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panelLocationFiles.add((Component)this.jLabel35, gridBagConstraints);
        this.jScrollPane13.setMaximumSize(null);
        this.jScrollPane13.setMinimumSize(new Dimension(100, 60));
        this.jScrollPane13.setPreferredSize(new Dimension(200, 50));
        this.lstLocationFiles.setFont(THEMIS.fontList);
        this.lstLocationFiles.setModel(new DefaultListModel());
        this.lstLocationFiles.setMaximumSize(null);
        this.lstLocationFiles.setMinimumSize(null);
        this.lstLocationFiles.setPreferredSize(null);
        this.lstLocationFiles.setVisibleRowCount(7);
        this.lstLocationFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstLocationFilesValueChanged(evt);
            }
        });
        this.jScrollPane13.setViewportView(this.lstLocationFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelLocationFiles.add((Component)this.jScrollPane13, gridBagConstraints);
        this.jPanel26.setLayout(new GridBagLayout());
        this.recordButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/record24.gif")));
        this.recordButton1.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.recordButton1.toolTipText"));
        this.recordButton1.setBorder(new SoftBevelBorder(0));
        this.recordButton1.setPreferredSize(new Dimension(35, 35));
        this.recordButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.recordButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel26.add((Component)this.recordButton1, gridBagConstraints);
        this.playButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/play24.gif")));
        this.playButton1.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.playButton1.toolTipText"));
        this.playButton1.setBorder(new SoftBevelBorder(0));
        this.playButton1.setPreferredSize(new Dimension(35, 35));
        this.playButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.playButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel26.add((Component)this.playButton1, gridBagConstraints);
        this.stopButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/stop24.gif")));
        this.stopButton1.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.stopButton1.toolTipText"));
        this.stopButton1.setBorder(new SoftBevelBorder(0));
        this.stopButton1.setPreferredSize(new Dimension(35, 35));
        this.stopButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.stopButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel26.add((Component)this.stopButton1, gridBagConstraints);
        this.playExternalLoc.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/open_external_24.gif")));
        this.playExternalLoc.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.playExternalLoc.toolTipText"));
        this.playExternalLoc.setBorder(new SoftBevelBorder(0));
        this.playExternalLoc.setPreferredSize(new Dimension(35, 35));
        this.playExternalLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.playExternalLocActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 0, 10);
        this.jPanel26.add((Component)this.playExternalLoc, gridBagConstraints);
        this.btnRemoveAudio1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveAudio1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnRemoveAudio1.text"));
        this.btnRemoveAudio1.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnRemoveAudio1.toolTipText"));
        this.btnRemoveAudio1.setBorder(new SoftBevelBorder(0));
        this.btnRemoveAudio1.setMinimumSize(new Dimension(35, 35));
        this.btnRemoveAudio1.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveAudio1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnRemoveAudio1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel26.add((Component)this.btnRemoveAudio1, gridBagConstraints);
        this.lblFileInfo1.setFont(THEMIS.fontInfo);
        Mnemonics.setLocalizedText((JLabel)this.lblFileInfo1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblFileInfo1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel26.add((Component)this.lblFileInfo1, gridBagConstraints);
        this.progressAudioLevel.setMinimumSize(new Dimension(100, 20));
        this.jPanel26.add((Component)this.progressAudioLevel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panelLocationFiles.add((Component)this.jPanel26, gridBagConstraints);
        this.panelLocationFilesOuter.add((Component)this.panelLocationFiles, "Center");
        this.panelLocationFilesTitle.setBackground(new Color(220, 220, 220));
        this.panelLocationFilesTitle.setPreferredSize(new Dimension(200, 26));
        this.lblLocationAllgemeinTitle4.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationAllgemeinTitle4.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationAllgemeinTitle4, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationAllgemeinTitle4.text"));
        GroupLayout panelLocationFilesTitleLayout = new GroupLayout(this.panelLocationFilesTitle);
        this.panelLocationFilesTitle.setLayout(panelLocationFilesTitleLayout);
        panelLocationFilesTitleLayout.setHorizontalGroup(panelLocationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 604, Short.MAX_VALUE).addGroup(panelLocationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationFilesTitleLayout.createSequentialGroup().addGap(0, 260, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle4).addGap(0, 261, Short.MAX_VALUE))));
        panelLocationFilesTitleLayout.setVerticalGroup(panelLocationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelLocationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationFilesTitleLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle4).addGap(0, 6, Short.MAX_VALUE))));
        this.panelLocationFilesOuter.add((Component)this.panelLocationFilesTitle, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.panelLocationFilesOuter, gridBagConstraints);
        this.panelLocationDocumentsOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelLocationDocumentsOuter.setLayout(new BorderLayout());
        this.jPanel19.setLayout(new GridBagLayout());
        this.fldLocationDocumentLibraryType.setFont(THEMIS.fontList);
        this.fldLocationDocumentLibraryType.setModel(new DefaultComboBoxModel());
        this.fldLocationDocumentLibraryType.setPreferredSize(new Dimension(56, 30));
        this.fldLocationDocumentLibraryType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldLocationDocumentLibraryTypeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel19.add(this.fldLocationDocumentLibraryType, gridBagConstraints);
        this.fldLocationDocumentLibrary.setFont(THEMIS.fontList);
        this.fldLocationDocumentLibrary.setModel(new DefaultComboBoxModel());
        this.fldLocationDocumentLibrary.setPreferredSize(new Dimension(56, 30));
        this.fldLocationDocumentLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldLocationDocumentLibraryItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel19.add(this.fldLocationDocumentLibrary, gridBagConstraints);
        this.btnLocationAddDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationAddDocument, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationAddDocument.text"));
        this.btnLocationAddDocument.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationAddDocument.toolTipText"));
        this.btnLocationAddDocument.setBorder(new SoftBevelBorder(0));
        this.btnLocationAddDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationAddDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel19.add((Component)this.btnLocationAddDocument, gridBagConstraints);
        this.jPanel20.setPreferredSize(new Dimension(318, 125));
        this.jPanel20.setLayout(new BorderLayout(10, 10));
        this.jScrollPane8.setMaximumSize(null);
        this.jScrollPane8.setMinimumSize(null);
        this.lstLocationDocuments.setFont(THEMIS.fontList);
        this.lstLocationDocuments.setModel(new DefaultListModel());
        this.lstLocationDocuments.setVisibleRowCount(6);
        this.lstLocationDocuments.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LocationObservationDialog.this.lstLocationDocumentsMousePressed(evt);
            }
        });
        this.lstLocationDocuments.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstLocationDocumentsValueChanged(evt);
            }
        });
        this.jScrollPane8.setViewportView(this.lstLocationDocuments);
        this.jPanel20.add((Component)this.jScrollPane8, "Center");
        this.btnLocationRemoveDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationRemoveDocument, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationRemoveDocument.text"));
        this.btnLocationRemoveDocument.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationRemoveDocument.toolTipText"));
        this.btnLocationRemoveDocument.setBorder(new SoftBevelBorder(0));
        this.btnLocationRemoveDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationRemoveDocumentActionPerformed(evt);
            }
        });
        this.btnLocationEditDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/controlled24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationEditDocument, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationEditDocument.text"));
        this.btnLocationEditDocument.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationEditDocument.toolTipText"));
        this.btnLocationEditDocument.setBorder(new SoftBevelBorder(0));
        this.btnLocationEditDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationEditDocumentActionPerformed(evt);
            }
        });
        GroupLayout jPanel21Layout = new GroupLayout(this.jPanel21);
        this.jPanel21.setLayout(jPanel21Layout);
        jPanel21Layout.setHorizontalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel21Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnLocationEditDocument, -2, 50, -2).addComponent(this.btnLocationRemoveDocument, -2, 50, -2)).addGap(0, 0, 0)));
        jPanel21Layout.setVerticalGroup(jPanel21Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel21Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.btnLocationRemoveDocument, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLocationEditDocument, -2, 35, -2).addContainerGap(49, Short.MAX_VALUE)));
        this.jPanel20.add((Component)this.jPanel21, "East");
        GroupLayout jPanel22Layout = new GroupLayout(this.jPanel22);
        this.jPanel22.setLayout(jPanel22Layout);
        jPanel22Layout.setHorizontalGroup(jPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel22Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel20, -1, 592, Short.MAX_VALUE).addContainerGap()));
        jPanel22Layout.setVerticalGroup(jPanel22Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel22Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel20, -2, -1, -2).addGap(5, 5, 5)));
        GroupLayout panelLocationDocumentsLayout = new GroupLayout(this.panelLocationDocuments);
        this.panelLocationDocuments.setLayout(panelLocationDocumentsLayout);
        panelLocationDocumentsLayout.setHorizontalGroup(panelLocationDocumentsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel19, -1, 604, Short.MAX_VALUE).addComponent(this.jPanel22, -1, -1, Short.MAX_VALUE));
        panelLocationDocumentsLayout.setVerticalGroup(panelLocationDocumentsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationDocumentsLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel19, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel22, -2, -1, -2).addGap(0, 0, 0)));
        this.panelLocationDocumentsOuter.add((Component)this.panelLocationDocuments, "Center");
        this.panelLocationDocumentsTitle.setBackground(new Color(220, 220, 220));
        this.panelLocationDocumentsTitle.setPreferredSize(new Dimension(200, 26));
        this.lblLocationAllgemeinTitle5.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationAllgemeinTitle5.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationAllgemeinTitle5, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationAllgemeinTitle5.text"));
        GroupLayout panelLocationDocumentsTitleLayout = new GroupLayout(this.panelLocationDocumentsTitle);
        this.panelLocationDocumentsTitle.setLayout(panelLocationDocumentsTitleLayout);
        panelLocationDocumentsTitleLayout.setHorizontalGroup(panelLocationDocumentsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 604, Short.MAX_VALUE).addGroup(panelLocationDocumentsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationDocumentsTitleLayout.createSequentialGroup().addGap(0, 271, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle5).addGap(0, 271, Short.MAX_VALUE))));
        panelLocationDocumentsTitleLayout.setVerticalGroup(panelLocationDocumentsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelLocationDocumentsTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLocationDocumentsTitleLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.lblLocationAllgemeinTitle5).addGap(0, 6, Short.MAX_VALUE))));
        this.panelLocationDocumentsOuter.add((Component)this.panelLocationDocumentsTitle, "First");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.panelLocationDocumentsOuter, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.jPanel6, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.emptyLabel, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.emptyLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocation.add((Component)this.emptyLabel, gridBagConstraints);
        this.panelLocationScroll.setViewportView(this.panelLocation);
        this.panelLocationOuter.add((Component)this.panelLocationScroll, "Center");
        this.panelLocationButtons.setLayout(new GridBagLayout());
        this.btnLocationSaveNew.setFont(THEMIS.fontButton);
        this.btnLocationSaveNew.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationSaveNew, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationSaveNew.text"));
        this.btnLocationSaveNew.setBorder(new SoftBevelBorder(0));
        this.btnLocationSaveNew.setMinimumSize(null);
        this.btnLocationSaveNew.setPreferredSize(null);
        this.btnLocationSaveNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationSaveNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationButtons.add((Component)this.btnLocationSaveNew, gridBagConstraints);
        this.btnLocationSaveClose.setFont(THEMIS.fontButton);
        this.btnLocationSaveClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationSaveClose, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationSaveClose.text"));
        this.btnLocationSaveClose.setBorder(new SoftBevelBorder(0));
        this.btnLocationSaveClose.setMinimumSize(null);
        this.btnLocationSaveClose.setPreferredSize(null);
        this.btnLocationSaveClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationSaveCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panelLocationButtons.add((Component)this.btnLocationSaveClose, gridBagConstraints);
        this.btnLocationCancel.setFont(THEMIS.fontButton);
        this.btnLocationCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocationCancel, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnLocationCancel.text"));
        this.btnLocationCancel.setBorder(new SoftBevelBorder(0));
        this.btnLocationCancel.setMinimumSize(null);
        this.btnLocationCancel.setPreferredSize(null);
        this.btnLocationCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnLocationCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelLocationButtons.add((Component)this.btnLocationCancel, gridBagConstraints);
        this.panelLocationOuter.add((Component)this.panelLocationButtons, "South");
        this.panelEditor.add((Component)this.panelLocationOuter, "cardLocation");
        this.panelObservationOuter.setPreferredSize(new Dimension(400, 500));
        this.panelObservationOuter.setLayout(new BorderLayout(10, 10));
        this.panelObservationHeader.setLayout(new GridBagLayout());
        this.lblObservationHead.setFont(THEMIS.fontHeading);
        this.lblObservationHead.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationHead, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationHead.text"));
        this.lblObservationHead.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationHeader.add((Component)this.lblObservationHead, gridBagConstraints);
        this.panelObservationOuter.add((Component)this.panelObservationHeader, "North");
        this.panelObservationScroll.setBorder(null);
        this.panelObservationScroll.setHorizontalScrollBar(null);
        this.panelObservationScroll.setPreferredSize(new Dimension(480, 1917));
        this.panelObservationScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelObservation.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.panelObservation.setLayout(new BoxLayout(this.panelObservation, 1));
        this.panelObservationTitle.setLayout(new GridBagLayout());
        this.jLabel41.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel41, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel41.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.jLabel41, gridBagConstraints);
        this.fldLocationTitleOnObs.setEditable(false);
        this.fldLocationTitleOnObs.setFont(THEMIS.fontLabelBold);
        this.fldLocationTitleOnObs.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldLocationTitleOnObs.text"));
        this.fldLocationTitleOnObs.setMinimumSize(new Dimension(200, 32));
        this.fldLocationTitleOnObs.setPreferredSize(new Dimension(200, 32));
        this.fldLocationTitleOnObs.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                LocationObservationDialog.this.fldLocationTitleOnObsInputMethodTextChanged(evt);
            }
        });
        this.fldLocationTitleOnObs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.fldLocationTitleOnObsActionPerformed(evt);
            }
        });
        this.fldLocationTitleOnObs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldLocationTitleOnObsKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.fldLocationTitleOnObs, gridBagConstraints);
        this.jLabel38.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel38, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel38.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.jLabel38, gridBagConstraints);
        this.fldObservationNumber.setEditable(false);
        this.fldObservationNumber.setFont(THEMIS.fontTextfield);
        this.fldObservationNumber.setHorizontalAlignment(0);
        this.fldObservationNumber.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldObservationNumber.text"));
        this.fldObservationNumber.setMinimumSize(new Dimension(50, 30));
        this.fldObservationNumber.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.fldObservationNumber, gridBagConstraints);
        this.jLabel40.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel40, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel40.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.jLabel40, gridBagConstraints);
        this.btnTypeMangel.setBackground(THEMIS.lightred);
        this.buttonGroupKategorie.add(this.btnTypeMangel);
        this.btnTypeMangel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTypeMangel, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnTypeMangel.text"));
        this.btnTypeMangel.setMinimumSize(new Dimension(70, 30));
        this.btnTypeMangel.setPreferredSize(new Dimension(85, 30));
        this.btnTypeMangel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnTypeMangelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.btnTypeMangel, gridBagConstraints);
        this.btnTypeAufgabe.setBackground(THEMIS.lightorange);
        this.buttonGroupKategorie.add(this.btnTypeAufgabe);
        this.btnTypeAufgabe.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTypeAufgabe, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnTypeAufgabe.text"));
        this.btnTypeAufgabe.setMinimumSize(new Dimension(70, 30));
        this.btnTypeAufgabe.setPreferredSize(new Dimension(85, 30));
        this.btnTypeAufgabe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnTypeAufgabeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.btnTypeAufgabe, gridBagConstraints);
        this.btnTypeKontrolle.setBackground(THEMIS.lightblue);
        this.buttonGroupKategorie.add(this.btnTypeKontrolle);
        this.btnTypeKontrolle.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTypeKontrolle, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnTypeKontrolle.text"));
        this.btnTypeKontrolle.setMinimumSize(new Dimension(70, 30));
        this.btnTypeKontrolle.setPreferredSize(new Dimension(85, 30));
        this.btnTypeKontrolle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnTypeKontrolleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.btnTypeKontrolle, gridBagConstraints);
        this.btnTypeInfo.setBackground(THEMIS.lightyellow);
        this.buttonGroupKategorie.add(this.btnTypeInfo);
        this.btnTypeInfo.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnTypeInfo, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnTypeInfo.text"));
        this.btnTypeInfo.setMinimumSize(new Dimension(70, 30));
        this.btnTypeInfo.setPreferredSize(new Dimension(85, 30));
        this.btnTypeInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnTypeInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.btnTypeInfo, gridBagConstraints);
        this.btnObservationCamera.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/showPictures_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationCamera, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationCamera.text"));
        this.btnObservationCamera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationCameraActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.btnObservationCamera, gridBagConstraints);
        this.jLabel39.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel39, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel39.text"));
        this.jLabel39.setPreferredSize(new Dimension(40, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.jLabel39, gridBagConstraints);
        this.fldObservationTitle.setFont(THEMIS.fontTextfield);
        this.fldObservationTitle.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldObservationTitle.text"));
        this.fldObservationTitle.setMinimumSize(new Dimension(200, 32));
        this.fldObservationTitle.setPreferredSize(new Dimension(200, 32));
        this.fldObservationTitle.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                LocationObservationDialog.this.fldObservationTitleInputMethodTextChanged(evt);
            }
        });
        this.fldObservationTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.fldObservationTitleActionPerformed(evt);
            }
        });
        this.fldObservationTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocationObservationDialog.this.fldObservationTitleKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelObservationTitle.add((Component)this.fldObservationTitle, gridBagConstraints);
        this.panelObservation.add(this.panelObservationTitle);
        this.panelObservation.add(this.filler6);
        this.panelObservationPropertiesOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelObservationPropertiesOuter.setLayout(new BorderLayout());
        this.panelObservationProperties.setLayout(new GridBagLayout());
        this.panelObservationPropertiesOuter.add((Component)this.panelObservationProperties, "Center");
        this.panelObservationPropertiesTitle.setBackground(new Color(220, 220, 220));
        this.lblLocationMerkmaleTitle1.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationMerkmaleTitle1.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationMerkmaleTitle1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationMerkmaleTitle1.text"));
        GroupLayout panelObservationPropertiesTitleLayout = new GroupLayout(this.panelObservationPropertiesTitle);
        this.panelObservationPropertiesTitle.setLayout(panelObservationPropertiesTitleLayout);
        panelObservationPropertiesTitleLayout.setHorizontalGroup(panelObservationPropertiesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 629, Short.MAX_VALUE).addGroup(panelObservationPropertiesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationPropertiesTitleLayout.createSequentialGroup().addGap(0, 277, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle1).addGap(0, 278, Short.MAX_VALUE))));
        panelObservationPropertiesTitleLayout.setVerticalGroup(panelObservationPropertiesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelObservationPropertiesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationPropertiesTitleLayout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle1).addGap(0, 5, Short.MAX_VALUE))));
        this.panelObservationPropertiesOuter.add((Component)this.panelObservationPropertiesTitle, "North");
        this.panelObservation.add(this.panelObservationPropertiesOuter);
        this.panelObservation.add(this.filler7);
        this.panelObservationDescriptionOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelObservationDescriptionOuter.setLayout(new BorderLayout());
        this.panelObservationDuedate.setPreferredSize(new Dimension(150, 30));
        this.lblObservationDuedate.setFont(THEMIS.fontLabel);
        this.lblObservationDuedate.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationDuedate, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationDuedate.text"));
        this.lblObservationDuedate.setPreferredSize(new Dimension(100, 14));
        this.fldObservationDueDate.setFont(THEMIS.fontTextfield);
        GroupLayout panelObservationDuedateLayout = new GroupLayout(this.panelObservationDuedate);
        this.panelObservationDuedate.setLayout(panelObservationDuedateLayout);
        panelObservationDuedateLayout.setHorizontalGroup(panelObservationDuedateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationDuedateLayout.createSequentialGroup().addComponent(this.lblObservationDuedate, -1, 130, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.fldObservationDueDate, -2, 164, -2)));
        panelObservationDuedateLayout.setVerticalGroup(panelObservationDuedateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationDuedateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblObservationDuedate, -2, -1, -2).addComponent((Component)this.fldObservationDueDate, -2, 30, -2)));
        this.panelObservationStatus.setPreferredSize(new Dimension(285, 23));
        this.lblObservationStatus.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationStatus, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationStatus.text"));
        this.lblObservationStatus.setPreferredSize(this.labelDimension);
        this.fldObservationStatus.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.fldObservationStatus, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldObservationStatus.text"));
        this.fldObservationStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldObservationStatusItemStateChanged(evt);
            }
        });
        GroupLayout panelObservationStatusLayout = new GroupLayout(this.panelObservationStatus);
        this.panelObservationStatus.setLayout(panelObservationStatusLayout);
        panelObservationStatusLayout.setHorizontalGroup(panelObservationStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelObservationStatusLayout.createSequentialGroup().addComponent(this.lblObservationStatus, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldObservationStatus, -2, 213, -2).addGap(0, 0, 0)));
        panelObservationStatusLayout.setVerticalGroup(panelObservationStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fldObservationStatus, -2, 30, -2).addComponent(this.lblObservationStatus, -1, -1, Short.MAX_VALUE));
        this.panelObservationMeasure.setLayout(new GridBagLayout());
        this.lblObservationMeasure.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationMeasure, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationMeasure.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelObservationMeasure.add((Component)this.lblObservationMeasure, gridBagConstraints);
        this.panelMeasureTemaplate.setLayout(new GridBagLayout());
        this.fldTemplateMeasure.setFont(THEMIS.fontList);
        this.fldTemplateMeasure.setModel(new DefaultComboBoxModel());
        this.fldTemplateMeasure.setMinimumSize(new Dimension(100, 30));
        this.fldTemplateMeasure.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.panelMeasureTemaplate.add((Component)this.fldTemplateMeasure, gridBagConstraints);
        this.btnApplyTemplateMeasure.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApplyTemplateMeasure, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnApplyTemplateMeasure.text"));
        this.btnApplyTemplateMeasure.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnApplyTemplateMeasure.toolTipText"));
        this.btnApplyTemplateMeasure.setBorder(new SoftBevelBorder(0));
        this.btnApplyTemplateMeasure.setPreferredSize(new Dimension(35, 35));
        this.btnApplyTemplateMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnApplyTemplateMeasureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.panelMeasureTemaplate.add((Component)this.btnApplyTemplateMeasure, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelObservationMeasure.add((Component)this.panelMeasureTemaplate, gridBagConstraints);
        this.fldObservationMeasure.setColumns(20);
        this.fldObservationMeasure.setFont(THEMIS.fontTextfield);
        this.fldObservationMeasure.setLineWrap(true);
        this.fldObservationMeasure.setRows(5);
        this.fldObservationMeasure.setWrapStyleWord(true);
        this.scrollMeasure.setViewportView(this.fldObservationMeasure);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelObservationMeasure.add((Component)this.scrollMeasure, gridBagConstraints);
        this.btnObservationCleareMeasure.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationCleareMeasure, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationCleareMeasure.text"));
        this.btnObservationCleareMeasure.setBorder(new SoftBevelBorder(0));
        this.btnObservationCleareMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationCleareMeasureActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelObservationMeasure.add((Component)this.btnObservationCleareMeasure, gridBagConstraints);
        this.btnObservationMeasureCalendar.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationMeasureCalendar, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationMeasureCalendar.text"));
        this.btnObservationMeasureCalendar.setBorder(new SoftBevelBorder(0));
        this.btnObservationMeasureCalendar.setMinimumSize(new Dimension(30, 30));
        this.btnObservationMeasureCalendar.setPreferredSize(new Dimension(30, 30));
        this.btnObservationMeasureCalendar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationMeasureCalendarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelObservationMeasure.add((Component)this.btnObservationMeasureCalendar, gridBagConstraints);
        this.lblObservationContact1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationContact1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationContact1.text"));
        this.lblObservationContact1.setPreferredSize(this.labelDimension);
        this.fldObservationRepeatCount.setFont(THEMIS.fontTextfield);
        this.fldObservationRepeatCount.setHorizontalAlignment(0);
        this.fldObservationRepeatCount.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldObservationRepeatCount.text"));
        this.fldObservationRepeat.setFont(THEMIS.fontList);
        this.fldObservationRepeat.setModel(new DefaultComboBoxModel());
        this.fldObservationRepeat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldObservationRepeatItemStateChanged(evt);
            }
        });
        this.btnRepeat.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRepeat, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnRepeat.text"));
        this.btnRepeat.setBorder(new SoftBevelBorder(0));
        this.btnRepeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnRepeatActionPerformed(evt);
            }
        });
        GroupLayout panelObservationRepeatLayout = new GroupLayout(this.panelObservationRepeat);
        this.panelObservationRepeat.setLayout(panelObservationRepeatLayout);
        panelObservationRepeatLayout.setHorizontalGroup(panelObservationRepeatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationRepeatLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lblObservationContact1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldObservationRepeatCount, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldObservationRepeat, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnRepeat, -1, 397, Short.MAX_VALUE)));
        panelObservationRepeatLayout.setVerticalGroup(panelObservationRepeatLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationRepeatLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelObservationRepeatLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblObservationContact1, -2, -1, -2).addComponent(this.fldObservationRepeatCount, -2, 30, -2).addComponent(this.fldObservationRepeat, -2, 30, -2).addComponent(this.btnRepeat, -2, 30, -2)).addGap(6, 6, 6)));
        this.lblObservationRisk.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationRisk, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationRisk.text"));
        this.fldObservationRisk.setFont(THEMIS.fontTextfield);
        this.fldObservationRisk.setText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.fldObservationRisk.text"));
        this.fldObservationRisk.setPreferredSize(new Dimension(100, 32));
        GroupLayout panelObservationRiskLayout = new GroupLayout(this.panelObservationRisk);
        this.panelObservationRisk.setLayout(panelObservationRiskLayout);
        panelObservationRiskLayout.setHorizontalGroup(panelObservationRiskLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationRiskLayout.createSequentialGroup().addComponent(this.lblObservationRisk).addGap(18, 18, 18).addComponent(this.fldObservationRisk, -1, -1, Short.MAX_VALUE)));
        panelObservationRiskLayout.setVerticalGroup(panelObservationRiskLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationRiskLayout.createSequentialGroup().addGroup(panelObservationRiskLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblObservationRisk).addComponent(this.fldObservationRisk, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.panelObservationContact.setPreferredSize(new Dimension(100, 32));
        this.lblObservationContact.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationContact, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationContact.text"));
        this.lblObservationContact.setPreferredSize(this.labelDimension);
        this.fldObservationContact.setFont(THEMIS.fontList);
        this.fldObservationContact.setModel(new DefaultComboBoxModel());
        this.fldObservationContact.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldObservationContactItemStateChanged(evt);
            }
        });
        this.btnAddContact.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddContact, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnAddContact.text"));
        this.btnAddContact.setMinimumSize(new Dimension(30, 30));
        this.btnAddContact.setPreferredSize(null);
        this.btnAddContact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnAddContactActionPerformed(evt);
            }
        });
        GroupLayout panelObservationContactLayout = new GroupLayout(this.panelObservationContact);
        this.panelObservationContact.setLayout(panelObservationContactLayout);
        panelObservationContactLayout.setHorizontalGroup(panelObservationContactLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationContactLayout.createSequentialGroup().addComponent(this.lblObservationContact, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fldObservationContact, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddContact, -2, -1, -2)));
        panelObservationContactLayout.setVerticalGroup(panelObservationContactLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblObservationContact, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(panelObservationContactLayout.createSequentialGroup().addGroup(panelObservationContactLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.fldObservationContact, GroupLayout.Alignment.LEADING).addComponent(this.btnAddContact, GroupLayout.Alignment.LEADING, -1, 30, Short.MAX_VALUE)).addGap(0, 3, Short.MAX_VALUE)));
        this.panelObservationDescription.setLayout(new GridBagLayout());
        this.lblObservationDescription.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblObservationDescription, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblObservationDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelObservationDescription.add((Component)this.lblObservationDescription, gridBagConstraints);
        this.fldObservationDescription.setColumns(20);
        this.fldObservationDescription.setFont(THEMIS.fontTextfield);
        this.fldObservationDescription.setLineWrap(true);
        this.fldObservationDescription.setRows(4);
        this.fldObservationDescription.setWrapStyleWord(true);
        this.scrollObsDescription.setViewportView(this.fldObservationDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelObservationDescription.add((Component)this.scrollObsDescription, gridBagConstraints);
        this.btnObservationCleareDescription.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationCleareDescription, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationCleareDescription.text"));
        this.btnObservationCleareDescription.setBorder(new SoftBevelBorder(0));
        this.btnObservationCleareDescription.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationCleareDescriptionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.panelObservationDescription.add((Component)this.btnObservationCleareDescription, gridBagConstraints);
        this.btnObservationMeasureCalendar1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/calendar.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationMeasureCalendar1, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationMeasureCalendar1.text"));
        this.btnObservationMeasureCalendar1.setBorder(new SoftBevelBorder(0));
        this.btnObservationMeasureCalendar1.setMinimumSize(new Dimension(30, 30));
        this.btnObservationMeasureCalendar1.setPreferredSize(new Dimension(30, 30));
        this.btnObservationMeasureCalendar1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationMeasureCalendar1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panelObservationDescription.add((Component)this.btnObservationMeasureCalendar1, gridBagConstraints);
        GroupLayout panelObservationMangelDetailsLayout = new GroupLayout(this.panelObservationMangelDetails);
        this.panelObservationMangelDetails.setLayout(panelObservationMangelDetailsLayout);
        panelObservationMangelDetailsLayout.setHorizontalGroup(panelObservationMangelDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationMangelDetailsLayout.createSequentialGroup().addContainerGap().addGroup(panelObservationMangelDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelObservationMeasure, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelObservationMangelDetailsLayout.createSequentialGroup().addComponent(this.panelObservationStatus, -1, 299, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.panelObservationDuedate, -1, 300, Short.MAX_VALUE)).addComponent(this.panelObservationRepeat, -1, -1, Short.MAX_VALUE).addComponent(this.panelObservationRisk, -1, -1, Short.MAX_VALUE).addComponent(this.panelObservationDescription, -1, -1, Short.MAX_VALUE).addComponent(this.panelObservationContact, -1, 617, Short.MAX_VALUE)).addContainerGap()));
        panelObservationMangelDetailsLayout.setVerticalGroup(panelObservationMangelDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationMangelDetailsLayout.createSequentialGroup().addContainerGap().addComponent(this.panelObservationDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelObservationMangelDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelObservationDuedate, -2, -1, -2).addComponent(this.panelObservationStatus, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObservationRepeat, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelObservationMeasure, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelObservationContact, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelObservationRisk, -2, -1, -2).addContainerGap()));
        this.panelObservationDescriptionOuter.add((Component)this.panelObservationMangelDetails, "Center");
        this.panelObservationDescriptionTitle.setBackground(new Color(220, 220, 220));
        this.lblLocationMerkmaleTitle2.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationMerkmaleTitle2.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationMerkmaleTitle2, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationMerkmaleTitle2.text"));
        GroupLayout panelObservationDescriptionTitleLayout = new GroupLayout(this.panelObservationDescriptionTitle);
        this.panelObservationDescriptionTitle.setLayout(panelObservationDescriptionTitleLayout);
        panelObservationDescriptionTitleLayout.setHorizontalGroup(panelObservationDescriptionTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 629, Short.MAX_VALUE).addGroup(panelObservationDescriptionTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationDescriptionTitleLayout.createSequentialGroup().addGap(0, 258, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle2).addGap(0, 259, Short.MAX_VALUE))));
        panelObservationDescriptionTitleLayout.setVerticalGroup(panelObservationDescriptionTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelObservationDescriptionTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationDescriptionTitleLayout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle2).addGap(0, 5, Short.MAX_VALUE))));
        this.panelObservationDescriptionOuter.add((Component)this.panelObservationDescriptionTitle, "North");
        this.panelObservation.add(this.panelObservationDescriptionOuter);
        this.panelObservation.add(this.filler8);
        this.panelObservationFilesOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelObservationFilesOuter.setMinimumSize(new Dimension(550, 390));
        this.panelObservationFilesOuter.setLayout(new BorderLayout());
        this.panelObservationFiles.setPreferredSize(new Dimension(300, 314));
        this.panelObservationFiles.setLayout(new GridBagLayout());
        this.jScrollPane2.setHorizontalScrollBarPolicy(32);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jScrollPane2.setMinimumSize(new Dimension(100, 122));
        this.jScrollPane2.setPreferredSize(new Dimension(200, 122));
        this.panelObservationImages.setMinimumSize(new Dimension(0, 100));
        this.panelObservationImages.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView(this.panelObservationImages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panelObservationFiles.add((Component)this.jScrollPane2, gridBagConstraints);
        this.panelObservationFilesButtons.setLayout(new GridBagLayout());
        this.btnObservationAddFile2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/showPictures_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationAddFile2, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddFile2.text"));
        this.btnObservationAddFile2.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddFile2.toolTipText"));
        this.btnObservationAddFile2.setBorder(new SoftBevelBorder(0));
        this.btnObservationAddFile2.setMinimumSize(new Dimension(35, 35));
        this.btnObservationAddFile2.setPreferredSize(new Dimension(35, 35));
        this.btnObservationAddFile2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationAddFile2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelObservationFilesButtons.add((Component)this.btnObservationAddFile2, gridBagConstraints);
        this.btnObservationAddPlansnippet.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locateInPlan24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationAddPlansnippet, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddPlansnippet.text"));
        this.btnObservationAddPlansnippet.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddPlansnippet.toolTipText"));
        this.btnObservationAddPlansnippet.setBorder(new SoftBevelBorder(0));
        this.btnObservationAddPlansnippet.setMinimumSize(new Dimension(35, 35));
        this.btnObservationAddPlansnippet.setPreferredSize(new Dimension(35, 35));
        this.btnObservationAddPlansnippet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationAddPlansnippetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.panelObservationFilesButtons.add((Component)this.btnObservationAddPlansnippet, gridBagConstraints);
        this.btnObservationAddFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationAddFile, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddFile.text"));
        this.btnObservationAddFile.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddFile.toolTipText"));
        this.btnObservationAddFile.setBorder(new SoftBevelBorder(0));
        this.btnObservationAddFile.setMinimumSize(new Dimension(35, 35));
        this.btnObservationAddFile.setPreferredSize(new Dimension(35, 35));
        this.btnObservationAddFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationAddFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationFilesButtons.add((Component)this.btnObservationAddFile, gridBagConstraints);
        this.btnObservationRemoveFile.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationRemoveFile, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRemoveFile.text"));
        this.btnObservationRemoveFile.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRemoveFile.toolTipText"));
        this.btnObservationRemoveFile.setBorder(new SoftBevelBorder(0));
        this.btnObservationRemoveFile.setMinimumSize(new Dimension(35, 35));
        this.btnObservationRemoveFile.setPreferredSize(new Dimension(35, 35));
        this.btnObservationRemoveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationRemoveFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationFilesButtons.add((Component)this.btnObservationRemoveFile, gridBagConstraints);
        this.btnObservationEditImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationEditImage, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationEditImage.text"));
        this.btnObservationEditImage.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationEditImage.toolTipText"));
        this.btnObservationEditImage.setBorder(new SoftBevelBorder(0));
        this.btnObservationEditImage.setMinimumSize(new Dimension(35, 35));
        this.btnObservationEditImage.setPreferredSize(new Dimension(35, 35));
        this.btnObservationEditImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationEditImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationFilesButtons.add((Component)this.btnObservationEditImage, gridBagConstraints);
        this.btnObservationRotateImageCW.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCW24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationRotateImageCW, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCW.text"));
        this.btnObservationRotateImageCW.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCW.toolTipText"));
        this.btnObservationRotateImageCW.setBorder(new SoftBevelBorder(0));
        this.btnObservationRotateImageCW.setMinimumSize(new Dimension(35, 35));
        this.btnObservationRotateImageCW.setPreferredSize(new Dimension(35, 35));
        this.btnObservationRotateImageCW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationRotateImageCWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panelObservationFilesButtons.add((Component)this.btnObservationRotateImageCW, gridBagConstraints);
        this.btnObservationRotateImageCCW.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCCW24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationRotateImageCCW, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCCW.text"));
        this.btnObservationRotateImageCCW.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRotateImageCCW.toolTipText"));
        this.btnObservationRotateImageCCW.setBorder(new SoftBevelBorder(0));
        this.btnObservationRotateImageCCW.setMinimumSize(new Dimension(35, 35));
        this.btnObservationRotateImageCCW.setPreferredSize(new Dimension(35, 35));
        this.btnObservationRotateImageCCW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationRotateImageCCWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationFilesButtons.add((Component)this.btnObservationRotateImageCCW, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.panelObservationFiles.add((Component)this.panelObservationFilesButtons, gridBagConstraints);
        this.jLabel33.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel33, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel33.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panelObservationFiles.add((Component)this.jLabel33, gridBagConstraints);
        this.jScrollPane11.setMaximumSize(null);
        this.jScrollPane11.setMinimumSize(new Dimension(100, 60));
        this.jScrollPane11.setPreferredSize(new Dimension(292, 50));
        this.lstObservationFiles.setFont(THEMIS.fontList);
        this.lstObservationFiles.setModel(new DefaultListModel());
        this.lstObservationFiles.setPreferredSize(null);
        this.lstObservationFiles.setVisibleRowCount(9);
        this.lstObservationFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstObservationFilesValueChanged(evt);
            }
        });
        this.jScrollPane11.setViewportView(this.lstObservationFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panelObservationFiles.add((Component)this.jScrollPane11, gridBagConstraints);
        this.jPanel25.setLayout(new GridBagLayout());
        this.recordButton.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/record24.gif")));
        this.recordButton.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.recordButton.toolTipText_1"));
        this.recordButton.setBorder(new SoftBevelBorder(0));
        this.recordButton.setMinimumSize(new Dimension(35, 35));
        this.recordButton.setPreferredSize(new Dimension(35, 35));
        this.recordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.recordButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel25.add((Component)this.recordButton, gridBagConstraints);
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/play24.gif")));
        this.playButton.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.playButton.toolTipText_1"));
        this.playButton.setBorder(new SoftBevelBorder(0));
        this.playButton.setMinimumSize(new Dimension(35, 35));
        this.playButton.setPreferredSize(new Dimension(35, 35));
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.playButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel25.add((Component)this.playButton, gridBagConstraints);
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/stop24.gif")));
        this.stopButton.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.stopButton.toolTipText_1"));
        this.stopButton.setBorder(new SoftBevelBorder(0));
        this.stopButton.setMinimumSize(new Dimension(35, 35));
        this.stopButton.setPreferredSize(new Dimension(35, 35));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.stopButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel25.add((Component)this.stopButton, gridBagConstraints);
        this.playExternal.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/open_external_24.gif")));
        this.playExternal.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.playExternal.toolTipText"));
        this.playExternal.setBorder(new SoftBevelBorder(0));
        this.playExternal.setMargin(new Insets(0, 0, 0, 0));
        this.playExternal.setMinimumSize(new Dimension(35, 35));
        this.playExternal.setPreferredSize(new Dimension(35, 35));
        this.playExternal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.playExternalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel25.add((Component)this.playExternal, gridBagConstraints);
        this.btnRemoveAudio.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveAudio, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnRemoveAudio.text"));
        this.btnRemoveAudio.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnRemoveAudio.toolTipText"));
        this.btnRemoveAudio.setBorder(new SoftBevelBorder(0));
        this.btnRemoveAudio.setMinimumSize(new Dimension(35, 35));
        this.btnRemoveAudio.setPreferredSize(new Dimension(35, 35));
        this.btnRemoveAudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnRemoveAudioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.jPanel25.add((Component)this.btnRemoveAudio, gridBagConstraints);
        this.lblFileInfo.setFont(THEMIS.fontInfo);
        Mnemonics.setLocalizedText((JLabel)this.lblFileInfo, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblFileInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel25.add((Component)this.lblFileInfo, gridBagConstraints);
        this.progressAudioLevel1.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.progressAudioLevel1.setMinimumSize(new Dimension(100, 20));
        this.jPanel25.add((Component)this.progressAudioLevel1, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.panelObservationFiles.add((Component)this.jPanel25, gridBagConstraints);
        this.panelObservationFilesOuter.add((Component)this.panelObservationFiles, "Center");
        this.panelObservationFilesTitle.setBackground(new Color(220, 220, 220));
        this.lblLocationMerkmaleTitle3.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationMerkmaleTitle3.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationMerkmaleTitle3, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationMerkmaleTitle3.text"));
        GroupLayout panelObservationFilesTitleLayout = new GroupLayout(this.panelObservationFilesTitle);
        this.panelObservationFilesTitle.setLayout(panelObservationFilesTitleLayout);
        panelObservationFilesTitleLayout.setHorizontalGroup(panelObservationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 629, Short.MAX_VALUE).addGroup(panelObservationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationFilesTitleLayout.createSequentialGroup().addGap(0, 273, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle3).addGap(0, 273, Short.MAX_VALUE))));
        panelObservationFilesTitleLayout.setVerticalGroup(panelObservationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelObservationFilesTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationFilesTitleLayout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle3).addGap(0, 5, Short.MAX_VALUE))));
        this.panelObservationFilesOuter.add((Component)this.panelObservationFilesTitle, "North");
        this.panelObservation.add(this.panelObservationFilesOuter);
        this.panelObservation.add(this.filler9);
        this.panelObservationDocumentsOuter.setBorder(BorderFactory.createBevelBorder(0));
        this.panelObservationDocumentsOuter.setPreferredSize(new Dimension(567, 175));
        this.panelObservationDocumentsOuter.setLayout(new BorderLayout());
        this.panelObservationDocuments.setPreferredSize(new Dimension(334, 125));
        this.panelObservationDocuments.setLayout(new GridBagLayout());
        this.fldObservationDocumentLibraryType.setFont(THEMIS.fontList);
        this.fldObservationDocumentLibraryType.setModel(new DefaultComboBoxModel());
        this.fldObservationDocumentLibraryType.setMinimumSize(new Dimension(56, 30));
        this.fldObservationDocumentLibraryType.setPreferredSize(new Dimension(56, 30));
        this.fldObservationDocumentLibraryType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationObservationDialog.this.fldObservationDocumentLibraryTypeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.panelObservationDocuments.add((Component)this.fldObservationDocumentLibraryType, gridBagConstraints);
        this.fldObservationDocumentLibrary.setFont(THEMIS.fontList);
        this.fldObservationDocumentLibrary.setModel(new DefaultComboBoxModel());
        this.fldObservationDocumentLibrary.setMinimumSize(new Dimension(56, 30));
        this.fldObservationDocumentLibrary.setPreferredSize(new Dimension(56, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.panelObservationDocuments.add((Component)this.fldObservationDocumentLibrary, gridBagConstraints);
        this.btnObservationAddDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationAddDocument, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddDocument.text"));
        this.btnObservationAddDocument.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationAddDocument.toolTipText"));
        this.btnObservationAddDocument.setBorder(new SoftBevelBorder(0));
        this.btnObservationAddDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationAddDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.panelObservationDocuments.add((Component)this.btnObservationAddDocument, gridBagConstraints);
        this.jScrollPane12.setMaximumSize(null);
        this.jScrollPane12.setMinimumSize(null);
        this.lstObservationDocuments.setFont(THEMIS.fontList);
        this.lstObservationDocuments.setModel(new DefaultListModel());
        this.lstObservationDocuments.setPreferredSize(null);
        this.lstObservationDocuments.setVisibleRowCount(7);
        this.lstObservationDocuments.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LocationObservationDialog.this.lstObservationDocumentsMousePressed(evt);
            }
        });
        this.lstObservationDocuments.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationObservationDialog.this.lstObservationDocumentsValueChanged(evt);
            }
        });
        this.jScrollPane12.setViewportView(this.lstObservationDocuments);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        this.panelObservationDocuments.add((Component)this.jScrollPane12, gridBagConstraints);
        this.btnObservationRemoveDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationRemoveDocument, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRemoveDocument.text"));
        this.btnObservationRemoveDocument.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationRemoveDocument.toolTipText"));
        this.btnObservationRemoveDocument.setBorder(new SoftBevelBorder(0));
        this.btnObservationRemoveDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationRemoveDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.panelObservationDocuments.add((Component)this.btnObservationRemoveDocument, gridBagConstraints);
        this.btnObservationEditDocument.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/controlled24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationEditDocument, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationEditDocument.text"));
        this.btnObservationEditDocument.setToolTipText(NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationEditDocument.toolTipText"));
        this.btnObservationEditDocument.setBorder(new SoftBevelBorder(0));
        this.btnObservationEditDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationEditDocumentActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationDocuments.add((Component)this.btnObservationEditDocument, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel20.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelObservationDocuments.add((Component)this.jLabel20, gridBagConstraints);
        this.panelObservationDocumentsOuter.add((Component)this.panelObservationDocuments, "Center");
        this.panelObservationFilesTitle1.setBackground(new Color(220, 220, 220));
        this.lblLocationMerkmaleTitle4.setFont(THEMIS.fontLabelBigBold);
        this.lblLocationMerkmaleTitle4.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblLocationMerkmaleTitle4, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.lblLocationMerkmaleTitle4.text"));
        GroupLayout panelObservationFilesTitle1Layout = new GroupLayout(this.panelObservationFilesTitle1);
        this.panelObservationFilesTitle1.setLayout(panelObservationFilesTitle1Layout);
        panelObservationFilesTitle1Layout.setHorizontalGroup(panelObservationFilesTitle1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 629, Short.MAX_VALUE).addGroup(panelObservationFilesTitle1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationFilesTitle1Layout.createSequentialGroup().addGap(0, 283, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle4).addGap(0, 284, Short.MAX_VALUE))));
        panelObservationFilesTitle1Layout.setVerticalGroup(panelObservationFilesTitle1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 26, Short.MAX_VALUE).addGroup(panelObservationFilesTitle1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelObservationFilesTitle1Layout.createSequentialGroup().addGap(0, 5, Short.MAX_VALUE).addComponent(this.lblLocationMerkmaleTitle4).addGap(0, 5, Short.MAX_VALUE))));
        this.panelObservationDocumentsOuter.add((Component)this.panelObservationFilesTitle1, "North");
        this.panelObservation.add(this.panelObservationDocumentsOuter);
        this.jPanel7.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jLabel14, gridBagConstraints);
        this.panelObservation.add(this.jPanel7);
        this.panelObservationScroll.setViewportView(this.panelObservation);
        this.panelObservationOuter.add((Component)this.panelObservationScroll, "Center");
        this.panelObservationButtons.setLayout(new GridBagLayout());
        this.btnObservationToItem.setFont(THEMIS.fontButton);
        this.btnObservationToItem.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/locate24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationToItem, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationToItem.text"));
        this.btnObservationToItem.setBorder(new SoftBevelBorder(0));
        this.btnObservationToItem.setMinimumSize(null);
        this.btnObservationToItem.setPreferredSize(null);
        this.btnObservationToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationToItemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationButtons.add((Component)this.btnObservationToItem, gridBagConstraints);
        this.btnObservationSaveClose.setFont(THEMIS.fontButton);
        this.btnObservationSaveClose.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationSaveClose, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationSaveClose.text"));
        this.btnObservationSaveClose.setBorder(new SoftBevelBorder(0));
        this.btnObservationSaveClose.setMinimumSize(null);
        this.btnObservationSaveClose.setPreferredSize(null);
        this.btnObservationSaveClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationSaveCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.panelObservationButtons.add((Component)this.btnObservationSaveClose, gridBagConstraints);
        this.btnObservationCancel.setFont(THEMIS.fontButton);
        this.btnObservationCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnObservationCancel, (String)NbBundle.getMessage(LocationObservationDialog.class, (String)"LocationObservationDialog.btnObservationCancel.text"));
        this.btnObservationCancel.setBorder(new SoftBevelBorder(0));
        this.btnObservationCancel.setMinimumSize(null);
        this.btnObservationCancel.setPreferredSize(null);
        this.btnObservationCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationObservationDialog.this.btnObservationCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelObservationButtons.add((Component)this.btnObservationCancel, gridBagConstraints);
        this.panelObservationOuter.add((Component)this.panelObservationButtons, "South");
        this.panelEditor.add((Component)this.panelObservationOuter, "cardObservation");
        this.splitPane.setRightComponent(this.panelEditor);
        this.add((Component)this.splitPane, "Center");
    }

    private void btnApplyTemplateLocationActionPerformed(ActionEvent evt) {
        this.applyLocationTemplate(true);
        this.showLocationDialog();
    }

    private CmsBasicElement getLocationTemplate(String title) {
        int count = ((DefaultListModel)this.lstTemplateLocation.getModel()).size();
        for (int ii = 0; ii < count; ++ii) {
            CmsBasicElement eleLoc = (CmsBasicElement)((DefaultListModel)this.lstTemplateLocation.getModel()).getElementAt(ii);
            if (!eleLoc.getTitle().equals(title)) continue;
            return eleLoc;
        }
        return null;
    }

    private ArrayList<CmsBasicElement> getLocationTemplates() {
        ArrayList<CmsBasicElement> result = new ArrayList<CmsBasicElement>();
        int count = ((DefaultListModel)this.lstTemplateLocation.getModel()).size();
        for (int ii = 0; ii < count; ++ii) {
            CmsBasicElement eleLoc = (CmsBasicElement)((DefaultListModel)this.lstTemplateLocation.getModel()).getElementAt(ii);
            result.add(eleLoc);
        }
        return result;
    }

    private void btnSaveTemplateLocationActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        if (!this.userAdministrator) {
            return;
        }
        CmsBasicElement selLoc = this.getLocationTemplate(this.fldLocationName.getText());
        if (selLoc != null && !Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.overwriteLocationTemplate.text"))) {
            selLoc = null;
        }
        CmsLocationTemplate template = selLoc == null ? (CmsLocationTemplate)this.project.createElement("locationtemplate") : (CmsLocationTemplate)this.project.loadElement(selLoc.getId(), this.project.getUser());
        this.applyLocationPanel();
        template.setAttributes(this.location);
        template.save();
        this.location.getLongAttribute("templateid").setValue(template.getId());
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATIONTEMPLATE_SAVED.setId(template.getId()));
        this.loadLocationTemplates();
        this.selectLocationTemplate(this.location);
        this.templatesChanged = true;
    }

    private void btnAddTemplateObservationActionPerformed(ActionEvent evt) {
        this.editObservationOnly = false;
        this.addNewTemplateObservation();
        if (this.currentPanel.equals("location")) {
            // empty if block
        }
    }

    private void btnSaveTemplateObservationActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        if (!this.userAdministrator) {
            return;
        }
        if ("".equals(this.fldObservationTitle.getText())) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.setTitleObs.Notif"));
            return;
        }
        CmsBasicElement ele = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
        if (ele == null) {
            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.chooseLocTemplateNotif.text"));
            return;
        }
        int idxTemplateLocationgroup = this.fldTemplateLocationgroup.getSelectedIndex();
        this.idxTemplateLocation = this.lstTemplateLocation.getSelectedIndex();
        if (this.observation != null) {
            CmsObservationTemplate obsTemplate;
            ArrayList<Long> ids = new ArrayList<Long>();
            CmsBasicElement selObs = null;
            int count = ((DefaultListModel)this.lstTemplateObservation.getModel()).size();
            for (int ii = 0; ii < count; ++ii) {
                CmsBasicElement eleObs = (CmsBasicElement)((DefaultListModel)this.lstTemplateObservation.getModel()).getElementAt(ii);
                if (eleObs.getTitle().equals(this.fldObservationTitle.getText())) {
                    selObs = eleObs;
                }
                ids.add(eleObs.getId());
            }
            if (selObs != null && !Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.overwriteObservationTemplate.text"))) {
                selObs = null;
            }
            int itemsort = 0;
            if (selObs == null) {
                obsTemplate = (CmsObservationTemplate)this.project.createElement("observationtemplate");
                DataRecord rec = this.project.getDatastorage().executeQuery("SELECT max(itemsort) AS sort FROM tdtaeleobservationtemplate WHERE idelement IN " + Util.toSqlString(ids), true).firstRow();
                if (rec != null && !rec.isEmpty("sort")) {
                    itemsort = rec.getInt("sort");
                }
                obsTemplate.getIntegerAttribute("itemsort").setValue(itemsort + 1);
            } else {
                obsTemplate = (CmsObservationTemplate)this.project.loadElement(selObs.getId(), this.project.getUser());
            }
            this.applyObservationPanel(true, this.observation);
            obsTemplate.setAttributes(this.observation);
            if (obsTemplate.isNew()) {
                obsTemplate.getRelationAttribute("location").add(ele.getId());
            }
            obsTemplate.save();
            this.observation.getLongAttribute("templateid").setValue(obsTemplate.getId());
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.OBSERVATIONTEMPLATE_SAVED.setId(obsTemplate.getId()));
            this.loadObservationTemplates();
            this.selectObservationTemplate(this.observation);
        }
    }

    private void btnApplyTemplateObservationActionPerformed(ActionEvent evt) {
        this.applyObservationTemplate();
    }

    private void btnLocationEditObservationActionPerformed(ActionEvent evt) {
        this.editObservationOnly = false;
        this.editObservation();
    }

    private void lstTemplateLocationValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            CmsBasicElement eleLoc = (CmsBasicElement)this.lstTemplateLocation.getSelectedValue();
            if (eleLoc != null && this.templateFavourites.contains(eleLoc.getId())) {
                this.btnTemplateFavourite.setSelected(true);
                this.btnTemplateFavourite.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/favoriten_selected24.gif")));
            } else {
                this.btnTemplateFavourite.setSelected(false);
                this.btnTemplateFavourite.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/favoriten24.gif")));
            }
            this.loadObservationTemplates();
            this.updateComponentVisibility();
        }
    }

    private void lstTemplateObservationValueChanged(ListSelectionEvent evt) {
        this.updateComponentVisibility();
    }

    private void btnLocationCancelActionPerformed(ActionEvent evt) {
        ThemisUtil.setWindowSize((String)DIALOG_CODE, (Dimension)this.dlg.getSize(), (ThemisApplication)this.app);
        if (this.audiostate == 1) {
            try {
                this.stopAudio();
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
            }
        }
        this.app.getSettings().setTemplateFavourite(this.templateFavourites);
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        this.applyLocationPanel();
        if (this.closeLocationPanel(true)) {
            this.dlg.dispose();
            this.stopFolderObserver();
        }
    }

    private void btnLocationSaveCloseActionPerformed(ActionEvent evt) {
        ThemisUtil.setWindowSize((String)DIALOG_CODE, (Dimension)this.dlg.getSize(), (ThemisApplication)this.app);
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        if (this.location != null) {
            if (this.audiostate == 1) {
                try {
                    this.stopAudio();
                }
                catch (IOException ex) {
                    Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
                }
            }
            for (ArrayList<ImageReference> refs : this.imageReferences.values()) {
                for (ImageReference ref : refs) {
                    ref.save();
                }
            }
            this.saveLocation();
        }
        this.locationChanged = false;
        if (this.closeLocationPanel(false)) {
            this.app.getFilter().resetSearchResult();
            this.app.getSettings().setTemplateFavourite(this.templateFavourites);
            int i = this.splitPane.getDividerLocation();
            this.dlg.dispose();
            this.stopFolderObserver();
        }
    }

    private void btnLocationAddDocumentActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        CmsElementSummary ele = (CmsElementSummary)this.fldLocationDocumentLibrary.getSelectedItem();
        if (this.location != null && ele != null) {
            this.location.getRelationAttribute("infos").add(ele);
            ((DefaultComboBoxModel)this.fldLocationDocumentLibrary.getModel()).removeElement(ele);
            ((DefaultListModel)this.lstLocationDocuments.getModel()).addElement(ele);
            this.locationChanged = true;
        }
    }

    private void btnLocationRemoveDocumentActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        CmsElementSummary ele = (CmsElementSummary)this.lstLocationDocuments.getSelectedValue();
        if (this.location != null && ele != null) {
            this.location.getRelationAttribute("infos").delete(ele.getId());
            ((DefaultListModel)this.lstLocationDocuments.getModel()).removeElement(ele);
            ((DefaultComboBoxModel)this.fldLocationDocumentLibrary.getModel()).addElement(ele);
            this.locationChanged = true;
        }
    }

    private void lstLocationDocumentsValueChanged(ListSelectionEvent evt) {
        if (this.updateComponentVisibilityFlag) {
            this.updateComponentVisibility();
        }
    }

    private void lstLocationObservationValueChanged(ListSelectionEvent evt) {
        if (this.updateComponentVisibilityFlag) {
            this.updateComponentVisibility();
        }
    }

    private void btnLocationAddObservationActionPerformed(ActionEvent evt) {
        this.addNewObservation();
    }

    private void btnLocationRemoveObservationActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        List selObss = this.lstLocationObservation.getSelectedValuesList();
        boolean atLeastOneLocked = false;
        for (ObservationListItem selObs : selObss) {
            boolean islocked = this.project.isObservationInSignedEvent(selObs.id);
            boolean bl = atLeastOneLocked = atLeastOneLocked || islocked;
            if (!islocked) {
                String message = MessageFormat.format(this.bundle.getString("LocationObservationDialog.deleteObsNotif.text"), selObs.title);
                if (!Dialogs.getInstance().showConfirmDialog(message, this.bundle.getString("LocationObservationDialog.deleteObsNotif1.text"))) continue;
                if (this.location.getRelationAttribute("observations").contains(selObs.id)) {
                    if (this.location.getRelationAttribute("observations").getElement(selObs.id).isNew()) {
                        this.location.deleteObservation(selObs.id);
                    } else {
                        this.deletedObservations.add(selObs.id);
                    }
                }
                if (this.observations.containsKey(selObs.id)) {
                    this.observations.remove(selObs.id);
                }
                this.updateObservationNumbers();
                this.populateObservationList(-1L);
                continue;
            }
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("LocationObservationDialog.lockedObservation"));
        }
    }

    private void fldLocationGroupItemStateChanged(ItemEvent evt) {
        this.locationChanged = true;
    }

    private void fldTemplateLocationgroupItemStateChanged(ItemEvent evt) {
        this.updateTemplatesByGroup();
    }

    private void btnLocationEditDocumentActionPerformed(ActionEvent evt) {
        CmsElementSummary sel = (CmsElementSummary)this.lstLocationDocuments.getSelectedValue();
        CmsElement ele = sel.getElement();
        if (ele instanceof CmsInfo) {
            List items = ele.getUploadAttribute("files").getUploadItems();
            if (items.size() == 1) {
                Desktop dt = Desktop.getDesktop();
                try {
                    dt.open(new File(((UploadItem)items.get(0)).getAbsolutePath()));
                }
                catch (IOException iOException) {}
            } else if (items.size() > 1) {
                UploadItemFilePanel p = new UploadItemFilePanel();
                p.populate(ele.getUploadAttribute("files"));
                Dialogs.getInstance().showDialogWithPanel(p, "dialog.select.title");
            }
        }
    }

    private void btnApplyTemplateMeasureActionPerformed(ActionEvent evt) {
        this.applyMeasureTemplate();
    }

    private void lstLocationObservationMousePressed(MouseEvent evt) {
        int count = this.handleClickEventOnList(this.lstLocationObservation, evt);
        if (this.lstLocationObservation.getSelectedIndex() >= 0 && count == 2 && THEMIS.checkAndCreateEvent()) {
            this.editObservationOnly = false;
            this.editObservation();
        }
    }

    private void lstTemplateLocationMousePressed(MouseEvent evt) {
        if (!this.lstTemplateLocation.isEnabled()) {
            return;
        }
        if (this.lstTemplateLocation.getSelectedValue() == null) {
            return;
        }
        int count = this.handleClickEventOnList(this.lstTemplateLocation, evt);
        if (count == 2) {
            if (this.currentPanel.equals("observation")) {
                return;
            }
            this.applyLocationTemplate(true);
            this.showLocationDialog();
        }
    }

    private void lstTemplateObservationMousePressed(MouseEvent evt) {
        int count = this.handleClickEventOnList(this.lstTemplateObservation, evt);
        if (count == 2) {
            if (this.currentPanel.equals("location")) {
                this.editObservationOnly = false;
                this.addNewTemplateObservation();
            } else if (this.currentPanel.equals("observation")) {
                this.applyObservationTemplate();
            }
        }
    }

    private void btnAddTemplateObservationsActionPerformed(ActionEvent evt) {
        this.addNewTemplateObservations(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lstLocationFilesValueChanged(ListSelectionEvent evt) {
        if (this.updateComponentVisibilityFlag) {
            this.updateComponentVisibility();
        }
        try {
            UploadItem uploadItem;
            if (this.lstLocationFiles.getModel().getSize() > 0 && !(uploadItem = (UploadItem)this.lstLocationFiles.getSelectedValue()).isAudio()) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnLocationAddFileActionPerformed(ActionEvent evt) {
        if (!this.canEdit || !this.app.getLicense().hasLicenseFull() && !((CmsLocation)this.currentElement).getImageUploadItems().isEmpty()) {
            return;
        }
        this.locationChanged = true;
        boolean success = false;
        try {
            File f = new ThemisFileDialog(this.bundle.getString("LocationObservationDialog.chooseFile.text"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getFileFolder(), null, THEMIS.getFileFilter(), null, false).getSelectedFile();
            if (f == null) {
                return;
            }
            File outputfile = null;
            try {
                BufferedImage image = this.imageSize == 0 ? ImageIO.read(f) : Util.resizeImage((BufferedImage)ImageIO.read(f), (int)this.imageSize, (int)0, (int)1, (boolean)false);
                File tmpFolder = this.app.getProject().getTempfileLocation();
                outputfile = new File(tmpFolder, f.getName());
                int counter = 1;
                String name = Util.getFileNameWithoutExtension((File)f);
                String extension = Util.getFileExtension((File)f);
                while (outputfile.exists()) {
                    outputfile = new File(tmpFolder, name + "_" + counter + "." + extension);
                    ++counter;
                }
                success = THEMIS.createImageFile(image, outputfile, this.app.getSettings().getImageUploadQuality());
            }
            catch (IOException image) {
                // empty catch block
            }
            if (success) {
                UploadItem item = this.location.getUploadAttribute("files").addUpload(outputfile);
                if (item != null && this.app.getSettings().getImageKeepOriginal()) {
                    Util.copy((File)f, (File)new File(this.project.getImagefileLocation(), item.createFilename()));
                }
                this.populateLocationUploads();
            }
            this.app.setFileFolder(f);
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.errWhileAssigningFileNotic.text"), ex);
        }
    }

    private void btnLocationRemoveFileActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        UploadItem uploadItem = this.selectedLocationImage;
        if (uploadItem == null) {
            return;
        }
        try {
            if (Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.reallyDeleteFileNotif.text"), uploadItem.getFilename()), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.deleteFile.text"))) {
                this.location.getUploadAttribute("files").deleteUpload(uploadItem);
                this.locationChanged = true;
                this.populateLocationUploads();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fldLocationDocumentLibraryItemStateChanged(ItemEvent evt) {
        this.btnLocationAddDocument.setEnabled(this.canEdit && this.fldLocationDocumentLibrary.getSelectedItem() != null);
    }

    private void fldLocationDimWidthPropertyChange(PropertyChangeEvent evt) {
    }

    private void fldLocationDimWidthKeyReleased(KeyEvent evt) {
        this.calculateLocationDimensionArea(false);
    }

    private void fldLocationDimHeightKeyReleased(KeyEvent evt) {
        this.calculateLocationDimensionArea(false);
    }

    private void fldLocationDimDiameterKeyReleased(KeyEvent evt) {
        this.calculateLocationDimensionArea(true);
    }

    private void recordButton1ActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.locationChanged = true;
        this.captureAudio();
    }

    private void playButton1ActionPerformed(ActionEvent evt) {
        this.playAudio();
    }

    private void stopButton1ActionPerformed(ActionEvent evt) {
        try {
            this.stopAudio();
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
        }
    }

    private void fldLocationNumberKeyTyped(KeyEvent evt) {
        String t = this.fldLocationNumber.getText();
        if (!"".equals(t)) {
            try {
                long l = Long.parseLong(t);
            }
            catch (Exception e) {
                ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.hastoBeIntegerNotif.text");
            }
        }
    }

    private void btnObservationAddDocumentActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observationChanged = true;
        CmsElementSummary ele = (CmsElementSummary)this.fldObservationDocumentLibrary.getSelectedItem();
        if (this.observation != null && ele != null) {
            this.observation.getRelationAttribute("infos").add(ele);
            ((DefaultComboBoxModel)this.fldObservationDocumentLibrary.getModel()).removeElement(ele);
            ((DefaultListModel)this.lstObservationDocuments.getModel()).addElement(ele);
        }
    }

    private void btnObservationEditDocumentActionPerformed(ActionEvent evt) {
        CmsElementSummary sel = (CmsElementSummary)this.lstObservationDocuments.getSelectedValue();
        CmsElement ele = sel.getElement();
        if (ele instanceof CmsInfo) {
            List items = ele.getUploadAttribute("files").getUploadItems();
            if (items.size() == 1) {
                Desktop dt = Desktop.getDesktop();
                try {
                    dt.open(new File(((UploadItem)items.get(0)).getAbsolutePath()));
                }
                catch (IOException iOException) {}
            } else if (items.size() > 1) {
                UploadItemFilePanel p = new UploadItemFilePanel();
                p.populate(ele.getUploadAttribute("files"));
                Dialogs.getInstance().showDialogWithPanel(p, "dialog.select.title");
            }
        }
    }

    private void btnObservationRemoveDocumentActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observationChanged = true;
        CmsElementSummary ele = (CmsElementSummary)this.lstObservationDocuments.getSelectedValue();
        if (this.observation != null && ele != null) {
            this.observation.getRelationAttribute("infos").delete(ele.getId());
            ((DefaultListModel)this.lstObservationDocuments.getModel()).removeElement(ele);
            ((DefaultComboBoxModel)this.fldObservationDocumentLibrary.getModel()).addElement(ele);
        }
    }

    private void lstObservationDocumentsValueChanged(ListSelectionEvent evt) {
        if (this.updateComponentVisibilityFlag) {
            this.updateComponentVisibility();
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        try {
            this.stopAudio();
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
        }
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        this.playAudio();
    }

    private void recordButtonActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observationChanged = true;
        this.captureAudio();
    }

    private void btnObservationRemoveFileActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        UploadItem uploadItem = this.selectedObservationImage;
        if (uploadItem == null) {
            return;
        }
        try {
            CmsEvent eve;
            CmsElement hist = this.observation.getHistoryForUpload(uploadItem);
            if (hist != null && (eve = (CmsEvent)hist.getRelationAttribute("event").getFirstElement().getElement()) != null && eve.isSigned()) {
                Dialogs.getInstance().showWarningDialog(this.project.getResourceText("error.eventLockedImagecantBeDeleted"));
                return;
            }
            if (Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.reallyDeleteFileNotif.text"), uploadItem.getFilename()), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.deleteFile.text"))) {
                ArrayList<UploadItem> items = this.getItemsToBeDeleted(this.observation);
                items.add(uploadItem);
                this.itemsToBeDeleted.put(this.observation, items);
                this.observation.getUploadAttribute("files").deleteUpload(uploadItem);
                this.observationChanged = true;
                this.selectedObservationImage = null;
                this.btnObservationRemoveFile.setEnabled(false);
                this.populateObservationUploads();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnObservationAddFileActionPerformed(ActionEvent evt) {
        if (!this.canEdit || !this.app.getLicense().hasLicenseFull() && ((CmsObservation)this.currentElement).getCurrentHistory().hasImages()) {
            return;
        }
        this.observationChanged = true;
        try {
            File f = new ThemisFileDialog(this.bundle.getString("LocationObservationDialog.chooseFile.text"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getFileFolder(), null, THEMIS.getFileFilter(), null, false).getSelectedFile();
            if (f == null) {
                return;
            }
            File outputfile = this.loadFileForObservation(f);
            if (outputfile != null) {
                this.observation.getUploadAttribute("files").addUpload(outputfile);
                this.observation.setSaved(false);
                this.populateObservationUploads();
            }
            this.app.setFileFolder(f);
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.errWhileAssigningFileNotic.text"), ex);
        }
    }

    private void fldObservationStatusItemStateChanged(ItemEvent evt) {
        this.observationChanged = true;
    }

    private void btnRepeatActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        try {
            String sel = (String)this.fldObservationRepeat.getSelectedItem();
            long selId = this.app.getProject().getKeytable("repeat").getIdByTerm(sel, this.app.getProject().getUser().getLang());
            if ("".equals(this.fldObservationRepeatCount.getText()) || selId == -1L) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.integerAndNumberSelectedNotif.text"));
                return;
            }
            Date dt = this.observation.getDuedateFromRepeat(selId, Integer.parseInt(this.fldObservationRepeatCount.getText()), true);
            this.fldObservationDueDate.setDate(dt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fldObservationRepeatItemStateChanged(ItemEvent evt) {
    }

    private void fldObservationContactItemStateChanged(ItemEvent evt) {
        this.observationChanged = true;
    }

    private void btnObservationToItemActionPerformed(ActionEvent evt) {
        this.editObservationOnly = false;
        ThemisUtil.setWindowSize((String)DIALOG_CODE, (Dimension)this.dlg.getSize(), (ThemisApplication)this.app);
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        if (this.observation != null && this.canEdit) {
            if (this.audiostate == 1) {
                try {
                    this.stopAudio();
                }
                catch (IOException ex) {
                    Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
                }
            }
            this.applyObservationPanel(false, this.observation);
            this.observation.setSaved(false);
        }
        this.closeObservationPanel();
        if (this.editObservationOnly) {
            this.editObservationOnly = false;
            if (this.canEdit) {
                this.saveLocation();
            }
            this.app.getSettings().setTemplateFavourite(this.templateFavourites);
            this.app.getFilter().resetSearchResult();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("observation").setId(this.observation.getId()));
            this.dlg.dispose();
            this.stopFolderObserver();
        }
    }

    private void btnObservationCancelActionPerformed(ActionEvent evt) {
        ThemisUtil.setWindowSize((String)DIALOG_CODE, (Dimension)this.dlg.getSize(), (ThemisApplication)this.app);
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        boolean doClose = true;
        if (this.observation != null && this.audiostate == 1) {
            try {
                this.stopAudio();
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
            }
        }
        if (this.observationChanged()) {
            doClose = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.obsNotSavedCloseNotif.text"));
        }
        if (doClose) {
            long obsId = -1L;
            if (this.observation != null) {
                obsId = this.observation.getId();
            }
            if (this.observations.get(obsId).isNew()) {
                this.observations.remove(obsId);
                this.location.getRelationAttribute("observations").remove(obsId);
            }
            if (obsId > 0L) {
                this.imageReferences.remove(obsId);
            }
            this.closeObservationPanel();
            if (this.editObservationOnly) {
                this.editObservationOnly = false;
                this.app.getSettings().setTemplateFavourite(this.templateFavourites);
                this.dlg.dispose();
                this.stopFolderObserver();
            }
        }
    }

    private void btnTypeKontrolleActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observation.getKeyAttribute("type").setValue(2L);
        this.observation.setDone(false);
        this.fldObservationStatus.setSelected(false);
        this.updateObservationType(false);
        this.applyObservationPanel(false, this.observation);
        this.populateObservationPanel();
    }

    private void btnTypeInfoActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observation.getKeyAttribute("type").setValue(3L);
        this.observation.setDone(false);
        this.fldObservationStatus.setSelected(false);
        this.updateObservationType(false);
        this.applyObservationPanel(false, this.observation);
        this.populateObservationPanel();
    }

    private void btnLocationSaveNewActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        if (this.location != null) {
            this.saveLocation();
            this.app.getFilter().resetSearchResult();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("location").setId(this.location.getId()));
        }
        this.app.getSettings().setTemplateFavourite(this.templateFavourites);
        CmsLocation loc = (CmsLocation)this.project.createElement("location");
        if (this.location.isBuilding()) {
            loc.setAsBuilding();
        }
        this.editLocation((CmsElement)loc, false);
    }

    private void fldObservationTitleActionPerformed(ActionEvent evt) {
    }

    private void btnTypeAufgabeActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observation.getKeyAttribute("type").setValue(4L);
        this.updateObservationType(false);
        this.applyObservationPanel(false, this.observation);
        this.populateObservationPanel();
    }

    private void btnObservationSaveCloseActionPerformed(ActionEvent evt) {
        ThemisUtil.setWindowSize((String)DIALOG_CODE, (Dimension)this.dlg.getSize(), (ThemisApplication)this.app);
        this.project.setProjectProperty("display.loc-obs-dialog.divider", this.splitPane.getDividerLocation() + "");
        if (this.observation != null && this.canEdit) {
            if (this.audiostate == 1) {
                try {
                    this.stopAudio();
                }
                catch (IOException ex) {
                    Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.fileCannotbeWrittenNotif.text"), ex);
                }
            }
            this.applyObservationPanel(false, this.observation);
            this.observation.setSaved(false);
        }
        this.closeObservationPanel();
        this.locationChanged = true;
        this.editObservationOnly = true;
        this.project.getLogger().fine("Saving " + this.imageReferences.size() + " image references");
        for (ArrayList<ImageReference> refs : this.imageReferences.values()) {
            for (ImageReference ref : refs) {
                ref.save();
            }
        }
        if (this.editObservationOnly) {
            this.editObservationOnly = false;
            if (this.canEdit) {
                this.saveLocation();
                this.stopElementEditLog();
            }
            this.app.getFilter().resetSearchResult();
            this.app.getSettings().setTemplateFavourite(this.templateFavourites);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setElementtype("observation"));
            this.dlg.dispose();
            this.stopFolderObserver();
        }
    }

    private void btnTypeMangelActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        this.observation.getKeyAttribute("type").setValue(1L);
        this.updateObservationType(false);
        this.applyObservationPanel(false, this.observation);
        this.populateObservationPanel();
    }

    private void fldLocationPostnumberKeyTyped(KeyEvent evt) {
    }

    private void fldLocationPrenumberKeyTyped(KeyEvent evt) {
    }

    private void playExternalActionPerformed(ActionEvent evt) {
        if (this.audiofile == null) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.no-audiofile-selected", this.app.getLocale()));
            return;
        }
        if (!this.audiofile.isFile()) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.audiofile-not-available", this.app.getLocale()));
            return;
        }
        try {
            Desktop.getDesktop().open(this.audiofile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void playExternalLocActionPerformed(ActionEvent evt) {
        if (this.audiofile == null) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.no-audiofile-selected", this.app.getLocale()));
            return;
        }
        if (!this.audiofile.isFile()) {
            Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.audiofile-not-available", this.app.getLocale()));
            return;
        }
        try {
            Desktop.getDesktop().open(this.audiofile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lstLocationDocumentsMousePressed(MouseEvent evt) {
        int count = this.handleClickEventOnList(this.lstLocationDocuments, evt);
        if (this.lstLocationDocuments.getSelectionModel().isSelectionEmpty()) {
            return;
        }
        if (count == 2) {
            this.openSelectedDocument(this.lstLocationDocuments);
        }
    }

    private void lstObservationDocumentsMousePressed(MouseEvent evt) {
        int count = this.handleClickEventOnList(this.lstObservationDocuments, evt);
        if (this.lstObservationDocuments.getSelectionModel().isSelectionEmpty()) {
            return;
        }
        if (count == 2) {
            this.openSelectedDocument(this.lstObservationDocuments);
        }
    }

    private void btnAddLocationTemplateActionPerformed(ActionEvent evt) {
        this.createLocationTemplate(null);
    }

    private void btnAddDescriptionActionPerformed(ActionEvent evt) {
        this.addObsDescriptionFromTemplate();
    }

    private void btnLocationObsUpActionPerformed(ActionEvent evt) {
        this.moveObservationUp();
    }

    private void btnLocationObsDownActionPerformed(ActionEvent evt) {
        this.moveObservationDown();
    }

    private void btnBarcodeActionPerformed(ActionEvent evt) {
        String result = QRCodeDetector.showDialog();
        if (result != null && !result.isEmpty()) {
            this.fldLocationBarcode.setText(result);
            this.locationChanged = true;
        }
    }

    private void btnAddLocationWithChecksActionPerformed(ActionEvent evt) {
        this.addNewTemplateObservations(true);
    }

    private void fldLocationNameInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldLocationNameKeyReleased(KeyEvent evt) {
    }

    private void fldObservationTitleInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldObservationTitleKeyReleased(KeyEvent evt) {
    }

    private void btnQuicksearchClearActionPerformed(ActionEvent evt) {
        this.fldTemplateQuicksearch.setText("");
        this.updateTemplateQuicksearch();
    }

    private void fldTemplateQuicksearchActionPerformed(ActionEvent evt) {
        this.updateTemplateQuicksearch();
    }

    private void btnTemplateFavouriteActionPerformed(ActionEvent evt) {
        this.toggleTemplateFavourite();
    }

    private void btnObservationEditImageActionPerformed(ActionEvent evt) {
        this.editImages((CmsElement)this.observation);
    }

    private void fldLocationDocumentLibraryTypeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        if (this.location != null) {
            this.loadDocumentLibrary(this.fldLocationDocumentLibraryType, this.fldLocationDocumentLibrary, this.lstLocationDocuments, this.location.getRelationAttribute("infos"));
        }
    }

    private void fldObservationDocumentLibraryTypeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        if (this.observation != null) {
            this.loadDocumentLibrary(this.fldObservationDocumentLibraryType, this.fldObservationDocumentLibrary, this.lstObservationDocuments, this.observation.getRelationAttribute("infos"));
        }
    }

    private void btnObservationAddFile2ActionPerformed(ActionEvent evt) {
        this.captureImage();
    }

    private void btnObservationCleareMeasureActionPerformed(ActionEvent evt) {
        if (Dialogs.getInstance().showConfirmDialog("dialog.clearText")) {
            this.fldObservationMeasure.setText("");
        }
    }

    private void btnObservationCleareDescriptionActionPerformed(ActionEvent evt) {
        if (Dialogs.getInstance().showConfirmDialog("dialog.clearText")) {
            this.fldObservationDescription.setText("");
        }
    }

    private void lstObservationFilesValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.setAudioFileSelection();
        this.updateAudioComponents();
    }

    private void btnLocationEditImageActionPerformed(ActionEvent evt) {
        this.editImages((CmsElement)this.location);
    }

    private void btnLocationCaptureImageActionPerformed(ActionEvent evt) {
        this.captureImage();
    }

    private void btnMigrageUploadToObservationActionPerformed(ActionEvent evt) {
        ObservationListItem eleObs = (ObservationListItem)this.lstLocationObservation.getSelectedValue();
        if (this.selectedLocationImage != null && eleObs != null) {
            CmsObservation obs = this.observations.get(eleObs.id);
            if (obs == null) {
                obs = (CmsObservation)this.project.loadElement(eleObs.id, this.project.getUser());
                this.observations.put(eleObs.id, obs);
            }
            obs.getUploadAttribute("files").addUpload(this.selectedLocationImage);
            this.location.getUploadAttribute("files").deleteUpload(this.selectedLocationImage);
            this.location.getUploadAttribute("files").removeDeletedItems();
            this.populateLocationUploads();
        }
    }

    private void fldTemplateQuicksearchKeyReleased(KeyEvent evt) {
        this.updateTemplateQuicksearch();
    }

    private void btnObservationMeasureCalendarActionPerformed(ActionEvent evt) {
        this.addDateToTextarea(this.fldObservationMeasure);
    }

    private void btnObservationMeasureCalendar1ActionPerformed(ActionEvent evt) {
        this.addDateToTextarea(this.fldObservationDescription);
    }

    private void btnObservationCameraActionPerformed(ActionEvent evt) {
        this.captureImage();
    }

    private void btnObservationAddPlansnippetActionPerformed(ActionEvent evt) {
        if (!this.canEdit || !this.app.getLicense().hasLicenseFull() && ((CmsObservation)this.currentElement).getCurrentHistory().hasImages()) {
            return;
        }
        final CmsReport rep = new CmsReport();
        rep.planSnippetSizeMM = Math.max(10, this.settings.getImagePlansnippetSize());
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                File f = new PlanSnippetGenerator(rep).getPlanSnippetFile(LocationObservationDialog.this.location, null);
                if (f == null) {
                    Dialogs.getInstance().showErrorDialog("error.no-plansnippetfile");
                    return;
                }
                File destFile = new File(LocationObservationDialog.this.app.getSettings().getFolderImageObserver().getValue(true), f.getName());
                int counter = 1;
                while (destFile.exists()) {
                    destFile = new File(LocationObservationDialog.this.app.getSettings().getFolderImageObserver().getValue(true), Util.getFileNameWithoutExtension((File)f) + "_" + counter + "." + Util.getFileExtension((File)f));
                    ++counter;
                }
                try {
                    Util.copy((File)f, (File)destFile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, (String)this.project.getResourceText("message.creating-plansnippet"));
    }

    private void btnLocationIconRemoveActionPerformed(ActionEvent evt) {
        this.location.getRelationAttribute("icon").clear();
        this.lblLocationIconGraphics.setIcon(null);
        this.lblLocationIconGraphics.setText("<kein Icon>");
    }

    private void btnLocationIconSetActionPerformed(ActionEvent evt) {
        long iconId = this.location.getRelationAttribute("icon").getFirstElementId();
        if (this.iconRecords == null) {
            this.loadIcons();
        }
        LocationIconChooser chooser = new LocationIconChooser();
        chooser.populate(this.iconRecords, iconId);
        if (Dialogs.getInstance().showDialog(chooser, "dialog.selecticon.title", new String[]{"text.ok", "text.cancel"}) == 0) {
            CmsBasicElement item = chooser.getSelection();
            if (item == null) {
                this.location.getRelationAttribute("icon").clear();
                this.updateLocationIconDisplay(null);
            } else {
                this.location.getRelationAttribute("icon").set(item.getId());
                try {
                    File iconFile = ThemisApplication.getInstance().getProject().getUploadFile("icon", item.getAttribute("file"));
                    this.updateLocationIconDisplay(iconFile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void btnRemoveAudioActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        UploadItem uploadItem = (UploadItem)this.lstObservationFiles.getSelectedValue();
        if (uploadItem == null) {
            return;
        }
        try {
            CmsEvent eve;
            CmsElement hist = this.observation.getHistoryForUpload(uploadItem);
            if (hist != null && (eve = (CmsEvent)hist.getRelationAttribute("event").getFirstElement().getElement()) != null && eve.isSigned()) {
                Dialogs.getInstance().showWarningDialog(this.project.getResourceText("error.eventLockedImagecantBeDeleted"));
                return;
            }
            ArrayList<UploadItem> items = this.getItemsToBeDeleted(this.observation);
            items.add(uploadItem);
            this.itemsToBeDeleted.put(this.observation, items);
            if (Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.reallyDeleteFileNotif.text"), uploadItem.getFilename()), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.deleteFile.text"))) {
                this.observation.getUploadAttribute("files").deleteUpload(uploadItem);
                this.observationChanged = true;
                this.populateObservationUploads();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnRemoveAudio1ActionPerformed(ActionEvent evt) {
        if (!this.canEdit) {
            return;
        }
        UploadItem uploadItem = (UploadItem)this.lstLocationFiles.getSelectedValue();
        if (uploadItem == null) {
            return;
        }
        try {
            if (Dialogs.getInstance().showConfirmDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.reallyDeleteFileNotif.text"), uploadItem.getFilename()), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("LocationObservationDialog.deleteFile.text"))) {
                this.location.getUploadAttribute("files").deleteUpload(uploadItem);
                this.locationChanged = true;
                this.populateLocationUploads();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnObservationRotateImageCCWActionPerformed(ActionEvent evt) {
        this.rotateImage((CmsElement)this.observation, this.selectedObservationImage, -90.0);
    }

    private void btnObservationRotateImageCWActionPerformed(ActionEvent evt) {
        this.rotateImage((CmsElement)this.observation, this.selectedObservationImage, 90.0);
    }

    private void btnObservationRotateImageCW1ActionPerformed(ActionEvent evt) {
        this.rotateImage((CmsElement)this.location, this.selectedLocationImage, 90.0);
    }

    private void btnObservationRotateImageCCW1ActionPerformed(ActionEvent evt) {
        this.rotateImage((CmsElement)this.location, this.selectedLocationImage, -90.0);
    }

    private void btnAddContactActionPerformed(ActionEvent evt) {
        CmsCompany c = (CmsCompany)this.project.createElement("company");
        ContactPanel cp = new ContactPanel(c);
        if (cp.isSaved()) {
            this.observation.getRelationAttribute("responsible").set((CmsElement)c);
            this.populateObservationContacts();
        }
    }

    private void fldLocationTitleOnObsInputMethodTextChanged(InputMethodEvent evt) {
    }

    private void fldLocationTitleOnObsActionPerformed(ActionEvent evt) {
    }

    private void fldLocationTitleOnObsKeyReleased(KeyEvent evt) {
    }

    private void fldLocationNumberActionPerformed(ActionEvent evt) {
    }

    private void updateLocationIconDisplay(File iconFile) {
        this.lblLocationIconGraphics.setIcon(null);
        this.lblLocationIconGraphics.setText("<kein Icon>");
        if (iconFile != null && iconFile.exists() && iconFile.isFile()) {
            try {
                BufferedImage img = ImageHelper.loadImage((File)iconFile);
                this.lblLocationIconGraphics.setIcon(new ImageIcon(Util.resizeImage((BufferedImage)img, (int)35, (int)35)));
                this.lblLocationIconGraphics.setText("");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.lblLocationIconGraphics.revalidate();
    }

    class ObservationListItem
    implements IconItem {
        long id;
        String title;
        boolean statusDone;
        int type;

        public ObservationListItem(long id, String title, boolean statusDone, int type) {
            this.id = id;
            this.title = title;
            this.statusDone = statusDone;
            this.type = type;
        }

        public String getIconKey() {
            switch (this.type) {
                case 1: 
                case 4: {
                    return this.statusDone ? "key_status_done" : "key_status_open";
                }
            }
            return "key_empty";
        }

        public String toString() {
            return this.title;
        }

        public int getForegroundColor() {
            return Color.BLACK.getRGB();
        }

        public int getBackgroundColor() {
            switch (this.type) {
                case 1: {
                    return THEMIS.COLOR_DEFECT.getRGB();
                }
                case 3: {
                    return THEMIS.COLOR_INFO.getRGB();
                }
                case 2: {
                    return THEMIS.COLOR_CHECK.getRGB();
                }
                case 4: {
                    return THEMIS.COLOR_TASK.getRGB();
                }
            }
            return -1;
        }
    }

    class LocationTCDnDListener
    implements DropTargetListener {
        boolean isDocument = false;
        String locOrObs = "";

        public LocationTCDnDListener(boolean isDocument, String locOrObs) {
            this.isDocument = isDocument;
            this.locOrObs = locOrObs;
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            DataFlavor[] flavors;
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                try {
                    if (!flavor.isFlavorJavaFileListType()) continue;
                    List files = (List)transferable.getTransferData(flavor);
                    for (File f : files) {
                        if (!this.isDocument) continue;
                        CmsInfo info = (CmsInfo)LocationObservationDialog.this.project.createElement("info");
                        info.getUploadAttribute("files").addUpload(f);
                        String title = Util.getFileNameWithoutExtension((File)f);
                        info.setAttributeValue("title", title);
                        info.save();
                        ThemisActionProvider.getInstance().invokeAction(ThemisAction.INFORMATION_SAVED);
                        if (this.locOrObs.equals("obs")) {
                            LocationObservationDialog.this.observationChanged = true;
                            LocationObservationDialog.this.observation.getRelationAttribute("infos").add((CmsElement)info);
                            ((DefaultListModel)LocationObservationDialog.this.lstObservationDocuments.getModel()).addElement(new CmsElementSummary((CmsElement)info));
                            continue;
                        }
                        LocationObservationDialog.this.locationChanged = true;
                        LocationObservationDialog.this.location.getRelationAttribute("infos").add((CmsElement)info);
                        ((DefaultListModel)LocationObservationDialog.this.lstLocationDocuments.getModel()).addElement(new CmsElementSummary((CmsElement)info));
                    }
                    if (files.isEmpty()) continue;
                    LocationObservationDialog.this.app.setFileFolder((File)files.get(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            event.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }

    static enum Position {
        LEFT,
        RIGHT,
        NORMAL;

    }
}

