/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.gui.ImagePanel;
import at.grid.gui.SimpleGeometry;
import at.grid.gui.event.Action;
import at.grid.gui.event.ActionListener;
import at.grid.gui.event.ActionProvider;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisPanelInterface;
import at.grid.themis.application.image.ImageReference;
import at.grid.themis.application.image.ImageRotateLeft;
import at.grid.themis.application.image.ImageRotateRight;
import at.grid.themis.application.util.ColorTracker;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class PhotoViewerPanel
extends JPanel
implements ActionListener,
ThemisPanelInterface,
ThemisActionListener {
    private Action MOVE_ACTION = new Action(100);
    private Action SELECTION_ACTION = new Action(200);
    public static final String DIALOGCODE = "photoviewerdialog";
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 600;
    BufferedImage noImage = null;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisSettings settings = this.app.getSettings();
    ThemisProject project = this.app.getProject();
    private ImagePanel imagePanel;
    private int imageIndex = -1;
    private ArrayList<ImageReference> imagesOrig = new ArrayList();
    private ArrayList<ImageReference> images = new ArrayList();
    private CmsElement imageReference = null;
    private long lastIdGeometry;
    private boolean isDrawing = false;
    private boolean listenerEnabled = true;
    private boolean showDrawComponents;
    JDialog dlg = null;
    boolean asTopComponent = false;
    GridBagConstraints imagePanelConstraints = new GridBagConstraints();
    Color drawingColor = Color.RED;
    private boolean controlVisibility;
    private JButton btnCCW;
    private JButton btnCW;
    private JButton btnCancel;
    private JButton btnDelete;
    private JButton btnDrawFree;
    private JButton btnDrawingCancel;
    private JButton btnDrawingDone;
    private JButton btnDrawingRemove;
    private JButton btnDrawingSettings;
    private JButton btnImageFullExt;
    private JButton btnNextImage;
    private JButton btnPrevImage;
    private JButton btnSave;
    private JButton btnSave2;
    private JButton btnZoomIn;
    private JButton btnZoomOut;
    private JComboBox<String> dropDownDraw;
    private JTextField fldFileInfo;
    private JComboBox<KeytableRecord> fldUploadDetail;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel lblCountImg;
    private JLabel lblEmpty5;
    private JLabel lblHideControls;
    private JTextField lblInfo;
    private JPanel mainPanel;
    private JPanel panelButtons;
    private JPanel panelImageButtons;
    private JPanel panelImageDetails;
    private JPanel panelPrevNext;
    private JPanel panelTop;
    private JPanel panelTopButtons;

    public PhotoViewerPanel(boolean asTopComponent) {
        this.initComponents();
        this.asTopComponent = asTopComponent;
        boolean bl = this.controlVisibility = !this.app.getSettings().getWindowPhotoViewerMinimised();
        if (asTopComponent) {
            this.panelButtons.setVisible(false);
            this.btnSave2.setVisible(true);
            this.btnSave2.setEnabled(false);
            this.panelImageButtons.setVisible(this.controlVisibility);
            this.panelImageDetails.setVisible(this.controlVisibility);
            this.panelTopButtons.setVisible(this.controlVisibility);
            this.panelPrevNext.setVisible(this.controlVisibility);
        } else {
            this.btnSave2.setVisible(false);
            this.lblHideControls.setVisible(false);
        }
        this.populateUploadDetails();
        this.imagePanel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
        this.imagePanelConstraints.gridx = 0;
        this.imagePanelConstraints.gridy = 0;
        this.imagePanelConstraints.fill = 1;
        this.imagePanelConstraints.weightx = 1.0;
        this.imagePanelConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.imagePanel, this.imagePanelConstraints);
        this.imagePanel.setDragable(false);
        ActionProvider prov = new ActionProvider();
        prov.register((ActionListener)this);
        this.imagePanel.setActionProvider(prov);
        this.imagePanel.setMoveAction(this.MOVE_ACTION);
        this.imagePanel.setSelectionAction(this.SELECTION_ACTION);
        try {
            this.noImage = ImageIO.read(this.getClass().getResource("/at/grid/themis/application/image/no_image.jpg"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDrawingColor(new Color(this.app.getColorManager().getColorFromString(this.settings.getDisplayDrawingColor())));
        int idx = this.settings.getDisplayDrawingTool();
        if (idx >= 0 && idx < this.dropDownDraw.getItemCount()) {
            this.dropDownDraw.setSelectedIndex(idx);
        }
    }

    public void onAction(Action action, Object o) {
        if (!action.equals((Object)this.MOVE_ACTION) && action.equals((Object)this.SELECTION_ACTION)) {
            this.updateComponents();
        }
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1101: {
                this.reset();
            }
            case 1100: 
            case 1102: {
                this.populateUploadDetails();
                this.updateComponents();
            }
        }
    }

    public void setEnableChanges(boolean flg) {
        boolean licenseFull = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        boolean licenseSpecialApp = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.APP);
        this.btnCCW.setEnabled(flg && licenseFull);
        this.btnCW.setEnabled(flg && licenseFull);
        this.dropDownDraw.setEnabled(this.showDrawComponents && flg && licenseFull);
        this.btnDrawFree.setEnabled(this.showDrawComponents && flg && licenseFull);
        this.btnDrawingRemove.setEnabled(this.showDrawComponents && flg && licenseFull);
        this.btnDelete.setEnabled(flg && (licenseSpecialApp || licenseFull));
        this.fldFileInfo.setEnabled(flg);
    }

    public void setEnableChanges(ImageReference img) {
        if (img == null || !img.hasUploadItem() || this.images.isEmpty() || this.isDrawing) {
            this.setEnableChanges(false);
            return;
        }
        if (this.imageReference == null) {
            this.checkAndUpdateImageReference(img.getUploadItem());
        }
        if (this.imageReference == null) {
            this.setEnableChanges(false);
        } else if (this.imageReference instanceof CmsLocation) {
            this.setEnableChanges(true);
        } else {
            this.setEnableChanges(this.project.isUploadImageEditable(img.getUploadItem()));
        }
    }

    @Override
    public boolean preClose() {
        return true;
    }

    @Override
    public void setDialog(JDialog dlg) {
        this.dlg = dlg;
    }

    @Override
    public JDialog getDialog() {
        return this.dlg;
    }

    private void closeDialog() {
        ThemisUtil.setWindowSize((String)DIALOGCODE, (Dimension)this.dlg.getSize(), (ThemisApplication)this.app);
        this.dlg.dispose();
    }

    private void saveChanges() {
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            img.save();
            this.drawImage(img);
            this.updateSaveButton();
        }
    }

    public void updateSaveButton() {
        this.btnSave2.setEnabled(this.isChanged());
    }

    public boolean isChanged() {
        for (ImageReference img : this.images) {
            if (!img.isChanged()) continue;
            return true;
        }
        return false;
    }

    public void populateUploadDetails() {
        if (this.fldUploadDetail.getItemCount() > 0) {
            this.fldUploadDetail.removeAllItems();
        }
        if (this.project.isOpen()) {
            ArrayList recs = (ArrayList)this.project.getKeytable("uploaddetail").getTable().get(this.project.getUser().getCurrentLanguage());
            for (KeytableRecord rec : recs) {
                this.fldUploadDetail.addItem(rec);
            }
        }
    }

    public void updateComponents() {
        boolean licenseFull = ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        this.listenerEnabled = false;
        boolean enabled = !this.images.isEmpty();
        this.btnImageFullExt.setEnabled(enabled);
        this.btnZoomIn.setEnabled(enabled);
        this.btnZoomOut.setEnabled(enabled);
        this.btnDrawingDone.setEnabled(this.showDrawComponents && enabled && this.isDrawing && licenseFull);
        this.btnDrawingCancel.setEnabled(this.showDrawComponents && enabled && this.isDrawing && licenseFull);
        this.btnDrawingRemove.setEnabled(this.showDrawComponents && enabled && !this.isDrawing && licenseFull && !this.imagePanel.getGeometries().isEmpty());
        this.fldUploadDetail.setEnabled(enabled);
        if (!enabled) {
            this.lblCountImg.setText("");
            this.imagePanel.clearBackgroundImage();
            this.lblInfo.setText("");
        } else {
            ImageReference img = this.getCurrentImageReference();
            if (img != null) {
                this.setEnableChanges(img);
                if (img.getUploadItem() == null || !licenseFull) {
                    this.fldUploadDetail.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                }
            } else {
                this.reset();
            }
        }
        this.updateSelectButtons();
        this.listenerEnabled = false;
    }

    private void updateSelectButtons() {
        this.btnNextImage.setEnabled(!this.isDrawing && this.imageIndex < this.images.size() - 1);
        this.btnPrevImage.setEnabled(!this.isDrawing && this.imageIndex > 0);
    }

    private void setDrawingColor(Color c) {
        this.drawingColor = c;
        this.btnDrawingSettings.setForeground(c);
        this.btnDrawingSettings.setBackground(c);
        this.btnDrawingSettings.setOpaque(false);
    }

    private void checkAndUpdateImageReference(UploadItem item) {
        if (this.imageReference == null) {
            long idElement = item.getIdelement();
            this.imageReference = this.project.loadElement(idElement, this.project.getUser());
            if (this.imageReference instanceof CmsHistory) {
                idElement = ((CmsHistory)this.imageReference).getObservationId();
                this.imageReference = this.project.loadElement(idElement, this.project.getUser());
            }
        }
    }

    public ArrayList<ImageReference> getImages() {
        return this.images;
    }

    public void updateImageBasedOnLocation(CmsElement loc) {
        if (loc != null) {
            if (this.settings.getImageForObservation()) {
                this.updateImagesBasedOnSelection(loc.getRelationAttribute("observations").getElementIds(false));
            } else {
                this.createImageReferences(loc.getUploadAttribute("files").getUploadItems(), loc.getTitle(), false);
            }
        } else {
            this.reset();
        }
    }

    public void updateImageForElement(CmsElement ele) {
        this.updateImageForElement(ele, null);
    }

    public void updateImageForElement(CmsElement ele, UploadItem sel) {
        if (ele != null) {
            this.imageReference = ele;
            this.showDrawComponents = true;
            ArrayList items = null;
            if (ele instanceof CmsObservation) {
                items = ((CmsObservation)ele).getUploads(true);
            } else if (ele instanceof CmsLocation) {
                items = ele.getUploadAttribute("files").getImageUploadItems();
            } else {
                this.reset();
                return;
            }
            this.createImageReferences(items, ele.getAttributeValue("title"), false, sel);
        } else {
            this.reset();
        }
    }

    public void setImageReference(CmsElement e) {
        this.imageReference = e;
    }

    public void updateImagesBasedOnSelection(List<Long> ids) {
        this.updateImagesBasedOnSelection(ids, -1L);
    }

    public void updateImagesBasedOnSelection(List<Long> ids, long sel) {
        ArrayList histIds;
        if (this.isDrawing) {
            this.saveDrawings();
        }
        if (ids.isEmpty()) {
            this.reset();
            return;
        }
        String sql = this.settings.getImageForObservation() ? "SELECT r.elementfrom AS idhistory  FROM tdtaRelation AS r  WHERE r.elementto IN " + Util.toSqlString(ids) + " AND r.relationcode = 'historyobservation'" : "SELECT r.elementfrom AS idlocation  FROM tdtaRelation AS r  WHERE r.elementto IN " + Util.toSqlString(ids) + " AND r.relationcode = 'locationobservation'";
        ArrayList items = this.project.getDatastorage().getUploadItems(sql, "files");
        UploadItem selItem = null;
        if (sel > 0L && !(histIds = this.project.getDatastorage().getRelationIds(sel, "historyobservation", false)).isEmpty()) {
            for (UploadItem item : items) {
                if (!histIds.contains(item.getIdelement())) continue;
                selItem = item;
                break;
            }
        }
        this.createImageReferences(items, "", ids.size() > 1, selItem);
    }

    void updateImage(ArrayList<ImageReference> imageReferences, boolean showFirst, UploadItem sel) {
        this.checkForChanges(false);
        this.images.clear();
        this.images.addAll(imageReferences);
        for (ImageReference ref : imageReferences) {
            this.imagesOrig.add(new ImageReference(ref));
        }
        this.showDrawComponents = true;
        int idx = -1;
        if (sel != null) {
            for (ImageReference ref : this.images) {
                if (sel.getId() != ref.getUploadItem().getId()) continue;
                idx = this.images.indexOf(ref);
            }
        }
        this.imageIndex = idx < 0 ? (showFirst ? 0 : this.images.size() - 1) : idx;
        this.displayImage();
    }

    public void updateImage(ArrayList<ImageReference> imageReferences, boolean showFirst) {
        this.updateImage(this.images, showFirst, null);
    }

    private void createImageReferences(List<UploadItem> items, String description, boolean showFirst) {
        this.createImageReferences(items, description, showFirst, null);
    }

    public void createImageReferences(List<UploadItem> items, String description, boolean showFirst, UploadItem sel) {
        this.checkForChanges(false);
        this.images.clear();
        if (this.asTopComponent) {
            this.imageReference = null;
        }
        if (items.isEmpty()) {
            this.reset();
            return;
        }
        this.showDrawComponents = true;
        int idx = -1;
        for (UploadItem item : items) {
            if (!item.isImage()) continue;
            this.checkAndUpdateImageReference(item);
            ImageReference imgref = new ImageReference(this.imageReference, item.getFile(), item.getFileComment(), item.getUploadDetail(), item.getFileInfo(), item.getIdelement());
            if (item.getFileInfo() == null || "".equals(item.getFileInfo())) {
                imgref.setImageInfo(item.getFileInfo());
            }
            this.images.add(imgref.setUploadItem(item));
            if (sel == null || item.getId() != sel.getId()) continue;
            idx = items.indexOf(item);
        }
        this.imageIndex = idx < 0 ? (showFirst ? 0 : this.images.size() - 1) : idx;
        this.displayImage();
    }

    public void createImageReferences(File f, String description, boolean allowDrawing) {
        this.checkForChanges(false);
        this.images.clear();
        this.images.add(new ImageReference(this.imageReference, f, "", -1L, "", -1L));
        this.imageIndex = this.images.size() - 1;
        this.showDrawComponents = allowDrawing;
        this.displayImage();
    }

    public ImageReference getCurrentImageReference() {
        if (this.imageIndex >= 0 && this.imageIndex < this.images.size()) {
            return this.images.get(this.imageIndex);
        }
        return null;
    }

    public void displayImage() {
        block7: {
            ImageReference img = this.getCurrentImageReference();
            this.setEnableChanges(false);
            if (img != null) {
                try {
                    this.drawImage(img);
                    this.setLabelContent(img.getImageInfo());
                    this.fldFileInfo.setText(img.getUploadItemComment());
                    this.fldFileInfo.setText(img.getUploadItemComment());
                    this.lblCountImg.setText(this.imageIndex + 1 + " / " + this.images.size());
                    if (img.hasUploadItem()) {
                        this.panelTop.setVisible(true);
                        this.listenerEnabled = false;
                        long uploadDetail = img.getUploaditemDetail();
                        int idx = this.project.getKeytable("uploaddetail").getIndex(uploadDetail);
                        if (idx < 0) {
                            KeytableRecord detailrecord;
                            idx = 0;
                            if (this.fldUploadDetail.getItemCount() > 0 && (detailrecord = this.fldUploadDetail.getItemAt(idx)) != null) {
                                img.setUploadItemDetailNoChange(detailrecord.id);
                            }
                        }
                        this.fldUploadDetail.setSelectedIndex(idx);
                        this.listenerEnabled = true;
                        this.setEnableChanges(img);
                        break block7;
                    }
                    this.setEnableChanges(false);
                    this.panelTop.setVisible(false);
                }
                catch (Exception ex) {
                    ThemisLogger.logger.info("Error while opening image file '" + img.getImageFile().getAbsolutePath() + "': " + ex.getMessage());
                    Dialogs.getInstance().showErrorDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.imageCannotBeOpened.text"), img.getImageFile().getAbsolutePath()), ex);
                }
            } else {
                this.imagePanel.setBackgroundImageObject(this.noImage);
                this.imagePanel.setAllowZoom(false);
                this.imagePanel.removeGeometries();
            }
        }
        this.imagePanel.reset();
        this.updateComponents();
        this.repaint();
    }

    private void drawImage(ImageReference img) {
        if (img != null) {
            if (img.getImage() == null) {
                ThemisLogger.logger.info("The image file '" + img.getImageFile().getAbsolutePath() + "' does not exist");
                Dialogs.getInstance().showErrorDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.imageNotExisting.text"), img.getImageFile().getAbsolutePath()));
                return;
            }
            this.imagePanel.setBackgroundImageObject(img.getImage());
            this.imagePanel.setAllowZoom(true);
            if (img.hasUploadItem()) {
                this.imagePanel.removeGeometries();
                this.lastIdGeometry = -1L;
                for (SimpleGeometry g : img.getDrawings()) {
                    this.imagePanel.addGeometry(g);
                    if (g.getId() <= this.lastIdGeometry) continue;
                    this.lastIdGeometry = g.getId();
                }
            }
        } else {
            this.btnSave2.setEnabled(false);
        }
    }

    public void reset() {
        this.images.clear();
        this.imagePanel.clearBackgroundImage();
        this.imagePanel.removeGeometries();
        this.lblCountImg.setText("");
        this.lblInfo.setText("");
        this.fldFileInfo.setText("");
        this.populateUploadDetails();
        this.updateComponents();
        this.repaint();
    }

    public void removeGeometries() {
        this.imagePanel.removeGeometries();
    }

    public boolean checkForChanges(boolean withCancel) {
        ImageReference img = this.getCurrentImageReference();
        if (this.asTopComponent && img != null && img.isChanged()) {
            String[] options = withCancel ? new String[]{this.project.getResourceText("text.yes"), this.project.getResourceText("text.no"), this.project.getResourceText("text.cancel")} : new String[]{this.project.getResourceText("text.yes"), this.project.getResourceText("text.no")};
            int choice = Dialogs.getInstance().showConfirmDialogWithOptions("dialog.confirm-save.text", "dialog.confirm-save.title", options);
            switch (choice) {
                case 0: {
                    img.save();
                    this.btnSave2.setEnabled(false);
                    break;
                }
                case 1: {
                    img.reset();
                    this.btnSave2.setEnabled(false);
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    private void showNextImage() {
        if (this.imageIndex < this.images.size() - 1) {
            if (!this.checkForChanges(true)) {
                return;
            }
            ++this.imageIndex;
            this.updateSelectButtons();
            this.displayImage();
        }
    }

    private void showPreviousImage() {
        this.showPreviousImage(false);
    }

    private void showPreviousImage(boolean roll) {
        if (!this.checkForChanges(true)) {
            return;
        }
        if (roll && this.imageIndex == 0) {
            this.imageIndex = this.images.size();
        }
        if (this.imageIndex > 0) {
            --this.imageIndex;
            this.updateSelectButtons();
            this.displayImage();
        }
    }

    private void rotateImage(double angle) {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            switch ((int)angle) {
                case 90: {
                    img.applyImageCorrection(new ImageRotateRight());
                    break;
                }
                case -90: 
                case 270: {
                    img.applyImageCorrection(new ImageRotateLeft());
                    break;
                }
                case 180: {
                    img.applyImageCorrection(new ImageRotateLeft());
                    img.applyImageCorrection(new ImageRotateLeft());
                }
            }
            this.drawImage(img);
            this.updateSaveButton();
        }
    }

    private void setLabelContent(String lbl) {
        this.lblInfo.setText(lbl);
    }

    protected void deleteImage() {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            this.images.remove(img);
            UploadItem upload = img.getUploadItem();
            if (upload != null) {
                CmsElement ele;
                if (this.imageReference != null) {
                    this.imageReference.getUploadAttribute("files").deleteUpload(upload);
                }
                if ((ele = this.project.loadElement(img.getIdElement(), this.project.getUser())) != null) {
                    if ("observation".equals(ele.getElementcode())) {
                        ((CmsObservation)ele).removeUpload(upload.getId());
                        ele.save();
                    } else if ("location".equals(ele.getElementcode())) {
                        ((CmsLocation)ele).getUploadAttribute("files").deleteUpload(upload.getId());
                        ele.save();
                    } else if ("history".equals(ele.getElementcode())) {
                        CmsEvent eve = ((CmsHistory)ele).getEvent();
                        if (eve != null && eve.isSigned()) {
                            Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.eventLockedImagecantBeDeleted.text"));
                            return;
                        }
                        ((CmsHistory)ele).getUploadAttribute("files").deleteUpload(upload.getId());
                        ele.save();
                        if (this.images.isEmpty()) {
                            CmsElement obs = ele.getRelationAttribute("observation").getFirstElement().getElement();
                            obs.save();
                            this.app.getFilter().resetSearchResult();
                            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setReference((Object)obs));
                        }
                    }
                }
                if (this.imageIndex > this.images.size() - 1) {
                    --this.imageIndex;
                }
                this.displayImage();
            }
        }
    }

    private void setControlVisibility(boolean flg) {
        this.controlVisibility = flg;
        this.panelImageButtons.setVisible(this.controlVisibility);
        this.panelImageDetails.setVisible(this.controlVisibility);
        this.panelTopButtons.setVisible(this.controlVisibility);
        this.panelPrevNext.setVisible(this.controlVisibility);
        TopComponent tc = WindowManager.getDefault().findTopComponent("PhotoViewerTopComponent");
        Mode mode1 = WindowManager.getDefault().findMode("editor");
        if (this.controlVisibility) {
            TopComponent[] topComponents;
            boolean alreadyDocked = false;
            for (TopComponent tc0 : topComponents = mode1.getTopComponents()) {
                if (tc0 != tc) continue;
                alreadyDocked = true;
                break;
            }
            if (mode1 != null && mode1.canDock(tc) && !alreadyDocked) {
                mode1.dockInto(tc);
            }
        }
        this.app.getSettings().setWindowPhotoViewerMinimised(!this.controlVisibility);
    }

    private void updateFileInfo() {
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            img.setUploadItemComment(this.fldFileInfo.getText());
            if (this.fldUploadDetail.getSelectedItem() != null) {
                long uploadDetail = ((KeytableRecord)this.fldUploadDetail.getSelectedItem()).id;
                img.setUploadItemDetail(uploadDetail);
            }
        }
    }

    private boolean checkModifyConditions(String saveOrDelete) {
        ImageReference img = this.getCurrentImageReference();
        if (img == null) {
            Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.noImageSelected.text"));
            return false;
        }
        UploadItem upload = img.getUploadItem();
        if ("save".equals(saveOrDelete)) {
            if (upload == null) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.noCommentPossible.text"));
                return false;
            }
            return true;
        }
        if ("delete".equals(saveOrDelete)) {
            if (upload == null) {
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.imageCannotBeDeleted.text"));
                return false;
            }
            return true;
        }
        return false;
    }

    private void saveDrawingsToDatabase() {
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            if (this.imagePanel.getStatus() == 8 || this.imagePanel.getStatus() == 9 || this.imagePanel.getStatus() == 10 || this.imagePanel.getStatus() == 11) {
                this.imagePanel.addGeometry(new SimpleGeometry(this.imagePanel.getCurrentGeometryObject(), false));
            }
            ArrayList geometries = this.imagePanel.getGeometries();
            img.addNewDrawings(geometries);
            long idGeom = this.lastIdGeometry;
            long idFileUpload = this.getCurrentImageReference().getUploadItem().getId();
            for (SimpleGeometry geom : geometries) {
                int count = this.project.getDatastorage().executeUpdate("UPDATE tdtaDrawing SET geometry = " + Util.toSqlString((String)geom.toWKT()) + ",geometrytype = " + geom.getType() + " WHERE idFileUpload = " + idFileUpload + " AND idgeometry = " + geom.getId(), true);
                if (count != 0) continue;
                this.project.getDatastorage().executeUpdate("INSERT INTO tdtaDrawing (idFileUpload, idGeometry, geometry, geometrytype, color, linewidth) VALUES (" + idFileUpload + "," + geom.getId() + ",'" + geom.toWKT() + "'," + geom.getType() + "," + geom.getDisplay().getColor().getRGB() + "," + geom.getDisplay().getLinewidth() + ")", true);
                if (idGeom >= geom.getId()) continue;
                idGeom = geom.getId();
            }
            this.lastIdGeometry = idGeom;
            this.imagePanel.setStatus(1);
            this.isDrawing = false;
            this.updateComponents();
            this.drawImage(img);
        }
    }

    private void saveDrawings() {
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            long idGeom;
            if (this.imagePanel.getStatus() == 8 || this.imagePanel.getStatus() == 9 || this.imagePanel.getStatus() == 10 || this.imagePanel.getStatus() == 11) {
                this.imagePanel.addGeometry(new SimpleGeometry(this.imagePanel.getCurrentGeometryObject(), false));
            }
            ArrayList geometries = this.imagePanel.getGeometries();
            img.addNewDrawings(geometries);
            this.lastIdGeometry = idGeom = this.lastIdGeometry;
            this.imagePanel.setStatus(1);
            this.isDrawing = false;
            this.updateComponents();
            this.drawImage(img);
            this.updateSaveButton();
        }
    }

    private void removeDrawings() {
        boolean geomSelected;
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ArrayList<Long> geomIds = new ArrayList<Long>();
        ArrayList geometries = new ArrayList();
        geometries = this.imagePanel.getGeometries();
        for (SimpleGeometry geom : geometries) {
            if (!geom.isSelected()) continue;
            geomIds.add(geom.getId());
        }
        boolean bl = geomSelected = geomIds.size() > 0;
        if (!geomSelected && !geometries.isEmpty()) {
            if (Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.deleteAllDrawings.text"))) {
                this.imagePanel.removeGeometries();
                this.getCurrentImageReference().clearDrawings();
                this.project.getDatastorage().executeUpdate("DELETE FROM tdtaDrawing  WHERE idFileupload=" + this.getCurrentImageReference().getUploadItem().getId(), true);
            }
        } else {
            Iterator iterator = geomIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.imagePanel.removeGeometry(id);
                this.getCurrentImageReference().removeDrawing(id);
                this.project.getDatastorage().executeUpdate("DELETE FROM tdtaDrawing  WHERE idFileupload=" + this.getCurrentImageReference().getUploadItem().getId() + " AND idgeometry=" + id, true);
            }
        }
        this.imagePanel.repaint();
    }

    private void setDrawing(boolean flg) {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        this.isDrawing = flg;
        this.updateComponents();
        if (flg) {
            int sel = this.dropDownDraw.getSelectedIndex();
            switch (sel) {
                case 0: {
                    this.imagePanel.setStatus(7);
                    break;
                }
                case 1: {
                    this.imagePanel.setStatus(8);
                    break;
                }
                case 2: {
                    this.imagePanel.setStatus(9);
                    break;
                }
                case 3: {
                    this.imagePanel.setStatus(10);
                    break;
                }
                case 4: {
                    this.imagePanel.setStatus(11);
                    break;
                }
                case 5: {
                    this.imagePanel.setStatus(12);
                    break;
                }
                case 6: {
                    this.imagePanel.setStatus(14);
                }
            }
            this.imagePanel.getCurrentGeometryObject().getDisplay().setColor(this.drawingColor, true);
        }
    }

    private void initComponents() {
        this.panelPrevNext = new JPanel();
        this.btnPrevImage = new JButton();
        this.btnNextImage = new JButton();
        this.lblEmpty5 = new JLabel();
        this.panelTopButtons = new JPanel();
        this.btnCW = new JButton();
        this.btnCCW = new JButton();
        this.btnSave2 = new JButton();
        this.jLabel2 = new JLabel();
        this.dropDownDraw = new JComboBox();
        this.btnDrawFree = new JButton();
        this.btnDrawingDone = new JButton();
        this.btnDrawingCancel = new JButton();
        this.btnDrawingRemove = new JButton();
        this.btnDrawingSettings = new JButton();
        this.jLabel3 = new JLabel();
        this.lblCountImg = new JLabel();
        this.panelImageButtons = new JPanel();
        this.btnImageFullExt = new JButton();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.btnDelete = new JButton();
        this.jLabel4 = new JLabel();
        this.panelTop = new JPanel();
        this.lblHideControls = new JLabel();
        this.lblInfo = new JTextField();
        this.panelImageDetails = new JPanel();
        this.jLabel1 = new JLabel();
        this.fldFileInfo = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldUploadDetail = new JComboBox();
        this.mainPanel = new JPanel();
        this.panelButtons = new JPanel();
        this.btnCancel = new JButton();
        this.btnSave = new JButton();
        this.setLayout(new GridBagLayout());
        this.panelPrevNext.setLayout(new GridBagLayout());
        this.btnPrevImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextLeft32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrevImage, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnPrevImage.text"));
        this.btnPrevImage.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnPrevImage.toolTipText"));
        this.btnPrevImage.setBorder(new SoftBevelBorder(0));
        this.btnPrevImage.setPreferredSize(new Dimension(45, 45));
        this.btnPrevImage.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnPrevImageActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPrevNext.add((Component)this.btnPrevImage, gridBagConstraints);
        this.btnNextImage.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/nextRight32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNextImage, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnNextImage.text"));
        this.btnNextImage.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnNextImage.toolTipText"));
        this.btnNextImage.setBorder(new SoftBevelBorder(0));
        this.btnNextImage.setPreferredSize(new Dimension(45, 45));
        this.btnNextImage.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnNextImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelPrevNext.add((Component)this.btnNextImage, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblEmpty5, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.lblEmpty5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelPrevNext.add((Component)this.lblEmpty5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.panelPrevNext, gridBagConstraints);
        this.panelTopButtons.setLayout(new GridBagLayout());
        this.btnCW.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCW32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCW, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnCW.text"));
        this.btnCW.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnCW.toolTipText"));
        this.btnCW.setBorder(new SoftBevelBorder(0));
        this.btnCW.setEnabled(false);
        this.btnCW.setPreferredSize(new Dimension(45, 45));
        this.btnCW.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnCWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnCW, gridBagConstraints);
        this.btnCCW.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/rotateCCW32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCCW, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnCCW.text"));
        this.btnCCW.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnCCW.toolTipText"));
        this.btnCCW.setBorder(new SoftBevelBorder(0));
        this.btnCCW.setEnabled(false);
        this.btnCCW.setPreferredSize(new Dimension(45, 45));
        this.btnCCW.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnCCWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnCCW, gridBagConstraints);
        this.btnSave2.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/save-red24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave2, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnSave2.text"));
        this.btnSave2.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnSave2.toolTipText"));
        this.btnSave2.setBorder(new SoftBevelBorder(0));
        this.btnSave2.setPreferredSize(new Dimension(45, 45));
        this.btnSave2.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnSave2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnSave2, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabelBig);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.jLabel2, gridBagConstraints);
        this.dropDownDraw.setFont(THEMIS.fontList);
        this.dropDownDraw.setModel(new DefaultComboBoxModel<String>(new String[]{"Frei zeichnen", "Pfeil", "Kreis", "Wolke", "Stern", "Rechteck", "Schw\u00e4rzen"}));
        this.dropDownDraw.setPreferredSize(new Dimension(120, 35));
        this.dropDownDraw.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PhotoViewerPanel.this.dropDownDrawItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add(this.dropDownDraw, gridBagConstraints);
        this.btnDrawFree.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/edit-32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDrawFree, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawFree.text"));
        this.btnDrawFree.setBorder(new SoftBevelBorder(0));
        this.btnDrawFree.setPreferredSize(new Dimension(45, 45));
        this.btnDrawFree.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnDrawFreeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawFree, gridBagConstraints);
        this.btnDrawingDone.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDrawingDone, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingDone.text"));
        this.btnDrawingDone.setBorder(new SoftBevelBorder(0));
        this.btnDrawingDone.setPreferredSize(new Dimension(45, 45));
        this.btnDrawingDone.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnDrawingDoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawingDone, gridBagConstraints);
        this.btnDrawingCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDrawingCancel, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingCancel.text"));
        this.btnDrawingCancel.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingCancel.toolTipText"));
        this.btnDrawingCancel.setBorder(new SoftBevelBorder(0));
        this.btnDrawingCancel.setPreferredSize(new Dimension(45, 45));
        this.btnDrawingCancel.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnDrawingCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawingCancel, gridBagConstraints);
        this.btnDrawingRemove.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/clearEntries32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDrawingRemove, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingRemove.text"));
        this.btnDrawingRemove.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingRemove.toolTipText"));
        this.btnDrawingRemove.setBorder(new SoftBevelBorder(0));
        this.btnDrawingRemove.setPreferredSize(new Dimension(45, 45));
        this.btnDrawingRemove.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnDrawingRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawingRemove, gridBagConstraints);
        this.btnDrawingSettings.setFont(new Font("Tahoma", 0, 36));
        this.btnDrawingSettings.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/farbeimer32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDrawingSettings, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingSettings.text"));
        this.btnDrawingSettings.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDrawingSettings.toolTipText"));
        this.btnDrawingSettings.setBorder(new SoftBevelBorder(0));
        this.btnDrawingSettings.setPreferredSize(new Dimension(45, 45));
        this.btnDrawingSettings.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnDrawingSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.btnDrawingSettings, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.jLabel3, gridBagConstraints);
        this.lblCountImg.setFont(THEMIS.fontLabel);
        this.lblCountImg.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblCountImg, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.lblCountImg.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTopButtons.add((Component)this.lblCountImg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panelTopButtons, gridBagConstraints);
        this.panelImageButtons.setMinimumSize(new Dimension(60, 0));
        this.panelImageButtons.setLayout(new GridBagLayout());
        this.btnImageFullExt.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/fullscreen-10-32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImageFullExt, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnImageFullExt.text"));
        this.btnImageFullExt.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnImageFullExt.toolTipText"));
        this.btnImageFullExt.setBorder(new SoftBevelBorder(0));
        this.btnImageFullExt.setPreferredSize(new Dimension(45, 45));
        this.btnImageFullExt.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnImageFullExtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageButtons.add((Component)this.btnImageFullExt, gridBagConstraints);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zoomIn32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnZoomIn, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnZoomIn.text"));
        this.btnZoomIn.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnZoomIn.toolTipText"));
        this.btnZoomIn.setBorder(new SoftBevelBorder(0));
        this.btnZoomIn.setPreferredSize(new Dimension(45, 45));
        this.btnZoomIn.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnZoomInActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageButtons.add((Component)this.btnZoomIn, gridBagConstraints);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/zoomOut32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnZoomOut, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnZoomOut.text"));
        this.btnZoomOut.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnZoomOut.toolTipText"));
        this.btnZoomOut.setBorder(new SoftBevelBorder(0));
        this.btnZoomOut.setPreferredSize(new Dimension(45, 45));
        this.btnZoomOut.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnZoomOutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageButtons.add((Component)this.btnZoomOut, gridBagConstraints);
        this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/removeImage32.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelete, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDelete.text"));
        this.btnDelete.setToolTipText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnDelete.toolTipText"));
        this.btnDelete.setBorder(new SoftBevelBorder(0));
        this.btnDelete.setPreferredSize(new Dimension(45, 45));
        this.btnDelete.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageButtons.add((Component)this.btnDelete, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageButtons.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.panelImageButtons, gridBagConstraints);
        this.panelTop.setLayout(new GridBagLayout());
        this.lblHideControls.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/action_resetWindows.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblHideControls, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.lblHideControls.text"));
        this.lblHideControls.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PhotoViewerPanel.this.lblHideControlsMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelTop.add((Component)this.lblHideControls, gridBagConstraints);
        this.lblInfo.setEditable(false);
        this.lblInfo.setFont(THEMIS.fontLabel);
        this.lblInfo.setText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.lblInfo.text"));
        this.lblInfo.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panelTop.add((Component)this.lblInfo, gridBagConstraints);
        this.panelImageDetails.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageDetails.add((Component)this.jLabel1, gridBagConstraints);
        this.fldFileInfo.setFont(THEMIS.fontTextfield);
        this.fldFileInfo.setText(NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.fldFileInfo.text"));
        this.fldFileInfo.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.fldFileInfoActionPerformed(evt);
            }
        });
        this.fldFileInfo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PhotoViewerPanel.this.fldFileInfoKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageDetails.add((Component)this.fldFileInfo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageDetails.add((Component)this.jLabel5, gridBagConstraints);
        this.fldUploadDetail.setModel(new DefaultComboBoxModel());
        this.fldUploadDetail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PhotoViewerPanel.this.fldUploadDetailItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelImageDetails.add(this.fldUploadDetail, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelTop.add((Component)this.panelImageDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panelTop, gridBagConstraints);
        this.mainPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnCancel.text"));
        this.btnCancel.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnCancel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(PhotoViewerPanel.class, (String)"PhotoViewerPanel.btnSave.text"));
        this.btnSave.addActionListener(new java.awt.event.ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhotoViewerPanel.this.btnSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelButtons.add((Component)this.btnSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panelButtons, gridBagConstraints);
    }

    private void btnImageFullExtActionPerformed(ActionEvent evt) {
        this.imagePanel.reset();
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        this.imagePanel.zoomIn();
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        this.imagePanel.zoomOut();
    }

    private void btnCWActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.rotateImage(90.0);
    }

    private void btnCCWActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.rotateImage(-90.0);
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        if (this.checkModifyConditions("delete") && Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PhotoViewerTopComponent.deleteImage.text"))) {
            this.deleteImage();
        }
    }

    private void btnPrevImageActionPerformed(ActionEvent evt) {
        this.updateFileInfo();
        this.showPreviousImage();
    }

    private void btnNextImageActionPerformed(ActionEvent evt) {
        this.updateFileInfo();
        this.showNextImage();
    }

    private void dropDownDrawItemStateChanged(ItemEvent evt) {
        if (this.listenerEnabled) {
            if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
                return;
            }
            try {
                if (this.project.isOpen() && this.isDrawing) {
                    this.setDrawing(true);
                    this.settings.setDisplayDrawingTool(this.dropDownDraw.getSelectedIndex());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void btnDrawFreeActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            this.drawImage(img);
            this.setDrawing(true);
        }
    }

    private void btnDrawingDoneActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.saveDrawings();
    }

    private void btnDrawingCancelActionPerformed(ActionEvent evt) {
        this.isDrawing = false;
        this.imagePanel.setStatus(1);
        this.imagePanel.removeGeometry(this.imagePanel.getCurrentGeometryObject());
        this.updateComponents();
        this.drawImage(this.getCurrentImageReference());
    }

    private void btnDrawingRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.removeDrawings();
        this.updateComponents();
    }

    private void fldFileInfoActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            img.setUploadItemComment(this.fldFileInfo.getText());
            this.updateSaveButton();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.images = this.imagesOrig;
        this.closeDialog();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            this.images.clear();
        }
        if (this.isDrawing) {
            this.saveDrawings();
        }
        this.closeDialog();
    }

    private void btnSave2ActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (this.isDrawing) {
            this.saveDrawings();
        }
        this.saveChanges();
    }

    private void fldUploadDetailItemStateChanged(ItemEvent evt) {
        ImageReference img;
        if (evt.getStateChange() == 1 && (img = this.getCurrentImageReference()) != null && this.fldUploadDetail.getSelectedItem() != null) {
            long uploadDetail = ((KeytableRecord)this.fldUploadDetail.getSelectedItem()).id;
            img.setUploadItemDetail(uploadDetail);
            this.updateSaveButton();
        }
    }

    private void fldFileInfoKeyReleased(KeyEvent evt) {
        ImageReference img = this.getCurrentImageReference();
        if (img != null) {
            img.setUploadItemComment(this.fldFileInfo.getText());
            this.updateSaveButton();
        }
    }

    private void btnDrawingSettingsActionPerformed(ActionEvent evt) {
        JColorChooser pane = new JColorChooser(Color.white);
        ColorTracker ct = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(this, "Farbe w\u00e4hlen", true, pane, ct, null);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Window w = (Window)e.getComponent();
                w.dispose();
            }
        });
        THEMIS.setDialogIcon(dialog);
        dialog.setVisible(true);
        Color color = ct.getColor();
        if (color != null) {
            this.app.getSettings().setDisplayDrawingColor(ThemisUtil.getStringFromColor((Color)color));
        }
        this.setDrawingColor(color);
    }

    private void lblHideControlsMouseClicked(MouseEvent evt) {
        int w = this.lblInfo.getWidth();
        this.setControlVisibility(!this.controlVisibility);
    }
}

