/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.observer.FolderListener;
import at.grid.cms.observer.FolderObserver;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.camera.WebcamFrame2;
import at.grid.themis.application.ui.ThemisDropTargetListener;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.ImageInfo;
import at.grid.util.NumberRange;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PlanPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private String DIALOG_CODE = "planpanel2";
    public static final int DIALOG_WIDTH = 700;
    public static final int DIALOG_HEIGHT = 300;
    private CmsPlan plan;
    private CmsPlan planCopy;
    private ArrayList<CmsPlan> createdPlans = new ArrayList();
    FolderObserver observer;
    int imageWidth;
    int imageHeight;
    float imageRatio;
    boolean imageWidthChanged = false;
    boolean fromCamera = false;
    private boolean newVersion = false;
    ArrayList<File> multipleFiles = new ArrayList();
    private File singleFile = null;
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    int countPlan = 0;
    private CmsPlan.Papersize selectedPaperSize = CmsPlan.Papersize.PDF;
    private JButton btnCamera;
    private JButton btnCancel;
    private JButton btnSaveAndClsoe;
    private JButton btnSelectPlan;
    private JComboBox<CmsElementSummary> fldBuilding;
    private JTextField fldFileName;
    private JTextField fldPages;
    private JTextField fldPaperHeight;
    private JTextField fldPaperWidth;
    private JComboBox<CmsPlan.Papersize> fldPapersize;
    private JTextField fldPlanName;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JLabel lblImageSize;
    private JLabel lblImageSize1;
    private JLabel lblPages;
    private JLabel lblPlanFile;
    private JLabel lblPlanName;
    private JLabel lblWarning;

    public PlanPanel(CmsPlan plan, boolean newVersion) {
        this(plan, null, newVersion);
    }

    public PlanPanel(CmsPlan plan, List<File> files) {
        this(plan, null, false);
        this.planFilesSelected(files);
    }

    public PlanPanel(CmsPlan plan, File f, boolean newVersion) {
        this.initComponents();
        this.newVersion = newVersion;
        this.lblWarning.setVisible(false);
        this.populatePaperSize();
        ArrayList buildings = this.project.getBuildings();
        this.fldBuilding.addItem(new CmsElementSummary(-1L, "-", this.app.getSystemLanguage(), (CmsApplication)this.project, this.project.getUser()));
        for (CmsElementSummary ele : buildings) {
            this.fldBuilding.addItem(ele);
        }
        this.lblPages.setEnabled(false);
        this.fldPages.setEnabled(false);
        if (plan != null) {
            this.plan = plan;
            this.initialiseFolderObserver();
            if (this.plan.isNew()) {
                this.fldPapersize.setSelectedItem(CmsPlan.Papersize.PDF);
            } else {
                this.fldPlanName.setText(plan.getTitle());
                this.fldPapersize.setSelectedItem(plan.getPapersize());
                this.fldPaperWidth.setText(Integer.toString(plan.getPaperWidth()));
                this.fldPaperHeight.setText(Integer.toString(plan.getPaperHeight()));
                if (newVersion) {
                    this.fldPapersize.setEnabled(true);
                    this.btnSelectPlan.setEnabled(true);
                    this.btnCamera.setEnabled(true);
                    this.fldPlanName.setEnabled(false);
                    this.fldBuilding.setEnabled(false);
                } else {
                    this.singleFile = plan.getPlanFile();
                    this.fldFileName.setText(plan.getPlanFileName());
                    this.fldPapersize.setEnabled(false);
                    this.fldPaperWidth.setEnabled(false);
                    this.fldPaperHeight.setEnabled(false);
                    this.btnSelectPlan.setEnabled(false);
                    this.btnCamera.setEnabled(false);
                    this.fldPlanName.setEnabled(true);
                    this.fldBuilding.setEnabled(true);
                }
            }
            CmsElementSummary building = this.plan.getRelationAttribute("building").getFirstElement();
            if (building != null) {
                for (CmsElementSummary ele : buildings) {
                    if (ele.getId() != building.getId()) continue;
                    this.fldBuilding.setSelectedItem(ele);
                }
            }
            if (f != null && f.isFile()) {
                this.setFile(f, true);
            }
        }
        ThemisDropTargetListener dndListener = new ThemisDropTargetListener(true, false, new String[]{"jpg", "pdf", "jpeg", "png"}){

            @Override
            public void dropFileAction(File f, DropTargetDropEvent event) {
            }

            @Override
            public boolean dropFileAction(List<File> files, DropTargetDropEvent event) {
                PlanPanel.this.planFilesSelected(files);
                return true;
            }
        };
        new DropTarget(this.fldFileName, dndListener);
        new DropTarget(this.fldPlanName, dndListener);
    }

    private void populatePaperSize() {
        this.fldPapersize.removeAllItems();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.fldPapersize.getModel();
        m.addElement(CmsPlan.Papersize.PDF);
        m.addElement(CmsPlan.Papersize.A4);
        m.addElement(CmsPlan.Papersize.A3);
        m.addElement(CmsPlan.Papersize.A2);
        m.addElement(CmsPlan.Papersize.A1);
        m.addElement(CmsPlan.Papersize.A0);
        m.addElement(CmsPlan.Papersize.Custom);
    }

    public void showAssistant() {
    }

    private boolean isValidPlanfile(File f) {
        String fileext = Util.getFileExtension((File)f).toLowerCase();
        return "jpg".equals(fileext) || "jpeg".equals(fileext) || "png".equals(fileext) || "pdf".equals(fileext);
    }

    protected void setFile(File f, boolean updateDialog) {
        try {
            if (f != null) {
                if (f.isFile()) {
                    if ("pdf".equalsIgnoreCase(FilenameUtils.getExtension((String)f.getAbsolutePath()))) {
                        PDDocument doc = PDDocument.load((File)f);
                        int pageCount = doc.getNumberOfPages();
                        if (pageCount > 1 && this.newVersion) {
                            Dialogs.getInstance().showErrorDialog("error.plan.only-single-for-new-version");
                            return;
                        }
                        this.fldPapersize.setSelectedItem(this.selectedPaperSize);
                        if (pageCount == 1) {
                            this.lblPages.setEnabled(false);
                            this.fldPages.setEnabled(false);
                            this.fldPages.setText("");
                            PDPage page = doc.getPage(0);
                            at.grid.util.Dimension pageSize = this.getPageSize(page);
                            this.fldPaperWidth.setText(Integer.toString(pageSize.getWidth()));
                            this.fldPaperHeight.setText(Integer.toString(pageSize.getHeight()));
                            this.imageRatio = (float)pageSize.getWidth() / (float)pageSize.getHeight();
                        } else {
                            this.lblPages.setEnabled(true);
                            this.fldPages.setEnabled(true);
                            this.fldPages.setText("1-" + pageCount);
                            this.fldPaperWidth.setText("");
                            this.fldPaperHeight.setText("");
                            this.imageRatio = -1.0f;
                        }
                        doc.close();
                    } else {
                        this.lblPages.setEnabled(false);
                        this.fldPages.setEnabled(false);
                        this.fldPages.setText("");
                        ImageInfo ii = new ImageInfo(f);
                        this.imageRatio = (float)ii.getWidth() / (float)ii.getHeight();
                        int w = CmsPlan.Papersize.A3.getWidth();
                        this.fldPapersize.setSelectedItem(CmsPlan.Papersize.A3);
                        this.fldPaperWidth.setText(Integer.toString(w));
                        this.fldPaperHeight.setText(Integer.toString((int)((float)w / this.imageRatio)));
                    }
                    this.singleFile = f;
                    if (updateDialog) {
                        this.fldFileName.setText(f.getName());
                        if ("".equals(this.fldPlanName.getText())) {
                            this.fldPlanName.setText(Util.getFileNameWithoutExtension((File)f).replace("/", "-").replace("\\", "-"));
                        }
                    }
                    this.planCopy = (CmsPlan)this.plan.copy();
                } else {
                    Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.onlyJPGandPDF.text"));
                }
            }
            if (this.fromCamera) {
                this.fromCamera = false;
            } else {
                this.app.getSettings().getFolderPlanImport().setValue(f.getParentFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private at.grid.util.Dimension getPageSize(PDPage page) {
        PDRectangle mediabox = page.getMediaBox();
        PDRectangle cropbox = page.getCropBox();
        PDRectangle trimbox = page.getTrimBox();
        PDRectangle box = trimbox;
        if (box == null) {
            box = cropbox;
        }
        if (box == null) {
            box = mediabox;
        }
        int pageSizeWidthMM = Math.round(25.4f * box.getWidth() / 72.027f);
        int pageSizeHeightMM = Math.round(25.4f * box.getHeight() / 72.027f);
        if (page.getRotation() == 90 || page.getRotation() == 270) {
            pageSizeWidthMM = Math.round(25.4f * box.getHeight() / 72.027f);
            pageSizeHeightMM = Math.round(25.4f * box.getWidth() / 72.027f);
        }
        return new at.grid.util.Dimension(pageSizeWidthMM, pageSizeHeightMM);
    }

    private void planFilesSelected(List<File> files) {
        if (files != null) {
            int numFiles = files.size();
            if (numFiles == 1) {
                File f = files.get(0);
                this.setFile(f, true);
            } else if (numFiles > 1) {
                if (this.newVersion) {
                    Dialogs.getInstance().showErrorDialog("error.plan.only-single-for-new-version");
                    return;
                }
                this.fldPlanName.setEnabled(false);
                this.fldPlanName.setText(MessageFormat.format(this.project.getResourceText("plan.multiple-files.selected"), numFiles));
                this.multipleFiles.clear();
                this.multipleFiles.addAll(files);
            }
        }
    }

    public int getPlanCount() {
        return this.countPlan;
    }

    public int savePlan() throws IOException {
        int countPlan = this.multipleFiles.size();
        if (countPlan == 0) {
            countPlan = 1;
        }
        if (this.newVersion && countPlan > 1) {
            Dialogs.getInstance().showErrorDialog("error.plan.only-single-file-for-new-version");
            return 0;
        }
        final long idBuilding = this.plan.getRelationAttribute("building").getFirstElementId();
        ProgressRunnable<String> runner = new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                int importTotalCount = PlanPanel.this.multipleFiles.size();
                int importCounter = 0;
                ph.switchToDeterminate(importTotalCount > 0 ? 3 * importTotalCount : 3);
                if (PlanPanel.this.multipleFiles.size() > 0) {
                    int failedCount = 0;
                    String failedPlans = "";
                    for (File f : PlanPanel.this.multipleFiles) {
                        if (PlanPanel.this.isValidPlanfile(f)) {
                            if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE) || ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL) && PlanPanel.this.project.getPlans().size() >= 15) break;
                            if (importCounter > 0) {
                                PlanPanel.this.plan = PlanPanel.this.project.createPlan(idBuilding);
                                if (PlanPanel.this.plan == null) break;
                                PlanPanel.this.setFile(f, false);
                            }
                            try {
                                if (PlanPanel.this.plan != null) {
                                    PlanPanel.this.saveSinglePlanfile(f, Util.getFileNameWithoutExtension((File)f), importCounter, importTotalCount, ph);
                                }
                            }
                            catch (Exception ex) {
                                if (!failedPlans.isEmpty()) {
                                    failedPlans = failedPlans + ", ";
                                }
                                failedPlans = failedPlans + f.getName();
                                ++failedCount;
                            }
                        }
                        ++importCounter;
                    }
                    if (!failedPlans.isEmpty()) {
                        if (failedCount == 1) {
                            Dialogs.getInstance().showErrorDialog(MessageFormat.format(PlanPanel.this.project.getResourceText("error.plan.loading"), failedPlans));
                        } else {
                            Dialogs.getInstance().showErrorDialog(MessageFormat.format(PlanPanel.this.project.getResourceText("error.plans.loading"), failedPlans));
                        }
                    }
                } else {
                    try {
                        PlanPanel.this.saveSinglePlanfile(PlanPanel.this.singleFile, PlanPanel.this.fldPlanName.getText(), 0, 1, ph);
                    }
                    catch (Exception ex) {
                        Dialogs.getInstance().showErrorDialog(MessageFormat.format(PlanPanel.this.project.getResourceText("error.plan.loading"), PlanPanel.this.plan.getPlanFile().getName()));
                    }
                    ph.finish();
                }
                return null;
            }
        };
        String progressTitle = this.project.getResourceText("plan.load.title");
        if (this.multipleFiles.size() > 1) {
            progressTitle = this.project.getResourceText("plan.load-multiple.title");
        }
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)runner, (String)progressTitle, (boolean)true);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SAVED.setId(this.plan.getId()).from((Object)this, "plan saved after edit"));
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(this.plan.getId()).from((Object)this, "plan selected after edit"));
        return countPlan;
    }

    public void saveSinglePlanfile(File planFile, String title, int counter, int totalCount, ProgressHandle ph) throws IOException {
        this.plan.setAttributeValue("title", title);
        if ("".equals(this.plan.getTitle()) || planFile == null && this.plan.getPlanFile() == null) {
            Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.defineTitleAndFile.text"));
            return;
        }
        if (totalCount > 1) {
            ph.progress(this.project.getResourceText("plan.load-multiple.title") + " [" + (counter + 1) + " / " + totalCount + "]");
        }
        if (this.newVersion || this.plan.isNew()) {
            if (planFile.getName().toLowerCase().endsWith(".pdf")) {
                this.convertPdf(planFile, counter, ph);
            } else {
                BufferedImage image = ImageIO.read(planFile);
                this.imageHeight = image.getHeight();
                this.imageWidth = image.getWidth();
                int targetWidthMM = Util.parseInt((String)this.fldPaperWidth.getText(), (int)-1);
                int targetWidthPx = this.imageWidth;
                if (targetWidthMM > 0) {
                    targetWidthPx = (int)((float)(300 * targetWidthMM) / 25.4f);
                }
                if (this.imageWidthChanged) {
                    File copyPlanFile = new File(this.project.getTempfileLocation(), planFile.getName());
                    if (copyPlanFile.isFile()) {
                        this.project.getFileAccess().delete(copyPlanFile);
                    }
                    ImageIO.write((RenderedImage)Util.resizeImage((BufferedImage)image, (int)targetWidthPx), "jpg", copyPlanFile);
                    this.plan.addPlanFile(copyPlanFile, null, null, new Date());
                } else {
                    this.plan.addPlanFile(planFile, null, null, new Date());
                }
                this.processPlanSave();
            }
        } else {
            this.processPlanSave();
        }
    }

    public String convertPdf(File planFile, int counter, ProgressHandle ph) {
        if (this.plan == null) {
            return "";
        }
        int maxCount = 99999;
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.APP)) {
            maxCount = 15;
        }
        int currentCount = this.project.getPlans().size();
        String plantitle = this.plan.getAttributeValue("title");
        try {
            boolean isPagenumbersSet = true;
            String pagenumbers = this.fldPages.getText().trim();
            if ("".equals(pagenumbers)) {
                pagenumbers = "1";
                isPagenumbersSet = false;
            }
            NumberRange pages = new NumberRange(pagenumbers);
            if (this.newVersion && !pages.isSingle()) {
                this.app.getDialog().showWarningDialog("error.plan.only-single-for-new-version");
                return "";
            }
            ph.progress(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.readPDF.text"), 3 * counter);
            PDDocument doc = PDDocument.load((File)planFile);
            PDFRenderer pdfRenderer = new PDFRenderer(doc);
            int pageCount = doc.getNumberOfPages();
            if (!this.newVersion && pageCount > 1 && "".equals(this.fldPages.getText())) {
                boolean convertAll = this.app.getDialog().showConfirmDialog("plan.load-pdf-multiple-pages.msg", "plan.load-pdf-multiple-pages.title");
                pagenumbers = convertAll ? "1-" : "1";
            }
            ph.progress(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.convert.text"), 3 * counter + 1);
            for (int ii = 0; ii < pageCount; ++ii) {
                if (!pages.containsNumber(ii + 1)) continue;
                if (currentCount >= maxCount) {
                    this.app.getDialog().showWarningDialog("license.too-many-plans");
                    break;
                }
                if (ii > 0) {
                    this.plan = (CmsPlan)this.planCopy.copy();
                }
                PDPage page = doc.getPage(ii);
                at.grid.util.Dimension pageSize = this.getPageSize(page);
                float dpi = 300.0f;
                int targetWidth = pageSize.getWidth();
                CmsPlan.Papersize paper = (CmsPlan.Papersize)this.fldPapersize.getSelectedItem();
                switch (paper) {
                    case PDF: {
                        break;
                    }
                    case Custom: {
                        targetWidth = Util.parseInt((String)this.fldPaperWidth.getText(), (int)pageSize.getWidth());
                        if (targetWidth != 0) break;
                        targetWidth = pageSize.getWidth();
                        break;
                    }
                    default: {
                        targetWidth = CmsPlan.Papersize.isLandscape((int)pageSize.getWidth(), (int)pageSize.getHeight()) ? ((CmsPlan.Papersize)this.fldPapersize.getSelectedItem()).getHeight() : ((CmsPlan.Papersize)this.fldPapersize.getSelectedItem()).getWidth();
                    }
                }
                dpi = dpi * (float)targetWidth / (float)pageSize.getWidth();
                BufferedImage image = pdfRenderer.renderImageWithDPI(ii, dpi, ImageType.RGB);
                String pagenumber = "_" + Integer.toString(ii + 1);
                File outputfile = new File(this.project.getTempfileLocation(), Util.getFileNameWithoutExtension((File)planFile) + pagenumber + ".jpg");
                outputfile.getParentFile().mkdirs();
                if (ii == 0) {
                    ph.progress(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.save1.text"), 3 * counter + 2);
                }
                ImageIO.write((RenderedImage)image, "jpg", outputfile);
                this.imageWidth = image.getWidth();
                this.imageHeight = image.getHeight();
                PDDocument doc2 = new PDDocument();
                doc2.addPage(page);
                String fn = Util.getFileNameWithoutExtension((File)planFile) + "_" + (ii + 1) + ".pdf";
                File filePdf = new File(this.project.getTempfileLocation(), fn);
                doc2.save(filePdf);
                doc2.close();
                this.plan.addPlanFile(outputfile, filePdf, null, new Date());
                if (pages.isSingle()) {
                    this.plan.setAttributeValue("title", plantitle);
                } else {
                    this.plan.setAttributeValue("title", plantitle + " Seite " + (ii + 1));
                }
                this.processPlanSave();
                ++currentCount;
            }
            doc.close();
        }
        catch (IOException isPagenumbersSet) {
        }
        catch (OutOfMemoryError e) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("plan.load.memory-error"));
        }
        return "";
    }

    private void processPlanSave() {
        CmsElementSummary sel;
        if (this.newVersion) {
            this.plan.getCurrentPlanfileElement().getIntegerAttribute("imagewidth").setValue(this.imageWidth);
            this.plan.getCurrentPlanfileElement().getIntegerAttribute("imageheight").setValue(this.imageHeight);
        }
        if ((sel = (CmsElementSummary)this.fldBuilding.getSelectedItem()).getId() > 0L) {
            this.plan.getRelationAttribute("building").set(sel);
        } else {
            this.plan.getRelationAttribute("building").clear();
        }
        this.plan.save();
        this.createdPlans.add(this.plan);
    }

    public String getTitle() {
        return this.plan.getTitle();
    }

    public String[] getSaveCancelBtn() {
        return new String[]{ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.save.text"), ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.cancel.text")};
    }

    public String getPlanPanelTitle() {
        String title = this.plan.getTitle();
        if (title.length() > 40) {
            title = title.substring(0, 40) + " (...)";
        }
        return title;
    }

    private void initialiseFolderObserver() {
        UploadAttribute uploadAttribute = null;
        String uploadAttributeString = "image";
        File folder = this.app.getSettings().getFolderImageObserver().getValue(true);
        if (folder == null) {
            Dialogs.getInstance().showWarningDialog(this.bundle.getString("LocationObservationDialog.uploadFolderNotExistingNotif.text"));
            return;
        }
        this.observer = new FolderObserver(this.project.getLogger(), folder);
        if (this.plan.getAttribute(uploadAttributeString).isOfType(15) || this.plan.getAttribute(uploadAttributeString).isOfType(16)) {
            uploadAttribute = (UploadAttribute)this.plan.getAttribute(uploadAttributeString);
            this.observer.registerListener(new FolderListener(){

                public void onNewFiles(FolderObserver observer, ArrayList<String> filenames) {
                    for (String filename : filenames) {
                        File f;
                        if (!filename.toLowerCase().endsWith(".jpg") || (f = new File(PlanPanel.this.app.getSettings().getFolderImageObserver().getValue(true) + "\\" + filename)) == null) continue;
                        if (f.isFile()) {
                            PlanPanel.this.fromCamera = true;
                            PlanPanel.this.setFile(f, true);
                            continue;
                        }
                        Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/Bundle").getString("PlanPanel.onlyFiles.text"));
                    }
                }
            });
        }
    }

    public void startFolderObserver() {
        if (this.observer != null) {
            this.observer.start();
        }
    }

    public void stopFolderObserver() {
        if (this.observer != null) {
            this.observer.unregisterListener();
            this.observer.stopRunning();
        }
    }

    private void initComponents() {
        this.lblPlanFile = new JLabel();
        this.fldFileName = new JTextField();
        this.btnSelectPlan = new JButton();
        this.btnCamera = new JButton();
        this.lblPages = new JLabel();
        this.fldPages = new JTextField();
        this.lblPlanName = new JLabel();
        this.fldPlanName = new JTextField();
        this.lblImageSize = new JLabel();
        this.fldPapersize = new JComboBox();
        this.jLabel6 = new JLabel();
        this.fldPaperWidth = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.fldPaperHeight = new JTextField();
        this.jLabel4 = new JLabel();
        this.lblWarning = new JLabel();
        this.lblImageSize1 = new JLabel();
        this.fldBuilding = new JComboBox();
        this.jPanel1 = new JPanel();
        this.btnSaveAndClsoe = new JButton();
        this.btnCancel = new JButton();
        this.setPreferredSize(new Dimension(600, 150));
        this.setLayout(new GridBagLayout());
        this.lblPlanFile.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanFile, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblPlanFile.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblPlanFile, gridBagConstraints);
        this.fldFileName.setEditable(false);
        this.fldFileName.setFont(THEMIS.fontTextfield);
        this.fldFileName.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldFileName.text"));
        this.fldFileName.setMinimumSize(new Dimension(100, 30));
        this.fldFileName.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFileName, gridBagConstraints);
        this.btnSelectPlan.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectPlan, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnSelectPlan.text"));
        this.btnSelectPlan.setActionCommand(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnSelectPlan.actionCommand"));
        this.btnSelectPlan.setMaximumSize(new Dimension(100, 30));
        this.btnSelectPlan.setMinimumSize(new Dimension(100, 30));
        this.btnSelectPlan.setPreferredSize(new Dimension(100, 30));
        this.btnSelectPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnSelectPlanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectPlan, gridBagConstraints);
        this.btnCamera.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/showPictures_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCamera, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCamera.text"));
        this.btnCamera.setBorder(new SoftBevelBorder(0));
        this.btnCamera.setMinimumSize(new Dimension(35, 35));
        this.btnCamera.setPreferredSize(new Dimension(35, 35));
        this.btnCamera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCameraActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCamera, gridBagConstraints);
        this.lblPages.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPages, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblPages.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblPages, gridBagConstraints);
        this.fldPages.setFont(THEMIS.fontTextfield);
        this.fldPages.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldPages.text"));
        this.fldPages.setMinimumSize(new Dimension(100, 30));
        this.fldPages.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldPages, gridBagConstraints);
        this.lblPlanName.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanName, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblPlanName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblPlanName, gridBagConstraints);
        this.fldPlanName.setFont(THEMIS.fontTextfield);
        this.fldPlanName.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldPlanName.text"));
        this.fldPlanName.setMinimumSize(new Dimension(100, 30));
        this.fldPlanName.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldPlanName, gridBagConstraints);
        this.lblImageSize.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblImageSize, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblImageSize.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblImageSize, gridBagConstraints);
        this.fldPapersize.setFont(THEMIS.fontList);
        this.fldPapersize.setModel(new DefaultComboBoxModel());
        this.fldPapersize.setMinimumSize(new Dimension(100, 30));
        this.fldPapersize.setPreferredSize(new Dimension(100, 30));
        this.fldPapersize.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PlanPanel.this.fldPapersizeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldPapersize, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 25, 5, 0);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.fldPaperWidth.setFont(THEMIS.fontTextfield);
        this.fldPaperWidth.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldPaperWidth.text"));
        this.fldPaperWidth.setMinimumSize(new Dimension(100, 30));
        this.fldPaperWidth.setPreferredSize(new Dimension(100, 30));
        this.fldPaperWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PlanPanel.this.fldPaperWidthKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldPaperWidth, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.fldPaperHeight.setEditable(false);
        this.fldPaperHeight.setFont(THEMIS.fontTextfield);
        this.fldPaperHeight.setText(NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.fldPaperHeight.text"));
        this.fldPaperHeight.setMinimumSize(new Dimension(100, 30));
        this.fldPaperHeight.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldPaperHeight, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.lblWarning.setFont(THEMIS.fontLabelBold);
        this.lblWarning.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.lblWarning, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblWarning.text"));
        this.lblWarning.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlanPanel.this.lblWarningMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblWarning, gridBagConstraints);
        this.lblImageSize1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblImageSize1, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.lblImageSize1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblImageSize1, gridBagConstraints);
        this.fldBuilding.setFont(THEMIS.fontList);
        this.fldBuilding.setModel(new DefaultComboBoxModel());
        this.fldBuilding.setMinimumSize(new Dimension(100, 30));
        this.fldBuilding.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldBuilding, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnSaveAndClsoe.setFont(THEMIS.fontButton);
        this.btnSaveAndClsoe.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAndClsoe, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnSaveAndClsoe.text"));
        this.btnSaveAndClsoe.setBorder(new SoftBevelBorder(0));
        this.btnSaveAndClsoe.setPreferredSize(new Dimension(190, 35));
        this.btnSaveAndClsoe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnSaveAndClsoeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.btnSaveAndClsoe, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(PlanPanel.class, (String)"PlanPanel.btnCancel.text"));
        this.btnCancel.setBorder(new SoftBevelBorder(0));
        this.btnCancel.setPreferredSize(new Dimension(190, 35));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlanPanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnSelectPlanActionPerformed(ActionEvent evt) {
        List<File> files = new ThemisFileDialog(this.bundle.getString("PlanPanel.loadPlan.text"), ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getSettings().getFolderPlanImport().getValue(true), null, new FileNameExtensionFilter(this.bundle.getString("PlanPanel.mapFileChooser.text"), "jpg", "jpeg", "png", "pdf"), null, true).getSelectedFiles();
        if (files != null) {
            this.planFilesSelected(files);
        }
    }

    private void btnSaveAndClsoeActionPerformed(ActionEvent evt) {
        try {
            this.countPlan = this.savePlan();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.countPlan > 0) {
            this.closeDialog(evt);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog(evt);
    }

    private void fldPapersizeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.selectedPaperSize = (CmsPlan.Papersize)this.fldPapersize.getSelectedItem();
            int w = this.selectedPaperSize.getWidth();
            int h = this.selectedPaperSize.getHeight();
            if (this.imageRatio > 1.0f) {
                w = h;
                h = this.selectedPaperSize.getWidth();
            }
            this.fldPaperWidth.setText(Integer.toString(w));
            this.fldPaperHeight.setText(Integer.toString(h));
            switch (this.selectedPaperSize) {
                case PDF: {
                    this.fldPaperWidth.setText("");
                    this.fldPaperHeight.setText("");
                }
                case A4: 
                case A3: 
                case A2: 
                case A1: 
                case A0: {
                    this.fldPaperWidth.setEnabled(false);
                    if (this.imageRatio > 0.0f) {
                        h = (int)((float)w / this.imageRatio);
                        this.fldPaperHeight.setText(Integer.toString(h));
                    }
                    this.imageWidthChanged = true;
                    break;
                }
                case Custom: {
                    w = CmsPlan.Papersize.A3.getHeight();
                    this.fldPaperWidth.setText(Integer.toString(w));
                    h = CmsPlan.Papersize.A3.getWidth();
                    if (this.imageRatio > 0.0f) {
                        h = (int)((float)w / this.imageRatio);
                    }
                    this.fldPaperHeight.setText(Integer.toString(h));
                    this.fldPaperWidth.setEnabled(true);
                }
            }
            this.lblWarning.setVisible(11.811023622047244 * (double)Math.max(w, h) > 12000.0);
        }
    }

    private void fldPaperWidthKeyReleased(KeyEvent evt) {
        if (CmsPlan.Papersize.Custom == this.fldPapersize.getSelectedItem()) {
            int w = Util.parseInt((String)this.fldPaperWidth.getText(), (int)0);
            int h = 0;
            float ratio = this.imageRatio;
            if (ratio <= 0.0f) {
                ratio = (float)CmsPlan.Papersize.A4.getHeight() / (float)CmsPlan.Papersize.A4.getWidth();
            }
            if (w > 0) {
                h = (int)((float)w / ratio);
                this.fldPaperHeight.setText(Integer.toString(h));
                this.imageWidthChanged = true;
            }
            this.lblWarning.setVisible(11.811023622047244 * (double)Math.max(w, h) > 12000.0);
        }
    }

    private void btnCameraActionPerformed(ActionEvent evt) {
        WebcamFrame2 webcamFrame = new WebcamFrame2(THEMIS.getMainWindow()).onlySingle();
        SwingUtilities.invokeLater(webcamFrame);
    }

    private void lblWarningMouseClicked(MouseEvent evt) {
        Dialogs.getInstance().showInfoDialog("warning.big-plan");
    }

    public void showDialog() {
        try {
            if (this.newVersion) {
                ThemisApplication.getInstance().getProject().createActionLog("plan_newversion", this.plan.getId(), "");
            } else {
                ThemisApplication.getInstance().getProject().createActionLog("plan_edit", this.plan.getId(), "");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.startFolderObserver();
        JDialog dlg = THEMIS.createDialog(this.project.getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, dlg, 700, 300);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        this.stopFolderObserver();
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }

    class PlanDnDListener
    implements DropTargetListener {
        PlanDnDListener() {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            DataFlavor[] flavors;
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                try {
                    if (!flavor.isFlavorJavaFileListType()) continue;
                    List files = (List)transferable.getTransferData(flavor);
                    PlanPanel.this.planFilesSelected(files);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            event.dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

