/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.THEMIS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class SignaturePanel
extends JPanel {
    Image image;
    Graphics2D graphics2D;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int defaultWidth = 400;
    boolean large = false;
    private JButton jButton1;
    private JButton jButton2;

    public SignaturePanel() {
        this.initComponents();
        this.setPreferredSize(new Dimension(this.defaultWidth, 170));
        this.setDoubleBuffered(false);
        this.jButton2.setVisible(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SignaturePanel.this.oldX = e.getX();
                SignaturePanel.this.oldY = e.getY();
                int a = e.getClickCount();
                if (a == 1) {
                    if (SignaturePanel.this.graphics2D != null) {
                        SignaturePanel.this.graphics2D.fillOval(SignaturePanel.this.oldX - 2, SignaturePanel.this.oldY - 2, 4, 4);
                    }
                    SignaturePanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SignaturePanel.this.currentX = e.getX();
                SignaturePanel.this.currentY = e.getY();
                if (SignaturePanel.this.graphics2D != null) {
                    SignaturePanel.this.graphics2D.drawLine(SignaturePanel.this.oldX, SignaturePanel.this.oldY, SignaturePanel.this.currentX, SignaturePanel.this.currentY);
                }
                SignaturePanel.this.repaint();
                SignaturePanel.this.oldX = SignaturePanel.this.currentX;
                SignaturePanel.this.oldY = SignaturePanel.this.currentY;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseClicked(MouseEvent e) {
                SignaturePanel.this.currentX = e.getX();
                SignaturePanel.this.currentY = e.getY();
                if (SignaturePanel.this.graphics2D != null) {
                    SignaturePanel.this.graphics2D.drawOval(SignaturePanel.this.currentX - 2, SignaturePanel.this.currentY - 2, 4, 4);
                }
                SignaturePanel.this.repaint();
            }
        });
    }

    public void writeToFile(File f) throws IOException {
        int w = this.getWidth();
        int h = this.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D bGr = bi.createGraphics();
        bGr.drawImage(this.image, 0, 0, null);
        bGr.dispose();
        ImageIO.write((RenderedImage)bi, "jpg", f);
    }

    public BufferedImage getImageAsBufferedImage() {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D bGr = bi.createGraphics();
        bGr.drawImage(this.image, 0, 0, null);
        bGr.dispose();
        return bi;
    }

    public Icon getImageAsIcon(int w, int h) {
        double scale1 = (double)w / (double)this.getWidth();
        double scale2 = (double)h / (double)this.getHeight();
        double scale = Math.min(scale1, scale2);
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D bGr = bi.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
        bGr.drawImage(this.image, at, null);
        bGr.dispose();
        return new ImageIcon(bi);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.image == null) {
            this.image = this.createImage(800, 400);
            this.graphics2D = (Graphics2D)this.image.getGraphics();
            this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics2D.setPaint(Color.blue);
            this.graphics2D.setStroke(new BasicStroke(3.0f));
            this.clear();
        }
        g.drawImage(this.image, 0, 0, null);
    }

    public void clear() {
        this.graphics2D.setPaint(Color.white);
        this.graphics2D.fillRect(0, 0, 800, 400);
        this.graphics2D.setPaint(Color.blue);
        this.repaint();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton1.setFont(THEMIS.fontButton);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/clearEntries24.gif")));
        this.jButton1.setText(NbBundle.getMessage(SignaturePanel.class, (String)"SignaturePanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignaturePanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setFont(THEMIS.fontButton);
        this.jButton2.setText("+");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignaturePanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 188, Short.MAX_VALUE).addComponent(this.jButton1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap(236, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.large) {
            this.setPreferredSize(new Dimension(this.defaultWidth, 170));
            this.large = false;
            this.jButton2.setText("+");
        } else {
            this.setPreferredSize(new Dimension(2 * this.defaultWidth, 170));
            this.large = true;
            this.jButton2.setText("-");
        }
    }

    public static void main(String[] args) {
        JDialog dlg = new JDialog();
        dlg.setTitle("Test paint");
        dlg.setContentPane(new SignaturePanel());
        dlg.setSize(800, 400);
        dlg.setVisible(true);
    }
}

