/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.BooleanAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.SearchResult;
import at.grid.cms.swing.CmsBasicElement;
import at.grid.gui.ImagePanel;
import at.grid.gui.SimpleGeometry;
import at.grid.ontology.swing.ui.PDControlScrollPane;
import at.grid.themis.application.ContactPanel;
import at.grid.themis.application.EventPanel;
import at.grid.themis.application.ModuleVersionManager;
import at.grid.themis.application.UpdateManager;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.application.ui.attributes.AbstractAttributePanel;
import at.grid.themis.application.ui.attributes.DocumentAttributePanel;
import at.grid.themis.application.ui.attributes.LongtextAttributePanel;
import at.grid.themis.application.ui.attributes.MeasureAttributePanel;
import at.grid.themis.application.ui.attributes.SizeAttributePanel;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.signature.SignatureManagementFxPanel;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.signature.ThemisSignature;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import at.grid.webdav.NextCloudWebDAV;
import com.lowagie.text.Image;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class THEMIS {
    private static ThemisApplication app = ThemisApplication.getInstance();
    private static Frame mainWindow = WindowManager.getDefault().getMainWindow();
    private static BufferedImage dialogIcon = null;
    private static ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    private static String fontFamily = "Verdana";
    private static int fontSize = 12;
    private static int fontSizeVeryBig = 24;
    private static int fontSizeBig = 15;
    private static int fontSizeSmall = 9;
    private static boolean messageAllLicencesInUse = false;
    public static Font fontHeading = new Font(fontFamily, 1, fontSizeVeryBig);
    public static Font fontSubheading = new Font(fontFamily, 1, fontSizeBig);
    public static Font fontLabel = new Font(fontFamily, 0, fontSize);
    public static Font fontLabelSmall = new Font(fontFamily, 0, fontSizeSmall);
    public static Font fontLabelItalic = new Font(fontFamily, 2, fontSize);
    public static Font fontLabelBold = new Font(fontFamily, 1, fontSize);
    public static Font fontLabelBig = new Font(fontFamily, 0, fontSizeBig);
    public static Font fontLabelBigBold = new Font(fontFamily, 1, fontSizeBig);
    public static Font fontButton = new Font(fontFamily, 0, fontSize);
    public static Font fontInfo = new Font(fontFamily, 2, fontSizeSmall);
    public static Font fontList = new Font(fontFamily, 0, fontSize);
    public static Font fontListBig = new Font(fontFamily, 0, fontSizeBig);
    public static Font fontListBold = new Font(fontFamily, 1, fontSize);
    public static Font fontTextfield = new Font(fontFamily, 0, fontSize);
    public static Font fontTextfieldFixed = new Font("Courier", 0, fontSize);
    public static Color red = new Color(255, 59, 48, 255);
    public static Color lightred = new Color(255, 171, 169, 255);
    public static Color green = new Color(85, 219, 108, 255);
    public static Color lightgreen = new Color(185, 240, 194, 255);
    public static Color yellow = new Color(255, 214, 49, 255);
    public static Color lightyellow = new Color(255, 238, 170, 255);
    public static Color orange = new Color(255, 149, 0, 255);
    public static Color lightorange = new Color(255, 219, 170, 255);
    public static Color brown = new Color(180, 130, 80, 255);
    public static Color lightbrown = new Color(211, 183, 154, 255);
    public static Color darkblue = new Color(0, 122, 255, 255);
    public static Color blue = new Color(49, 157, 255, 255);
    public static Color lightblue = new Color(170, 210, 255, 255);
    public static Color gray = new Color(160, 160, 160, 255);
    public static Color lightgray = new Color(200, 200, 200, 255);
    public static Color white = new Color(255, 255, 255, 255);
    public static Color black = new Color(10, 10, 10, 255);
    public static Color COLOR_DEFECT = new Color(lightred.getRGB());
    public static Color COLOR_DEFECT_SEL = new Color(red.getRGB());
    public static Color COLOR_INFO = new Color(lightyellow.getRGB());
    public static Color COLOR_INFO_SEL = new Color(yellow.getRGB());
    public static Color COLOR_CHECK = new Color(lightblue.getRGB());
    public static Color COLOR_CHECK_SEL = new Color(blue.getRGB());
    public static Color COLOR_TASK = new Color(lightbrown.getRGB());
    public static Color COLOR_TASK_SEL = new Color(brown.getRGB());
    public static Color COLOR_LIST_SELECTION_BG = new Color(0, 120, 215, 255);
    public static Color COLOR_LIST_SELECTION_FG = new Color(255, 255, 255, 255);
    public static Color COLOR_LIST_FG = new Color(0, 0, 0, 255);
    public static Color COLOR_LIST_BG = new Color(255, 255, 255, 255);
    public static final ImageIcon ICON_THEMIS = new ImageIcon(THEMIS.class.getResource("media/icon_themis.gif"));
    public static final ImageIcon ICON_WARN = new ImageIcon(THEMIS.class.getResource("media/icon_warn.gif"));
    public static final ImageIcon ICON_INFO = new ImageIcon(THEMIS.class.getResource("media/icon_info.gif"));
    public static final ImageIcon ICON_DONE = new ImageIcon(THEMIS.class.getResource("media/icon_done.gif"));
    public static final ImageIcon ICON_ERROR = new ImageIcon(THEMIS.class.getResource("media/icon_error.gif"));
    public static final int MESSAGE_INFO = 1;
    public static final int MESSAGE_WARNING = 2;
    public static final int MESSAGE_ERROR = 3;
    public static final int MESSAGE_TIPP = 4;
    public static final int MESSAGE_DONE = 5;
    public static final ModuleVersionManager moduleVersionManager = new ModuleVersionManager();
    public static String widthMessageDialogs = "200px";
    public static String[] observationListAttributes = new String[]{"type:60:string", "fullnumber:40:int", "plan:130:string", "location:130:string", "referencedate:80:date", "editor:60:string", "control:80:string", "observationtitle:100:string", "description:200:string", "observationdescription:200:string", "langtext1:200:string", "langtext2:200:string", "measure:200:string", "duedate:80:date", "done:80:string", "contactname:80:string", "observationtype:80:string", "priority:80:string", "risk:40:string", "topic:80:string", "code:80:string", "freetext1:80:string", "freetext2:80:string", "freetext3:80:string", "quantity:80:string", "hasimage:55:string", "hasaudio:55:string"};
    public static String[] locationListAttributes = new String[]{"locnumber:40:int", "plan:100:string", "location:100:string", "locationgroup:70:string", "loccode:70:string", "code2:70:string", "list1:70:string", "list2:70:string", "barcode:70:string"};
    private static Icon checkboxIcon = null;
    private static Icon checkboxIconSelected = null;
    private static GridBagConstraints gbcLabel = null;
    private static GridBagConstraints gbcContent = null;
    private static GridBagConstraints gbcChecklistText = null;
    private static GridBagConstraints gbcChecklistForm = null;

    public static ArrayList<String> getObservationTableColumnsAll() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : observationListAttributes) {
            result.add(s.split(":")[0]);
        }
        return result;
    }

    public static ArrayList<String> getLocationTableColumnCodesAll() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : locationListAttributes) {
            result.add(s.split(":")[0]);
        }
        return result;
    }

    public static ArrayList<String> getLocationTableColumnsAll() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : locationListAttributes) {
            result.add(s);
        }
        return result;
    }

    public static synchronized ThemisLicense getLicense() {
        return ThemisApplication.getInstance().getLicense();
    }

    public static void dismissNotify(int seconds, final Notification notify) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                notify.clear();
            }
        }, seconds * 1000);
    }

    public static Notification notify(int category, String title, String text) {
        NotificationDisplayer.Category cat = null;
        ImageIcon icon = null;
        switch (category) {
            case 2: {
                cat = NotificationDisplayer.Category.WARNING;
                icon = ICON_WARN;
                break;
            }
            case 3: {
                cat = NotificationDisplayer.Category.ERROR;
                icon = ICON_ERROR;
                break;
            }
            case 5: {
                cat = NotificationDisplayer.Category.INFO;
                icon = ICON_DONE;
                break;
            }
            case 4: {
                cat = NotificationDisplayer.Category.INFO;
                icon = ICON_THEMIS;
                break;
            }
            default: {
                cat = NotificationDisplayer.Category.INFO;
                icon = ICON_INFO;
            }
        }
        if (title == null) {
            title = "";
        }
        return NotificationDisplayer.getDefault().notify(ThemisApplication.getInstance().getProject().getResourceText(title), (Icon)icon, ThemisApplication.getInstance().getProject().getResourceText(text), null, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
    }

    public static void openHandbookFull() {
        THEMIS.openPDF("THEMIS_Handbuch.pdf");
    }

    public static void openHandbookWhatsNew() {
        THEMIS.openPDF("THEMIS_Update.pdf");
    }

    private static void openPDF(String filename) {
        try {
            File f = new File(ThemisApplication.getInstance().getApplicationDataDocumentsFolder(), filename);
            if (f.isFile()) {
                f.delete();
            }
            if (f.isFile()) {
                ThemisApplication.getInstance().getDialog().showErrorDialog("error.fileCannotBeDeleted");
                return;
            }
            f.getParentFile().mkdirs();
            InputStream is = THEMIS.class.getResourceAsStream("/at/grid/themis/application/docs/" + filename);
            FileOutputStream os = new FileOutputStream(f);
            Util.copy((InputStream)is, (OutputStream)os);
            if (f.isFile()) {
                Desktop.getDesktop().open(f);
                return;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ThemisApplication.getInstance().getDialog().showErrorDialog("error.noWriteAccessInInstall");
    }

    public static void showFile(File f) {
        if (f == null) {
            return;
        }
        if (f.exists()) {
            Desktop dt = Desktop.getDesktop();
            try {
                dt.open(f);
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog("error.cannot-read-file", f.getAbsolutePath());
            }
        } else {
            Dialogs.getInstance().showErrorDialog("error.file-not-found", f.getAbsolutePath());
        }
    }

    public static javax.swing.filechooser.FileFilter getProjectFileFilter() {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File pathname) {
                File f = new File(pathname.getParentFile(), "db/themis.h2.db");
                if (f.exists()) {
                    return false;
                }
                return pathname.isDirectory();
            }

            public String toString() {
                return "THEMIS project folder";
            }

            @Override
            public String getDescription() {
                return this.toString();
            }
        };
    }

    public static javax.swing.filechooser.FileFilter getFolderFilter() {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }

            public String toString() {
                return "Folder";
            }

            @Override
            public String getDescription() {
                return this.toString();
            }
        };
    }

    public static javax.swing.filechooser.FileFilter getFileExtensionFilter(String ext, String desc) {
        return new FileNameExtensionFilter(desc, ext);
    }

    public static javax.swing.filechooser.FileFilter getFileFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.imageAndAudioFiles.text"), "jpg", "jpeg", "gif", "png", "wav", "JPG", "JPEG", "GIF", "PNG", "WAV");
    }

    public static javax.swing.filechooser.FileFilter getImageFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.images.text"), "jpg", "jpeg", "gif", "png", "JPG", "JPEG", "GIF", "PNG");
    }

    public static javax.swing.filechooser.FileFilter getCsvFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.csv.text"), "csv", "txt", "CSV", "TXT");
    }

    public static javax.swing.filechooser.FileFilter getCsvXlsFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.csvxls.text"), "csv", "txt", "xlsx", "xls", "CSV", "TXT", "XLSX", "XLS");
    }

    public static javax.swing.filechooser.FileFilter getReportExcelFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.reporttemplate.text"), "xls", "xlsx", "xlsm", "XLSX", "XLS", "XLSM");
    }

    public static javax.swing.filechooser.FileFilter getReportWordFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.reporttemplateword.text"), "doc", "docx", "DOC", "DOCX");
    }

    public static javax.swing.filechooser.FileFilter getZipFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.zip.text"), "zip", "ZIP");
    }

    public static javax.swing.filechooser.FileFilter getLayoutFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.layout.text"), "layout");
    }

    public static javax.swing.filechooser.FileFilter getPdfFilter() {
        return new FileNameExtensionFilter(bundle.getString("THEMIS.pdf.text"), "pdf", "PDF");
    }

    public static javax.swing.filechooser.FileFilter getDatabaseFilter() {
        return new FileNameExtensionFilter(ThemisApplication.getInstance().getProject().getResourceText("THEMIS.database.text"), "db");
    }

    public static javax.swing.filechooser.FileFilter getThemisFileFilter() {
        return new FileNameExtensionFilter(ThemisApplication.getInstance().getProject().getResourceText("dialog.load.protocol-template.tms"), "themis");
    }

    public static javax.swing.filechooser.FileFilter getProjectListFileFilter() {
        return new FileNameExtensionFilter(ThemisApplication.getInstance().getProject().getResourceText("filefilter.projectlist"), "projectlist");
    }

    public static File getSelectedFile(JTextField fld, File f, String ext) {
        File selFile;
        boolean emptyText = "".equals(fld.getText().trim());
        if (f == null || emptyText) {
            fld.setText("");
            return null;
        }
        File file = selFile = emptyText ? f : new File(f.getParentFile(), fld.getText());
        if (!selFile.getName().toLowerCase().endsWith("." + ext.toLowerCase())) {
            selFile = new File(selFile.getParentFile(), selFile.getName() + "." + ext);
        }
        fld.setText(selFile.getName());
        return selFile;
    }

    public static void saveWindowSizeAndLocation(String dialogcode, Window dlg) {
        ThemisUtil.setWindowSize((String)dialogcode, (Dimension)dlg.getSize(), (ThemisApplication)app);
    }

    public static void applyWindowSizeAndLocation(String dialogcode, Window dlg, int defaultWidth, int defaultHeight) {
        Dimension windowSize = THEMIS.getWindowSize(dialogcode, app);
        if (windowSize == null) {
            windowSize = new Dimension(defaultWidth, defaultHeight);
        }
        dlg.setSize(windowSize);
        dlg.setPreferredSize(windowSize);
        dlg.setLocationRelativeTo(mainWindow);
    }

    public static void applyWindowSizeAndLocation(String dialogcode, JDialog dlg, int defaultWidth, int defaultHeight) {
        THEMIS.applyWindowSizeAndLocation(dialogcode, dlg, new Dimension(defaultWidth, defaultHeight), new Dimension(-1, -1));
    }

    public static void applyWindowSizeAndLocation(String dialogcode, JDialog dlg, int defaultWidth, int defaultHeight, int minWidth, int minHeight) {
        THEMIS.applyWindowSizeAndLocation(dialogcode, dlg, new Dimension(defaultWidth, defaultHeight), new Dimension(minWidth, minHeight));
    }

    public static void applyWindowSizeAndLocation(String dialogcode, JDialog dlg, Dimension defaultDim, Dimension minDim) {
        Dimension windowSize = THEMIS.getWindowSize(dialogcode, app);
        if (windowSize == null) {
            windowSize = new Dimension(defaultDim.width, defaultDim.height);
        }
        if (minDim.height > 0 && windowSize.height < minDim.height) {
            windowSize.height = minDim.height;
        }
        if (minDim.width > 0 && windowSize.width < minDim.width) {
            windowSize.width = minDim.width;
        }
        dlg.setSize(windowSize);
        dlg.setPreferredSize(windowSize);
        dlg.setLocationRelativeTo(mainWindow);
    }

    public static Dimension getWindowSize(String dialogcode, ThemisApplication app) {
        return THEMIS.getWindowSize(dialogcode, -1, -1, app);
    }

    public static Dimension getWindowSize(String dialogcode, int defaultWidth, int defaultHeight, ThemisApplication app) {
        String dim = app.getConfiguration("dialog.#.size".replaceAll("#", dialogcode));
        if (dim == null) {
            if (defaultHeight < 0 || defaultWidth < 0) {
                return null;
            }
            return new Dimension(defaultWidth, defaultHeight);
        }
        String[] dims = dim.split(",");
        return new Dimension((int)Double.parseDouble(dims[0]), (int)Double.parseDouble(dims[1]));
    }

    public static void setMainWindow() {
        mainWindow = WindowManager.getDefault().getMainWindow();
    }

    public static Frame getMainWindow() {
        if (mainWindow == null) {
            THEMIS.setMainWindow();
        }
        return mainWindow;
    }

    public static void applyTreeExpansionState(JTree tree, String state) {
        String[] indexes;
        if ("".equals(state)) {
            return;
        }
        for (String st : indexes = state.split(",")) {
            int row = Integer.parseInt(st);
            if (row >= tree.getRowCount()) continue;
            tree.expandRow(row);
        }
    }

    public static String getTreeExpansionState(JTree tree) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            if (!tree.isExpanded(i)) continue;
            sb.append(i).append(",");
        }
        return sb.toString();
    }

    public static SimpleGeometry transformGeometryToPanel(SimpleGeometry geom, CmsPlan plan, ImagePanel panel) {
        if (plan != null && plan.isCalibrated()) {
            if (plan.isCurrentPlanfileCalibrated()) {
                return geom.retransform(panel.getImageHeight(), plan.getGeometry());
            }
            return geom.retransform(panel.getImageHeight(), plan.getCalibPlanfileElement().getCalibration().toGeometry());
        }
        return geom;
    }

    public static SimpleGeometry transformGeometryToPlan(SimpleGeometry geom, CmsPlan plan, ImagePanel panel) {
        if (plan.isCalibrated()) {
            if (plan.isCurrentPlanfileCalibrated()) {
                return geom.transform(panel.getImageHeight(), plan.getGeometry());
            }
            return geom.transform(panel.getImageHeight(), plan.getCalibPlanfileElement().getCalibration().toGeometry());
        }
        return geom;
    }

    public static boolean createImageFile(File inputFile, File outputFile, float quality) {
        try {
            return THEMIS.createImageFile(ImageIO.read(inputFile), outputFile, quality);
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog("error.cannot-read-file");
            return false;
        }
    }

    public static boolean createImageFile(BufferedImage bufimg, File outputFile, float quality) {
        ImageWriter writer = null;
        try {
            String ext = Util.getFileExtension((File)outputFile);
            if ("".equals(ext)) {
                Dialogs.getInstance().showErrorDialog("error.unknown-image-format");
                return false;
            }
            if ("tif".equalsIgnoreCase(ext)) {
                ext = "tiff";
            }
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(ext);
            writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            try {
                iwp.setCompressionMode(2);
                if (iwp.getCompressionType() != null) {
                    iwp.setCompressionQuality(quality);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            writer.setOutput(ImageIO.createImageOutputStream(outputFile));
            writer.write(null, new IIOImage(bufimg, null, null), iwp);
            writer.dispose();
            return true;
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog("error.cannot-read-imagefile");
            return false;
        }
    }

    public static BufferedImage createImage(ArrayList<SimpleGeometry> drawings, File imagefile, int width) {
        if (imagefile == null || !imagefile.isFile()) {
            return null;
        }
        try {
            BufferedImage bi = ImageIO.read(imagefile);
            if (bi == null) {
                return null;
            }
            return THEMIS.createImage(drawings, bi, width);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static BufferedImage createImage(ArrayList<SimpleGeometry> drawings, BufferedImage bi, int width) {
        if (bi == null) {
            return null;
        }
        try {
            if (drawings == null || drawings.isEmpty()) {
                if (width < 0) {
                    return bi;
                }
                return Util.resizeImage((BufferedImage)bi, (int)width);
            }
            ImagePanel panel = new ImagePanel(ThemisApplication.getInstance().getProject().getLogger());
            panel.setBackgroundImage(bi);
            for (SimpleGeometry geometry : drawings) {
                geometry.getDisplay().setLinewidth(8);
                panel.addGeometry(geometry);
            }
            if (width < 0) {
                return panel.getAsBufferedImage();
            }
            return Util.resizeImage((BufferedImage)panel.getAsBufferedImage(), (int)width);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static Image bufferedImageToPdfImage(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", baos);
            baos.flush();
            Image img = Image.getInstance((byte[])baos.toByteArray());
            baos.close();
            return img;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static Icon getCheckboxIcon(boolean selected) {
        if (selected) {
            if (checkboxIconSelected == null) {
                checkboxIconSelected = new ImageIcon(THEMIS.class.getResource("/at/grid/themis/application/media/checkbox_selected24.gif"));
            }
            return checkboxIconSelected;
        }
        if (checkboxIcon == null) {
            checkboxIcon = new ImageIcon(THEMIS.class.getResource("/at/grid/themis/application/media/checkbox24.gif"));
        }
        return checkboxIcon;
    }

    public static void setCheckboxIcon(JCheckBox chk) {
        chk.setIcon(THEMIS.getCheckboxIcon(false));
        chk.setSelectedIcon(THEMIS.getCheckboxIcon(true));
    }

    public static void setCheckboxIcon(JCheckBox ... chks) {
        for (JCheckBox chk : chks) {
            THEMIS.setCheckboxIcon(chk);
        }
    }

    public static void removeUsualTabBehavior(JTextArea textarea) {
        textarea.setFocusTraversalKeys(0, null);
        textarea.setFocusTraversalKeys(1, null);
    }

    public static ModuleVersionManager getModuleVersionManager() {
        return moduleVersionManager;
    }

    public static boolean checkAndCreateEvent() {
        ThemisApplication app = ThemisApplication.getInstance();
        if (app.getProject().getCurrentEventId() > 0L) {
            return true;
        }
        if (app.getProject().isThemisFileDirectAccess() && !THEMIS.checkNoEvent(null)) {
            return app.getProject().getSelectionManager().getCurrentEventId() > 0L;
        }
        ArrayList eventsForToday = app.getProject().getEventsForToday();
        if (app.getSettings().getDoAutoGenerateEvent()) {
            String defaultTitle = app.getSettings().getTerm(ThemisSettings.Term.NewEventTitle);
            for (CmsBasicElement e : eventsForToday) {
                if (!e.getTitle().startsWith(defaultTitle)) continue;
                CmsEvent event = (CmsEvent)app.getProject().loadElement(e.getId(), app.getProject().getUser());
                if (event.isSigned()) break;
                app.getProject().setCurrentEvent(event, true);
                return true;
            }
            CmsEvent event = (CmsEvent)app.getProject().createElement("event");
            event.setAttributeValue("title", defaultTitle);
            event.getDateAttribute("date").setDate(new Date());
            event.setAttributeValue("time", Util.formatDate((Date)new Date(), (String)"HH:mm", (TimeZone)app.getTimeZone()));
            event.save();
            app.getActionProvider().invokeAction(ThemisAction.EVENT_SAVED.setId(event.getId()));
            app.getProject().setCurrentEvent(event);
            return true;
        }
        String txt = app.getProject().getResourceText("app.core.text.noevent.create", app.getLocale());
        String[] buttons = new String[]{app.getProject().getResourceText("app.core.text.cancel", app.getLocale()), app.getProject().getResourceText("event.buttoncreatenew", app.getLocale())};
        if (eventsForToday.size() > 0) {
            txt = app.getProject().getResourceText("app.core.text.noevent.createorselect", app.getLocale());
            buttons = new String[]{app.getProject().getResourceText("app.core.text.cancel", app.getLocale()), app.getProject().getResourceText("event.buttoncreatenew", app.getLocale()), app.getProject().getResourceText("event.buttonshowselect", app.getLocale())};
        }
        switch (app.getDialog().showConfirmDialogWithOptions(txt, "", buttons)) {
            case 0: {
                return false;
            }
            case 1: {
                EventPanel event = new EventPanel();
                event.createEvent();
                return app.getProject().getCurrentEventId() >= 0L;
            }
        }
        ViewHelper.showEventList();
        return app.getProject().getCurrentEventId() >= 0L;
    }

    public static File chooseThemisRootFolder() {
        ThemisApplication app = ThemisApplication.getInstance();
        File rootFolder = app.getSettings().getFolderProjectRoot().getValue(true);
        if (rootFolder == null) {
            rootFolder = app.getSettings().getFolderOpenProject().getValue(true);
        }
        File f = new ThemisFileDialog(bundle.getString("ThemisFileDialog.chooseRootFolder.text"), ThemisFileDialog.DIALOGTYPE.DIRECTORY, rootFolder, null, null, null, false).getSelectedFile();
        return f;
    }

    public static void prepareEmail(String subject, String text, boolean asHTML, File attach) {
        THEMIS.prepareEmail("info@themis-software.com", subject, text, asHTML, attach);
    }

    public static void prepareEmail(String recipient, String subject, String text, boolean asHTML, File attach) {
        ArrayList<File> files = new ArrayList<File>();
        if (attach != null) {
            files.add(attach);
        }
        THEMIS.prepareEmail(recipient, subject, text, asHTML, files);
    }

    public static void prepareEmail(String recipient, String subject, String text, boolean asHTML, ArrayList<File> attachments) {
        THEMIS.prepareEmail(recipient, subject, text, asHTML, attachments, true);
    }

    public static void prepareEmail(String recipient, String subject, String text, boolean asHTML, ArrayList<File> attachments, boolean storeInProject) {
        try {
            File emailFile;
            ThemisProject project = ThemisApplication.getInstance().getProject();
            File folder = ThemisApplication.getInstance().getApplicationDataTempFolder();
            if (project.isOpen() && storeInProject) {
                folder = project.getEmailsfileLocation();
            }
            if ((emailFile = new File(folder, "message_" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)ThemisApplication.getInstance().getProject().getTimeZone()) + ".eml")).isFile()) {
                emailFile.delete();
            }
            Properties props = new Properties();
            props.setProperty("mail.transport.protocol", "smtp");
            Session mailSession = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(mailSession);
            if (recipient != null) {
                message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            }
            message.setSubject(subject);
            message.setHeader("X-Unsent", "1");
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)text, "text/" + (asHTML ? "html" : "plain"));
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (attachments != null) {
                for (File attach : attachments) {
                    messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(attach);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName(attach.getName());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
            }
            message.setContent((Multipart)multipart);
            FileOutputStream fos = new FileOutputStream(emailFile);
            message.writeTo((OutputStream)fos);
            fos.close();
            Desktop dt = Desktop.getDesktop();
            dt.open(emailFile);
        }
        catch (IOException project) {
        }
        catch (MessagingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static boolean updateThemisConf() {
        try {
            String javaConfJre;
            String javaConf;
            String jre = UpdateManager.getInstalledJRE();
            int ramSetting = Util.parseInt((String)ThemisApplication.getInstance().getConfiguration("system.system.ram", "2500"), (int)2500);
            String javaSetting = ThemisApplication.getInstance().getConfiguration("system.system.useInegratedJava", "true");
            boolean changed = false;
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream("etc/themis.conf");
            props.load(fis);
            fis.close();
            String ramConfString = props.getProperty("default_options");
            Pattern pattern = Pattern.compile("\\d+");
            ArrayList<String> allMatches = new ArrayList<String>();
            Matcher m = pattern.matcher(ramConfString);
            while (m.find()) {
                allMatches.add(m.group());
            }
            int ramConf = -1;
            if (!allMatches.isEmpty()) {
                ramConf = Util.parseInt((String)((String)allMatches.get(allMatches.size() - 1)), (int)-1);
            }
            String string = javaConf = (javaConfJre = props.getProperty("jdkhome", null)) == null || "".equals(javaConfJre) ? "false" : "true";
            if (ramSetting != ramConf) {
                props.put("default_options", ramConfString.replaceAll("-J-Xmx" + ramConf + "m", "-J-Xmx" + ramSetting + "m"));
                changed = true;
            }
            if (!javaSetting.equals(javaConf)) {
                if ("false".equals(javaSetting)) {
                    props.remove("jdkhome");
                } else {
                    if (javaConfJre == null || "".equals(javaConfJre)) {
                        javaConfJre = "./jre/";
                    }
                    props.put("jdkhome", javaConfJre);
                }
                changed = true;
            }
            if (changed) {
                ThemisApplication.getInstance().setConfiguration("system.system.ram", Integer.toString(ramSetting), false);
                ThemisApplication.getInstance().setConfiguration("system.system.useInegratedJava", javaSetting, true);
                FileOutputStream fos = new FileOutputStream("etc/themis.conf");
                props.store(fos, null);
                fos.close();
                Dialogs.getInstance().showInfoDialog(bundle.getString("Installer.restartTHEMIS"));
            }
            return changed;
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Could not update THEMIS configuration file: " + ex.getMessage());
            return false;
        }
    }

    public static JPanel getContactListWithAddOption(ArrayList<CmsElementSummary> eles, JTextArea fld, boolean withTitle, boolean withSummary) {
        int inset = 3;
        JPanel pm = new JPanel(new GridBagLayout());
        DefaultComboBoxModel<CmsElementSummary> model = new DefaultComboBoxModel<CmsElementSummary>();
        for (CmsElementSummary ele : eles) {
            model.addElement(ele);
        }
        JComboBox<Object> combo = new JComboBox<Object>(model);
        combo.setRenderer(new SimpleTextRenderer());
        combo.setFont(fontList);
        combo.setMaximumSize(new Dimension(1000, 30));
        combo.setMinimumSize(new Dimension(50, 30));
        combo.setPreferredSize(new Dimension(120, 30));
        JButton btnSelect = new JButton("");
        btnSelect.setIcon(new ImageIcon(THEMIS.class.getResource("/at/grid/themis/application/media/confirm.gif")));
        btnSelect.setFont(fontButton);
        btnSelect.setMaximumSize(new Dimension(40, 35));
        btnSelect.setMinimumSize(new Dimension(40, 35));
        btnSelect.setPreferredSize(new Dimension(40, 35));
        btnSelect.addActionListener(action -> {
            String txt = fld.getText().trim();
            CmsElementSummary sel = (CmsElementSummary)model.getSelectedItem();
            if (sel != null) {
                String txtAdd = ((withTitle ? sel.getTitle() : "") + "\n" + (withSummary ? sel.getSummary() : "")).trim();
                if ("".equals(txtAdd)) {
                    txtAdd = sel.getTitle();
                }
                fld.setText(("".equals(txt) ? "" : txt + "\n") + txtAdd);
            }
        });
        JButton btnAdd = new JButton("neu");
        btnAdd.setIcon(new ImageIcon(THEMIS.class.getResource("/at/grid/themis/application/media/add2.gif")));
        btnAdd.setFont(fontButton);
        btnAdd.setMaximumSize(new Dimension(150, 35));
        btnAdd.setMinimumSize(new Dimension(60, 35));
        btnAdd.setPreferredSize(new Dimension(80, 35));
        btnAdd.addActionListener(action -> {
            CmsCompany c = (CmsCompany)app.getProject().createElement("company");
            ContactPanel cp = new ContactPanel(c);
            if (cp.isSaved()) {
                model.addElement(new CmsElementSummary((CmsElement)c));
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(inset, inset, inset, inset);
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        pm.add(combo, gbc);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(inset, inset, inset, inset);
        gbc.anchor = 18;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        pm.add((Component)btnSelect, gbc);
        pm.add((Component)btnAdd, gbc);
        return pm;
    }

    public static GridBagConstraints getConstraintLabel() {
        if (gbcLabel == null) {
            gbcLabel = new GridBagConstraints();
            THEMIS.gbcLabel.insets = new Insets(3, 3, 0, 3);
            THEMIS.gbcLabel.anchor = 17;
            THEMIS.gbcLabel.weightx = 0.0;
            THEMIS.gbcLabel.weighty = 0.0;
            THEMIS.gbcLabel.gridwidth = 0;
            THEMIS.gbcLabel.gridx = -1;
            THEMIS.gbcLabel.gridy = -1;
            THEMIS.gbcLabel.fill = 2;
        }
        return gbcLabel;
    }

    public static GridBagConstraints getConstraintContent() {
        if (gbcContent == null) {
            gbcContent = new GridBagConstraints();
            THEMIS.gbcContent.insets = new Insets(3, 3, 3, 3);
            THEMIS.gbcContent.anchor = 17;
            THEMIS.gbcContent.weightx = 1.0;
            THEMIS.gbcContent.weighty = 0.0;
            THEMIS.gbcContent.gridwidth = 0;
            THEMIS.gbcContent.gridx = -1;
            THEMIS.gbcContent.gridy = -1;
            THEMIS.gbcContent.fill = 2;
        }
        return gbcContent;
    }

    public static GridBagConstraints getConstraintChecklistText() {
        if (gbcChecklistText == null) {
            gbcChecklistText = new GridBagConstraints();
            THEMIS.gbcChecklistText.insets = new Insets(3, 3, 3, 3);
            THEMIS.gbcChecklistText.anchor = 17;
            THEMIS.gbcChecklistText.weightx = 2.0;
            THEMIS.gbcChecklistText.weighty = 0.0;
            THEMIS.gbcChecklistText.gridwidth = -1;
            THEMIS.gbcChecklistText.gridx = -1;
            THEMIS.gbcChecklistText.gridy = -1;
            THEMIS.gbcChecklistText.fill = 2;
        }
        return gbcChecklistText;
    }

    public static GridBagConstraints getConstraintChecklistForm() {
        if (gbcChecklistForm == null) {
            gbcChecklistForm = new GridBagConstraints();
            THEMIS.gbcChecklistForm.insets = new Insets(3, 3, 3, 3);
            THEMIS.gbcChecklistForm.anchor = 17;
            THEMIS.gbcChecklistForm.weightx = 1.0;
            THEMIS.gbcChecklistForm.weighty = 0.0;
            THEMIS.gbcChecklistForm.gridwidth = 0;
            THEMIS.gbcChecklistForm.gridx = -1;
            THEMIS.gbcChecklistForm.gridy = -1;
            THEMIS.gbcChecklistForm.fill = 2;
        }
        return gbcChecklistForm;
    }

    public static JComponent addAttributeToPanel(ThemisAttribute ta, CmsElement element, JPanel panel) {
        JComponent comp = null;
        GridBagConstraints gbcLabel = THEMIS.getConstraintLabel();
        GridBagConstraints gbcContent = THEMIS.getConstraintContent();
        JLabel lbl = new JLabel(ta.getLabel());
        lbl.setFont(fontLabelSmall);
        panel.add((Component)lbl, gbcLabel);
        CmsAttribute att = element.getAttribute(ta.getCmsCode());
        if (att == null) {
            return null;
        }
        block5 : switch (ta.getId()) {
            case "measure": {
                comp = new MeasureAttributePanel(element);
                break;
            }
            case "documents": {
                comp = new DocumentAttributePanel(element);
                break;
            }
            case "size": {
                comp = new SizeAttributePanel(element);
                break;
            }
            default: {
                switch (ta.getTypeId()) {
                    case NUMBER: 
                    case TEXT: {
                        comp = new JTextField();
                        String content = element.getAttributeValue(ta.getCmsCode());
                        ((JTextField)comp).setText(content);
                        comp.setFont(fontTextfield);
                        comp.setPreferredSize(new Dimension(120, 30));
                        break block5;
                    }
                    case DATE: {
                        comp = new JXDatePicker();
                        comp.setFont(fontTextfield);
                        ((JXDatePicker)comp).setDate(element.getDateAttribute(ta.getCmsCode()).getDate());
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        break block5;
                    }
                    case LONGTEXT: {
                        comp = new LongtextAttributePanel(element, ta);
                        break block5;
                    }
                    case BOOLEAN: {
                        comp = new JCheckBox();
                        ((JCheckBox)comp).setSelected(((BooleanAttribute)att).isSet());
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        break block5;
                    }
                    case LIST: {
                        Keytable tbl = ((KeyAttribute)att).getKeytable();
                        long id = ((KeyAttribute)att).getId();
                        DefaultComboBoxModel<KeytableRecord> model = new DefaultComboBoxModel<KeytableRecord>();
                        KeytableRecord sel = null;
                        for (KeytableRecord r : tbl.toList(att.getParent().getCurrentUser().getCurrentLanguage(), true)) {
                            model.addElement(r);
                            if (r.id != id) continue;
                            sel = r;
                        }
                        comp = new JComboBox(model);
                        if (sel != null) {
                            ((JComboBox)comp).setSelectedItem(sel);
                        }
                        ((JComboBox)comp).setRenderer(new SimpleTextRenderer());
                        comp.setFont(fontList);
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        break block5;
                    }
                    case RELATION: {
                        RelationAttribute rel = (RelationAttribute)att;
                        long id = rel.getFirstElementId();
                        DefaultComboBoxModel<CmsBasicElement> model2 = new DefaultComboBoxModel<CmsBasicElement>();
                        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)app.getProject(), app.getProject().getUser(), false);
                        s.setElementtypes(rel.getElementtype());
                        s.addSelectMeta();
                        SearchResult result = s.search();
                        CmsBasicElement sel2 = null;
                        model2.addElement(new CmsBasicElement(-1L, "-"));
                        for (CmsBasicElement ele : result.getResultAsBasicElements()) {
                            model2.addElement(ele);
                            if (ele.getId() != id) continue;
                            sel2 = ele;
                        }
                        comp = new JComboBox(model2);
                        if (sel2 != null) {
                            ((JComboBox)comp).setSelectedItem(sel2);
                        }
                        ((JComboBox)comp).setRenderer(new SimpleTextRenderer());
                        comp.setFont(fontList);
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                    }
                }
            }
        }
        if (comp != null) {
            panel.add((Component)comp, gbcContent);
            if (ta.isWriteprotected() && !app.isUserAdministrator()) {
                comp.setEnabled(false);
            }
        }
        return comp;
    }

    public static JComponent addFormItemToPanel(String type, String labelText, String options, String value, int width, JPanel panel) {
        JComponent comp = null;
        if (value == null) {
            value = "";
        }
        if (options == null) {
            options = "";
        }
        GridBagConstraints gbcText = THEMIS.getConstraintChecklistText();
        GridBagConstraints gbcForm = THEMIS.getConstraintChecklistForm();
        JLabel lbl = new JLabel("<html>" + labelText + "</html");
        lbl.setFont(fontLabelSmall);
        switch (type) {
            case "heading": {
                lbl.setFont(fontSubheading);
                gbcText = gbcForm;
                break;
            }
            case "text": {
                comp = new JTextField();
                ((JTextComponent)comp).setText(value);
                comp.setFont(fontTextfield);
                comp.setPreferredSize(new Dimension(120, 30));
                break;
            }
            case "date": {
                comp = new JXDatePicker();
                comp.setFont(fontTextfield);
                if (!"".equals(value)) {
                    ((JXDatePicker)comp).setDate(Util.parseDate((String)value, (String)Util.DATE_READ, (TimeZone)app.getTimeZone(), (Date)new Date()));
                }
                comp.setMaximumSize(new Dimension(1000, 30));
                comp.setMinimumSize(new Dimension(50, 30));
                comp.setPreferredSize(new Dimension(120, 30));
                break;
            }
            case "longtext": {
                comp = new JTextArea();
                ((JTextArea)comp).setText(value);
                comp.setFont(fontTextfield);
                comp.setPreferredSize(new Dimension(120, 100));
                break;
            }
            case "checkbox": {
                comp = new JCheckBox();
                ((JCheckBox)comp).setSelected("x".equals(value.toLowerCase()));
                comp.setMaximumSize(new Dimension(1000, 30));
                comp.setMinimumSize(new Dimension(50, 30));
                comp.setPreferredSize(new Dimension(120, 30));
                break;
            }
            case "select": {
                String[] values = options.split(";");
                String sel = null;
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                model.addElement("-");
                for (String v : values) {
                    model.addElement(v);
                    if (!value.equals(v)) continue;
                    sel = v;
                }
                comp = new JComboBox(model);
                if (sel != null) {
                    ((JComboBox)comp).setSelectedItem(sel);
                }
                ((JComboBox)comp).setRenderer(new SimpleTextRenderer());
                comp.setFont(fontList);
                comp.setMaximumSize(new Dimension(1000, 30));
                comp.setMinimumSize(new Dimension(50, 30));
                comp.setPreferredSize(new Dimension(120, 30));
            }
        }
        if (comp != null) {
            panel.add((Component)lbl, gbcText);
            panel.add((Component)comp, gbcForm);
        } else {
            panel.add((Component)lbl, gbcForm);
        }
        return comp;
    }

    public static void addDateToTextarea(JTextArea fld) {
        String txt = fld.getText();
        if (!("".equals(txt) || txt.endsWith(" ") || txt.endsWith("\n"))) {
            txt = txt + " ";
        }
        String dt = Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)ThemisApplication.getInstance().getTimeZone()) + " ";
        int idx = fld.getCaretPosition();
        txt = idx >= 0 ? txt.substring(0, idx) + dt + txt.substring(idx) : txt + dt;
        fld.setText(txt);
        fld.setCaretPosition(idx + dt.length());
        fld.requestFocus();
    }

    public static JComponent addAttributeToPanel(int inset, int panelRow, ThemisAttribute ta, CmsElement element, JPanel panel) {
        JComponent comp = null;
        GridBagConstraints gridBagConstraintsLabel = new GridBagConstraints();
        gridBagConstraintsLabel.insets = new Insets(inset, inset, inset, inset);
        gridBagConstraintsLabel.anchor = 18;
        gridBagConstraintsLabel.weightx = 0.0;
        gridBagConstraintsLabel.weighty = 1.0;
        gridBagConstraintsLabel.gridx = 0;
        gridBagConstraintsLabel.gridy = panelRow;
        GridBagConstraints gridBagConstraintsContent = new GridBagConstraints();
        gridBagConstraintsContent.fill = 2;
        gridBagConstraintsContent.insets = new Insets(inset, inset, inset, inset);
        gridBagConstraintsContent.anchor = 18;
        gridBagConstraintsContent.weightx = 1.0;
        gridBagConstraintsContent.weighty = 1.0;
        gridBagConstraintsContent.gridx = 1;
        gridBagConstraintsContent.gridy = panelRow;
        GridBagConstraints gridBagConstraintsContentNoFill = new GridBagConstraints();
        gridBagConstraintsContentNoFill.weightx = 100.0;
        gridBagConstraintsContentNoFill.weighty = 1.0;
        gridBagConstraintsContentNoFill.insets = new Insets(inset, inset, inset, inset);
        gridBagConstraintsContentNoFill.anchor = 18;
        gridBagConstraintsContentNoFill.gridx = 1;
        gridBagConstraintsContentNoFill.gridy = panelRow;
        GridBagConstraints gridBagConstraintsPanel = new GridBagConstraints();
        gridBagConstraintsPanel.fill = 2;
        gridBagConstraintsPanel.insets = new Insets(inset, inset, inset, inset);
        gridBagConstraintsPanel.anchor = 18;
        gridBagConstraintsPanel.weightx = 1.0;
        gridBagConstraintsPanel.weighty = 1.0;
        gridBagConstraintsPanel.gridx = 0;
        gridBagConstraintsPanel.gridy = panelRow;
        JPanel p = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel(ta.getLabel());
        lbl.setFont(fontLabel);
        lbl.setMaximumSize(new Dimension(110, 30));
        lbl.setMinimumSize(new Dimension(110, 30));
        lbl.setPreferredSize(new Dimension(110, 30));
        p.add((Component)lbl, gridBagConstraintsLabel);
        CmsAttribute att = element.getAttribute(ta.getCmsCode());
        if (att != null) {
            long templateid;
            boolean showMeasure;
            ArrayList measures = new ArrayList();
            boolean bl = showMeasure = ta.getTarget() == ThemisAttribute.Target.OBSERVATION && ta.getCmsCode().equals("measure") && (!ta.isWriteprotected() || app.isUserAdministrator());
            if (showMeasure && (templateid = element.getAttributeValueLong("templateid")) > 0L) {
                CmsBasicSearch s = new CmsBasicSearch((CmsApplication)app.getProject(), app.getProject().getUser(), "measuretemplate");
                s.addWhereRelationId(app.getProject().getDefaultElement("measuretemplate").getAttribute("observationtemplate"), "=", Long.toString(templateid));
                s.addSelectMeta();
                measures.addAll(s.search().getResultAsElementSummary());
            }
            if (showMeasure && !measures.isEmpty()) {
                JPanel pm = new JPanel(new GridBagLayout());
                final DefaultComboBoxModel<CmsElementSummary> model = new DefaultComboBoxModel<CmsElementSummary>();
                for (CmsElementSummary measure : measures) {
                    model.addElement(measure);
                }
                JComboBox<Object> combo = new JComboBox<Object>(model);
                combo.setRenderer(new SimpleTextRenderer());
                combo.setFont(fontList);
                combo.setMaximumSize(new Dimension(1000, 30));
                combo.setMinimumSize(new Dimension(50, 30));
                combo.setPreferredSize(new Dimension(120, 30));
                PDControlScrollPane compScroll = new PDControlScrollPane();
                final JTextArea fld = new JTextArea();
                fld.setFont(fontTextfield);
                String content = element.getAttributeValue(ta.getCmsCode());
                fld.setText(content);
                fld.setRows(app.getSettings().getDisplayTextareaSize());
                fld.setColumns(20);
                fld.setLineWrap(true);
                fld.setWrapStyleWord(true);
                compScroll.setViewportView(fld);
                JButton btn = new JButton("+");
                btn.setFont(fontButton);
                btn.setMaximumSize(new Dimension(100, 30));
                btn.setMinimumSize(new Dimension(40, 30));
                btn.setPreferredSize(new Dimension(40, 30));
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String txt = fld.getText().trim();
                        CmsElementSummary sel = (CmsElementSummary)model.getSelectedItem();
                        String txtMeasure = sel.getSummary();
                        if ("".equals(txtMeasure)) {
                            txtMeasure = sel.getTitle();
                        }
                        fld.setText(("".equals(txt) ? "" : txt + "\n") + txtMeasure);
                    }
                });
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridwidth = 1;
                gbc.fill = 2;
                gbc.insets = new Insets(inset, inset, inset, inset);
                gbc.anchor = 18;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.gridx = 0;
                gbc.gridy = 0;
                pm.add(combo, gbc);
                gbc = new GridBagConstraints();
                gbc.gridwidth = 1;
                gbc.fill = 2;
                gbc.insets = new Insets(inset, inset, inset, inset);
                gbc.anchor = 18;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.gridx = 1;
                gbc.gridy = 0;
                pm.add((Component)btn, gbc);
                gbc = new GridBagConstraints();
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(inset, inset, inset, inset);
                gbc.anchor = 18;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.gridx = 0;
                gbc.gridy = 1;
                pm.add((Component)compScroll, gbc);
                p.add((Component)pm, gridBagConstraintsContent);
                comp = fld;
                if (ta.isWriteprotected() && !app.isUserAdministrator()) {
                    fld.setEnabled(false);
                }
                panel.add((Component)p, gridBagConstraintsPanel);
            } else {
                switch (ta.getTypeId()) {
                    case NUMBER: 
                    case TEXT: {
                        comp = new JTextField();
                        String content = element.getAttributeValue(ta.getCmsCode());
                        ((JTextField)comp).setText(content);
                        comp.setFont(fontTextfield);
                        comp.setPreferredSize(new Dimension(120, 30));
                        p.add((Component)comp, gridBagConstraintsContent);
                        break;
                    }
                    case DATE: {
                        comp = new JXDatePicker();
                        comp.setFont(fontTextfield);
                        ((JXDatePicker)comp).setDate(element.getDateAttribute(ta.getCmsCode()).getDate());
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        p.add((Component)comp, gridBagConstraintsContentNoFill);
                        break;
                    }
                    case LONGTEXT: {
                        PDControlScrollPane compScroll = new PDControlScrollPane();
                        comp = new JTextArea();
                        comp.setFont(fontTextfield);
                        String content = element.getAttributeValue(ta.getCmsCode());
                        ((JTextArea)comp).setText(content);
                        ((JTextArea)comp).setRows(app.getSettings().getDisplayTextareaSize());
                        ((JTextArea)comp).setColumns(20);
                        ((JTextArea)comp).setLineWrap(true);
                        ((JTextArea)comp).setWrapStyleWord(true);
                        compScroll.setViewportView(comp);
                        p.add((Component)compScroll, gridBagConstraintsContent);
                        break;
                    }
                    case BOOLEAN: {
                        comp = new JCheckBox();
                        ((JCheckBox)comp).setSelected(((BooleanAttribute)att).isSet());
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        p.add((Component)comp, gridBagConstraintsContentNoFill);
                        break;
                    }
                    case LIST: {
                        Keytable tbl = ((KeyAttribute)att).getKeytable();
                        long id = ((KeyAttribute)att).getId();
                        DefaultComboBoxModel<KeytableRecord> model = new DefaultComboBoxModel<KeytableRecord>();
                        KeytableRecord sel = null;
                        for (KeytableRecord r : tbl.toList(att.getParent().getCurrentUser().getCurrentLanguage(), true)) {
                            model.addElement(r);
                            if (r.id != id) continue;
                            sel = r;
                        }
                        comp = new JComboBox(model);
                        if (sel != null) {
                            ((JComboBox)comp).setSelectedItem(sel);
                        }
                        ((JComboBox)comp).setRenderer(new SimpleTextRenderer());
                        comp.setFont(fontList);
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        p.add((Component)comp, gridBagConstraintsContent);
                        break;
                    }
                    case RELATION: {
                        RelationAttribute rel = (RelationAttribute)att;
                        long id = rel.getFirstElementId();
                        DefaultComboBoxModel<CmsBasicElement> model2 = new DefaultComboBoxModel<CmsBasicElement>();
                        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)app.getProject(), app.getProject().getUser(), false);
                        s.setElementtypes(rel.getElementtype());
                        s.addSelectMeta();
                        SearchResult result = s.search();
                        CmsBasicElement sel2 = null;
                        model2.addElement(new CmsBasicElement(-1L, "-"));
                        for (CmsBasicElement ele : result.getResultAsBasicElements()) {
                            model2.addElement(ele);
                            if (ele.getId() != id) continue;
                            sel2 = ele;
                        }
                        comp = new JComboBox(model2);
                        if (sel2 != null) {
                            ((JComboBox)comp).setSelectedItem(sel2);
                        }
                        ((JComboBox)comp).setRenderer(new SimpleTextRenderer());
                        comp.setFont(fontList);
                        comp.setMaximumSize(new Dimension(1000, 30));
                        comp.setMinimumSize(new Dimension(50, 30));
                        comp.setPreferredSize(new Dimension(120, 30));
                        p.add((Component)comp, gridBagConstraintsContent);
                    }
                }
                if (comp != null) {
                    if (ta.isWriteprotected() && !app.isUserAdministrator()) {
                        comp.setEnabled(false);
                    }
                    panel.add((Component)p, gridBagConstraintsPanel);
                }
            }
        }
        return comp;
    }

    public static void applyAttribute(HashMap<String, JComponent> map, CmsElement element) {
        for (String attcode : map.keySet()) {
            JComponent comp = map.get(attcode);
            if (comp instanceof JTextField) {
                String val = ((JTextField)comp).getText();
                if (element.getAttribute(attcode).isNumber()) {
                    val = val.replaceAll(",", ".");
                }
                element.setAttributeValue(attcode, val);
                continue;
            }
            if (comp instanceof JTextArea) {
                element.setAttributeValue(attcode, ((JTextArea)comp).getText());
                continue;
            }
            if (comp instanceof LongtextAttributePanel) {
                element.setAttributeValue(attcode, ((LongtextAttributePanel)comp).getText());
                continue;
            }
            if (comp instanceof JXDatePicker) {
                element.getDateAttribute(attcode).setDate(((JXDatePicker)comp).getDate());
                continue;
            }
            if (comp instanceof JCheckBox) {
                element.getBooleanAttribute(attcode).setValue(((JCheckBox)comp).isSelected());
                continue;
            }
            if (comp instanceof JComboBox) {
                KeytableRecord rec;
                if (((JComboBox)comp).getSelectedItem() instanceof KeytableRecord) {
                    rec = (KeytableRecord)((JComboBox)comp).getSelectedItem();
                    if (rec == null) continue;
                    if (rec.id < 0L) {
                        element.getKeyAttribute(attcode).clear();
                        continue;
                    }
                    element.getKeyAttribute(attcode).setTerm(rec.term, false);
                    continue;
                }
                if (!(((JComboBox)comp).getSelectedItem() instanceof CmsBasicElement) || (rec = (CmsBasicElement)((JComboBox)comp).getSelectedItem()) == null) continue;
                element.getRelationAttribute(attcode).set(rec.getId());
                continue;
            }
            if (!(comp instanceof AbstractAttributePanel)) continue;
            ((AbstractAttributePanel)comp).apply();
        }
    }

    public static BufferedImage getDialogIcon() {
        if (dialogIcon == null) {
            try {
                BufferedImage img = ImageHelper.loadImage((URL)THEMIS.class.getResource("/at/grid/themis/application/media/themis.gif"));
                dialogIcon = Util.resizeImage((BufferedImage)img, (int)16, (int)16, (int)2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dialogIcon;
    }

    public static void setDialogIcon(JDialog dlg) {
        dlg.setIconImage(THEMIS.getDialogIcon());
    }

    public static JDialog createDialog(String title, JPanel panel, boolean resizable, boolean modal) {
        return THEMIS.createDialog(title, panel, resizable, modal, true);
    }

    public static JDialog createDialogAndShow(String title, JPanel panel, boolean resizable, boolean modal) {
        JDialog dlg = THEMIS.createDialog(title, panel, resizable, modal, false);
        dlg.setVisible(true);
        return dlg;
    }

    public static JDialog createDialog(String title, JPanel panel, boolean resizable, boolean modal, boolean assistant) {
        boolean a = false;
        Frame mainWindow1 = THEMIS.getMainWindow();
        GraphicsConfiguration graphicsConfiguration = THEMIS.getMainWindow().getGraphicsConfiguration();
        JDialog dlg = new JDialog(THEMIS.getMainWindow(), title, modal);
        THEMIS.setDialogIcon(dlg);
        if (assistant) {
            THEMIS.setAssistantMoveListener(dlg);
        }
        dlg.setContentPane(panel);
        dlg.setResizable(resizable);
        dlg.setDefaultCloseOperation(2);
        dlg.pack();
        dlg.setLocationRelativeTo(THEMIS.getMainWindow());
        return dlg;
    }

    public static void setAssistantMoveListener(Window window) {
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
            }
        });
    }

    public static List<ThemisFolder> findThemisProjects(File root) {
        return THEMIS.findThemisProjects(root, new ArrayList<ThemisFolder>());
    }

    public static List<ThemisFolder> findThemisProjects(File root, List<ThemisFolder> projects) {
        File[] files = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (files != null) {
            for (File file : files) {
                ThemisFolder themisfolder = new ThemisFolder(file);
                if (themisfolder.isProject()) {
                    projects.add(themisfolder);
                    continue;
                }
                THEMIS.findThemisProjects(file, projects);
            }
        }
        return projects;
    }

    public static void uploadFileToNextcloud(String url, File f) {
        THEMIS.uploadFileToNextcloud(url, null, f);
    }

    public static void uploadFileToNextcloud(String url, String pwd, File f) {
        BaseProgressUtils.showProgressDialogAndRun(() -> {
            NextCloudWebDAV webdav = NextCloudWebDAV.fromShareUrl((String)url, (String)pwd);
            try {
                webdav.putFile(null, f);
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog("error.cannot-upload-file", ex.getMessage());
                ex.printStackTrace();
            }
        }, (String)app.getProject().getResourceText("progress.upload-file"));
    }

    public static File getDefaultFolder() {
        return FileSystemView.getFileSystemView().getDefaultDirectory().getAbsoluteFile();
    }

    public static void showFileResultDialog(File destinationFile) {
        THEMIS.showFileResultDialog(destinationFile, true);
    }

    public static void showFileResultDialog(File destinationFile, boolean withOpen) {
        if (destinationFile == null) {
            return;
        }
        try {
            Object[] objectArray;
            ThemisProject project = ThemisApplication.getInstance().getProject();
            if (!destinationFile.exists() || destinationFile.getName().toLowerCase().endsWith(".themis")) {
                withOpen = false;
            }
            if (withOpen) {
                String[] stringArray = new String[3];
                stringArray[0] = project.getResourceText("export.show-after-done", app.getLocale());
                stringArray[1] = project.getResourceText("export.show-folder-after-done", app.getLocale());
                objectArray = stringArray;
                stringArray[2] = project.getResourceText("core.core.text.ok", app.getLocale());
            } else {
                Object[] objectArray2 = new String[2];
                objectArray2[0] = project.getResourceText("export.show-folder-after-done", app.getLocale());
                objectArray = objectArray2;
                objectArray2[1] = project.getResourceText("core.core.text.ok", app.getLocale());
            }
            Object[] options = objectArray;
            int option = Dialogs.getInstance().showInfoOptionDialog(project.getResourceText("export.success", app.getLocale()), project.getResourceText("export.info-title", app.getLocale()), options);
            if (option == 0) {
                Desktop.getDesktop().open(withOpen ? destinationFile : destinationFile.getParentFile());
            } else if (option == 1 && withOpen) {
                Desktop.getDesktop().open(destinationFile.getParentFile());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void sendIDElog() {
        File f;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        String userHome = System.getProperty("user.home");
        String[] filenames = new String[]{userHome + "/AppData/Roaming/.themis/dev/var/log/messages.log", userHome + "/.themis/dev/var/log/messages.log", userHome + "/AppData/Roaming/NetBeans/8.2/var/log/messages.log"};
        int idx = 0;
        while (!(f = new File(filenames[idx])).isFile() && ++idx < filenames.length) {
        }
        if (f.isFile()) {
            ArrayList<File> files = new ArrayList<File>();
            files.add(f);
            for (String nr : new String[]{"1", "2", "3"}) {
                File f2 = new File(f.getAbsolutePath() + "." + nr);
                if (!f2.isFile()) continue;
                files.add(f2);
            }
            StringWriter writer = new StringWriter();
            if (project.isOpen() && project != null) {
                Properties stats = project.getProjectStatistics();
                try {
                    stats.store(writer, "");
                }
                catch (IOException iOException) {}
            } else {
                writer.append(project.getResourceText("app.core.window.no-project"));
            }
            THEMIS.prepareEmail("info@themis-software.com", "IDE log aus THEMIS", "<p>THEMIS Log im Anhang</p><p><b>THEMIS Version:</b>&nbsp;" + project.getVersion() + "</p><p><b>Projektinfo:</b></p><pre>" + writer.toString() + "</pre>", true, files);
        } else {
            ThemisApplication.getInstance().getDialog().showErrorDialog("error.cannot-find-log");
        }
    }

    public static JMenuItem createMenuItem(String text, Color background, boolean bold, Icon icon) {
        JMenuItem item = new JMenuItem(text);
        item.setBackground(background);
        item.setIcon(icon);
        item.setOpaque(true);
        item.setMargin(new Insets(3, 0, 3, 0));
        if (bold) {
            item.setFont(fontLabelBigBold);
        } else {
            item.setFont(fontLabelBig);
        }
        return item;
    }

    public static JMenu createMenu(String text, Color background, boolean bold, Icon icon) {
        JMenu item = new JMenu(text);
        item.setBackground(background);
        item.setIcon(icon);
        item.setOpaque(true);
        item.setMargin(new Insets(3, 0, 3, 0));
        if (bold) {
            item.setFont(fontLabelBigBold);
        } else {
            item.setFont(fontLabelBig);
        }
        return item;
    }

    public static JSeparator createSeparator(Color background) {
        JSeparator sep = new JSeparator();
        sep.setBackground(background);
        return sep;
    }

    public static ArrayList<ThemisSignature> getSignatures(ArrayList<ThemisSignature> sigs) {
        ArrayList<ThemisSignature> createdSignatures = new ArrayList<ThemisSignature>();
        createdSignatures.addAll(sigs);
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("edit-signatures", 1050, 450).setParentFrame(THEMIS.getMainWindow());
        SignatureManagementFxPanel pane = new SignatureManagementFxPanel(sigs);
        JavaFxDialog fxDlg = new JavaFxDialog((Node)pane);
        fxDlg.addSaveButton("\u00dcbernehmen").setOnAction(t -> {
            List newSignatures = pane.getSignatures();
            createdSignatures.clear();
            createdSignatures.addAll(newSignatures);
            fxDlg.closeDialog();
            dlg.close();
        });
        fxDlg.addCancelButton("Abbrechen").setOnAction(t -> {
            fxDlg.closeDialog();
            dlg.close();
        });
        dlg.setContent((Node)fxDlg);
        dlg.show();
        return createdSignatures;
    }

    public static Closing getCloseProjectFeedback(Closing closing) {
        int closeOption;
        if (!closing.askUser) {
            return closing;
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add(app.getProject().getResourceText("core.text.closeproject", app.getLocale()));
        if (app.getProject().hasThemisServer() && app.getSettings().getAutoExportFullProject()) {
            options.add(app.getProject().getResourceText("core.text.closeprojectwithoutexport", app.getLocale()));
        }
        if (ThemisApplication.getInstance().getProject().isThemisFileDirectAccess()) {
            options.add(app.getProject().getResourceText("core.text.closewithoutsave", app.getLocale()));
        }
        options.add(app.getProject().getResourceText("core.text.cancel", app.getLocale()));
        String confirmText = "dialog.close-project.text";
        if (ThemisApplication.getInstance().getProject().isThemisFileDirectAccess()) {
            confirmText = "dialog.close-themis-file.text";
        }
        if ((closeOption = app.getDialog().showConfirmDialogWithOptions(confirmText, "dialog.close-project.title", options.toArray(new String[0]))) < 0 || closeOption == options.size() - 1) {
            return closing.dontClose();
        }
        if (ThemisApplication.getInstance().getProject().isThemisFileDirectAccess()) {
            if (!app.getLicense().hasLicense()) {
                return closing.withoutSave().withoutExport();
            }
            if (closeOption == options.size() - 2) {
                if (Dialogs.getInstance().showConfirmDialog("Wirklich beenden ohne zu speichern? Alle \u00c4nderungen gehen verloren.")) {
                    return closing.withoutSave();
                }
                return closing.dontClose();
            }
        }
        if (closeOption > 0) {
            return closing.withoutExport();
        }
        return closing;
    }

    public static boolean checkNoEvent(Object ref) {
        int sel;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!project.isOpen()) {
            return false;
        }
        if (project.getSelectionManager().getCurrentEvent() != null) {
            Dialogs.getInstance().showWarningDialog("Sie bearbeiten eine *.themis Datei. Es kann hier nur ein Ereignis bearbeitet werden. Es ist beriets ein aktives Ereignis gesetzt.");
            return false;
        }
        ArrayList events = project.getEvents();
        if (events.size() > 1 && (sel = Dialogs.getInstance().showConfirmDialogWithOptions("Sie bearbeiten eine *.themis Datei. Es kann hier nur ein Ereignis bearbeitet werden. M\u00f6chten Sie das bestehende Ereignis weiter bearbeiten oder ein neues Ereignis anlegen?", "Ereignis ausw\u00e4hlen", new String[]{"weiter bearbeiten", "neu anlegen"})) == 0) {
            for (CmsElementSummary ele : events) {
                if (CmsEvent.isSigned((long)ele.getId())) continue;
                project.getSelectionManager().setCurrentEvent(((CmsElementSummary)events.get(0)).getId(), true, ref);
                return false;
            }
        }
        return true;
    }
}

