/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ThemisLocalProjectsPanel
extends JPanel {
    private static final String DIALOG_CODE = "localprojects";
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 380;
    private boolean openProject = false;
    private ThemisFolder projectToOpen = null;
    private JButton btnCheck;
    private JButton btnClose;
    private JButton btnDelete;
    private JButton btnOpen;
    private JButton btnSave;
    private JButton btnSaveAsNew;
    private JTextField fldSource;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JList<ThemisFolder> lstProjects;

    public ThemisLocalProjectsPanel() {
        this.initComponents();
        this.lstProjects.setCellRenderer(new SimpleTextRenderer());
        this.populateProjectList();
    }

    private void populateProjectList() {
        ArrayList files = ThemisApplication.getInstance().getProject().checkLocalProjects();
        ((DefaultListModel)this.lstProjects.getModel()).clear();
        for (ThemisFolder f : files) {
            ((DefaultListModel)this.lstProjects.getModel()).addElement(f.withDateInTitle());
        }
        this.updateButtons();
    }

    private void itemSelected() {
        this.updateButtons();
        ThemisFolder tf = this.lstProjects.getSelectedValue();
        this.fldSource.setText(tf == null ? "" : tf.getProjectFolder().getAbsolutePath());
    }

    private void updateButtons() {
        boolean selection = this.lstProjects.getSelectedValue() != null;
        this.btnCheck.setEnabled(selection);
        this.btnDelete.setEnabled(selection);
        this.btnOpen.setEnabled(selection);
        this.btnSave.setEnabled(selection);
        this.btnSaveAsNew.setEnabled(selection);
    }

    public boolean doOpenProject() {
        return this.openProject;
    }

    public ThemisFolder getSelectedProject() {
        return this.projectToOpen == null ? this.lstProjects.getSelectedValue() : this.projectToOpen;
    }

    private boolean checkSelectedProject(ThemisFolder tf, boolean showOk) {
        String localUser = System.getProperty("user.name");
        if (tf != null) {
            String remoteUser = tf.getProjectLock().getUserName();
            if (!tf.getProjectLock().isLocked()) {
                ThemisApplication.getInstance().getDialog().showErrorDialog("error.network.already-edited");
                return false;
            }
            if (!localUser.equals(remoteUser)) {
                ThemisApplication.getInstance().getDialog().showErrorDialog("error.network.currently-edited", new String[]{remoteUser});
                return false;
            }
            if (showOk) {
                ThemisApplication.getInstance().getDialog().showInfoDialog("info.network.project-can-save-back");
            }
        }
        return true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstProjects = new JList();
        this.btnCheck = new JButton();
        this.btnSave = new JButton();
        this.btnSaveAsNew = new JButton();
        this.btnDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.fldSource = new JTextField();
        this.jPanel1 = new JPanel();
        this.btnOpen = new JButton();
        this.btnClose = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.lstProjects.setFont(THEMIS.fontList);
        this.lstProjects.setModel(new DefaultListModel());
        this.lstProjects.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ThemisLocalProjectsPanel.this.lstProjectsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstProjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnCheck.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCheck, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.btnCheck.text"));
        this.btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLocalProjectsPanel.this.btnCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCheck, gridBagConstraints);
        this.btnSave.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.btnSave.text"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLocalProjectsPanel.this.btnSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSave, gridBagConstraints);
        this.btnSaveAsNew.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveAsNew, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.btnSaveAsNew.text"));
        this.btnSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLocalProjectsPanel.this.btnSaveAsNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSaveAsNew, gridBagConstraints);
        this.btnDelete.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelete, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.btnDelete.text"));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLocalProjectsPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnDelete, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.fldSource.setEditable(false);
        this.fldSource.setText(NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.fldSource.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldSource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnOpen.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpen, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.btnOpen.text"));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLocalProjectsPanel.this.btnOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnOpen, gridBagConstraints);
        this.btnClose.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnClose, (String)NbBundle.getMessage(ThemisLocalProjectsPanel.class, (String)"ThemisLocalProjectsPanel.btnClose.text"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThemisLocalProjectsPanel.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.openProject = true;
        this.closeDialog(evt);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.closeDialog(evt);
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        if (this.lstProjects.getSelectedValuesList() != null && ThemisApplication.getInstance().getDialog().showConfirmDialog("info.network.local-project-delete")) {
            for (ThemisFolder tf : this.lstProjects.getSelectedValuesList()) {
                tf.deleteLocal();
                tf.deleteProjectLock();
                this.populateProjectList();
            }
        }
    }

    private void btnCheckActionPerformed(ActionEvent evt) {
        ThemisFolder tf = this.lstProjects.getSelectedValue();
        if (tf != null) {
            this.checkSelectedProject(tf, true);
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        ThemisFolder tf = this.lstProjects.getSelectedValue();
        if (tf != null && this.checkSelectedProject(tf, false)) {
            BaseProgressUtils.showProgressDialogAndRun(() -> {
                boolean success = ThemisApplication.getInstance().getProject().restoreFromLocalToProject(tf);
                if (success) {
                    tf.deleteProjectLock();
                    this.populateProjectList();
                    ThemisApplication.getInstance().getDialog().showInfoDialog("info.network.project-saved-back");
                } else {
                    ThemisApplication.getInstance().getDialog().showErrorDialog("error.network.cannot-save-back");
                }
            }, (String)ThemisApplication.getInstance().getProject().getResourceText("progress.checkin-project"));
        }
    }

    private void lstProjectsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.itemSelected();
        }
    }

    private void btnSaveAsNewActionPerformed(ActionEvent evt) {
        File folder;
        ThemisFolder tf = this.lstProjects.getSelectedValue();
        if (tf != null && this.checkSelectedProject(tf, false) && (folder = new ThemisFileDialog("Zielordner ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, null, null, THEMIS.getFolderFilter(), null, false).getSelectedFile()) != null) {
            BaseProgressUtils.showProgressDialogAndRun(() -> {
                String result = ThemisApplication.getInstance().getProject().saveLocalAsNewProject(tf, folder);
                if (result == null) {
                    tf.deleteProjectLock();
                    this.populateProjectList();
                    ThemisApplication.getInstance().getDialog().showInfoDialog("Projekt erfolgreich gespeichert");
                } else {
                    ThemisApplication.getInstance().getDialog().showErrorDialog("Das Projekt kann nicht kopiert werden: " + result);
                }
            }, (String)ThemisApplication.getInstance().getProject().getResourceText("Projekt wird gespeichert"));
        }
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(ThemisApplication.getInstance().getProject().getResourceText("dialog.localprojects.title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        THEMIS.applyWindowSizeAndLocation(DIALOG_CODE, dlg, 600, 380);
        dlg.setVisible(true);
    }

    private void closeDialog(ActionEvent evt) {
        JComponent c = (JComponent)evt.getSource();
        Window w = SwingUtilities.getWindowAncestor(c);
        THEMIS.saveWindowSizeAndLocation(DIALOG_CODE, w);
        w.dispose();
    }
}

