/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.util.Util;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TrashTopComponent", persistenceType=0)
public final class TrashTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    private JButton btnClearFilter;
    private JButton btnSetFilter;
    private JButton btnUndelete;
    private JTextField fldDeleteDate;
    private JComboBox<ElementType> fldElementtype;
    private JTextField fldFilter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JList<CmsElementSummary> lstElements;

    public TrashTopComponent() {
        this.initComponents();
        this.setName(this.bundle.getString("CTL_TrashTopComponent"));
        this.setToolTipText(this.bundle.getString("CTL_TrashTopComponent"));
        ThemisActionProvider.getInstance().register(this);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fldElementtype.getModel();
        model.addElement(new ElementType("location", this.project.getResourceText("element.location")));
        model.addElement(new ElementType("observation", this.project.getResourceText("element.observation")));
        model.addElement(new ElementType("plan", this.project.getResourceText("element.plan")));
        model.addElement(new ElementType("event", this.project.getResourceText("element.event")));
        model.addElement(new ElementType("info", this.project.getResourceText("element.info")));
        model.addElement(new ElementType("company", this.project.getResourceText("element.company")));
        model.addElement(new ElementType("report", this.project.getResourceText("element.report")));
        this.lstElements.setCellRenderer(new SimpleTextRenderer());
        this.populateList();
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1100: 
            case 1101: {
                this.populateList();
            }
        }
    }

    public void populateList() {
        if (!this.project.isOpen()) {
            ((DefaultListModel)this.lstElements.getModel()).clear();
            return;
        }
        this.btnUndelete.setEnabled(this.app.getLicense().hasLicense());
        String filter = this.fldFilter.getText();
        CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
        s.addSelectMeta();
        switch (((ElementType)this.fldElementtype.getSelectedItem()).code) {
            case "location": {
                s.setElementtypes("location");
                s.addSelectAttribute(this.project.getDefaultElement("location").getAttribute("number"));
                break;
            }
            case "observation": {
                s.setElementtypes("observation");
                s.addRelationJoin(this.project.getDefaultElement("observation").getAttribute("location"), true);
                s.addInnerJoin("tdtaelelocation AS loc ON (loc.idelement=locatione.idelement)");
                s.addSelect("loc.number", "locnumber");
                s.addSelectAttribute(this.project.getDefaultElement("observation").getAttribute("number"));
                s.addWhere("NOT locatione.deleted");
                break;
            }
            case "plan": 
            case "event": 
            case "info": 
            case "company": {
                s.setElementtypes(((ElementType)this.fldElementtype.getSelectedItem()).code);
            }
        }
        s.setSearchTrash(true);
        if (!"".equals(filter)) {
            s.addWhereFreetext(filter);
        }
        ArrayList eles = s.search().getResultAsElementSummary();
        List recs = s.search().getResult();
        ((DefaultListModel)this.lstElements.getModel()).clear();
        for (DataRecord rec : recs) {
            CmsElementSummary ele = new CmsElementSummary((CmsApplication)this.project, rec, this.project.getUser());
            switch (ele.getElementcode()) {
                case "location": {
                    ele.setTitle("[" + rec.getString("number") + "] " + rec.getString("meta_title"));
                    break;
                }
                case "observation": {
                    ele.setTitle("[" + rec.getString("locnumber") + "." + rec.getString("number") + "] " + rec.getString("meta_title"));
                }
            }
            ((DefaultListModel)this.lstElements.getModel()).addElement(ele);
        }
    }

    private void undelete() {
        if (this.lstElements.getSelectedValuesList() == null) {
            return;
        }
        long lastLocationId = -1L;
        long lastObservationId = -1L;
        for (CmsElementSummary ele : this.lstElements.getSelectedValuesList()) {
            if (ele == null) continue;
            CmsElement e = ele.getElement();
            e.restoreFromTrash();
            switch (ele.getElementcode()) {
                case "location": {
                    lastLocationId = ele.getId();
                    break;
                }
                case "observation": {
                    lastObservationId = ele.getId();
                }
            }
        }
        this.populateList();
        this.app.getFilter().clearAll();
        if (lastLocationId > 0L) {
            this.project.getSelectionManager().setSelectedLocation(lastLocationId, true, (Object)this);
        } else if (lastObservationId > 0L) {
            this.project.getSelectionManager().setSelectedObservation(lastObservationId, true, (Object)this);
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.fldElementtype = new JComboBox();
        this.jLabel2 = new JLabel();
        this.fldFilter = new JTextField();
        this.btnSetFilter = new JButton();
        this.btnClearFilter = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstElements = new JList();
        this.jLabel1 = new JLabel();
        this.fldDeleteDate = new JTextField();
        this.btnUndelete = new JButton();
        this.setMinimumSize(new Dimension(87, 21));
        this.setPreferredSize(new Dimension(100, 30));
        this.setLayout(new GridBagLayout());
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.jLabel3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add(this.jLabel3, gridBagConstraints);
        this.fldElementtype.setFont(THEMIS.fontListBig);
        this.fldElementtype.setModel(new DefaultComboBoxModel());
        this.fldElementtype.setMinimumSize(new Dimension(100, 30));
        this.fldElementtype.setPreferredSize(new Dimension(100, 30));
        this.fldElementtype.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TrashTopComponent.this.fldElementtypeItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldElementtype, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel2, gridBagConstraints);
        this.fldFilter.setFont(THEMIS.fontTextfield);
        this.fldFilter.setText(NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.fldFilter.text"));
        this.fldFilter.setMinimumSize(new Dimension(100, 30));
        this.fldFilter.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldFilter, gridBagConstraints);
        this.btnSetFilter.setFont(THEMIS.fontButton);
        this.btnSetFilter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetFilter, (String)NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.btnSetFilter.text"));
        this.btnSetFilter.setBorder(new SoftBevelBorder(0));
        this.btnSetFilter.setContentAreaFilled(false);
        this.btnSetFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrashTopComponent.this.btnSetFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.btnSetFilter, gridBagConstraints);
        this.btnClearFilter.setFont(THEMIS.fontButton);
        this.btnClearFilter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/action_remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearFilter, (String)NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.btnClearFilter.text"));
        this.btnClearFilter.setBorder(new SoftBevelBorder(0));
        this.btnClearFilter.setContentAreaFilled(false);
        this.btnClearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrashTopComponent.this.btnClearFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.btnClearFilter, gridBagConstraints);
        this.lstElements.setFont(THEMIS.fontList);
        this.lstElements.setModel(new DefaultListModel());
        this.lstElements.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TrashTopComponent.this.lstElementsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstElements);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel1, gridBagConstraints);
        this.fldDeleteDate.setEditable(false);
        this.fldDeleteDate.setFont(THEMIS.fontTextfield);
        this.fldDeleteDate.setText(NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.fldDeleteDate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldDeleteDate, gridBagConstraints);
        this.btnUndelete.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUndelete, (String)NbBundle.getMessage(TrashTopComponent.class, (String)"TrashTopComponent.btnUndelete.text"));
        this.btnUndelete.setBorder(new SoftBevelBorder(0));
        this.btnUndelete.setContentAreaFilled(false);
        this.btnUndelete.setPreferredSize(new Dimension(100, 30));
        this.btnUndelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrashTopComponent.this.btnUndeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.btnUndelete, gridBagConstraints);
    }

    private void btnSetFilterActionPerformed(ActionEvent evt) {
        this.populateList();
    }

    private void btnClearFilterActionPerformed(ActionEvent evt) {
        this.fldFilter.setText("");
        this.populateList();
    }

    private void btnUndeleteActionPerformed(ActionEvent evt) {
        this.undelete();
    }

    private void lstElementsValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        CmsElementSummary ele = this.lstElements.getSelectedValue();
        if (ele == null) {
            this.fldDeleteDate.setText("");
        } else {
            this.fldDeleteDate.setText(Util.formatDate((Date)ele.getLastEdit(), (String)Util.DATETIME_READ, (TimeZone)this.project.getTimeZone()));
        }
    }

    private void fldElementtypeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.populateList();
        }
    }

    public void componentOpened() {
        this.populateList();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    class ElementType {
        String code;
        String label;

        public ElementType(String c, String l) {
            this.code = c;
            this.label = l;
        }

        public String toString() {
            return this.label;
        }
    }
}

