/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.Installer;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.UpdatePanel;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.DefaultProgressHandler;
import at.grid.util.NumberRange;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.LifecycleManager;
import org.openide.util.Exceptions;

public class UpdateManager {
    public static final String UPDATE_AVAILABLE = "update-available";
    public static final String UP_TO_DATE = "up-to-date";
    private final File updateFolder = new File("themis/update/download");
    private final ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/Bundle");
    private boolean ignoreUpdates = false;
    private boolean manualUpdate = false;
    private boolean forceBeta = false;
    private String jreVersion = "jre";

    public void setForceBeta() {
        this.forceBeta = true;
    }

    public void setManualUpdate(boolean f) {
        this.manualUpdate = f;
    }

    public boolean isManualUpdate() {
        return this.manualUpdate;
    }

    public boolean execute(ProgressHandler ph) throws JDOMException, IOException {
        return this.execute(false, ph);
    }

    public boolean execute(boolean onlyCheck, ProgressHandler ph) throws JDOMException, IOException {
        return this.execute(onlyCheck, false, ph);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(boolean onlyCheck, boolean fromInstaller, ProgressHandler ph) throws JDOMException, IOException {
        File appFolder;
        File jreFolder;
        boolean jreUpdateRequired;
        if (ph == null) {
            ph = new DefaultProgressHandler();
        }
        int numberOfSteps = 5;
        ph.switchToDeterminate(numberOfSteps);
        Date dtPauseUntil = ThemisApplication.getInstance().getSettings().getUpdatePauseUntil();
        this.ignoreUpdates = dtPauseUntil != null && dtPauseUntil.after(new Date());
        ThemisApplication.getInstance().getProject().getLogger().info("... loading descriptor ...");
        boolean updateFromLocalSource = this.isUpdateSourceLocal();
        Document xml = null;
        Element xmlRoot = null;
        String updateUrlBase = "";
        int maxBuildNr = 0;
        int lastNonSilentBuild = 0;
        if (updateFromLocalSource) {
            boolean success = false;
            String fldName = ThemisApplication.getInstance().getConfiguration("system.update.source");
            if (fldName == null) {
                this.showMessage(3, "FEHLER", "Es ist kein Ordner f\u00fcr die Updates definiert. Bitte legen Sie diesen in den Systemeinstellungen fest.", false);
                return false;
            }
            File fld = new File(fldName);
            if (!fld.isDirectory()) {
                this.showMessage(3, "FEHLER", "Der definierte Ordner f\u00fcr die Updates ist nicht verf\u00fcgbar. Bitte aktualisieren Sie ihn in den Systemeinstellungen.\n\n" + fld.getAbsolutePath(), false);
                return false;
            }
            File fXml = new File(fld, "themis_version.xml");
            if (!fXml.isFile()) {
                this.showMessage(3, "FEHLER", "Im definierten Ordner f\u00fcr Updates ist keine Update-Datei enthalten.\n\nthemis_version.xml", false);
                return false;
            }
            SAXBuilder saxbuilder = new SAXBuilder(false);
            xml = saxbuilder.build(fXml);
            Element rootelement = xml.getRootElement();
            if (rootelement == null) {
                ThemisApplication.getInstance().getProject().getLogger().severe("Descriptor 'themis_version.xml' is empty, no root element on local file");
            } else {
                String xmlJre;
                String nonSilentBuildnrStr;
                xmlRoot = rootelement;
                String buildnrStr = rootelement.getChildText("buildnr");
                int buildnr = Util.parseInt((String)buildnrStr, (int)0);
                if (buildnr > maxBuildNr) {
                    maxBuildNr = buildnr;
                }
                if ((buildnr = Util.parseInt((String)(nonSilentBuildnrStr = rootelement.getChildText("silent")), (int)0)) > lastNonSilentBuild) {
                    lastNonSilentBuild = buildnr;
                }
                if ((xmlJre = rootelement.getChildText("jre")) != null && !"".equals(xmlJre)) {
                    this.jreVersion = xmlJre;
                }
                success = true;
            }
            updateFromLocalSource = success;
        }
        if (!updateFromLocalSource) {
            ph.progress("Update-Information wird geladen ...", 1);
            ArrayList<String> updateUrls = new ArrayList<String>();
            updateUrls.add("https://update.themis-software.at/");
            updateUrls.add("http://update.themis-software.com/");
            Object versionnumber = Float.toString(6.1f);
            for (String updateUrl : updateUrls) {
                try {
                    String latestVersion = Util.urlToString((URL)new URL(updateUrl + "currentversion"));
                    if (latestVersion != null) {
                        versionnumber = latestVersion;
                        ThemisApplication.getLogger().info("available version on server '" + updateUrl + "' is " + (String)latestVersion);
                        break;
                    }
                    ThemisApplication.getLogger().info("no version info on server '" + updateUrl + "' available");
                }
                catch (Exception latestVersion) {}
            }
            String stadium = "";
            if (this.isUpdateBetaProgram()) {
                stadium = this.isUpdateAlphaProgram() ? "alpha" : "beta";
                ThemisApplication.getLogger().info("Update - Checking " + stadium.toUpperCase() + " server");
            }
            ThemisLicense license = ThemisApplication.getInstance().getLicense();
            for (String updateUrl : updateUrls) {
                try {
                    String xmlJre;
                    String nonSilentBuildnrStr;
                    String urlbase = updateUrl + "themis_v" + (String)versionnumber + "/update" + stadium + "/";
                    URL url = new URL(urlbase + "themis_version.xml?currentbuild=" + 2146 + "&reference=" + (license == null ? "0" : Integer.valueOf(license.getClientID())));
                    ph.setDisplayName("Checking version " + (String)versionnumber + " " + stadium.toUpperCase());
                    if (!Util.checkUrlConnection((String)(urlbase + "themis_version.xml"))) {
                        ThemisApplication.getInstance().getProject().getLogger().warning("Update server at '" + urlbase + "' not available");
                        continue;
                    }
                    SAXBuilder saxbuilder = new SAXBuilder(false);
                    InputStream in = Util.getInputStream((URL)url);
                    Document updateXml = saxbuilder.build(in);
                    in.close();
                    if (updateXml == null) {
                        ThemisApplication.getInstance().getProject().getLogger().severe("Descriptor 'themis_version.xml' is not available" + urlbase);
                        continue;
                    }
                    Element rootelement = updateXml.getRootElement();
                    if (rootelement == null) {
                        ThemisApplication.getInstance().getProject().getLogger().severe("Descriptor 'themis_version.xml' is empty, no root element" + urlbase);
                        continue;
                    }
                    ph.progress("Update-Information wird analysiert ...", 2);
                    String buildnrStr = rootelement.getChildText("buildnr");
                    int buildnr = Util.parseInt((String)buildnrStr, (int)0);
                    if (buildnr > maxBuildNr) {
                        xmlRoot = rootelement;
                        updateUrlBase = urlbase;
                        maxBuildNr = buildnr;
                    }
                    if ((buildnr = Util.parseInt((String)(nonSilentBuildnrStr = rootelement.getChildText("silent")), (int)0)) > lastNonSilentBuild) {
                        lastNonSilentBuild = buildnr;
                    }
                    if ((xmlJre = rootelement.getChildText("jre")) == null || "".equals(xmlJre)) continue;
                    this.jreVersion = xmlJre;
                }
                catch (Exception ex) {
                    ThemisApplication.getInstance().getProject().getLogger().severe("Exception in UpdateManager: \n" + ex);
                }
            }
        }
        boolean bl = jreUpdateRequired = !(jreFolder = new File(appFolder = new File("").getAbsoluteFile(), this.jreVersion)).isDirectory();
        if (xmlRoot == null) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Descriptor 'themis_version.xml' is not available");
            if (onlyCheck) return false;
            if (fromInstaller) return false;
            ThemisApplication.getInstance().getDialog().showErrorDialog("error.update-source-not-available");
            return false;
        }
        if (onlyCheck) {
            if (this.isManualUpdate() || lastNonSilentBuild == 0) {
                if (maxBuildNr <= 2146) return false;
                return true;
            }
            if (lastNonSilentBuild <= 2146) return false;
            return true;
        }
        UpdatePanel panel = new UpdatePanel(xmlRoot, this.isUpdateBetaProgram());
        if (panel.isUrgentUpdate() || this.isManualUpdate() || panel.isUpdateAvailable() && !panel.isSilent() && !this.doIgnoreUpdate()) {
            panel.showDialog();
        }
        ThemisSettings.UpdateMethod method = panel.getUpdateMethod();
        if (!panel.isModuleUpdateAllowed() && method == ThemisSettings.UpdateMethod.MODULE) {
            method = ThemisSettings.UpdateMethod.INSTALLER;
        }
        if (!panel.doUpdate()) {
            if (!panel.doIgnore()) return true;
            ThemisApplication.getInstance().getSettings().setUpdatePauseUntil(14);
            return true;
        }
        if (ThemisApplication.getInstance().getProject().isOpen() && ProjectHelper.closeProject(THEMIS.getCloseProjectFeedback(new Closing().withoutExport().withoutTrigger()), null)) {
            return false;
        }
        String filename = panel.getFilename(method);
        File destFolder = new File("themis/update/download");
        destFolder.mkdirs();
        Util.deleteContent((File)destFolder);
        File dest = new File(destFolder, filename);
        String updateUrlBaseFinal = updateUrlBase;
        if (!updateFromLocalSource) {
            ph.progress("Update wird heruntergeladen ...", 3);
            switch (method) {
                case INSTALLER: {
                    dest = new File(ThemisApplication.getInstance().getApplicationDataUpdateFolder(), filename);
                    break;
                }
                case MODULE: {
                    dest = new File(destFolder, filename);
                    break;
                }
                case ZIP: {
                    File rootFolder = new File(".").getAbsoluteFile().getParentFile().getParentFile();
                    dest = new File(rootFolder, filename);
                    break;
                }
            }
            if (dest.isFile()) {
                dest.delete();
            }
        }
        File downloadFile = dest;
        boolean updateFromLocalSourceFinal = updateFromLocalSource;
        ThemisTaskWithDialog.createTask("progress.downloading-update", ph2 -> {
            if (jreUpdateRequired) {
                // empty if block
            }
            try {
                if (updateFromLocalSourceFinal) {
                    Util.copy((File)new File(ThemisApplication.getInstance().getConfiguration("system.update.source"), filename), (File)downloadFile);
                } else {
                    URL urlFile = new URL(updateUrlBaseFinal + filename);
                    Util.copy((URL)urlFile, (File)downloadFile);
                }
            }
            catch (IOException ex) {
                ThemisApplication.getInstance().getProject().getLogger().severe("  update file (installer) not found: " + ex.getMessage());
            }
        });
        if (downloadFile.isFile() && downloadFile.length() > 0L) {
            switch (method) {
                case INSTALLER: {
                    ph.progress("Update wird gestartet ...", 4);
                    Dialogs.getInstance().showInfoDialog("Die Updates wurden heruntergeladen. Der Update-Prozess wird jetzt gestartet, THEMIS wird dazu beendet.");
                    Runtime.getRuntime().exec(dest.getAbsolutePath() + " /prevDir=\"" + new File("").getAbsolutePath() + "\"");
                    Installer.ask = false;
                    LifecycleManager.getDefault().exit();
                    return true;
                }
                case MODULE: {
                    UpdateManager.unzipFile(downloadFile);
                    File fld0 = new File(downloadFile.getAbsoluteFile().getParentFile(), Util.getFileNameWithoutExtension((File)downloadFile));
                    if (fld0.listFiles().length > 0) {
                        File fld1 = fld0.listFiles()[0];
                        for (File ff : fld1.listFiles()) {
                            if (!ff.isFile()) continue;
                            ff.renameTo(new File(downloadFile.getAbsoluteFile().getParentFile(), ff.getName()));
                        }
                    }
                    downloadFile.delete();
                    fld0.delete();
                    Dialogs.getInstance().showInfoDialog("Die Updates wurden heruntergeladen. Der Update-Prozess wird jetzt gestartet, THEMIS wird dazu beendet. Starten Sie THEMIS neu, um das Update einzuspielen.");
                    Installer.ask = false;
                    LifecycleManager.getDefault().exit();
                    return true;
                }
                case ZIP: {
                    UpdateManager.unzipFile(downloadFile);
                    Dialogs.getInstance().showInfoDialog("Die Updates wurden heruntergeladen und entpackt. Sie k\u00f6nnen die neue Version jetzt verwenden. Sie m\u00fcssen ggf. ihre Verkn\u00fcpfungen auf dem Desktop oder im Startmen\u00fc manuell anpassen. THEMIS wird jetzt beendet.");
                    Installer.ask = false;
                    LifecycleManager.getDefault().exit();
                    return true;
                }
            }
            return true;
        }
        downloadFile.delete();
        Dialogs.getInstance().showInfoDialog("Das Update konnte nicht heruntergeladen werden, bitte nehmen Sie Kontakt mit dem Support auf (info@themis-software.com)");
        return true;
    }

    public boolean updateJRE(boolean noWarning) {
        try {
            String serverUrl = this.getUpdateServer();
            if (serverUrl == null) {
                return false;
            }
            ThemisApplication.getLogger().info("Checking JRE on server " + serverUrl);
            String javaVersionUrl = serverUrl + "java/version.xml";
            SAXBuilder saxbuilder = new SAXBuilder(false);
            InputStream in = Util.getInputStream((URL)new URL(javaVersionUrl));
            Document doc = saxbuilder.build(in);
            Element xml = doc.getRootElement();
            in.close();
            String installedJavaVersion = this.getInstalledJRE();
            ThemisApplication.getLogger().info("Installed JRE is " + installedJavaVersion);
            String javaVersion = installedJavaVersion;
            List builds = xml.getChildren();
            for (Element build : builds) {
                String numberrange = build.getAttributeValue("nr");
                NumberRange range = new NumberRange(numberrange, false);
                if (!range.containsNumber(2146)) continue;
                javaVersion = build.getText();
                break;
            }
            ThemisApplication.getLogger().info("Available JRE on server is " + javaVersion);
            if (installedJavaVersion != null && !installedJavaVersion.equals(javaVersion) && ThemisApplication.getInstance().getDialog().showConfirmDialog("Eine wichtige technische Komponente f\u00fcr THEMIS muss aktualisiert werden. Bitte best\u00e4tigen Sie den Download.")) {
                String finalJavaVersion = javaVersion;
                ThemisTaskWithDialog.createTask("Aktualisierung", ph -> {
                    try {
                        String javaDownloadUrl = serverUrl + "java/" + finalJavaVersion + ".zip";
                        ThemisApplication.getLogger().info("downloading " + javaDownloadUrl);
                        URL urlFile = new URL(javaDownloadUrl);
                        File downloadFile = new File(finalJavaVersion + ".zip");
                        ph.progress("Daten werden heruntergeladen");
                        ThemisApplication.getLogger().info("copying to " + downloadFile.getAbsolutePath());
                        Util.copy((URL)urlFile, (File)downloadFile);
                        ph.progress("Daten werden entpackt");
                        UpdateManager.unzipFile(downloadFile, true);
                        downloadFile.delete();
                        this.updateThemisConfJre(finalJavaVersion, noWarning);
                    }
                    catch (MalformedURLException ex) {
                        ThemisApplication.getLogger().severe("Cannot check JRE:" + ex.getMessage());
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        ThemisApplication.getLogger().severe("Cannot check JRE:" + ex.getMessage());
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
                return true;
            }
        }
        catch (IOException | JDOMException ex) {
            ThemisApplication.getLogger().severe("Cannot check JRE:" + ex.getMessage());
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    public static String getInstalledJRE() {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream("etc/themis.conf"));
            String jre = props.getProperty("jdkhome");
            jre = jre.replaceAll("\"", "");
            return jre.substring(1).replaceAll("/", "");
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Could not update THEMIS configuration file: " + ex.getMessage());
            File fld = new File("").getAbsoluteFile();
            for (File f : fld.listFiles()) {
                if (f == null || !f.isDirectory() || !f.getName().toLowerCase().startsWith("jre")) continue;
                return f.getName().toLowerCase();
            }
            return null;
        }
    }

    public void updateThemisConfJre(String jre, boolean noWarning) {
        try {
            if (jre == null) {
                jre = "";
            }
            Properties props = new Properties();
            props.load(new FileInputStream("etc/themis.conf"));
            String curreentJre = props.getProperty("jdkhome", "");
            if (!curreentJre.equals(jre)) {
                ThemisApplication.getLogger().info("updating config.properties");
                if (jre == null) {
                    props.remove("jdkhome");
                } else {
                    props.setProperty("jdkhome", "./" + jre + "/");
                }
                FileWriter fw = new FileWriter("etc/themis.conf");
                props.store(fw, curreentJre);
                fw.close();
                if (!noWarning) {
                    Dialogs.getInstance().showInfoDialog(this.bundle.getString("Installer.restartTHEMIS"));
                }
            }
        }
        catch (IOException ex) {
            ThemisApplication.getInstance().getProject().getLogger().severe("Could not update THEMIS configuration file: " + ex.getMessage());
        }
    }

    public String getUpdateServer() {
        ArrayList<String> updateUrls = new ArrayList<String>();
        updateUrls.add("https://update.themis-software.at/");
        updateUrls.add("http://update.themis-software.com/");
        for (String updateUrl : updateUrls) {
            if (!Util.checkUrlConnection((String)updateUrl)) continue;
            return updateUrl;
        }
        return null;
    }

    public String isUpdateAvailable() throws JDOMException, IOException {
        return this.execute(true, null) ? "YES" : "NO";
    }

    private void runUpdateInstaller() {
    }

    private void runUpdateZip() {
    }

    private void runUpdateModule() {
    }

    public static File unzipFile(File zipFile) {
        return UpdateManager.unzipFile(zipFile, true);
    }

    public static File unzipFile(File zipFile, boolean createSubfolder) {
        try {
            File destDir;
            int BUFFER = 2048;
            ZipFile zip = new ZipFile(zipFile);
            String zipName = zipFile.getName();
            String unzipName = zipFile.getName().substring(0, zipName.length() - 4);
            File file = destDir = createSubfolder ? new File(zipFile.getParentFile(), unzipName) : zipFile.getParentFile();
            if (createSubfolder && destDir.exists()) {
                FileUtils.deleteDirectory((File)destDir);
            }
            destDir.mkdirs();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(destDir, currentEntry);
                File destinationParent = destFile.getParentFile();
                destinationParent.mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            return destDir;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean doIgnoreUpdate() {
        return this.ignoreUpdates;
    }

    private void showMessage(int messagetype, String title, String msg, boolean forceDialog) {
        this.showMessage(messagetype, title, msg, forceDialog, null);
    }

    private void showMessage(int messagetype, String title, String msg, boolean forceDialog, Exception e) {
        String txt = msg;
        if (this.bundle.containsKey("UpdateManager." + msg)) {
            txt = this.bundle.getString("UpdateManager." + msg);
        }
        String tit = title;
        if (this.bundle.containsKey("UpdateManager." + title)) {
            tit = this.bundle.getString("UpdateManager." + title);
        }
        if (this.isManualUpdate() || forceDialog) {
            if (e == null) {
                Dialogs.getInstance().showInfoDialog(txt);
                ThemisApplication.getInstance().getProject().getLogger().info("  message: " + txt);
            } else {
                Dialogs.getInstance().showErrorDialog(txt, e);
                ThemisApplication.getInstance().getProject().getLogger().severe("  message: " + txt);
            }
        } else {
            THEMIS.notify(messagetype, tit, txt);
            ThemisApplication.getInstance().getProject().getLogger().info("  message: " + txt);
        }
    }

    public int getDaysAfterLastSuccessfulCheck() {
        Date lastUpdateCheck = this.getLastSuccessfulUpdateCheck();
        return (int)((new Date().getTime() - lastUpdateCheck.getTime()) / 86400000L);
    }

    public Date getLastSuccessfulUpdateCheck() {
        String dt = ThemisApplication.getInstance().getConfiguration("system.update.lastcheck", null);
        Date lastUpdateCheck = new Date(new File("themis").lastModified());
        if (dt != null) {
            try {
                lastUpdateCheck = Util.parseDate((String)dt, (String)Util.DATE_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lastUpdateCheck;
    }

    public void setSuccessfulUpdateCheck() {
        ThemisApplication.getInstance().setConfiguration("system.update.lastcheck", Util.formatDate((Date)new Date(), (String)Util.DATE_XML, (TimeZone)ThemisApplication.getInstance().getTimeZone()), true);
    }

    public boolean isUpdateSourceLocal() {
        String conf = ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0");
        return "1".equals(conf);
    }

    public boolean isUpdateBetaProgram() {
        return this.forceBeta || Util.parseInt((String)ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0"), (int)1) >= 2;
    }

    public boolean isUpdateAlphaProgram() {
        return Util.parseInt((String)ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0"), (int)1) >= 3;
    }
}

