/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application;

import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.util.NumberRange;
import at.grid.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UpdatePanel
extends JPanel {
    private String DIALOG_CODE = "updatepanel";
    public static final int DIALOG_WIDTH = 700;
    public static final int DIALOG_HEIGHT = 800;
    ThemisProject project = ThemisApplication.getInstance().getProject();
    boolean execute = false;
    boolean ignoreFor30days = false;
    boolean updateAvailable = false;
    boolean silent = false;
    boolean urgentUpdate = false;
    boolean allowModuleUpdate = true;
    String versionText = "";
    ThemisSettings.UpdateMethod method = ThemisSettings.UpdateMethod.INSTALLER;
    private JButton btnCancel;
    private JButton btnIgnore;
    private JButton btnUpdate;
    private JCheckBox chkNeuinstallatoin;
    private JTextField fldInstalledPath;
    private JTextField fldInstalledVersion;
    private JTextField fldServerDatetime;
    private JTextField fldServerVersion;
    private JTextArea fldServerWhatsnew;
    private JTextField fldUpdateSource;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblBetaProgram;
    private JLabel lblInfoInstaller;
    private JLabel lblServerHint;
    private JLabel lblUpdateInfo;
    private JLabel lblWasIstNeu;

    public UpdatePanel(Element rootelement, ThemisSettings.UpdateMethod method, boolean beta) {
        this(rootelement, beta);
    }

    public UpdatePanel(Element rootelement, boolean beta) {
        this.initComponents();
        String jre = rootelement.getChildText("jre");
        boolean jreUpdateRequired = false;
        if ("".equals(jre)) {
            jre = null;
        }
        if (jre != null) {
            File appFolder = new File("").getAbsoluteFile();
            File jreFolder = new File(appFolder, jre);
            jreUpdateRequired = !jreFolder.isDirectory();
        }
        jreUpdateRequired = false;
        String version = rootelement.getChildText("version");
        String buildnrStr = rootelement.getChildText("buildnr");
        int buildnr = Util.parseInt((String)buildnrStr, (int)0);
        this.versionText = version + "-" + buildnrStr;
        String hint = rootelement.getChildText("hint");
        String type = rootelement.getChildText("type");
        String datetime = rootelement.getChildText("datetime");
        String silentBuildStr = rootelement.getChildText("silent");
        int silentBuild = Util.parseInt((String)silentBuildStr, (int)0);
        this.silent = silentBuild > 0 && 2146 >= silentBuild;
        String fullinstallBuildStr = rootelement.getChildText("fullinstall");
        int fullinstallBuild = Util.parseInt((String)fullinstallBuildStr, (int)0);
        this.allowModuleUpdate = 2146 > fullinstallBuild;
        this.lblInfoInstaller.setVisible(!this.allowModuleUpdate);
        this.btnUpdate.setVisible(this.allowModuleUpdate);
        List whatsnews = rootelement.getChildren("whatsnew");
        StringBuilder sb = new StringBuilder();
        if (jreUpdateRequired) {
            sb.append("Wichtige technische Komponenten m\u00fcssen aktualisiert werden! \n");
        }
        for (Element whatsnew : whatsnews) {
            int whatsnewBuildnr = Util.parseInt((String)whatsnew.getAttributeValue("build", buildnrStr), (int)buildnr);
            if (whatsnewBuildnr <= 2146) continue;
            sb.append("#" + whatsnewBuildnr);
            sb.append(whatsnew.getText());
            sb.append("\n");
        }
        if (sb.length() == 0) {
            sb.append("Keine Updateinfo verf\u00fcgbar");
        }
        String whatsnewStr = sb.toString();
        List urgents = rootelement.getChildren("urgent");
        String urgentInfo = null;
        for (Element urgent : urgents) {
            String urgentBuildNr = urgent.getAttributeValue("build");
            NumberRange nr = new NumberRange(urgentBuildNr, false);
            if (!nr.containsNumber(2146)) continue;
            urgentInfo = urgent.getText();
            break;
        }
        if (beta) {
            this.lblBetaProgram.setText("BETA Programm");
        }
        this.fldInstalledVersion.setText(ThemisProject.VERSION);
        this.fldInstalledPath.setText(new File("").getAbsolutePath());
        this.fldServerVersion.setText(this.versionText);
        this.fldServerDatetime.setText(datetime);
        int fileBuildnr = Util.parseInt((String)buildnrStr, (int)0);
        boolean bl = this.updateAvailable = fileBuildnr > 2146;
        if (this.updateAvailable || jreUpdateRequired) {
            this.lblUpdateInfo.setText(this.updateAvailable ? type + " verf\u00fcgbar" : "Aktualisierung erforderlich");
            if (hint != null && !"".equals(hint)) {
                this.lblServerHint.setText(hint);
            } else {
                this.lblServerHint.setVisible(false);
            }
            this.fldServerWhatsnew.setText(whatsnewStr);
        } else {
            this.lblUpdateInfo.setText("Kein Update verf\u00fcgbar");
            this.lblServerHint.setVisible(false);
            this.lblWasIstNeu.setVisible(false);
            this.jScrollPane1.setVisible(false);
            this.btnUpdate.setText("Trotzdem aktualisieren");
        }
        boolean bl2 = this.urgentUpdate = urgentInfo != null;
        if (this.urgentUpdate) {
            this.lblServerHint.setVisible(true);
            this.lblServerHint.setText("Update dringend durchf\u00fchren");
            this.fldServerWhatsnew.setText(urgentInfo + "\n\n" + whatsnewStr);
        }
        String updateSource = "THEMIS Server";
        String conf = ThemisApplication.getInstance().getConfiguration("system.update.source.selection", "0");
        if ("1".equals(conf)) {
            String fldName;
            updateSource = fldName = ThemisApplication.getInstance().getConfiguration("system.update.source");
        } else if ("2".equals(conf)) {
            updateSource = "THEMIS Server (BETA)";
        } else if ("3".equals(conf)) {
            updateSource = "THEMIS Server (INTERN)";
        }
        this.fldUpdateSource.setText(updateSource);
    }

    public boolean isModuleUpdateAllowed() {
        return this.allowModuleUpdate;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isUrgentUpdate() {
        return this.urgentUpdate;
    }

    public boolean doUpdate() {
        return this.execute;
    }

    public boolean doIgnore() {
        return this.ignoreFor30days;
    }

    public ThemisSettings.UpdateMethod getUpdateMethod() {
        return this.method;
    }

    public String getFilename(ThemisSettings.UpdateMethod method) {
        switch (method) {
            case INSTALLER: {
                return "THEMIS_v" + this.versionText + "_64bit_setup.exe";
            }
            case ZIP: {
                return "THEMIS_v" + this.versionText + ".zip";
            }
        }
        return "THEMIS_v" + this.versionText + "_modules.zip";
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblBetaProgram = new JLabel();
        this.jLabel2 = new JLabel();
        this.fldInstalledVersion = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldInstalledPath = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldUpdateSource = new JTextField();
        this.lblUpdateInfo = new JLabel();
        this.lblServerHint = new JLabel();
        this.jLabel4 = new JLabel();
        this.fldServerVersion = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldServerDatetime = new JTextField();
        this.lblWasIstNeu = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldServerWhatsnew = new JTextArea();
        this.chkNeuinstallatoin = new JCheckBox();
        this.lblInfoInstaller = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCancel = new JButton();
        this.btnIgnore = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.lblBetaProgram.setFont(THEMIS.fontLabelBigBold);
        this.lblBetaProgram.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.lblBetaProgram, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.lblBetaProgram.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblBetaProgram, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        this.jLabel2.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.fldInstalledVersion.setEditable(false);
        this.fldInstalledVersion.setFont(THEMIS.fontTextfield);
        this.fldInstalledVersion.setText(NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.fldInstalledVersion.text"));
        this.fldInstalledVersion.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldInstalledVersion, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        this.jLabel3.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fldInstalledPath.setEditable(false);
        this.fldInstalledPath.setFont(THEMIS.fontTextfield);
        this.fldInstalledPath.setText(NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.fldInstalledPath.text"));
        this.fldInstalledPath.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldInstalledPath, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        this.jLabel6.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.fldUpdateSource.setEditable(false);
        this.fldUpdateSource.setFont(THEMIS.fontTextfield);
        this.fldUpdateSource.setText(NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.fldUpdateSource.text"));
        this.fldUpdateSource.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldUpdateSource, gridBagConstraints);
        this.lblUpdateInfo.setFont(THEMIS.fontLabelBigBold);
        Mnemonics.setLocalizedText((JLabel)this.lblUpdateInfo, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.lblUpdateInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblUpdateInfo, gridBagConstraints);
        this.lblServerHint.setFont(THEMIS.fontLabelBigBold);
        this.lblServerHint.setForeground(Color.red);
        this.lblServerHint.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblServerHint, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.lblServerHint.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblServerHint, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontLabel);
        this.jLabel4.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fldServerVersion.setEditable(false);
        this.fldServerVersion.setFont(THEMIS.fontTextfield);
        this.fldServerVersion.setText(NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.fldServerVersion.text"));
        this.fldServerVersion.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldServerVersion, gridBagConstraints);
        this.jLabel5.setFont(THEMIS.fontLabel);
        this.jLabel5.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.fldServerDatetime.setEditable(false);
        this.fldServerDatetime.setFont(THEMIS.fontTextfield);
        this.fldServerDatetime.setText(NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.fldServerDatetime.text"));
        this.fldServerDatetime.setPreferredSize(new Dimension(120, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldServerDatetime, gridBagConstraints);
        this.lblWasIstNeu.setFont(THEMIS.fontLabel);
        this.lblWasIstNeu.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lblWasIstNeu, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.lblWasIstNeu.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblWasIstNeu, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(300, 200));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 200));
        this.fldServerWhatsnew.setColumns(20);
        this.fldServerWhatsnew.setFont(THEMIS.fontTextfield);
        this.fldServerWhatsnew.setLineWrap(true);
        this.fldServerWhatsnew.setRows(5);
        this.fldServerWhatsnew.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.fldServerWhatsnew);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.chkNeuinstallatoin.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkNeuinstallatoin, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.chkNeuinstallatoin.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.chkNeuinstallatoin, gridBagConstraints);
        this.lblInfoInstaller.setFont(THEMIS.fontLabelBold);
        this.lblInfoInstaller.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.lblInfoInstaller, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.lblInfoInstaller.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblInfoInstaller, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnUpdate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpdate, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.btnUpdate.text"));
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.btnUpdateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnUpdate, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.btnCancel, gridBagConstraints);
        this.btnIgnore.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnIgnore, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.btnIgnore.text"));
        this.btnIgnore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.btnIgnoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 35, 5, 5);
        this.jPanel2.add((Component)this.btnIgnore, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void btnUpdateActionPerformed(ActionEvent evt) {
        this.execute = true;
        this.method = this.chkNeuinstallatoin.isSelected() ? ThemisSettings.UpdateMethod.INSTALLER : ThemisSettings.UpdateMethod.MODULE;
        this.closeDialog();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnIgnoreActionPerformed(ActionEvent evt) {
        this.ignoreFor30days = true;
        this.closeDialog();
    }

    public void showDialog() {
        JDialog dlg = THEMIS.createDialog(this.project.getResourceText("dialog." + this.DIALOG_CODE + ".title"), this, true, true);
        THEMIS.setAssistantMoveListener(dlg);
        dlg.pack();
        Dimension windowSize = new Dimension(700, dlg.getHeight());
        dlg.setSize(windowSize);
        dlg.setPreferredSize(windowSize);
        dlg.setVisible(true);
    }

    private void closeDialog() {
        JDialog parent = (JDialog)this.getRootPane().getParent();
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, parent);
        parent.dispose();
    }
}

