/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.action;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.action.ribbon.ToggleRibbonAction;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.project.ProjectHelper;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

public final class CloseProjectAction
extends ToggleRibbonAction
implements ActionListener {
    public CloseProjectAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle"), "CTL_CloseAction", "at/grid/themis/application/media/action_closeProject.gif", "TOP");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (project == null || !project.isOpen()) {
            Dialogs.getInstance().showWarningDialog(app.getProject().getResourceText("app.core.text.noproject", app.getLocale()));
            ViewHelper.showStartScreen();
            return;
        }
        Closing closing = THEMIS.getCloseProjectFeedback(new Closing());
        if (closing.dontClose) {
            return;
        }
        String msg = "progress.saving-project";
        if (!closing.withSave) {
            msg = "Das Projekt wird geschlossen ...";
        }
        ThemisTaskWithDialog.createTask(msg, ph -> ProjectHelper.closeProject(closing, ph));
        ViewHelper.showStartScreen();
    }
}

