/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.action;

import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ThemisActions;
import at.grid.themis.application.action.ribbon.DefaultRibbonAction;
import at.grid.themis.application.camera.QRCodeDetector;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.barcode.Barcode;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class ScanBarcodeAction
extends DefaultRibbonAction {
    public ScanBarcodeAction() {
        super(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle"), "CTL_ScanBarcodeAction", "at/grid/themis/application/media/qr-code.gif", "MEDIUM");
        this.putValue("INITIAL_ACTION", "HIDE");
        this.putValue("HAS_ACTION", true);
        this.putValue(ThemisAction.PROJECT_OPENED.getAction() + "", "TOGGLE_BARCODE");
        this.putValue(ThemisAction.PROJECT_CLOSED.getAction() + "", "HIDE");
        this.putValue(ThemisAction.SETTINGS_CHANGED.getAction() + "", "TOGGLE_BARCODE");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        String barcodeResult = QRCodeDetector.showDialog();
        if (barcodeResult != null && !barcodeResult.isEmpty()) {
            boolean found = false;
            if (ThemisApplication.getInstance().getSettings().getLocationAttribute("barcode").isUsed()) {
                found = this.selectLocationsByBarcode(barcodeResult);
            }
            if (!found) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(barcodeResult), null);
                THEMIS.dismissNotify(5, THEMIS.notify(1, this.bundle.getString("Barcode.clipboard.title"), this.bundle.getString("Barcode.clipboard.text")));
            }
        }
    }

    private boolean selectLocationsByBarcode(String barcode) {
        HashMap planMap = new HashMap();
        ArrayList<Long> locIds = new ArrayList<Long>();
        for (DataRecord r : Barcode.findLocationsForBarcode((String)barcode)) {
            long locId = r.getLong("meta_id");
            locIds.add(locId);
            long planId = r.getLong("idplan", Long.valueOf(-1L));
            if (!planMap.containsKey(planId)) {
                ArrayList<Long> locs = new ArrayList<Long>();
                locs.add(locId);
                planMap.put(planId, locs);
                continue;
            }
            ((List)planMap.get(planId)).add(locId);
        }
        if (locIds.size() > 0) {
            long planId;
            ThemisApplication.getInstance().getProject().getSelectionManager().setSelectedLocations(locIds, true, (Object)this);
            if (planMap.keySet().size() == 1 && (planId = ((Long)planMap.keySet().iterator().next()).longValue()) >= 0L) {
                List locs = (List)planMap.get(planId);
                if (locs.size() == 1) {
                    ThemisActions.showLocationInPlan(planId, (Long)locs.get(0));
                } else {
                    ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(planId));
                }
            }
            return true;
        }
        return false;
    }
}

