/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.action;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.action.ActionProvider;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import javax.swing.SwingUtilities;

public class ThemisActionProvider
extends ActionProvider {
    private static long invokeId = 0L;
    private static ThemisActionProvider provider = new ThemisActionProvider();

    public static ThemisActionProvider getInstance() {
        return provider;
    }

    public static void enable() {
        provider.setActive(true);
    }

    public static void disable() {
        provider.setActive(false);
    }

    public synchronized void invokeAction(ThemisAction a, boolean force) {
        boolean bl;
        ThemisApplication.getInstance().getProject().getLogger().fine("INVOKE " + a.toString() + (force ? " WITH FORCE" : "") + (this.isActive() ? "" : " BUT INACTIVE") + (this.secondaryAction ? " IS SECONDARY ACTION" : ""));
        if (a.getAction() == 1101 && this.secondaryAction) {
            bl = false;
        }
        if (a.getAction() < 0) {
            bl = false;
        }
        if (this.isActive() && !this.secondaryAction || force) {
            ++invokeId;
            if (a.isWaitForExecution()) {
                ThemisApplication.getInstance().getProject().getLogger().fine("INVOKE #" + invokeId + " AND WAIT");
                this.secondaryAction = true;
                for (ThemisActionListener listener : this.getRelevantListeners()) {
                    listener.onAction(a);
                }
                this.secondaryAction = false;
                a.reset();
            } else {
                ThemisApplication.getInstance().getProject().getLogger().fine("INVOKE #" + invokeId + ": " + a.toString() + " ... calling invoker");
                ActionInvoker invoker = new ActionInvoker(a, this, invokeId);
                SwingUtilities.invokeLater(invoker);
            }
        }
    }

    class ActionInvoker
    implements Runnable {
        ThemisAction a;
        ThemisActionProvider ap;
        long id = 0L;

        public ActionInvoker(ThemisAction a, ThemisActionProvider ap) {
            this.a = a;
            this.ap = ap;
        }

        public ActionInvoker(ThemisAction a, ThemisActionProvider ap, long id) {
            this.a = a;
            this.ap = ap;
            this.id = id;
        }

        @Override
        public void run() {
            ThemisApplication.getInstance().getProject().getLogger().fine("INVOKE #" + invokeId + ": " + this.a.toString() + " ... running invoker" + (this.ap.isActive() ? "" : " - BUT NOT ACTIVE"));
            if (this.ap.isActive()) {
                this.ap.secondaryAction = true;
                ThemisApplication.getInstance().getProject().getLogger().fine("executing action " + this.a.getAction() + " on " + this.ap.getRelevantListeners().size() + " listeners");
                for (ThemisActionListener listener : this.ap.getRelevantListeners()) {
                    listener.onAction(this.a);
                }
                this.ap.secondaryAction = false;
            }
            this.a.reset();
        }
    }
}

