/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.action;

import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.application.PlanPanel;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.element.ElementDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.Util;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ThemisActions {
    public static CmsElement createEvent() {
        CmsElement ele;
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (!project.isOpen() || ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return null;
        }
        if (project.isOpen() && ElementDialog.show(ele = project.createElement("event"))) {
            project.setCurrentEvent((CmsEvent)ele);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.EVENT_SAVED);
            return ele;
        }
        return null;
    }

    public static void createTopic() {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (project.isOpen()) {
            CmsElement ele = project.createElement("company");
            if (ElementDialog.show(ele)) {
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.COMPANY_SAVED);
            }
        } else {
            Dialogs.getInstance().showWarningDialog(app.getProject().getResourceText("app.core.text.noproject", app.getLocale()));
        }
    }

    public static int editPlan(CmsPlan ele) {
        return ThemisActions.editPlan(ele, null, false);
    }

    public static int editPlan(CmsPlan ele, boolean newVersion) {
        return ThemisActions.editPlan(ele, null, newVersion);
    }

    public static int editPlan(CmsPlan ele, File f, boolean newVersion) {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return 0;
        }
        if (ele != null) {
            PlanPanel planPanel = new PlanPanel(ele, f, newVersion);
            planPanel.showDialog();
            return planPanel.getPlanCount();
        }
        return 0;
    }

    public static int editPlan(CmsPlan ele, List<File> files) {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return 0;
        }
        if (ele != null) {
            PlanPanel planPanel = new PlanPanel(ele, files);
            planPanel.showDialog();
            return planPanel.getPlanCount();
        }
        return 0;
    }

    public static void showPlan(CmsElementSummary e) {
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(e.getId()));
    }

    public static void setCurrenetEvent(CmsElementSummary ele) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        long currentEventId = project.getCurrentEventId();
        app.getFilter().resetSearchResult();
        if (project.isOpen()) {
            if (ele == null) {
                project.setCurrentEvent(null);
                project.createActionLog("event_setinactive", currentEventId, "");
            } else if (currentEventId != ele.getId()) {
                project.setCurrentEvent((CmsEvent)ele.getElement(project.getUser()));
                project.createActionLog("event_setactive", currentEventId, "");
            }
        }
    }

    public static boolean deleteLocation(long id) {
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return false;
        }
        ArrayList<Long> lst = new ArrayList<Long>();
        lst.add(id);
        return ThemisActions.deleteLocations(lst);
    }

    public static boolean deleteLocations(List<Long> ids) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle");
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return false;
        }
        if (ids.isEmpty()) {
            return false;
        }
        boolean noDeletePossible = false;
        long copyId = project.getCopiedLocationId();
        StringBuilder sb = new StringBuilder();
        ArrayList<CmsElement> deleteElements = new ArrayList<CmsElement>();
        for (Long locIds : ids) {
            CmsElement ele = project.loadElement(locIds.longValue(), project.getUser());
            if (ele instanceof CmsLocation && ((CmsLocation)ele).isBuilding() && !project.getPlansForBuilding(ele.getId()).isEmpty()) {
                Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/planviewer/planlist/Bundle").getString("ManagerTopComponent.stillMapsProvidedForBuilding.text"));
                continue;
            }
            List obsIds = ele.getRelationAttribute("observations").getElementIds();
            String sql = "SELECT o.idelement FROM tdtaEleObservation AS o INNER JOIN tdtaElement AS ele ON de(o.idelement=ele.idelement AND NOT ele.deleted) INNER JOIN tdtaRelation AS r1 ON (o.idelement=r1.elementto AND r1.relationcode='historyobservation') INNER JOIN tdtaRelation AS r2 ON (r1.elementfrom=r2.elementfrom AND r2.relationcode='historyevent') INNER JOIN tdtaEleEvent AS e ON (r2.elementto=e.idelement) INNER JOIN tdtaFileUpload AS f ON (f.idelement=e.elementto AND f.code='signature') WHERE o.idelement IN " + Util.toSqlString((Iterable)obsIds);
            if (obsIds.isEmpty() || project.getDatastorage().executeQuery(sql, true).isEmpty()) {
                deleteElements.add(ele);
                sb.append("  - ").append(ele.getTitle()).append("\n");
                continue;
            }
            noDeletePossible = true;
        }
        if (ids.contains(copyId)) {
            project.clearCopiedLocationId();
        }
        if (noDeletePossible) {
            Dialogs.getInstance().showWarningDialog(bundle.getString("ThemisActions.deleteLocationsNotPossibleForAll.text"));
        }
        boolean remove = false;
        if (!deleteElements.isEmpty()) {
            remove = deleteElements.size() == 1 ? Dialogs.getInstance().showConfirmDialog(MessageFormat.format(bundle.getString("ThemisActions.deleteLocation.text"), sb.toString()), bundle.getString("ThemisActions.deleteLocationsShort.text")) : (deleteElements.size() < 5 ? Dialogs.getInstance().showConfirmDialog(MessageFormat.format(bundle.getString("ThemisActions.deleteLocationPlural.text"), sb.toString()), bundle.getString("ThemisActions.deleteLocationShortPlural.text")) : Dialogs.getInstance().showConfirmDialog(MessageFormat.format(bundle.getString("ThemisActions.deleteLocationPlural.text"), "  " + deleteElements.size() + " Gegenst\u00e4nde"), bundle.getString("ThemisActions.deleteLocationShortPlural.text")));
        }
        if (remove) {
            for (CmsElement del : deleteElements) {
                del.moveToTrash();
                project.getSelectionManager().removeSelectedLocation(del.getId(), false, null);
            }
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_DELETED);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.SELECTION_CHANGED);
        }
        return true;
    }

    public static void reviewObservation(int status) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            return;
        }
        if (!project.isOpen() || project.getCurrentEventId() < 0L) {
            Dialogs.getInstance().showWarningDialog(app.getProject().getResourceText("app.core.text.noevent", app.getLocale()));
            return;
        }
        if (project.checkForCurrentEvent(false) && project.isEditFutureData()) {
            return;
        }
        String newStatus = "?";
        String statusInfo = " ";
        switch (status) {
            case 2: {
                newStatus = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.done.text");
                statusInfo = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.markObsDone.text");
                break;
            }
            case 1: {
                newStatus = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.undone.text");
                statusInfo = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.markObsUndone.text");
                break;
            }
            case 4: {
                newStatus = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.checked.text");
                statusInfo = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.markObsChecked.text");
                break;
            }
            case 3: {
                newStatus = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.unchecked.text");
                statusInfo = ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.markObsUnchecked.text");
            }
        }
        ArrayList sel = project.getSelectionManager().getSelectedObservationIds();
        if (sel.size() > 0) {
            Object type;
            ArrayList<Long> notmodified = new ArrayList<Long>();
            String msg = "";
            if (sel.size() > 1) {
                msg = MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.markObsAs.text"), sel.size(), newStatus);
            } else {
                type = project.getDatastorage().getElementAttribute(((Long)sel.get(0)).longValue(), "type");
                if ((Integer.toString(2).equals(type) || Integer.toString(3).equals(type)) && (status == 2 || status == 1)) {
                    Dialogs.getInstance().showErrorDialog("error.statusDoneNotAllowedForCheckAndInfo");
                    return;
                }
                String obs = project.getDatastorage().getElementTitle(((Long)sel.get(0)).longValue());
                msg = MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.markObservationsAsNotif.text"), obs, newStatus, project.getCurrentEvent().getTitle());
            }
            if (Dialogs.getInstance().showConfirmDialog(msg, statusInfo) && sel.size() > 0) {
                type = sel.iterator();
                while (type.hasNext()) {
                    long id = (Long)type.next();
                    switch (status) {
                        case 2: {
                            project.setObservationAsDoneNotDone(id, true, false);
                            break;
                        }
                        case 1: {
                            project.setObservationAsDoneNotDone(id, false, false);
                            break;
                        }
                        case 4: {
                            project.setObservationAsReviewed(id, false);
                            break;
                        }
                        case 3: {
                            if (project.setObservationAsNotReviewed(id, false)) break;
                            notmodified.add(id);
                        }
                    }
                }
                app.getFilter().resetSearchResult();
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(((Long)sel.get(sel.size() - 1)).longValue()));
            }
            if (!notmodified.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Long obsid : notmodified) {
                    sb.append("\n  - ").append(project.getDatastorage().getElementTitle(obsid.longValue()));
                }
                Dialogs.getInstance().showWarningDialog(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.cannotDeleteObs.text"), sb.toString()));
            }
            project.updateCurrentEvent();
        }
    }

    public static void showLocationInPlan(long idPlan, long idLoc) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        long currentPlan = project.getCurrentPlanId();
        if (currentPlan != idPlan) {
            project.setCurrentPlanId(idPlan);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(idPlan));
        }
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_ZOOM_TO.setId(idLoc));
    }

    public static void showObservationInPlan() {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (project.getSelectionManager().hasSelectedObservationIds()) {
            long obsid = (Long)project.getSelectionManager().getSelectedObservationIds().get(0);
            CmsObservation obs = null;
            if (obsid > 0L) {
                obs = (CmsObservation)project.loadElement(obsid, project.getUser());
            }
            if (obs != null) {
                RelationAttribute loc = obs.getRelationAttribute("location");
                long locationid = loc.getFirstElementId();
                CmsLocation location = (CmsLocation)project.loadElement(locationid, project.getUser());
                if (obs.getRelationAttribute("plan").isEmpty() && location.getAttributeValue("plan").isEmpty()) {
                    Dialogs.getInstance().showWarningDialog(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.noMapAssigned.text"));
                } else {
                    long planid = obs.getRelationAttribute("plan").getFirstElementId();
                    if (planid < 0L) {
                        planid = location.getRelationAttribute("plan").getFirstElementId();
                    }
                    ThemisActions.showLocationInPlan(planid, locationid);
                }
            }
        } else {
            Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/application/action/Bundle").getString("ThemisActions.selObsOrLoc.text"));
        }
    }
}

