/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.action;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.demo.SelectDemoProjectFxPanel;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.template.TemplateDescription;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javafx.scene.Node;
import org.netbeans.api.progress.BaseProgressUtils;

public final class UnpackDemoProjectsAction
implements ActionListener {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        File dest = this.app.getSettings().getFolderProjectRoot().getValue(true);
        File src = this.app.getSettings().getFolderDemoUnpack().getValue(true);
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("demoprojects", 800, 600).setParentFrame(THEMIS.getMainWindow());
        SelectDemoProjectFxPanel fx = new SelectDemoProjectFxPanel();
        JavaFxDialog fxDialog = new JavaFxDialog((Node)fx);
        fxDialog.addCancelButton("Abbrechen").setOnAction(ev -> {
            fxDialog.closeDialog();
            dlg.close();
        });
        fxDialog.addSaveButton("Speichern").setOnAction(ev -> {
            final TemplateDescription currentItem = fx.getCurrentItem();
            if (currentItem == null) {
                ThemisApplication.getInstance().getDialog().showErrorDialog("Es ist nichts ausgew\u00e4hlt");
            } else {
                File sel = this.app.getSettings().getFolderDemoUnpack().getValue(false);
                final File fld = new ThemisFileDialog("Ordner ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, sel, null, null, null, false).getSelectedFile();
                if (fld != null) {
                    this.app.getSettings().getFolderDemoUnpack().setValue(fld);
                    BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (currentItem.saveToFile(fld)) {
                                THEMIS.showFileResultDialog(new File(fld, currentItem.getFileToShow().getName()), currentItem.doShow());
                            }
                        }
                    }, (String)this.project.getResourceText("Daten speichern"));
                }
            }
        });
        dlg.setContent((Node)fxDialog);
        dlg.show();
    }
}

