/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.action;

import at.grid.themis.ontology.license.ThemisLicense;
import javax.swing.SwingUtilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ViewHelper {
    private static void openAndShow(TopComponent t, boolean allowMinimised) {
        if (t != null) {
            if (!allowMinimised) {
                WindowManager.getDefault().setTopComponentMinimized(t, false);
            } else {
                WindowManager.getDefault().setTopComponentMinimized(t, true);
            }
            t.open();
            t.requestActive();
        }
    }

    private static synchronized void openAndShow(TC tc, boolean allowMinimised) {
        if (tc != null) {
            boolean reducedLicense = ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
            switch (tc) {
                case IMPORT_PHOTO: {
                    if (!reducedLicense) break;
                    return;
                }
            }
            SwingUtilities.invokeLater(() -> {
                if (tc.isInExplorer()) {
                    for (TC ttc : TC.values()) {
                        if (ttc == tc) {
                            ViewHelper.openAndShow(WindowManager.getDefault().findTopComponent(tc.getTag()), allowMinimised);
                            continue;
                        }
                        if (!ttc.isInExplorer() || ttc == TC.LOCATION_LIST) continue;
                        ViewHelper.close(ttc);
                    }
                } else {
                    ViewHelper.openAndShow(WindowManager.getDefault().findTopComponent(tc.getTag()), allowMinimised);
                }
            });
        }
    }

    private static void close(TopComponent t) {
        if (t != null) {
            t.close();
        }
    }

    private static synchronized void close(TC tc) {
        if (tc != null) {
            ViewHelper.close(WindowManager.getDefault().findTopComponent(tc.getTag()));
        }
    }

    public static synchronized void openExplorerTopComponent(final TC tc) {
        if (tc == null || !tc.isInExplorer()) {
            return;
        }
        boolean reducedLicense = ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        switch (tc) {
            case IMPORT_PHOTO: {
                if (!reducedLicense) break;
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (TC ttc : TC.values()) {
                    if (ttc == tc) {
                        ViewHelper.openAndShow(ttc, false);
                        continue;
                    }
                    if (!ttc.isInExplorer() || ttc == TC.LOCATION_LIST) continue;
                    ViewHelper.close(ttc);
                }
            }
        });
    }

    public static synchronized void showStartScreen() {
        block3: for (TC tc : TC.values()) {
            switch (tc) {
                case FIRST_START: {
                    ViewHelper.openAndShow(tc, false);
                    continue block3;
                }
                default: {
                    ViewHelper.close(tc);
                }
            }
        }
    }

    public static void showOpenProject() {
        block4: for (TC tc : TC.values()) {
            switch (tc) {
                case PLAN: 
                case EVENT: 
                case PHOTO_VIEWER: 
                case OBSERVATION_LIST: {
                    ViewHelper.openAndShow(tc, false);
                    continue block4;
                }
                case FILTER: {
                    ViewHelper.openAndShow(tc, true);
                    continue block4;
                }
                default: {
                    ViewHelper.close(tc);
                }
            }
        }
    }

    public static synchronized void showPhotoViewer() {
        ViewHelper.openAndShow(TC.PHOTO_VIEWER, false);
    }

    public static synchronized void showChecklistEditor() {
        ViewHelper.openAndShow(TC.CHECKLIST, false);
    }

    public static synchronized void showEventList() {
        ViewHelper.openAndShow(TC.EVENT, false);
    }

    public static synchronized void showProjectDetails() {
        ViewHelper.openAndShow(TC.PROJECT, false);
    }

    public static synchronized void showPlanList() {
        ViewHelper.openAndShow(TC.PLANLIST, false);
    }

    public static synchronized void showTrash() {
        ViewHelper.openAndShow(TC.TRASH, false);
    }

    public static synchronized void showStatistics() {
        ViewHelper.openAndShow(TC.PROJECT_OVERVIEW, false);
    }

    public static synchronized void showCommunication() {
        ViewHelper.openAndShow(TC.COMMUNICATION, false);
    }

    public static synchronized void showDocuments() {
        ViewHelper.openAndShow(TC.DOCUMENTS, false);
    }

    public static synchronized void showEmailSync() {
        ViewHelper.openAndShow(TC.EMAIL_SYNC, false);
    }

    public static synchronized void showPhotoImport() {
        ViewHelper.openAndShow(TC.IMPORT_PHOTO, false);
    }

    public static synchronized void closeStartScreen() {
        ViewHelper.close(TC.FIRST_START);
    }

    public static synchronized void showLocationlist() {
        ViewHelper.openAndShow(TC.LOCATION_LIST, false);
    }

    public static synchronized void showFormList() {
        ViewHelper.openAndShow(TC.FORM_LIST, false);
    }

    public static synchronized void showChecklist() {
        ViewHelper.openAndShow(TC.OBSERVATION_CONTROL, false);
    }

    public static synchronized void showObservationHistory() {
        ViewHelper.openAndShow(TC.OBSERVATION_VIEWER, false);
    }

    public static synchronized void showTemplates() {
        ViewHelper.openAndShow(TC.TEMPLATE, false);
    }

    public static synchronized void showCalendar() {
        ViewHelper.openAndShow(TC.CALENDAR, false);
    }

    public static synchronized void showSpecialFeatures() {
        ViewHelper.openAndShow(TC.SPECIAL_FEATURE, false);
    }

    public static synchronized void closeIDELog() {
        ViewHelper.close(TC.OUTPUT);
    }

    public static synchronized void showPlan() {
        ViewHelper.openAndShow(TC.PLAN, false);
    }

    public static void setWindowMode(TC tc, WindowMode windowMode) {
        ViewHelper.setWindowMode(WindowManager.getDefault().findTopComponent(tc.getTag()), windowMode);
    }

    public static void setWindowMode(TopComponent w, WindowMode m) {
        Mode mode = null;
        switch (m) {
            case EDITOR: {
                mode = WindowManager.getDefault().findMode("editor");
                break;
            }
            case OUTPUT: {
                mode = WindowManager.getDefault().findMode("output");
                break;
            }
            case EXPLORER: {
                mode = WindowManager.getDefault().findMode("explorer");
            }
        }
        if (mode != null && w != null) {
            mode.dockInto(w);
            w.open();
            w.requestActive();
        }
    }

    public static enum WindowMode {
        EDITOR,
        OUTPUT,
        EXPLORER;

    }

    public static enum TC {
        FIRST_START("ThemisWelcomeTopComponent", false),
        PHOTO_VIEWER("PhotoViewerTopComponent", false),
        CHECKLIST("ChecklistTopComponent", false),
        PLAN("PlanTopComponent", false),
        PROJECT_OVERVIEW("ProjectOverviewTopComponent", false),
        CALENDAR("CalendarTopComponent", true),
        COMMUNICATION("CommunicationTopComponent", true),
        DOCUMENTS("DocumentsTopComponent", true),
        EVENT("EventTopComponent", true),
        LOCATION_LIST("LocationListTopComponent", true),
        FORM_LIST("FormListTopComponent", true),
        IMPORT_PHOTO("ImportPhotoTopComponent", true),
        PLANLIST("ManagerTopComponent", true),
        OBSERVATION_CONTROL("ObservationControlTopComponent", true),
        OBSERVATION_VIEWER("ObservationViewerTopComponent", true),
        PROJECT("ProjectTopComponent", true),
        SPECIAL_FEATURE("SpecialFeatureTopComponent", true),
        EMAIL_SYNC("EmailSyncTopComponent", true),
        TEMPLATE("TemplateTopComponent", true),
        TRASH("TrashTopComponent", true),
        TEMPLATEMATCHING("TemplateMatchingTopComponent", true),
        SUPPORT("SupportTopComponent", true),
        OBSERVATION_LIST("ObservationListTopComponent", false),
        OUTPUT("output", false),
        FILTER("FilterNewTopComponent", false),
        ANY("", true);

        final String tag;
        final boolean inExplorer;
        boolean isMinimised = false;

        private TC(String tag, boolean inExplorer) {
            this.tag = tag;
            this.inExplorer = inExplorer;
        }

        public String getTag() {
            return this.tag;
        }

        public boolean isInExplorer() {
            return this.inExplorer;
        }
    }
}

