/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.api;

import at.grid.themis.application.THEMIS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

public class Accordion
extends JPanel
implements ActionListener {
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private Map bars = new LinkedHashMap();
    private int visibleBar = 0;
    private JComponent visibleComponent = null;

    public Accordion() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
    }

    public void addBar(String name, JComponent component) {
        BarInfo barInfo = new BarInfo(name, component);
        barInfo.getButton().addActionListener(this);
        this.bars.put(name, barInfo);
        this.render();
    }

    public void addBar(String name, Icon icon, JComponent component) {
        BarInfo barInfo = new BarInfo(name, icon, component);
        barInfo.getButton().addActionListener(this);
        this.bars.put(name, barInfo);
        this.render();
    }

    public void removeBar(String name) {
        this.bars.remove(name);
        this.render();
    }

    public int getVisibleBar() {
        return this.visibleBar;
    }

    public void setVisibleBar(int visibleBar) {
        if (visibleBar >= 0 && visibleBar < this.bars.size() - 1) {
            this.visibleBar = visibleBar;
            this.render();
        }
    }

    public void render() {
        int totalBars = this.bars.size();
        int topBars = this.visibleBar + 1;
        int bottomBars = totalBars - topBars;
        Iterator itr = this.bars.keySet().iterator();
        this.topPanel.removeAll();
        GridLayout topLayout = (GridLayout)this.topPanel.getLayout();
        topLayout.setRows(topBars);
        topLayout.setVgap(5);
        topLayout.setHgap(5);
        BarInfo barInfo = null;
        for (int i = 0; i < topBars; ++i) {
            String barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            this.topPanel.add(barInfo.getButton());
        }
        this.topPanel.validate();
        if (this.visibleComponent != null) {
            this.remove(this.visibleComponent);
        }
        this.visibleComponent = barInfo.getComponent();
        this.add((Component)this.visibleComponent, "Center");
        this.bottomPanel.removeAll();
        GridLayout bottomLayout = (GridLayout)this.bottomPanel.getLayout();
        bottomLayout.setRows(bottomBars);
        for (int i = 0; i < bottomBars; ++i) {
            String barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            this.bottomPanel.add(barInfo.getButton());
        }
        this.bottomPanel.validate();
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentBar = 0;
        for (String barName : this.bars.keySet()) {
            BarInfo barInfo = (BarInfo)this.bars.get(barName);
            if (barInfo.getButton() == e.getSource()) {
                this.visibleBar = currentBar;
                this.render();
                return;
            }
            ++currentBar;
        }
    }

    public static JPanel getDummyPanel(String name) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JLabel(name, 0));
        return panel;
    }

    public static void main(String[] args) {
    }

    class BarInfo {
        private String name;
        private JButton button;
        private JComponent component;

        public BarInfo(String name, JComponent component) {
            this.name = name;
            this.component = component;
            this.button = new JButton(name);
            this.setButtonStyle();
        }

        private void setButtonStyle() {
            this.button.setMinimumSize(new Dimension(125, 35));
            this.button.setPreferredSize(new Dimension(125, 35));
            this.button.setMargin(new Insets(0, 10, 0, 10));
            this.button.setHorizontalAlignment(0);
            this.button.setBackground(new Color(240, 240, 240));
            this.button.setBorder(new SoftBevelBorder(0));
            this.button.setFont(THEMIS.fontSubheading);
        }

        public BarInfo(String name, Icon icon, JComponent component) {
            this.name = name;
            this.component = component;
            this.button = new JButton(name, icon);
            this.setButtonStyle();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JButton getButton() {
            return this.button;
        }

        public JComponent getComponent() {
            return this.component;
        }
    }
}

