/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.api;

import at.grid.cms.util.Pair;
import at.grid.gui.ProgressFrame;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.DialogPanel;
import at.grid.themis.application.api.OpenLockedProjectPanel;
import at.grid.themis.application.api.ThemisPanelInterface;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.communication.ThemisDialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Dialogs
implements ThemisDialog {
    private Icon iconError = null;
    private Icon iconQuestion = null;
    private Icon iconWarning = null;
    private Icon iconInfo = null;
    private String widthPane = "200px";
    private Font fontfamily = null;
    public static final String[] optionsNoYes = new String[]{ResourceBundle.getBundle("at/grid/themis/application/api/Bundle").getString("Dialogs.yes"), ResourceBundle.getBundle("at/grid/themis/application/api/Bundle").getString("Dialogs.no")};
    public static final String[] optionsCancelOk = new String[]{ResourceBundle.getBundle("at/grid/themis/application/api/Bundle").getString("Dialogs.cancel"), ResourceBundle.getBundle("at/grid/themis/application/api/Bundle").getString("Dialogs.ok")};
    private static Dialogs instance = new Dialogs();
    ThemisApplication app = ThemisApplication.getInstance();

    protected Dialogs() {
        this.iconError = new ImageIcon(Dialogs.class.getResource("/at/grid/themis/application/media/errorMessage32.gif"));
        this.iconQuestion = new ImageIcon(Dialogs.class.getResource("/at/grid/themis/application/media/questionMessage32.gif"));
        this.iconWarning = new ImageIcon(Dialogs.class.getResource("/at/grid/themis/application/media/warningMessage32.gif"));
        this.iconInfo = new ImageIcon(Dialogs.class.getResource("/at/grid/themis/application/media/infoMessage32.gif"));
        this.fontfamily = THEMIS.fontLabel;
        this.widthPane = THEMIS.widthMessageDialogs;
    }

    public static Dialogs getInstance() {
        return instance;
    }

    private String formatMessage(String message, boolean translate) {
        String txt = translate ? this.app.getProject().getResourceText(message) : message;
        return "<html><body><p style='width: " + this.widthPane + "; font-family:" + this.fontfamily.getName() + ";'>" + txt.replace("\n", "<br>") + "</p></body></html>";
    }

    private String formatMessage(String message) {
        return this.formatMessage(message, true);
    }

    private String formatString(String text) {
        return "<html><body><p style='font-family:" + this.fontfamily.getName() + ";'>" + this.app.getProject().getResourceText(text).replace("\n", "<br>") + "</p></body></html>";
    }

    public void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(message), this.app.getProject().getResourceText("app.core.text.errormessage"), 0, this.iconError);
    }

    public void showErrorDialog(String message, Object[] params) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(txt, false), this.app.getProject().getResourceText("app.core.text.errormessage"), 0, this.iconError);
    }

    public void showErrorDialog(String message, String ... params) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(txt, false), this.app.getProject().getResourceText("app.core.text.errormessage"), 0, this.iconError);
    }

    public void showErrorDialog(String message, Exception ex) {
        if (ex != null) {
            message = this.app.getProject().getResourceText(message) + "<br><br>" + this.app.getProject().getResourceText("app.core.text.error") + ": " + ex;
        }
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(message), this.app.getProject().getResourceText("app.core.text.errormessage"), 0, this.iconError);
    }

    public void showInfoDialog(String message) {
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(message), this.app.getProject().getResourceText("app.core.text.infomessage"), 0, this.iconInfo);
    }

    public void showInfoDialog(String message, Object ... params) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(txt, false), this.app.getProject().getResourceText("app.core.text.infomessage"), 0, this.iconInfo);
    }

    public void showInfoMessageDialog(String message, String title) {
        new DialogPanel(title, message);
    }

    public void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(message), this.app.getProject().getResourceText("app.core.text.warningmessage"), 0, this.iconWarning);
    }

    public void showWarningDialog(String message, Object[] params) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        JOptionPane.showMessageDialog(THEMIS.getMainWindow(), this.formatMessage(txt, false), this.app.getProject().getResourceText("app.core.text.warningmessage"), 0, this.iconWarning);
    }

    public boolean showConfirmDialog(String message) {
        return this.showConfirmDialog(message, "");
    }

    public boolean showConfirmDialog(String message, String title) {
        return this.showConfirmDialog(message, title, optionsNoYes);
    }

    public boolean showConfirmDialog(String message, String title, Object ... params) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        return this.showConfirmDialog(txt, title, optionsNoYes);
    }

    public boolean showConfirmDialog(String message, String title, String[] specOptions) {
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), this.formatMessage(message, true), this.app.getProject().getResourceText(title), 0, 3, this.iconQuestion, specOptions, specOptions[0]) == 0;
    }

    public int showConfirmDialogWithOptions(String message, String title, String[] specOptions) {
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), this.formatMessage(message), this.app.getProject().getResourceText(title), 0, 3, this.iconQuestion, specOptions, specOptions[0]);
    }

    public int showConfirmDialogWithOptions(String message, String title, Object[] params, String[] specOptions) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), this.formatMessage(txt, false), this.app.getProject().getResourceText(title), 0, 3, this.iconQuestion, specOptions, specOptions[0]);
    }

    public String showInputDialog(String message, String title) {
        return JOptionPane.showInputDialog(THEMIS.getMainWindow(), this.formatMessage(message), this.app.getProject().getResourceText(title), -1);
    }

    public String showInputDialogFilled(String message, String initialValue) {
        return JOptionPane.showInputDialog(THEMIS.getMainWindow(), this.formatMessage(message), initialValue);
    }

    public boolean showOptionDialog(String message, String title, Object[] options) {
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), this.formatMessage(message), title, 0, 3, this.iconQuestion, options, options[0]) == 0;
    }

    public int showInfoOptionDialog(String message, String title, Object[] options) {
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), this.formatMessage(message), title, -1, 3, this.iconInfo, options, options[0]);
    }

    public int showInfoOptionDialog(String message, String title, Object[] params, Object[] options) {
        String txt = MessageFormat.format(ThemisApplication.getInstance().getProject().getResourceText(message), params);
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), this.formatMessage(txt, false), title, -1, 3, this.iconInfo, options, options[0]);
    }

    public JDialog showDialogWithPanel(JPanel panel, String title) {
        JDialog dlg = THEMIS.createDialog(title, panel, true, true);
        dlg.setVisible(true);
        return dlg;
    }

    public boolean showDialog(JPanel panel, String title) {
        String t = ThemisApplication.getInstance().getProject().getResourceText(title);
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), panel, t, 0, -1, null, null, null) == 0;
    }

    public int showDialog(JPanel panel, String title, String[] options) {
        String t = ThemisApplication.getInstance().getProject().getResourceText(title);
        Object[] os = new String[options.length];
        for (int ii = 0; ii < os.length; ++ii) {
            os[ii] = ThemisApplication.getInstance().getProject().getResourceText(options[ii]);
        }
        return JOptionPane.showOptionDialog(THEMIS.getMainWindow(), panel, t, -1, -1, null, os, null);
    }

    public void showOkDialog(JPanel panel, String title) {
        Object[] options = new String[]{"OK"};
        String t = ThemisApplication.getInstance().getProject().getResourceText(title);
        JOptionPane.showOptionDialog(THEMIS.getMainWindow(), panel, t, 1, -1, null, options, options[0]);
    }

    public ProgressFrame showProgressFrame(int minval, int maxval) {
        ProgressFrame frm = new ProgressFrame(minval, maxval);
        frm.setLocationRelativeTo(null);
        frm.setVisible(true);
        return frm;
    }

    public boolean[] showCheckboxDialog(String message, String title, String checkbox) {
        return this.showCheckboxDialog(message, title, optionsNoYes, checkbox);
    }

    public boolean[] showCheckboxDialog(String message, String title, String[] specOptions, String checkbox) {
        JCheckBox chkbox = new JCheckBox(this.formatString(checkbox));
        Object[] params = new Object[]{this.formatMessage(message), chkbox};
        int option = JOptionPane.showOptionDialog(THEMIS.getMainWindow(), params, title, 0, 3, this.iconQuestion, specOptions, specOptions[0]);
        boolean chkSelected = chkbox.isSelected();
        return new boolean[]{option == 0, chkSelected};
    }

    public Pair<Integer, Boolean> showCheckboxDialogWithOptions(String message, String title, String[] specOptions, String checkbox) {
        JCheckBox chkbox = new JCheckBox(this.formatString(checkbox));
        Object[] params = new Object[]{this.formatMessage(message), chkbox};
        int option = JOptionPane.showOptionDialog(THEMIS.getMainWindow(), params, title, 0, 3, this.iconQuestion, specOptions, specOptions[0]);
        return new Pair((Object)option, (Object)chkbox.isSelected());
    }

    public void showDialog(JPanel panel, final ThemisPanelInterface panelInterface, boolean requireProject, final String dialogCode, int defaultWidth, int defaultHeight, String dialogTitle) {
        if (requireProject && !this.app.getProject().isOpen()) {
            return;
        }
        final JDialog dlg = THEMIS.createDialog(dialogTitle, panel, true, true, true);
        panelInterface.setDialog(dlg);
        Dimension windowsize = THEMIS.getWindowSize(dialogCode, defaultWidth, defaultHeight, this.app);
        if (windowsize != null) {
            dlg.setSize(windowsize);
            dlg.setPreferredSize(windowsize);
        }
        dlg.setLocationRelativeTo(THEMIS.getMainWindow());
        dlg.setDefaultCloseOperation(0);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                panelInterface.preClose();
                ThemisUtil.setWindowSize((String)dialogCode, (Dimension)dlg.getSize(), (ThemisApplication)Dialogs.this.app);
                dlg.dispose();
            }
        });
        dlg.setVisible(true);
    }

    public boolean showOpenLockedProjectDialog(String username, String openSince, String computer) {
        OpenLockedProjectPanel panel = new OpenLockedProjectPanel(username, openSince, computer);
        panel.showDialog();
        return panel.confirmOpen();
    }

    public String showInputDialogFilled(String message, String title, String initialValue) {
        return JOptionPane.showInputDialog(THEMIS.getMainWindow(), message, initialValue);
    }
}

