/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.api;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;

public class DragScrollHandler
extends MouseAdapter {
    private JComponent component;
    private Point pressedPoint;
    private Point draggedPoint;
    private Rectangle visiRect;
    boolean scrollX = true;
    boolean scrollY = true;

    public DragScrollHandler(JComponent c) {
        this(c, true, true);
    }

    public DragScrollHandler(JComponent c, boolean scrollX, boolean scrollY) {
        this.component = c;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        c.addMouseWheelListener(this);
    }

    public void addDragComponent(JComponent c) {
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        c.addMouseWheelListener(this);
    }

    public void dispose() {
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
        this.component.removeMouseWheelListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressedPoint = e.getPoint();
        this.draggedPoint = e.getPoint();
        this.visiRect = this.component.getVisibleRect();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.visiRect = this.component.getVisibleRect();
        this.visiRect.y += 20 * e.getWheelRotation();
        this.component.scrollRectToVisible(this.visiRect);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.draggedPoint = e.getPoint();
        if (this.draggedPoint == null) {
            return;
        }
        if (this.visiRect == null) {
            return;
        }
        if (this.pressedPoint == null) {
            return;
        }
        if (this.scrollX) {
            this.visiRect.x += this.pressedPoint.x - this.draggedPoint.x;
        }
        if (this.scrollY) {
            this.visiRect.y += this.pressedPoint.y - this.draggedPoint.y;
        }
        this.component.scrollRectToVisible(this.visiRect);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

