/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.api;

import at.grid.ontology.swing.SwingUtils;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.javafx.FXUtilities;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.ImageHelper;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javafx.embed.swing.JFXPanel;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.Exceptions;
import sun.swing.FilePane;

public class ThemisFileDialog {
    private JFileChooser fileChooser;
    boolean cancelled = false;
    String forcedExtension = null;
    File fileSelection = null;
    List<File> fileSelections = null;

    public ThemisFileDialog() {
    }

    public ThemisFileDialog(String title, DIALOGTYPE type, File root, File sel, FileFilter filter, String ext, boolean allowMulti) {
        this();
        this.forcedExtension = ext;
        this.openDialog(title, type, root, sel, filter, allowMulti);
    }

    public ThemisFileDialog(String title, File root) {
        this();
        this.forcedExtension = null;
        this.openDialog(title, DIALOGTYPE.DIRECTORY, root, null, null, false);
    }

    public File getSelectedFile() {
        if (this.fileSelection == null) {
            return null;
        }
        if (this.forcedExtension != null) {
            this.fileSelection = new File(this.fileSelection.getParentFile(), Util.getFileNameWithoutExtension((File)this.fileSelection) + "." + this.forcedExtension);
        }
        return this.fileSelection;
    }

    public List<File> getSelectedFiles() {
        if (this.forcedExtension != null) {
            ArrayList<File> files = new ArrayList<File>();
            for (File f : this.fileSelections) {
                files.add(new File(f.getParentFile(), Util.getFileNameWithoutExtension((File)f) + "." + this.forcedExtension));
            }
            this.fileSelections = files;
        }
        return this.fileSelections;
    }

    public void setChoosableFileFilter(FileFilter[] filters) {
        for (FileFilter filter : filters) {
            this.fileChooser.addChoosableFileFilter(filter);
        }
    }

    public boolean isSymlink(File file) {
        try {
            return Files.isSymbolicLink(file.toPath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean disableDirectorySelection(Container c) {
        Component[] cmps;
        for (Component cmp : cmps = c.getComponents()) {
            if (cmp instanceof JTextField) {
                ((JTextField)cmp).setText(".");
                return true;
            }
            if (!(cmp instanceof Container) || !this.disableDirectorySelection((Container)cmp)) continue;
            return true;
        }
        return false;
    }

    public final void openDialog(String title, int type, File root, FileFilter filter, boolean allowMulti, boolean allowAllFileFilter, int filesAndDirectories) {
        DIALOGTYPE t;
        DIALOGTYPE dIALOGTYPE = t = type == 0 ? DIALOGTYPE.OPEN : DIALOGTYPE.SAVE;
        if (filesAndDirectories == 1) {
            t = DIALOGTYPE.DIRECTORY;
        }
        this.openDialog(title, t, root, null, filter, allowMulti);
    }

    public final void openDialog(String title, final DIALOGTYPE dialogtype, File root, File selFile, FileFilter filter, final boolean allowMulti) {
        JFXPanel filterExt;
        FileChooser.ExtensionFilter extFilter = null;
        if (filter instanceof FileNameExtensionFilter) {
            String filterName = ((FileNameExtensionFilter)filter).getDescription();
            filterExt = new ArrayList();
            for (String ext : ((FileNameExtensionFilter)filter).getExtensions()) {
                filterExt.add("*." + ext);
            }
            extFilter = new FileChooser.ExtensionFilter(filterName, (List)filterExt);
        }
        File folder = null;
        if (root == null) {
            folder = selFile != null ? selFile.getParentFile() : new File(System.getProperty("user.home"), "Documents");
        } else if (root.isFile()) {
            folder = root.getParentFile();
        } else if (root.isDirectory()) {
            folder = root;
        } else if (root.getParentFile() != null && root.getParentFile().exists()) {
            folder = root.getParentFile();
        }
        try {
            filterExt = new JFXPanel();
        }
        catch (IllegalStateException ise) {
            int filesDirectories = 2;
            if (dialogtype == DIALOGTYPE.DIRECTORY) {
                filesDirectories = 1;
            }
            this.openJFileChooserDialog(title, dialogtype, root, selFile, filter, allowMulti, false, filesDirectories);
            return;
        }
        final FileChooser chooser = new FileChooser();
        final DirectoryChooser chooserDir = new DirectoryChooser();
        chooser.setTitle(title);
        chooserDir.setTitle(title);
        if (folder != null && folder.isFile()) {
            folder = folder.getAbsoluteFile().getParentFile();
        }
        if (folder != null && folder.isDirectory()) {
            chooser.setInitialDirectory(folder);
            chooserDir.setInitialDirectory(folder);
        }
        if (selFile != null) {
            chooser.setInitialFileName(selFile.getName());
        }
        if (extFilter != null) {
            chooser.getExtensionFilters().add((Object)extFilter);
            chooser.setSelectedExtensionFilter(extFilter);
        }
        try {
            FXUtilities.runAndWait(new Runnable(){

                @Override
                public void run() {
                    switch (dialogtype) {
                        case OPEN: {
                            if (allowMulti) {
                                ThemisFileDialog.this.fileSelections = chooser.showOpenMultipleDialog(null);
                                if (ThemisFileDialog.this.fileSelections == null || ThemisFileDialog.this.fileSelections.size() <= 0) break;
                                ThemisFileDialog.this.fileSelection = ThemisFileDialog.this.fileSelections.get(0);
                                break;
                            }
                            ThemisFileDialog.this.fileSelection = chooser.showOpenDialog(null);
                            if (ThemisFileDialog.this.fileSelection == null) break;
                            ThemisFileDialog.this.fileSelections = new ArrayList<File>();
                            ThemisFileDialog.this.fileSelections.add(ThemisFileDialog.this.fileSelection);
                            break;
                        }
                        case SAVE: {
                            ThemisFileDialog.this.fileSelection = chooser.showSaveDialog(null);
                            if (ThemisFileDialog.this.fileSelection == null) break;
                            ThemisFileDialog.this.fileSelections = new ArrayList<File>();
                            ThemisFileDialog.this.fileSelections.add(ThemisFileDialog.this.fileSelection);
                            break;
                        }
                        case DIRECTORY: {
                            ThemisFileDialog.this.fileSelection = chooserDir.showDialog(null);
                            if (ThemisFileDialog.this.fileSelection == null) break;
                            ThemisFileDialog.this.fileSelections = new ArrayList<File>();
                            ThemisFileDialog.this.fileSelections.add(ThemisFileDialog.this.fileSelection);
                        }
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public final void openJFileChooserDialog(String title, DIALOGTYPE dialogtype, File root, File selFile, FileFilter filter, boolean allowMulti, boolean allowAllFileFilter, int filesAndDirectories) {
        FileNameExtensionFilter singleFilter = null;
        if (filter instanceof FileNameExtensionFilter) {
            singleFilter = (FileNameExtensionFilter)filter;
        }
        this.fileChooser = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(THEMIS.getMainWindow());
                FilePane filePane = SwingUtils.getDescendantOfClass(FilePane.class, this, "Enabled", true);
                Action tableViewAction = filePane.getViewTypeAction(1);
                tableViewAction.actionPerformed(null);
                try {
                    BufferedImage img = ImageHelper.loadImage((URL)this.getClass().getResource("/at/grid/themis/application/media/themis.gif"));
                    BufferedImage image = Util.resizeImage((BufferedImage)img, (int)16, (int)16, (int)2);
                    dialog.setIconImage(image);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return dialog;
            }
        };
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setCurrentDirectory(root);
        this.fileChooser.setSelectedFile(selFile);
        this.fileChooser.setDialogTitle(title);
        this.fileChooser.setDialogType(dialogtype == DIALOGTYPE.OPEN ? 0 : 1);
        this.fileChooser.setDragEnabled(false);
        this.fileChooser.setFileFilter(filter);
        this.fileChooser.setMultiSelectionEnabled(allowMulti);
        this.fileChooser.setAcceptAllFileFilterUsed(allowAllFileFilter);
        this.disableDirectorySelection(this.fileChooser);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){
            private boolean handlingEvent = false;

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                File selectedFile;
                if (this.handlingEvent) {
                    return;
                }
                this.handlingEvent = true;
                String propertyName = e.getPropertyName();
                if ((propertyName.equals("SelectedFileChangedProperty") || propertyName.equals("directoryChanged")) && (selectedFile = (File)e.getNewValue()) != null && (selectedFile.isDirectory() || ThemisFileDialog.this.isSymlink(selectedFile))) {
                    long deltaTime = 2001L;
                    try {
                        BasicFileAttributes attr = Files.readAttributes(selectedFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                        deltaTime = new Date().getTime() - attr.creationTime().toMillis();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (deltaTime > 2000L && !ThemisProject.isProjectFolder((File)selectedFile)) {
                        ThemisFileDialog.this.fileChooser.setCurrentDirectory(selectedFile);
                        ThemisFileDialog.this.disableDirectorySelection(ThemisFileDialog.this.fileChooser);
                    }
                }
                this.handlingEvent = false;
            }
        });
        while (!this.cancelled && this.fileSelection == null) {
            int result = dialogtype == DIALOGTYPE.OPEN ? this.fileChooser.showOpenDialog(null) : this.fileChooser.showSaveDialog(null);
            File f = this.fileChooser.getSelectedFile();
            switch (result) {
                case 0: {
                    break;
                }
                case 1: {
                    this.cancelled = true;
                    break;
                }
            }
            if (filesAndDirectories == 0 && this.fileSelection != null && this.fileSelection.isDirectory()) {
                this.fileSelection = null;
            }
            if (this.cancelled) {
                this.fileSelections = null;
                continue;
            }
            File[] selectedFiles = this.fileChooser.getSelectedFiles();
            if (selectedFiles == null) continue;
            this.fileSelections = Arrays.asList(selectedFiles);
        }
    }

    public static enum DIALOGTYPE {
        OPEN,
        SAVE,
        DIRECTORY;

    }
}

