/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.api;

import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.ProgressHandler;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

public class ThemisProgressHandler
implements ProgressHandler {
    ProgressHandle p;
    String currentText = "";
    int workunits;
    int currentProgress = 0;

    public ThemisProgressHandler(String displayName, int workunits) {
        this(displayName);
        this.workunits = workunits;
    }

    public ThemisProgressHandler(ProgressHandle ph) {
        this.p = ph;
    }

    public ThemisProgressHandler(String displayName) {
        this.p = ProgressHandleFactory.createHandle((String)displayName, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public void switchToDeterminate(int workunits) {
        this.workunits = workunits;
        this.p.switchToDeterminate(workunits);
    }

    public void done() {
        this.progressDone();
    }

    public void progressDone() {
        this.p.finish();
    }

    public void doneWithConfirm(String info) {
        this.p.finish();
        ThemisApplication.getInstance().getDialog().showConfirmDialog(info);
    }

    public ProgressHandle getProgressHandle() {
        return this.p;
    }

    public void progress(String t, int step) {
        if (step >= this.workunits) {
            step = this.workunits - 1;
        }
        if (step < this.currentProgress) {
            step = this.currentProgress;
        }
        try {
            this.p.progress(t, step);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentText = t;
        this.currentProgress = step;
    }

    public void progress(String t) {
        try {
            this.p.progress(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentText = t;
    }

    public void setDisplayName(String n) {
        this.p.setDisplayName(n);
    }

    public void progress(int step) {
        this.progress(this.currentText, step);
    }

    public boolean isCancelled() {
        return false;
    }

    public void disableCancel() {
    }

    public void increaseProgress(int count) {
        this.progress(this.currentProgress + count);
    }

    public void progress(int fromCount, int untilCount, float val) {
        this.progress((int)((float)fromCount + val * (float)(untilCount - fromCount)));
    }
}

