/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.audio;

import at.grid.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.openide.util.Exceptions;

public class ThemisAudioRecorder {
    public static AudioFormat DEFAULT_FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    public static AudioFileFormat.Type DEFAULT_FILE_TYPE = AudioFileFormat.Type.WAVE;
    public static double DEFAULT_SILENCE_THRESHOLD = 0.001;
    private final File file;
    private final AudioFormat format;
    private final AudioFileFormat.Type fileType;
    private final double silenceLevelThreshold;
    private final ArrayList<ThemisAudioEventListener> listeners = new ArrayList();
    private ByteArrayOutputStream outputStream;
    private Thread capturingThread;
    private boolean recording;
    private boolean paused;
    private double durationInSeconds;
    private Date silenceDetected;

    public ThemisAudioRecorder(File file, AudioFormat format, AudioFileFormat.Type fileType, double silenceLevelThreshold) {
        this.file = file;
        this.format = format;
        this.fileType = fileType;
        this.silenceLevelThreshold = silenceLevelThreshold;
    }

    public ThemisAudioRecorder(File file) {
        this(file, DEFAULT_FORMAT, DEFAULT_FILE_TYPE, DEFAULT_SILENCE_THRESHOLD);
    }

    public void startRecording() throws LineUnavailableException {
        if (this.isRecording()) {
            return;
        }
        if (this.file.exists()) {
            throw new IllegalArgumentException("file-exists");
        }
        this.setRecording(true);
        this.durationInSeconds = 0.0;
        this.silenceDetected = null;
        this.outputStream = new ByteArrayOutputStream();
        DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(dataLineInfo)) {
            throw new LineUnavailableException();
        }
        TargetDataLine line = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
        line.open(this.format);
        line.start();
        int bufferSize = 2048;
        byte[] buffer = new byte[bufferSize];
        this.capturingThread = new Thread(() -> {
            try {
                int counter = 0;
                while (this.isRecording()) {
                    int available;
                    if (counter > 5) {
                        for (ThemisAudioEventListener listener : this.listeners) {
                            listener.onEvent(new MicrophoneUnavailable());
                        }
                    }
                    if ((available = line.available()) < bufferSize) {
                        Thread.sleep(100L);
                        ++counter;
                        continue;
                    }
                    counter = 0;
                    int count = line.read(buffer, 0, bufferSize);
                    if (count <= 0) continue;
                    double level = ThemisAudioRecorder.calculateLevel(buffer, this.format);
                    for (ThemisAudioEventListener listener : this.listeners) {
                        listener.onEvent(new AudioLevelEvent(level));
                    }
                    if (this.isPaused()) continue;
                    if (level > this.silenceLevelThreshold && this.silenceDetected != null) {
                        this.silenceDetected = null;
                    }
                    if (level <= this.silenceLevelThreshold && this.silenceDetected == null) {
                        this.silenceDetected = new Date();
                    }
                    if (this.silenceDetected != null) {
                        long milliseconds = new Date().getTime() - this.silenceDetected.getTime();
                        for (ThemisAudioEventListener listener : this.listeners) {
                            listener.onEvent(new SilenceDetectionEvent(milliseconds));
                        }
                    }
                    this.outputStream.write(buffer, 0, count);
                    byte[] audio = this.outputStream.toByteArray();
                    double frames = audio.length / this.format.getFrameSize();
                    this.durationInSeconds = Util.round((double)(frames / (double)this.format.getFrameRate()), (int)1);
                }
                line.stop();
                line.close();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        });
        this.capturingThread.start();
    }

    public void stopRecording() {
        if (!this.isRecording()) {
            return;
        }
        this.setRecording(false);
        while (this.capturingThread != null && !this.capturingThread.getState().equals((Object)Thread.State.TERMINATED)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        byte[] audio = this.outputStream.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(audio);
        try {
            AudioInputStream ais = new AudioInputStream(input, this.format, audio.length / this.format.getFrameSize());
            AudioSystem.write(ais, this.fileType, this.file);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void resetSilenceDetection() {
        this.silenceDetected = null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public double getDurationInSeconds() {
        return this.durationInSeconds;
    }

    private static float calculateLevel(byte[] buffer, AudioFormat format) {
        float result = 0.0f;
        int max = 0;
        boolean use16Bit = format.getSampleSizeInBits() == 16;
        boolean signed = format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        boolean bigEndian = format.isBigEndian();
        if (use16Bit) {
            for (int i = 0; i < buffer.length; i += 2) {
                byte loByte;
                int value = 0;
                byte hiByte = bigEndian ? buffer[i] : buffer[i + 1];
                byte by = loByte = bigEndian ? buffer[i + 1] : buffer[i];
                if (signed) {
                    short shortVal = hiByte;
                    shortVal = (short)(shortVal << 8 | (byte)loByte);
                    value = shortVal;
                } else {
                    value = hiByte << 8 | loByte;
                }
                max = Math.max(max, value);
            }
        } else {
            for (int i = 0; i < buffer.length; ++i) {
                short value = 0;
                if (signed) {
                    value = buffer[i];
                } else {
                    short shortVal = 0;
                    value = shortVal = (short)(shortVal | buffer[i]);
                }
                max = Math.max(max, value);
            }
        }
        result = signed ? (use16Bit ? (float)max / 32767.0f : (float)max / 127.0f) : (use16Bit ? (float)max / 65535.0f : (float)max / 255.0f);
        return result;
    }

    public void addListener(ThemisAudioEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ThemisAudioEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public class MicrophoneUnavailable
    implements ThemisAudioEvent {
    }

    public class SilenceDetectionEvent
    implements ThemisAudioEvent {
        private final long duration;

        public SilenceDetectionEvent(long duration) {
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }
    }

    public class AudioLevelEvent
    implements ThemisAudioEvent {
        private final double level;

        public AudioLevelEvent(double level) {
            this.level = level;
        }

        public double getLevel() {
            return this.level;
        }
    }

    public static interface ThemisAudioEvent {
    }

    public static interface ThemisAudioEventListener {
        public void onEvent(ThemisAudioEvent var1);
    }
}

