/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.barcode;

import at.grid.util.ProgressHandler;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import org.openide.util.Exceptions;

public class BarcodeGenerator {
    Rectangle pageSize = PageSize.A4;
    float left = 8.1f;
    float bottom = 12.8f;
    int cols = 3;
    int rows = 8;
    float fontsize = 10.0f;
    boolean withBorder = false;
    int startRow = 0;
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/barcode/Bundle");

    public BarcodeGenerator setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public BarcodeGenerator setLabelSize(float width, float height) {
        float paperWidth = this.pageSize.getWidth() / 2.833333f;
        float paperHeight = this.pageSize.getHeight() / 2.833333f;
        double countWidth = Math.floor(paperWidth / width);
        double countHeight = Math.floor(paperHeight / height);
        return this.setLeft((float)(((double)paperWidth - countWidth * (double)width) / 2.0)).setBottom((float)(((double)paperHeight - countHeight * (double)height) / 2.0)).setCols((int)countWidth).setRows((int)countHeight);
    }

    public BarcodeGenerator setLeft(float left) {
        this.left = left;
        return this;
    }

    public BarcodeGenerator setBottom(float bottom) {
        this.bottom = bottom;
        return this;
    }

    public BarcodeGenerator setCols(int cols) {
        this.cols = cols;
        return this;
    }

    public BarcodeGenerator setRows(int rows) {
        this.rows = rows;
        return this;
    }

    public BarcodeGenerator setFontsize(float fontsize) {
        this.fontsize = fontsize;
        return this;
    }

    public BarcodeGenerator setWithBorder() {
        this.withBorder = true;
        return this;
    }

    public BarcodeGenerator setStartRow(int row) {
        this.startRow = row;
        return this;
    }

    public void createPdf(File fOut, ArrayList<String> texts, ProgressHandler ph) throws DocumentException, FileNotFoundException, IOException {
        ph.switchToDeterminate(texts.size());
        ph.setDisplayName(this.bundle.getString("progress.createingCodes.text"));
        ph.progress(0);
        int widthPx = (int)((this.pageSize.getWidth() - 2.0f * BarcodeGenerator.mmToPx(this.left)) / (float)this.cols);
        int heightPx = (int)((this.pageSize.getHeight() - 2.0f * BarcodeGenerator.mmToPx(this.bottom)) / (float)this.rows);
        Document document = new Document();
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
        document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
        document.open();
        int page = 0;
        int counter = this.startRow * this.cols;
        for (String txt : texts) {
            ph.increaseProgress(1);
            if (ph.isCancelled()) break;
            if (counter % (this.rows * this.cols) == 0 && counter > 0) {
                document.newPage();
                ++page;
            }
            int col = counter % this.cols;
            int row = counter / this.cols - page * this.rows;
            try {
                int scale = 5;
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                BitMatrix bitMatrix = qrCodeWriter.encode(txt, BarcodeFormat.QR_CODE, heightPx * scale, heightPx * scale);
                ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
                MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
                BufferedImage bi = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
                BufferedImage bi2 = new BufferedImage(widthPx * scale, heightPx * scale, 2);
                Graphics g = bi2.getGraphics();
                int imgPosX = (widthPx * scale - heightPx * scale) / 2;
                int imgPosY = 0;
                g.drawImage(bi, imgPosX, imgPosY, null);
                g.setColor(Color.BLACK);
                Font f = g.getFont().deriveFont((float)scale * this.fontsize * 0.8f);
                g.setFont(f);
                FontMetrics m = g.getFontMetrics(f);
                int textPosX = (scale * widthPx - m.stringWidth("www.themis-software.com")) / 2;
                int textPoxY = m.getHeight() + 5;
                g.drawString("www.themis-software.com", textPosX, textPoxY);
                f = g.getFont().deriveFont((float)scale * this.fontsize);
                g.setFont(f);
                m = g.getFontMetrics(f);
                textPosX = (scale * widthPx - m.stringWidth(txt)) / 2;
                textPoxY = scale * heightPx - 5;
                g.drawString(txt, textPosX, textPoxY);
                if (this.withBorder) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawRect(0, 0, scale * widthPx - 1, scale * heightPx - 1);
                }
                g.dispose();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bi2, "png", baos);
                byte[] bytes = baos.toByteArray();
                Image img = Image.getInstance((byte[])bytes);
                PdfContentByte canvas = writer.getDirectContent();
                canvas.saveState();
                img.setAbsolutePosition(BarcodeGenerator.mmToPx(this.left) + (float)(col * widthPx), BarcodeGenerator.mmToPx(this.bottom) + (float)((this.rows - row - 1) * heightPx));
                img.scaleToFit((float)widthPx, (float)heightPx);
                document.add((Element)img);
                canvas.addImage(img);
                canvas.restoreState();
                ++counter;
            }
            catch (WriterException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        document.close();
        FileOutputStream file = new FileOutputStream(fOut);
        fos.writeTo(file);
        file.close();
        if (ph.isCancelled()) {
            fOut.delete();
        }
    }

    public static float mmToPx(float mm) {
        return 72.0f * mm / 25.4f;
    }

    public static BufferedImage createQRcodeImage(String txt, int heightPx, int scale) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(txt, BarcodeFormat.QR_CODE, heightPx * scale, heightPx * scale);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        BufferedImage bi = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        return bi;
    }
}

