/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public class BarcodeHelper {
    public static String findBarcode(BufferedImage qrCodeimage) {
        Result qrCodeResult = null;
        try {
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(qrCodeimage)));
            qrCodeResult = new MultiFormatReader().decode(binaryBitmap);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (qrCodeResult == null) {
            return null;
        }
        return qrCodeResult.getText();
    }

    public static String findBarcode(File qrCodeimage) {
        try {
            return BarcodeHelper.findBarcode(ImageIO.read(new FileInputStream(qrCodeimage)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void writeQRCodeImageToFile(String text, int width, int height, File f) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
        Path path = FileSystems.getDefault().getPath(f.getAbsolutePath(), new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"PNG", (Path)path);
    }

    public static byte[] getQRCodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        byte[] pngData = pngOutputStream.toByteArray();
        return pngData;
    }

    private static byte[] getBarcodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.CODABAR, width, height);
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        byte[] pngData = pngOutputStream.toByteArray();
        return pngData;
    }
}

