/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.barcode;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.barcode.BarcodeGenerator;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PrintBarcodePanel
extends ThemisPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/barcode/Bundle");
    ArrayList<Long> locationIds = new ArrayList();
    private JButton btnCancel;
    private JButton btnRun;
    private JTextField fldFirstRow;
    private JTextField fldFontSize;
    private JComboBox<String> fldFormat;
    private JTextField fldLabelHeight;
    private JTextField fldLabelWidth;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JLabel lblCountLocations;

    public PrintBarcodePanel() {
        this.initComponents();
        this.locationIds.addAll(this.project.getSelectionManager().getSelectedLocationIds());
        this.lblCountLocations.setText(Integer.toString(this.locationIds.size()));
    }

    @Override
    public void populate(ProgressHandler ph0) {
    }

    @Override
    public void apply() {
    }

    private void updateFormat(String format) {
        if (format == null || "-".equals(format)) {
            return;
        }
        String w = format.substring(0, format.indexOf("x"));
        String h = format.substring(format.indexOf("x") + 1, format.indexOf("m"));
        this.fldLabelWidth.setText(w.trim());
        this.fldLabelHeight.setText(h.trim());
        if (Util.parseFloat((String)h, (float)50.0f) <= 30.0f || Util.parseFloat((String)w, (float)60.0f) <= 45.0f) {
            this.fldFontSize.setText("8");
        }
    }

    private boolean createBarcdePdf() {
        final ArrayList<String> texts = new ArrayList<String>();
        for (long id : this.locationIds) {
            String barcode = this.project.getDatastorage().getElementAttribute(id, "barcode");
            if (barcode == null || "".equals(barcode)) continue;
            texts.add(barcode);
        }
        if (texts.isEmpty()) {
            this.app.getDialog().showErrorDialog("Die ausgew\u00e4hlten Gegenst\u00e4nde weisen keine QR-Codes auf.");
            return false;
        }
        final File f = new ThemisFileDialog(this.project.getResourceText("dialog.getExportFile.title"), ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getPathExportFolder(), null, THEMIS.getPdfFilter(), "pdf", false).getSelectedFile();
        if (f != null) {
            try {
                this.app.setPathExportFolder(f.getParentFile());
                float labelWidth = Util.parseFloat((String)this.fldLabelWidth.getText(), (float)0.0f);
                float labelHeight = Util.parseFloat((String)this.fldLabelHeight.getText(), (float)0.0f);
                if (labelWidth * labelHeight <= 0.0f) {
                    this.app.getDialog().showErrorDialog(this.bundle.getString("error.widthHeight"));
                    return false;
                }
                ThemisTaskWithDialog task = new ThemisTaskWithDialog(this.bundle.getString("progress.createingCodes.title"), true, true){

                    @Override
                    public void execute(ProgressHandler ph) {
                        try {
                            new BarcodeGenerator().setLabelSize(Util.parseFloat((String)PrintBarcodePanel.this.fldLabelWidth.getText(), (float)8.1f), Util.parseFloat((String)PrintBarcodePanel.this.fldLabelHeight.getText(), (float)12.8f)).setStartRow(Util.parseInt((String)PrintBarcodePanel.this.fldFirstRow.getText(), (int)1) - 1).setFontsize(Util.parseFloat((String)PrintBarcodePanel.this.fldFontSize.getText(), (float)10.0f)).createPdf(f, texts, (ProgressHandler)this);
                        }
                        catch (Exception ex) {
                            PrintBarcodePanel.this.app.getDialog().showErrorDialog("Fehler beim Erzeugen des PDF", ex);
                            ex.printStackTrace();
                        }
                    }
                };
                if (f.isFile()) {
                    THEMIS.showFileResultDialog(f, true);
                }
            }
            catch (Exception ex) {
                this.app.getDialog().showErrorDialog("error.cannotCreatePdf", new String[]{ex.getLocalizedMessage()});
                return false;
            }
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.lblCountLocations = new JLabel();
        this.jLabel3 = new JLabel();
        this.fldFormat = new JComboBox();
        this.jLabel6 = new JLabel();
        this.fldLabelWidth = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.fldLabelHeight = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.fldFontSize = new JTextField();
        this.jLabel7 = new JLabel();
        this.fldFirstRow = new JTextField();
        this.jPanel1 = new JPanel();
        this.btnRun = new JButton();
        this.btnCancel = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel5.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.lblCountLocations.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblCountLocations, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.lblCountLocations.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblCountLocations, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fldFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"-", "48.5 x 25.4 mm", "52.5 x 29.7 mm", "64 x 36 mm", "64 x 45 mm", "64.6 x 33.8 mm", "70 x 36 mm", "70 x 42.3 mm", "70 x 50.8 mm", "70 x 70 mm", "97 x 42.3 mm", "97 x 67.7 mm", "105 x 37 mm", "105 x 42.3 mm", "105 x 48 mm", "105 x 70 mm"}));
        this.fldFormat.setMinimumSize(new Dimension(100, 30));
        this.fldFormat.setPreferredSize(new Dimension(100, 30));
        this.fldFormat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PrintBarcodePanel.this.fldFormatItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldFormat, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.fldLabelWidth.setFont(THEMIS.fontTextfield);
        this.fldLabelWidth.setText(NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.fldLabelWidth.text"));
        this.fldLabelWidth.setMinimumSize(new Dimension(100, 30));
        this.fldLabelWidth.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldLabelWidth, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.fldLabelHeight.setFont(THEMIS.fontTextfield);
        this.fldLabelHeight.setText(NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.fldLabelHeight.text"));
        this.fldLabelHeight.setMinimumSize(new Dimension(100, 30));
        this.fldLabelHeight.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldLabelHeight, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel11, gridBagConstraints);
        this.fldFontSize.setFont(THEMIS.fontTextfield);
        this.fldFontSize.setText(NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.fldFontSize.text"));
        this.fldFontSize.setMinimumSize(new Dimension(100, 30));
        this.fldFontSize.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFontSize, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.fldFirstRow.setFont(THEMIS.fontTextfield);
        this.fldFirstRow.setText(NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.fldFirstRow.text"));
        this.fldFirstRow.setMinimumSize(new Dimension(100, 30));
        this.fldFirstRow.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFirstRow, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnRun.setFont(THEMIS.fontButton);
        this.btnRun.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRun, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.btnRun.text"));
        this.btnRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintBarcodePanel.this.btnRunActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnRun, gridBagConstraints);
        this.btnCancel.setFont(THEMIS.fontButton);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/cancel24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(PrintBarcodePanel.class, (String)"PrintBarcodePanel.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintBarcodePanel.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void btnRunActionPerformed(ActionEvent evt) {
        if (this.createBarcdePdf()) {
            this.closeDialog();
        }
    }

    private void fldFormatItemStateChanged(ItemEvent evt) {
        String sel = (String)this.fldFormat.getSelectedItem();
        this.updateFormat(sel);
    }

    @Override
    public String getDialogCode() {
        return "printbarcodepanel";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(350, 370);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(350, 370);
    }
}

