/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.calendar;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class CalendarEntry {
    public static final int COL_YEAR = 0;
    public static final int COL_MONTH = 1;
    public static final int COL_CHECKS = 2;
    public static final int COL_DEFECTS = 3;
    public static final long TYPE_DEFECT = 1L;
    public static final long TYPE_CHECK = 2L;
    public static final long TYPE_TASK = 3L;
    static ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/calendar/Bundle");
    private int year;
    private int month;
    private ArrayList<Long> checks = new ArrayList();
    private ArrayList<Long> defects = new ArrayList();

    public CalendarEntry(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public void addRecord(long type, long id) {
        if (type == 2L) {
            this.checks.add(id);
        } else if (type == 1L) {
            this.defects.add(id);
        } else if (type == 3L) {
            this.defects.add(id);
        }
    }

    public boolean match(int year, int month) {
        return this.year == year && this.month == month;
    }

    public String getColumnAt(int index) {
        switch (index) {
            case 0: {
                return Integer.toString(this.year);
            }
            case 1: {
                return bundle.getString("month" + this.month);
            }
            case 2: {
                return Integer.toString(this.checks.size());
            }
            case 3: {
                return Integer.toString(this.defects.size());
            }
        }
        return null;
    }

    public List<String> getColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(this.year == 0 ? "-" : Integer.toString(this.year));
        cols.add(bundle.getString("month" + this.month));
        cols.add(this.checks.size() == 0 ? "" : Integer.toString(this.checks.size()));
        cols.add(this.defects.size() == 0 ? "" : Integer.toString(this.defects.size()));
        return cols;
    }

    public int numColumns() {
        return this.getColumns().size();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public ArrayList<Long> getChecks() {
        return this.checks;
    }

    public int getCountKontrolle() {
        return this.checks.size();
    }

    public ArrayList<Long> getDefects() {
        return this.defects;
    }

    public int getCountMangel() {
        return this.defects.size();
    }

    public static String[] getColumnNames() {
        return new String[]{bundle.getString("column.year.text"), bundle.getString("column.month.text"), bundle.getString("column.check.text"), bundle.getString("column.defect.text")};
    }
}

