/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.calendar;

import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.calendar.CalendarEntry;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="CalendarTopComponent", persistenceType=0)
public final class CalendarTopComponent
extends TopComponent
implements ThemisActionListener {
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/calendar/Bundle");
    private DefaultTableModel model;
    private ThemisProject project = ThemisApplication.getInstance().getProject();
    private SortedMap<Integer, CalendarEntry> calendarEntries = new TreeMap<Integer, CalendarEntry>();
    private boolean filterActive;
    private JButton btnRefreshCal;
    private JTextField fldVorschau;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblTitle;
    private JTable table;
    private JScrollPane tableScroll;

    public CalendarTopComponent() {
        this.initComponents();
        this.setName(this.bundle.getString("CTL_ExplorerTopComponent"));
        this.setToolTipText(this.bundle.getString("HINT_ExplorerTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.sliding_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.undocking_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.table.setDefaultRenderer(String.class, centerRenderer);
        this.model = new DefaultTableModel(CalendarEntry.getColumnNames(), 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(this.model);
        this.tableScroll.getVerticalScrollBar().setPreferredSize(new Dimension(30, Integer.MAX_VALUE));
        this.table.setFont(THEMIS.fontLabel);
        this.table.setShowVerticalLines(false);
        this.table.getSelectionModel().setSelectionMode(0);
        for (int columnIndex = 0; columnIndex < this.model.getColumnCount(); ++columnIndex) {
            this.table.getColumnModel().getColumn(columnIndex).setCellRenderer(centerRenderer);
        }
        JTableHeader header = this.table.getTableHeader();
        final DefaultTableCellRenderer headerRenderer = (DefaultTableCellRenderer)header.getDefaultRenderer();
        header.setFont(THEMIS.fontLabelBold);
        header.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                try {
                    DefaultTableCellRenderer firstRowTableCellRenderer = (DefaultTableCellRenderer)table.getCellRenderer(0, column);
                    int firstRowAlignment = firstRowTableCellRenderer.getHorizontalAlignment();
                    headerRenderer.setHorizontalAlignment(firstRowAlignment);
                    return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, firstRowAlignment, column);
                }
                catch (ClassCastException cce) {
                    headerRenderer.setHorizontalAlignment(0);
                    return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            }
        });
        ThemisActionProvider.getInstance().register(this);
        this.populate();
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1100: {
                this.populate();
                break;
            }
            case 1101: {
                this.clear();
                break;
            }
            case 1110: {
                if (action.getSource() == this) break;
                this.table.clearSelection();
            }
        }
    }

    private void updateCalendarSummary(int years) {
        Date endDate = ThemisApplication.applyPeriodToDate((Date)new Date(), (Integer)4, (Integer)years);
        String sql = "SELECT o.idelement AS id, month(o.duedate) AS month, year(o.duedate) AS year, o.idtype AS type, o.duedate AS duedate, o.repeatcount AS repeatcount, o.idrepeat AS repeat FROM tdtaeleobservation AS o INNER JOIN tdtaelement AS e ON (o.idelement=e.idelement) WHERE NOT e.deleted AND o.idtype IN (1,2,3) AND NOT o.done ORDER BY o.duedate,o.idtype";
        List recs = this.project.getDatastorage().executeQuery(sql, true).getResult();
        this.calendarEntries.clear();
        for (DataRecord rec : recs) {
            int year = 0;
            int month = 0;
            if (!rec.isEmpty("year")) {
                year = rec.getInt("year");
            }
            if (!rec.isEmpty("month")) {
                month = rec.getInt("month");
            }
            if (rec.isEmpty("type")) continue;
            this.addEntry(year, month, rec.getLong("type"), rec.getLong("id"));
            if (2L != rec.getLong("type") || rec.getInt("repeat", Integer.valueOf(0)) < 0 || rec.getInt("repeatcount", Integer.valueOf(0)) <= 0) continue;
            Date dt = rec.getDate("duedate", this.project.getTimeZone());
            dt = ThemisApplication.applyPeriodToDate((Date)dt, (Integer)rec.getInt("repeat"), (Integer)rec.getInt("repeatcount"));
            Calendar cal = Calendar.getInstance();
            while (dt != null && endDate.after(dt)) {
                cal.setTime(dt);
                this.addEntry(cal.get(1), cal.get(2) + 1, rec.getLong("type"), rec.getLong("id"));
                dt = ThemisApplication.applyPeriodToDate((Date)dt, (Integer)rec.getInt("repeat"), (Integer)rec.getInt("repeatcount"));
            }
        }
    }

    private void addEntry(int year, int month, long type, long id) {
        int key = year * 100 + month;
        CalendarEntry entry = (CalendarEntry)this.calendarEntries.get(key);
        if (entry == null) {
            entry = new CalendarEntry(year, month);
            this.calendarEntries.put(key, entry);
        }
        entry.addRecord(type, id);
    }

    private void populate() {
        this.clear();
        if (this.project.isOpen()) {
            int years = Util.parseInt((String)this.fldVorschau.getText(), (int)5);
            if (years > 20) {
                this.fldVorschau.setText("20");
                years = 20;
            }
            this.updateCalendarSummary(years);
            for (CalendarEntry sum : this.calendarEntries.values()) {
                this.model.addRow(sum.getColumns().toArray());
            }
        }
    }

    private void clear() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
    }

    private CalendarEntry getSelectedEntry() {
        int selectedRow = this.table.getSelectedRow();
        Collection<CalendarEntry> values = this.calendarEntries.values();
        CalendarEntry entry = null;
        Iterator<CalendarEntry> it = values.iterator();
        for (int ii = 0; ii <= selectedRow; ++ii) {
            if (!it.hasNext()) {
                return null;
            }
            entry = it.next();
        }
        return entry;
    }

    private void removeFilter() {
        this.filterActive = false;
        ThemisApplication.getInstance().getFilter().clearAll();
    }

    private void setFilter() {
        this.filterActive = true;
        this.applySelectionAsFilter();
    }

    private void applySelectionAsFilter() {
        CalendarEntry entry;
        if (this.project.isOpen() && (entry = this.getSelectedEntry()) != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.addAll(entry.getChecks());
            ids.addAll(entry.getDefects());
            ThemisApplication.getInstance().getFilter().setObservationIds(ids, (Object)this);
        }
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.btnRefreshCal = new JButton();
        this.jLabel1 = new JLabel();
        this.fldVorschau = new JTextField();
        this.jLabel2 = new JLabel();
        this.tableScroll = new JScrollPane();
        this.table = new JTable();
        this.setMinimumSize(new Dimension(10, 136));
        this.setLayout(new GridBagLayout());
        this.lblTitle.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(CalendarTopComponent.class, (String)"CalendarTopComponent.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.lblTitle, gridBagConstraints);
        this.btnRefreshCal.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/refresh24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefreshCal, (String)NbBundle.getMessage(CalendarTopComponent.class, (String)"CalendarTopComponent.btnRefreshCal.text"));
        this.btnRefreshCal.setToolTipText(NbBundle.getMessage(CalendarTopComponent.class, (String)"CalendarTopComponent.btnRefreshCal.toolTipText"));
        this.btnRefreshCal.setMinimumSize(new Dimension(50, 40));
        this.btnRefreshCal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarTopComponent.this.btnRefreshCalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.btnRefreshCal, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CalendarTopComponent.class, (String)"CalendarTopComponent.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel1, gridBagConstraints);
        this.fldVorschau.setFont(THEMIS.fontTextfield);
        this.fldVorschau.setHorizontalAlignment(0);
        this.fldVorschau.setText(NbBundle.getMessage(CalendarTopComponent.class, (String)"CalendarTopComponent.fldVorschau.text"));
        this.fldVorschau.setMinimumSize(new Dimension(60, 30));
        this.fldVorschau.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldVorschau, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CalendarTopComponent.class, (String)"CalendarTopComponent.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jLabel2, gridBagConstraints);
        this.tableScroll.setMinimumSize(new Dimension(10, 20));
        this.tableScroll.setPreferredSize(new Dimension(452, 160));
        this.table.setFont(THEMIS.fontLabel);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setMinimumSize(new Dimension(5, 88));
        this.table.setRowHeight(22);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CalendarTopComponent.this.tableMousePressed(evt);
            }
        });
        this.tableScroll.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.tableScroll, gridBagConstraints);
    }

    private void tableMousePressed(MouseEvent evt) {
        this.applySelectionAsFilter();
    }

    private void btnRefreshCalActionPerformed(ActionEvent evt) {
        this.populate();
    }

    public void componentOpened() {
    }

    public void componentShowing() {
        this.populate();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

