/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.camera;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamPanel;
import com.github.sarxos.webcam.WebcamResolution;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class QRCodeDetector
implements Runnable,
ThreadFactory {
    private Executor executor = Executors.newSingleThreadExecutor(this);
    private JDialog dlg;
    private Webcam webcam;
    private JPanel mainPanel;
    private WebcamPanel webcamPanel;
    private boolean isRunning = false;
    private String result = null;
    BufferedImage image = null;
    private int selectedCam = -1;

    public static String showDialog() {
        QRCodeDetector detector = new QRCodeDetector();
        detector.dlg.setVisible(true);
        detector.applySettings();
        return detector.result;
    }

    public static BufferedImage getImage() {
        QRCodeDetector detector = new QRCodeDetector();
        detector.dlg.setVisible(true);
        detector.applySettings();
        return detector.image;
    }

    private QRCodeDetector() {
        final List webcams = Webcam.getWebcams();
        if (webcams.isEmpty()) {
            Dialogs.getInstance().showErrorDialog("camera.not-available");
            return;
        }
        String[] camNames = new String[webcams.size()];
        for (int i = 0; i < webcams.size(); ++i) {
            camNames[i] = ((Webcam)webcams.get(i)).getName();
        }
        int lastUsedCam = Integer.valueOf(ThemisApplication.getInstance().getConfiguration("system.camera.lastused", "-1"));
        if (lastUsedCam >= 0 && lastUsedCam < webcams.size()) {
            this.webcam = (Webcam)webcams.get(lastUsedCam);
            this.selectedCam = lastUsedCam;
        } else {
            this.webcam = Webcam.getDefault();
            for (int i = 0; i < webcams.size(); ++i) {
                if (!camNames[i].equals(this.webcam.getName())) continue;
                this.selectedCam = i;
            }
        }
        if (!this.trySetCameraResolution(this.webcam)) {
            this.webcam.close();
            this.dlg.dispose();
            return;
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        final JComboBox<String> lstCameras = new JComboBox<String>(camNames);
        lstCameras.setSelectedIndex(this.selectedCam);
        lstCameras.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    QRCodeDetector.this.selectedCam = lstCameras.getSelectedIndex();
                    QRCodeDetector.this.webcam.close();
                    QRCodeDetector.this.mainPanel.remove((Component)QRCodeDetector.this.webcamPanel);
                    QRCodeDetector.this.webcam = (Webcam)webcams.get(lstCameras.getSelectedIndex());
                    if (!QRCodeDetector.this.trySetCameraResolution(QRCodeDetector.this.webcam)) {
                        QRCodeDetector.this.webcam.close();
                        QRCodeDetector.this.dlg.dispose();
                        return;
                    }
                    QRCodeDetector.this.webcamPanel = new WebcamPanel(QRCodeDetector.this.webcam);
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridy = 1;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    QRCodeDetector.this.mainPanel.add((Component)QRCodeDetector.this.webcamPanel, c);
                    QRCodeDetector.this.dlg.pack();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(10, 10, 10, 10);
        this.mainPanel.add(lstCameras, c);
        this.webcamPanel = new WebcamPanel(this.webcam);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.mainPanel.add((Component)this.webcamPanel, c);
        this.dlg = new JDialog();
        THEMIS.setDialogIcon(this.dlg);
        this.dlg.setTitle(ResourceBundle.getBundle("at/grid/themis/application/camera/Bundle").getString("CameraHelper.camera-dialog-title.text"));
        this.dlg.setModal(true);
        this.dlg.setContentPane(this.mainPanel);
        this.dlg.setResizable(false);
        this.dlg.pack();
        this.dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                QRCodeDetector.this.webcam.close();
                QRCodeDetector.this.isRunning = false;
            }
        });
        this.dlg.setDefaultCloseOperation(2);
        this.dlg.setLocationRelativeTo(null);
        this.isRunning = true;
        this.executor.execute(this);
    }

    private void applySettings() {
        ThemisApplication.getInstance().setConfiguration("system.camera.lastused", this.selectedCam + "", true);
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Result result = null;
            if (this.webcam.isOpen()) {
                this.image = this.webcam.getImage();
                if (this.image == null) continue;
                BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(this.image);
                BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                try {
                    result = new MultiFormatReader().decode(bitmap);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (result == null) continue;
            String resultText = result.getText();
            this.setResult(resultText);
            this.webcam.close();
            this.dlg.dispose();
            this.isRunning = false;
        } while (this.isRunning);
    }

    private Dimension[] getCustomResolution() {
        return new Dimension[]{WebcamResolution.HD.getSize(), WebcamResolution.VGA.getSize()};
    }

    private boolean trySetCameraResolution(Webcam webcam) {
        Dimension[] dims = this.getCustomResolution();
        webcam.setCustomViewSizes(dims);
        for (int i = 0; i < dims.length; ++i) {
            try {
                webcam.setViewSize(dims[i]);
            }
            catch (Exception e) {
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, "qr-code-detector");
        t.setDaemon(true);
        return t;
    }

    public void setResult(String result) {
        this.result = result;
    }
}

