/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.camera;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.util.Util;
import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.openide.util.Exceptions;

public class WebcamFrame
extends JDialog
implements Runnable,
WebcamListener,
WindowListener,
Thread.UncaughtExceptionHandler {
    ThemisApplication app = ThemisApplication.getInstance();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/camera/Bundle");
    private static final long serialVersionUID = 1L;
    private Webcam webcam = null;
    private WebcamPanel panel = null;
    private int currentCameraIndex = -1;
    JPanel mainPanel = new JPanel();
    ArrayList<BufferedImage> images = new ArrayList();
    BufferedImage currentImage = null;
    boolean running = true;
    boolean restartFrame = false;
    String DIALOG_CODE = "WebcamFrame";
    JLabel lblImageCount = new JLabel("");
    int imageCount = 0;
    Dimension size = new Dimension(1330, 2000);
    ImageObtainer imageObtainer = ImageObtainer.NONE;

    public WebcamFrame(Frame mainWindow, int cameraIndex) {
        this(mainWindow);
        this.currentCameraIndex = cameraIndex;
    }

    public WebcamFrame(Frame mainWindow) {
        super(mainWindow);
        THEMIS.applyWindowSizeAndLocation(this.DIALOG_CODE, (JDialog)this, 800, 500);
    }

    @Override
    public void run() {
        this.currentCameraIndex = ThemisApplication.getInstance().getSettings().getCurrentCamera();
        this.setTitle("Aufnahme");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.webcam = this.getCamera();
        if (this.webcam == null) {
            this.app.getProject().getLogger().severe("no webcams found");
            Dialogs.getInstance().showErrorDialog("camera.not-available");
            this.closeDialog();
        }
        if (!this.webcam.isOpen()) {
            this.webcam.setCustomViewSizes(new Dimension[]{this.size});
            this.webcam.setViewSize(this.size);
        }
        this.webcam.addWebcamListener((WebcamListener)this);
        this.panel = new WebcamPanel(this.webcam, false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCameraSelectControls(), "North");
        this.add((Component)this.panel, "Center");
        this.add((Component)this.getPictureControls(), "South");
        this.pack();
        this.setModal(true);
        Thread t = new Thread(){

            @Override
            public void run() {
                WebcamFrame.this.panel.start();
                WebcamFrame.this.setVisible(true);
                boolean debug = false;
                WebcamFrame.this.app.getProject().getLogger().info("Webcam thread stopped");
            }
        };
        t.setName("THEMIS webcam");
        t.setDaemon(true);
        t.setUncaughtExceptionHandler(this);
        t.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean doRestart() {
        return this.restartFrame;
    }

    public ArrayList<BufferedImage> getImages() {
        return this.images;
    }

    private JPanel getCameraSelectControls() {
        JPanel panelControl = new JPanel();
        panelControl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        final List webcams = Webcam.getWebcams();
        JButton btn = new JButton("Kamera wechseln");
        btn.setFont(THEMIS.fontLabel);
        btn.setMargin(new Insets(4, 25, 4, 25));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebcamFrame.this.currentCameraIndex++;
                if (WebcamFrame.this.currentCameraIndex > webcams.size()) {
                    WebcamFrame.this.currentCameraIndex = 0;
                }
                WebcamFrame.this.activateCamera();
            }
        });
        panelControl.add((Component)btn, gbc);
        return panelControl;
    }

    private JPanel getPictureControls() {
        JPanel panelPicture = new JPanel();
        panelPicture.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 10, 0, 0);
        this.lblImageCount.setFont(THEMIS.fontLabel);
        panelPicture.add((Component)this.lblImageCount, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        JButton btnCancel = new JButton("Abbrechen");
        btnCancel.setFont(THEMIS.fontLabel);
        btnCancel.setMargin(new Insets(4, 25, 4, 25));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebcamFrame.this.closeDialog();
            }
        });
        panelPicture.add((Component)btnCancel, gbc);
        JButton btnMulti = new JButton("Mehrfach");
        btnMulti.setFont(THEMIS.fontLabelBigBold);
        btnMulti.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add-double32.gif")));
        btnMulti.setMargin(new Insets(4, 25, 4, 25));
        btnMulti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebcamFrame.this.saveAsFile(WebcamFrame.this.currentImage);
            }
        });
        panelPicture.add((Component)btnMulti, gbc);
        JButton btnSingle = new JButton("Einzel");
        btnSingle.setFont(THEMIS.fontLabelBigBold);
        btnSingle.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/add2_32.gif")));
        btnSingle.setMargin(new Insets(4, 25, 4, 25));
        btnSingle.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                5 var2_2 = this;
                synchronized (var2_2) {
                    WebcamFrame.this.saveAsFile(WebcamFrame.this.currentImage);
                    WebcamFrame.this.closeDialog();
                }
            }
        });
        panelPicture.add((Component)btnSingle, gbc);
        return panelPicture;
    }

    private Webcam getCamera() {
        List webcams = Webcam.getWebcams();
        if (this.currentCameraIndex >= 0 && this.currentCameraIndex < webcams.size()) {
            return (Webcam)webcams.get(this.currentCameraIndex);
        }
        this.webcam = Webcam.getDefault();
        return this.webcam;
    }

    public void webcamOpen(WebcamEvent we) {
        this.app.getProject().getLogger().info("Webcam opened");
    }

    public void webcamClosed(WebcamEvent we) {
        this.app.getProject().getLogger().info("Webcam closed");
    }

    public void webcamDisposed(WebcamEvent we) {
        this.app.getProject().getLogger().info("Webcam disposed");
    }

    public synchronized void webcamImageObtained(WebcamEvent we) {
        BufferedImage newImage;
        this.currentImage = newImage = we.getImage();
    }

    private synchronized void saveAsFileTest(BufferedImage bi, String fn) {
        if (bi == null) {
            return;
        }
        File folder2 = this.app.getApplicationDataTempFolder();
        File f = new File(folder2, fn + ".jpg");
        int counter = 1;
        while (f.exists()) {
            f = new File(folder2, fn + "_" + counter + ".jpg");
            ++counter;
        }
        try {
            ImageIO.write((RenderedImage)bi, "jpg", f);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private synchronized void saveAsFile(BufferedImage bi) {
        if (bi == null) {
            return;
        }
        File folder = this.app.getSettings().getFolderImageObserver().getValue(true);
        folder.mkdirs();
        File folder2 = this.app.getApplicationDataTempFolder();
        String fn = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE_MILI, (TimeZone)this.app.getTimeZone());
        File f = new File(folder2, fn + ".jpg");
        int counter = 1;
        while (f.exists()) {
            f = new File(folder2, fn + "_" + counter + ".jpg");
            ++counter;
        }
        try {
            ImageIO.write((RenderedImage)bi, "jpg", f);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        File f2 = new File(folder, fn + ".jpg");
        counter = 1;
        while (f2.exists()) {
            f2 = new File(folder, fn + "_" + counter + ".jpg");
            ++counter;
        }
        try {
            FileUtils.copyFile((File)f, (File)f2);
            f.delete();
            this.lblImageCount.setText(this.bundle.getString("WebcamFrame.countImages") + ": " + Integer.toString(++this.imageCount));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.webcam.close();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.app.getProject().getLogger().info("Webcam viewer resumed");
        this.panel.resume();
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.app.getProject().getLogger().info("Webcam viewer paused");
        this.panel.pause();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.app.getProject().getLogger().severe("Exception in webcam thread");
        e.printStackTrace();
        this.closeDialog();
    }

    private void activateCamera() {
        this.restartFrame = true;
        this.closeDialog();
    }

    private void closeDialog() {
        ThemisApplication.getInstance().getSettings().setCurrentCamera(this.currentCameraIndex);
        THEMIS.saveWindowSizeAndLocation(this.DIALOG_CODE, this);
        if (this.webcam != null) {
            this.panel.stop();
            this.remove((Component)this.panel);
            this.webcam.removeWebcamListener((WebcamListener)this);
            this.webcam.close();
        }
        this.running = false;
        this.dispose();
    }

    public static enum ImageObtainer {
        NONE,
        SINGLE,
        MULTIPLE;

    }
}

