/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.SearchResult;
import at.grid.themis.application.ContactPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.ui.SimpleTextRenderer;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="CommunicationTopComponent", persistenceType=0)
public final class CommunicationTopComponent
extends TopComponent
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisFilter filter = this.app.getFilter();
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/communication/Bundle");
    private JButton btnAdd;
    private JButton btnCopy;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnSetFilter;
    private JButton btnUnsetFilter;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane3;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lblEmail;
    private JLabel lblName;
    private JLabel lblTel;
    private JList lstContact;

    public CommunicationTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        this.initComponents();
        this.setName(this.bundle.getString("CTL_CommunicationTopComponent"));
        this.setToolTipText(this.bundle.getString("HINT_CommunicationTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        new DragScrollHandler(this.lstContact, true, true);
        this.lstContact.setCellRenderer(new SimpleTextRenderer());
        ThemisActionProvider.getInstance().register(this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (action.getSource() == this) {
            return;
        }
        switch (action.getAction()) {
            case 1100: 
            case 1101: 
            case 1102: 
            case 1300: {
                this.populate();
                break;
            }
            case 1110: {
                this.filter = this.app.getFilter();
                this.lstContact.getSelectionModel().clearSelection();
                this.updateSelection();
            }
        }
    }

    private void initialiseTopComponent() {
        this.populate();
        if (ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.NONE)) {
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnCopy.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    public DefaultListModel<CmsElementSummary> getModel() {
        return (DefaultListModel)this.lstContact.getModel();
    }

    public List<CmsElementSummary> getSelection() {
        ArrayList eles = this.lstContact.getSelectedValuesList();
        return eles == null ? new ArrayList() : eles;
    }

    public void setSelection(long id) {
        for (int ii = 0; ii < this.getModel().getSize(); ++ii) {
            if (this.getModel().elementAt(ii).getId() != id) continue;
            this.lstContact.setSelectedIndex(ii);
            break;
        }
    }

    public void addSelection(long id) {
        int[] sel = this.lstContact.getSelectedIndices();
        int newIdx = -1;
        for (int ii = 0; ii < this.getModel().getSize(); ++ii) {
            if (this.getModel().elementAt(ii).getId() != id) continue;
            newIdx = ii;
            break;
        }
        if (newIdx >= 0) {
            int[] newSel = new int[sel.length + 1];
            for (int ii = 0; ii < sel.length; ++ii) {
                newSel[ii] = sel[ii];
            }
            newSel[newSel.length - 1] = newIdx;
            this.lstContact.setSelectedIndices(newSel);
        }
    }

    private void enableButtons() {
        boolean hasLicense = this.app.getLicense().hasLicense();
        boolean isSel = !this.getSelection().isEmpty();
        this.btnAdd.setEnabled(hasLicense);
        this.btnCopy.setEnabled(isSel && hasLicense);
        this.btnEdit.setEnabled(isSel && hasLicense);
        this.btnRemove.setEnabled(isSel && hasLicense);
        this.btnSetFilter.setEnabled(isSel);
        this.btnUnsetFilter.setEnabled(isSel);
    }

    public void populate() {
        List<CmsElementSummary> sel = this.getSelection();
        ArrayList<Long> selIds = new ArrayList<Long>();
        for (CmsElementSummary ele : sel) {
            selIds.add(ele.getId());
        }
        int[] selIdx = new int[selIds.size()];
        this.getModel().clear();
        boolean isFilterSet = this.filter.getCompanyId().isEmpty();
        this.btnSetFilter.setVisible(!isFilterSet);
        this.btnUnsetFilter.setVisible(isFilterSet);
        if (this.project.isOpen()) {
            CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
            s.setElementtypes("company");
            s.addSelectMeta();
            s.setSort("upper(el.title)");
            SearchResult result = s.search();
            ArrayList elements = result.getResultAsElementSummary();
            List recs = result.getResult();
            int idx = 0;
            for (int ii = 0; ii < recs.size(); ++ii) {
                this.getModel().addElement((CmsElementSummary)elements.get(ii));
                if (!selIds.contains(((CmsElementSummary)elements.get(ii)).getId())) continue;
                selIdx[idx++] = ii;
            }
            this.lstContact.setSelectedIndices(selIdx);
        }
        this.updateSelection();
    }

    private void updateSelection() {
        List<CmsElementSummary> eles = this.getSelection();
        this.enableButtons();
        if (!this.filter.getCompanyId().isEmpty()) {
            this.setAsFilter();
        }
        CmsElement e = null;
        if (!eles.isEmpty()) {
            e = eles.get(0).getElement();
        }
        if (!eles.isEmpty() && e != null) {
            this.lblName.setText(e.getTitle());
            this.lblTel.setText(e.getAttributeValue("tel"));
            this.lblEmail.setText(e.getAttributeValue("email"));
        } else {
            this.lblName.setText("<keine Auswahl>");
            this.lblTel.setText("");
            this.lblEmail.setText("");
        }
        this.updateFilterOptions();
    }

    private void updateFilterOptions() {
        if (this.filter.getCompanyId().isEmpty()) {
            this.btnSetFilter.setVisible(true);
            this.btnUnsetFilter.setVisible(false);
        } else {
            this.btnSetFilter.setVisible(false);
            this.btnUnsetFilter.setVisible(true);
        }
    }

    private void removeSelectedContact() {
        if (this.lstContact.getSelectedIndex() < 0) {
            return;
        }
        boolean remove = false;
        List<CmsElementSummary> eles = this.getSelection();
        if (eles.size() == 1) {
            remove = this.app.getDialog().showConfirmDialog(this.bundle.getString("CommunicationTopComponent.deleteContact.text"), this.bundle.getString("CommunicationTopComponent.deleteContact.title"));
        } else if (eles.size() > 1) {
            remove = this.app.getDialog().showConfirmDialog(this.bundle.getString("CommunicationTopComponent.deleteContactPlural.text"), this.bundle.getString("CommunicationTopComponent.deleteContactPlural.title"));
        }
        if (!remove) {
            return;
        }
        boolean filterChanged = false;
        boolean companyRemoved = false;
        this.filter.setTriggerEnabled(false);
        for (CmsElementSummary e : eles) {
            if (this.filter.getCompanyId().getList().contains(e.getId())) {
                this.filter.getCompanyId().removeItem(e.getId(), (Object)this);
                filterChanged = true;
            }
            CmsElement.moveToTrash((CmsApplication)this.project, (long)e.getId(), (CmsUser)this.project.getUser());
            this.project.createActionLog("contact_delete", e.getId(), "");
            companyRemoved = true;
        }
        if (filterChanged) {
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.FILTER_CHANGED.from((Object)this, "contact removed"));
        }
        if (companyRemoved) {
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.COMPANY_DELETED);
        }
        this.populate();
        this.filter.setTriggerEnabled(true, (Object)this, false);
    }

    private void setAsFilter() {
        if (!this.project.isOpen()) {
            return;
        }
        List eles = this.lstContact.getSelectedValuesList();
        if (eles != null && !eles.isEmpty()) {
            this.filter.setTriggerEnabled(false);
            this.filter.getCompanyId().clear((Object)this);
            for (CmsElementSummary ele : eles) {
                this.filter.getCompanyId().addItem(ele.getId(), (Object)this);
            }
            this.filter.setTriggerEnabled(true, (Object)this, false);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.FILTER_CHANGED.from((Object)this, "contact set as filter"));
        }
        this.updateFilterOptions();
    }

    private void editContact(CmsCompany c) {
        ContactPanel p;
        if (c != null && (p = new ContactPanel(c)).isSaved()) {
            this.populate();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lstContact = new JList();
        this.jPanel1 = new JPanel();
        this.lblName = new JLabel();
        this.lbl1 = new JLabel();
        this.lblEmail = new JLabel();
        this.lbl2 = new JLabel();
        this.lblTel = new JLabel();
        this.jPanel4 = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnCopy = new JButton();
        this.btnRemove = new JButton();
        this.jLabel7 = new JLabel();
        this.btnSetFilter = new JButton();
        this.btnUnsetFilter = new JButton();
        this.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(10, 0));
        this.setPreferredSize(new Dimension(300, 598));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                CommunicationTopComponent.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel2.setMinimumSize(new Dimension(0, 600));
        this.jPanel2.setPreferredSize(new Dimension(0, 600));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 100));
        this.lstContact.setFont(THEMIS.fontList);
        this.lstContact.setModel(new DefaultListModel());
        this.lstContact.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CommunicationTopComponent.this.lstContactMouseClicked(evt);
            }
        });
        this.lstContact.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CommunicationTopComponent.this.lstContactValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstContact);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jScrollPane3.getAccessibleContext().setAccessibleParent((Accessible)((Object)this));
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblName.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblName, gridBagConstraints);
        this.lbl1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lbl1, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.lbl1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl1, gridBagConstraints);
        this.lblEmail.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblEmail, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.lblEmail.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.lblEmail, gridBagConstraints);
        this.lbl2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lbl2, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.lbl2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.lbl2, gridBagConstraints);
        this.lblTel.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblTel, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.lblTel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.jPanel1.add((Component)this.lblTel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.btnAdd.setFont(THEMIS.fontButton);
        this.btnAdd.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/add2_24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnAdd.toolTipText"));
        this.btnAdd.setBorder(new SoftBevelBorder(0));
        this.btnAdd.setMaximumSize(null);
        this.btnAdd.setMinimumSize(null);
        this.btnAdd.setPreferredSize(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTopComponent.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setFont(THEMIS.fontButton);
        this.btnEdit.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/edit24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnEdit, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnEdit.text"));
        this.btnEdit.setToolTipText(NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnEdit.toolTipText"));
        this.btnEdit.setBorder(new SoftBevelBorder(0));
        this.btnEdit.setMaximumSize(null);
        this.btnEdit.setMinimumSize(new Dimension(30, 30));
        this.btnEdit.setPreferredSize(new Dimension(30, 30));
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTopComponent.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnEdit, gridBagConstraints);
        this.btnCopy.setFont(THEMIS.fontButton);
        this.btnCopy.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/copy24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnCopy.toolTipText"));
        this.btnCopy.setBorder(new SoftBevelBorder(0));
        this.btnCopy.setMaximumSize(null);
        this.btnCopy.setMinimumSize(new Dimension(30, 30));
        this.btnCopy.setPreferredSize(new Dimension(30, 30));
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTopComponent.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnCopy, gridBagConstraints);
        this.btnRemove.setFont(THEMIS.fontButton);
        this.btnRemove.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnRemove.toolTipText"));
        this.btnRemove.setBorder(new SoftBevelBorder(0));
        this.btnRemove.setMaximumSize(null);
        this.btnRemove.setMinimumSize(new Dimension(30, 30));
        this.btnRemove.setPreferredSize(new Dimension(30, 30));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTopComponent.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jLabel7, gridBagConstraints);
        this.btnSetFilter.setFont(THEMIS.fontButton);
        this.btnSetFilter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/filter24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetFilter, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnSetFilter.text"));
        this.btnSetFilter.setToolTipText(NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnSetFilter.toolTipText"));
        this.btnSetFilter.setBorder(new SoftBevelBorder(0));
        this.btnSetFilter.setMaximumSize(null);
        this.btnSetFilter.setMinimumSize(new Dimension(30, 30));
        this.btnSetFilter.setPreferredSize(new Dimension(30, 30));
        this.btnSetFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTopComponent.this.btnSetFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnSetFilter, gridBagConstraints);
        this.btnUnsetFilter.setFont(THEMIS.fontButton);
        this.btnUnsetFilter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/application/media/filterOff24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUnsetFilter, (String)NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnUnsetFilter.text"));
        this.btnUnsetFilter.setToolTipText(NbBundle.getMessage(CommunicationTopComponent.class, (String)"CommunicationTopComponent.btnUnsetFilter.toolTipText"));
        this.btnUnsetFilter.setBorder(new SoftBevelBorder(0));
        this.btnUnsetFilter.setMaximumSize(null);
        this.btnUnsetFilter.setMinimumSize(new Dimension(30, 30));
        this.btnUnsetFilter.setPreferredSize(new Dimension(30, 30));
        this.btnUnsetFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTopComponent.this.btnUnsetFilterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.btnUnsetFilter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.add(this.jPanel2, "Center");
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        this.removeSelectedContact();
    }

    private void lstContactValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.updateSelection();
        }
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        CmsCompany c = (CmsCompany)this.project.createElement("company");
        this.editContact(c);
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        List<CmsElementSummary> eles = this.getSelection();
        if (eles.size() > 0) {
            CmsCompany e = (CmsCompany)this.project.loadElement(eles.get(0).getId(), this.project.getUser());
            this.editContact(e);
        }
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app)) {
            return;
        }
        List<CmsElementSummary> eles = this.getSelection();
        if (eles.size() > 0) {
            CmsCompany e = (CmsCompany)this.project.loadElement(eles.get(0).getId(), this.project.getUser());
            e = (CmsCompany)e.copy();
            this.editContact(e);
        }
    }

    private void btnSetFilterActionPerformed(ActionEvent evt) {
        this.setAsFilter();
    }

    private void btnUnsetFilterActionPerformed(ActionEvent evt) {
        this.filter.getCompanyId().clear((Object)this);
        this.updateFilterOptions();
    }

    private void lstContactMouseClicked(MouseEvent evt) {
        List<CmsElementSummary> eles;
        if (evt.getClickCount() > 1 && this.app.getLicense().hasLicense() && (eles = this.getSelection()).size() > 0) {
            CmsCompany e = (CmsCompany)this.project.loadElement(eles.get(0).getId(), this.project.getUser());
            this.editContact(e);
        }
    }

    public void componentOpened() {
        this.populate();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

