/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.DragScrollHandler;
import at.grid.themis.application.communication.email.Email;
import at.grid.themis.application.communication.email.ImapMessageLoader;
import at.grid.themis.application.communication.email.ViewEmailPanel;
import at.grid.themis.ontology.ThemisApplication;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.mail.MessagingException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EmailPanel
extends JPanel {
    ResourceBundle bundle = ResourceBundle.getBundle("at/grid/themis/application/communication/email/Bundle");
    private long obsId = -1L;
    private ImapMessageLoader messageLoader;
    private long messageUID;
    private JCheckBox chkSelection;
    private JLabel lblSender;
    private JLabel lblSubject;
    private JLabel lblTime;
    private JPanel panelStatus;
    private JButton readEmail;

    public EmailPanel(String date, String subject, String sender, long obsId, long messageUID, ImapMessageLoader messageLoader) throws IOException, MessagingException {
        this.initComponents();
        this.messageLoader = messageLoader;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EmailPanel.this.readEmailActionPerformed(null);
                } else {
                    EmailPanel.this.setSelection();
                }
            }
        });
        this.obsId = obsId;
        this.messageUID = messageUID;
        this.setContent(date, subject, sender, obsId);
        new DragScrollHandler(this);
    }

    public void setContent(String date, String subject, String sender, long obsId) {
        this.lblSender.setText(sender);
        this.lblSubject.setText(subject);
        this.lblTime.setText(date);
    }

    public void setSelection() {
        Component[] components;
        for (Component c : components = this.getParent().getComponents()) {
            if (!(c instanceof EmailPanel)) continue;
            ((EmailPanel)c).setSelectCheckbox(false);
        }
        this.chkSelection.setSelected(true);
    }

    public void setSelectCheckbox(boolean flag) {
        this.chkSelection.setSelected(flag);
    }

    private void updateSelection() {
        if (this.chkSelection.isSelected()) {
            // empty if block
        }
    }

    public boolean isSelected() {
        return this.chkSelection.isSelected();
    }

    public long getObsId() {
        return this.obsId;
    }

    public long getMessageUID() {
        return this.messageUID;
    }

    private void initComponents() {
        this.lblSubject = new JLabel();
        this.lblTime = new JLabel();
        this.lblSender = new JLabel();
        this.panelStatus = new JPanel();
        this.chkSelection = new JCheckBox();
        this.readEmail = new JButton();
        this.setBorder(new SoftBevelBorder(0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        this.setMinimumSize(new Dimension(174, 50));
        this.setPreferredSize(new Dimension(174, 50));
        this.setLayout(new GridBagLayout());
        this.lblSubject.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblSubject, (String)NbBundle.getMessage(EmailPanel.class, (String)"EmailPanel.lblSubject.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.lblSubject, gridBagConstraints);
        this.lblTime.setFont(THEMIS.fontLabel);
        this.lblTime.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/time-16.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblTime, (String)NbBundle.getMessage(EmailPanel.class, (String)"EmailPanel.lblTime.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.lblTime, gridBagConstraints);
        this.lblSender.setFont(THEMIS.fontLabel);
        this.lblSender.setHorizontalAlignment(4);
        this.lblSender.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/contacts-16.gif")));
        Mnemonics.setLocalizedText((JLabel)this.lblSender, (String)NbBundle.getMessage(EmailPanel.class, (String)"EmailPanel.lblSender.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.lblSender, gridBagConstraints);
        this.panelStatus.setMinimumSize(new Dimension(46, 46));
        this.panelStatus.setPreferredSize(new Dimension(46, 46));
        this.panelStatus.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.chkSelection, (String)NbBundle.getMessage(EmailPanel.class, (String)"EmailPanel.chkSelection.text"));
        this.chkSelection.setHorizontalAlignment(0);
        this.chkSelection.setHorizontalTextPosition(0);
        this.chkSelection.setMaximumSize(new Dimension(46, 46));
        this.chkSelection.setMinimumSize(new Dimension(46, 46));
        this.chkSelection.setPreferredSize(new Dimension(46, 46));
        this.chkSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EmailPanel.this.chkSelectionItemStateChanged(evt);
            }
        });
        this.panelStatus.add((Component)this.chkSelection, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.panelStatus, gridBagConstraints);
        this.readEmail.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/email-open24.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.readEmail, (String)NbBundle.getMessage(EmailPanel.class, (String)"EmailPanel.readEmail.text"));
        this.readEmail.setMargin(new Insets(2, 2, 2, 2));
        this.readEmail.setMaximumSize(new Dimension(40, 40));
        this.readEmail.setMinimumSize(new Dimension(40, 40));
        this.readEmail.setPreferredSize(new Dimension(40, 40));
        this.readEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmailPanel.this.readEmailActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.readEmail, gridBagConstraints);
    }

    private void chkSelectionItemStateChanged(ItemEvent evt) {
        this.setBackground(this.chkSelection.isSelected() ? Color.LIGHT_GRAY : new Color(240, 240, 240));
    }

    private void readEmailActionPerformed(ActionEvent evt) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                final Email loaded = EmailPanel.this.messageLoader.saveMessage(EmailPanel.this.messageUID);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (loaded != null) {
                            ViewEmailPanel.showDialog(loaded);
                        } else {
                            Dialogs.getInstance().showWarningDialog("error.email.loading");
                        }
                    }
                });
            }
        };
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runner, (String)ThemisApplication.getInstance().getProject().getResourceText("email.loading.text"));
    }
}

