/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.cms.element.CmsElement;
import at.grid.themis.application.LocationObservationDialog;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.communication.email.Email;
import at.grid.themis.application.communication.email.EmailAttachment;
import at.grid.themis.application.communication.email.EmailPanel;
import at.grid.themis.application.communication.email.ImapHelper;
import at.grid.themis.application.communication.email.ImapMessageLoader;
import at.grid.themis.application.communication.email.MailAuthenticator;
import at.grid.themis.application.communication.email.ViewEmailPanel;
import at.grid.themis.application.ui.ThemisPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsInfo;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class EmailSyncPanel
extends ThemisPanel {
    ResourceBundle bundle = ResourceBundle.getBundle("/at/grid/themis/application/communication/email/Bundle");
    private List<EmailPanel> emailPanels = new ArrayList<EmailPanel>();
    private ImapMessageLoader messageLoader;
    private JButton btnApply;
    private JButton btnRefresh;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JPanel panelMails;
    private JScrollPane panelMailsScroll;

    public EmailSyncPanel() {
        this.initComponents();
        this.updateVisibility();
    }

    @Override
    public void populate(ProgressHandler ph) {
    }

    @Override
    public void apply() {
    }

    private void clear() {
        this.panelMails.removeAll();
        this.panelMails.revalidate();
        this.panelMails.repaint();
    }

    private void updateVisibility() {
        boolean insufficientLicense = ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL);
        this.btnApply.setEnabled(!insufficientLicense);
        this.btnRefresh.setEnabled(!insufficientLicense);
        if (insufficientLicense) {
            this.clear();
        }
    }

    private void readEmails() {
        ThemisApplication app = ThemisApplication.getInstance();
        try {
            if (ImapHelper.authenticate()) {
                final Notification notify = THEMIS.notify(1, this.bundle.getString("EmailSyncTopComponent.loading.title"), this.bundle.getString("EmailSyncTopComponent.loading.text"));
                JLabel loadingMessages = new JLabel(this.bundle.getString("EmailSyncTopComponent.loadingMessages.text"));
                loadingMessages.setFont(THEMIS.fontLabelBig);
                loadingMessages.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.panelMails.add((Component)loadingMessages, 0);
                this.panelMails.revalidate();
                this.panelMails.repaint();
                SwingWorker<Map<Long, Message>, Void> worker = new SwingWorker<Map<Long, Message>, Void>(){

                    @Override
                    protected Map<Long, Message> doInBackground() throws Exception {
                        if (EmailSyncPanel.this.messageLoader != null) {
                            EmailSyncPanel.this.messageLoader.disconnect();
                        }
                        EmailSyncPanel.this.messageLoader = new ImapMessageLoader();
                        return EmailSyncPanel.this.messageLoader.getMessages();
                    }

                    @Override
                    public void done() {
                        try {
                            EmailSyncPanel.this.panelMails.remove(0);
                            Map unseenMessages = (Map)this.get();
                            if (unseenMessages == null) {
                                if (MailAuthenticator.getInstance().isAuthenticated()) {
                                    Dialogs.getInstance().showWarningDialog("error.email.connect");
                                } else {
                                    Dialogs.getInstance().showErrorDialog("MailAuthenticator.failed.text");
                                }
                            } else {
                                EmailSyncPanel.this.panelMails.removeAll();
                                EmailSyncPanel.this.emailPanels.clear();
                                JLabel noNewMessages = new JLabel(EmailSyncPanel.this.bundle.getString("EmailSyncTopComponent.noNewMessages.text"));
                                noNewMessages.setFont(THEMIS.fontLabelBig);
                                noNewMessages.setBorder(new EmptyBorder(5, 5, 5, 5));
                                if (unseenMessages.isEmpty()) {
                                    EmailSyncPanel.this.panelMails.add(noNewMessages);
                                } else {
                                    Set entrySet = unseenMessages.entrySet();
                                    final Comparator<Message> comp = EmailSyncPanel.this.messageLoader.msgComparator();
                                    entrySet.stream().sorted(new Comparator<Map.Entry<Long, Message>>(){

                                        @Override
                                        public int compare(Map.Entry<Long, Message> o1, Map.Entry<Long, Message> o2) {
                                            Message val1 = o1.getValue();
                                            Message val2 = o2.getValue();
                                            return comp.compare(val1, val2);
                                        }
                                    }).forEach(new Consumer<Map.Entry<Long, Message>>(){

                                        @Override
                                        public void accept(Map.Entry<Long, Message> t) {
                                            try {
                                                long uid = t.getKey();
                                                Message m = t.getValue();
                                                String subject = m.getSubject();
                                                EmailPanel panel = new EmailPanel(EmailSyncPanel.formatToYesterdayOrToday(m.getSentDate()), m.getSubject(), ((InternetAddress)m.getFrom()[0]).getAddress(), -1L, uid, EmailSyncPanel.this.messageLoader);
                                                EmailSyncPanel.this.emailPanels.add(panel);
                                                GridBagConstraints c = new GridBagConstraints();
                                                c.gridwidth = 0;
                                                EmailSyncPanel.this.panelMails.add((Component)panel, c);
                                            }
                                            catch (Exception e) {
                                                ThemisLogger.logger.severe("Could not refresh emails: " + e.getLocalizedMessage());
                                            }
                                        }
                                    });
                                    if (EmailSyncPanel.this.emailPanels.isEmpty()) {
                                        EmailSyncPanel.this.panelMails.add(noNewMessages);
                                    }
                                }
                                EmailSyncPanel.this.panelMails.revalidate();
                                EmailSyncPanel.this.panelMails.repaint();
                            }
                        }
                        catch (Exception ex) {
                            ThemisLogger.logger.severe("Could not refresh emails: " + ex.getLocalizedMessage());
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        notify.clear();
                    }
                };
                worker.execute();
            }
        }
        catch (Exception e) {
            ThemisLogger.logger.severe("Could not refresh emails: " + e.getLocalizedMessage());
        }
    }

    private void applyEmails() {
        final ThemisProject project = ThemisApplication.getInstance().getProject();
        if (project.getCurrentEventId() < 0L) {
            Dialogs.getInstance().showWarningDialog(project.getResourceText("app.core.text.noevent"));
            return;
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ArrayList<Long> msgUIDs = new ArrayList<Long>();
                for (EmailPanel p : EmailSyncPanel.this.emailPanels) {
                    if (!p.isSelected()) continue;
                    msgUIDs.add(p.getMessageUID());
                }
                UUID thisPUID = ThemisApplication.getInstance().getProject().getProjectElement().getUUID();
                int projectMismatch = 0;
                int obsNotFound = 0;
                for (Long msgUID : msgUIDs) {
                    Email email = EmailSyncPanel.this.messageLoader.saveMessage(msgUID);
                    String body = email.body;
                    try {
                        Pattern p = Pattern.compile("\\[(.*?)\\]");
                        Matcher matcher = p.matcher(body);
                        String pUIDString = null;
                        String obsIdString = null;
                        while (matcher.find()) {
                            String result = matcher.group(1);
                            String[] split = result.split(":");
                            if (split.length > 0) {
                                pUIDString = split[0];
                            }
                            if (split.length <= 1) continue;
                            obsIdString = split[1];
                        }
                        UUID pUUID = null;
                        if (pUIDString != null) {
                            try {
                                pUUID = UUID.fromString(pUIDString);
                            }
                            catch (Exception split) {
                                // empty catch block
                            }
                        }
                        long obsId = -1L;
                        if (obsIdString != null) {
                            try {
                                obsId = Long.valueOf(obsIdString);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (pUUID != null && pUUID.compareTo(thisPUID) == 0 && obsId != -1L) {
                            CmsObservation obs = (CmsObservation)project.loadElement(obsId, project.getUser());
                            if (obs != null && email != null) {
                                CmsLocation loc = obs.getLocation();
                                if (body != null && !body.isEmpty()) {
                                    obs.setAttributeValue("description", obs.getAttributeValue("description") + "\n\n" + email.from + " (" + email.received + "):\n" + ViewEmailPanel.getContentAsText(body));
                                }
                                for (EmailAttachment at : email.attachments) {
                                    if (at.name.toLowerCase().endsWith("jpg") || at.name.toLowerCase().endsWith("jpeg") || at.name.toLowerCase().endsWith("png") || at.name.toLowerCase().endsWith("gif") || at.name.toLowerCase().endsWith("wav")) {
                                        obs.getUploadAttribute("files").addUpload(new File(at.path));
                                        continue;
                                    }
                                    if (!at.name.toLowerCase().endsWith("pdf")) continue;
                                    CmsInfo info = (CmsInfo)project.createElement("info");
                                    File f = new File(at.path);
                                    info.getUploadAttribute("files").addUpload(f);
                                    String title = Util.getFileNameWithoutExtension((File)f);
                                    info.setAttributeValue("title", title);
                                    info.save();
                                    obs.getRelationAttribute("infos").add((CmsElement)info);
                                }
                                if (msgUIDs.size() == 1) {
                                    new LocationObservationDialog().editObservation((CmsElement)loc, obs);
                                    continue;
                                }
                                obs.save();
                                continue;
                            }
                            ++obsNotFound;
                            continue;
                        }
                        ++projectMismatch;
                        ThemisLogger.logger.warning("Did not apply email to observation because of project or obs ID mismatch.");
                    }
                    catch (Exception e) {
                        ThemisLogger.logger.warning("Could not apply email to observation: " + e.getLocalizedMessage());
                    }
                }
                if (projectMismatch > 0 || obsNotFound > 0) {
                    if (projectMismatch > 0) {
                        Dialogs.getInstance().showInfoDialog(EmailSyncPanel.this.bundle.getString("EmailSyncTopComponent.projectMismatch.text"));
                    } else {
                        Dialogs.getInstance().showInfoDialog(EmailSyncPanel.this.bundle.getString("EmailSyncTopComponent.obsMismatch.text"));
                    }
                }
                if (msgUIDs.size() > 1) {
                    Dialogs.getInstance().showInfoDialog(EmailSyncPanel.this.bundle.getString("EmailSyncTopComponent.updatedObservations.text") + ": " + msgUIDs.size());
                }
            }
        };
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runner, (String)ThemisApplication.getInstance().getProject().getResourceText("email.apply.text"));
    }

    private void initComponents() {
        this.btnApply = new JButton();
        this.jPanel3 = new JPanel();
        this.panelMailsScroll = new JScrollPane();
        this.panelMails = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnRefresh = new JButton();
        this.setMinimumSize(new Dimension(10, 30));
        this.setPreferredSize(new Dimension(300, 100));
        this.setLayout(new GridBagLayout());
        this.btnApply.setFont(THEMIS.fontButton);
        this.btnApply.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApply, (String)NbBundle.getMessage(EmailSyncPanel.class, (String)"EmailSyncPanel.btnApply.text"));
        this.btnApply.setBorder(new SoftBevelBorder(0));
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmailSyncPanel.this.btnApplyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnApply, gridBagConstraints);
        this.jPanel3.setLayout(new BorderLayout());
        this.panelMailsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.panelMails.setLayout(new BoxLayout(this.panelMails, 3));
        this.panelMailsScroll.setViewportView(this.panelMails);
        this.jPanel3.add((Component)this.panelMailsScroll, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EmailSyncPanel.class, (String)"EmailSyncPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.btnRefresh.setFont(THEMIS.fontButton);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/refresh24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)NbBundle.getMessage(EmailSyncPanel.class, (String)"EmailSyncPanel.btnRefresh.text"));
        this.btnRefresh.setBorder(new SoftBevelBorder(0));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmailSyncPanel.this.btnRefreshActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnRefresh, gridBagConstraints);
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.readEmails();
    }

    public static String formatToYesterdayOrToday(Date dateTime) throws ParseException {
        String dateString = new SimpleDateFormat("hh:mma MMM d, yyyy").format(dateTime);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        Calendar today = Calendar.getInstance();
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        SimpleDateFormat timeFormatter = new SimpleDateFormat("hh:mm a");
        if (calendar.get(1) == today.get(1) && calendar.get(6) == today.get(6)) {
            return ThemisApplication.getInstance().getProject().getResourceText("time.today") + " " + timeFormatter.format(dateTime);
        }
        if (calendar.get(1) == yesterday.get(1) && calendar.get(6) == yesterday.get(6)) {
            return ThemisApplication.getInstance().getProject().getResourceText("time.yesterday") + " " + timeFormatter.format(dateTime);
        }
        return dateString;
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        this.applyEmails();
    }

    @Override
    public String getDialogCode() {
        return "emailsync";
    }

    @Override
    public Dimension getPanelSize() {
        return new Dimension(400, 500);
    }

    @Override
    public Dimension getPanelMinimumSize() {
        return new Dimension(400, 500);
    }
}

