/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.communication.email.Email;
import at.grid.themis.application.communication.email.EmailAttachment;
import at.grid.themis.application.communication.email.MailAuthenticator;
import at.grid.themis.application.communication.email.SecureEmailAuthenticationPanel;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsCompany;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PdfContentHeaderProject;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.pdf.PdfExportBase;
import at.grid.themis.ontology.report.pdf.PdfLayoutExporter;
import at.grid.themis.ontology.settings.ThemisSettings;
import at.grid.themis.ontology.util.EmailSendThread;
import at.grid.util.Util;
import com.sun.mail.imap.IMAPFolder;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.netbeans.api.progress.BaseProgressUtils;

public class ImapHelper {
    public static void sendObservationViaEmail(long id) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!ThemisApplication.getInstance().getProject().isOpen()) {
            return;
        }
        CmsElement e = project.loadElement(id, project.getUser());
        if (e != null && e instanceof CmsObservation) {
            ImapHelper.sendObservationViaEmail((CmsObservation)e);
        }
    }

    public static void sendObservationViaEmail(CmsObservation obs) {
        ThemisSettings settings = ThemisApplication.getInstance().getSettings();
        EmailSendThread email = settings.getEmailSender();
        String recipient = null;
        CmsElement contact = obs.getContact();
        if (contact != null) {
            recipient = ((CmsCompany)contact).getEmail();
        }
        if (!ImapHelper.authenticate()) {
            return;
        }
        email.setSubject("").setMessage("").addRecipient(recipient).setAuthentication(MailAuthenticator.getInstance().getPasswordAuthentication()).send(false);
    }

    public static void sendEmail() {
        boolean emailSyncEnabled = "yes".equals(ThemisApplication.getInstance().getConfiguration("system.email.sync.enabled", "no"));
        boolean sendAllObsInOneEmail = !emailSyncEnabled;
        boolean openMailProgram = !emailSyncEnabled;
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        ResourceBundle bundle = ResourceBundle.getBundle("/at/grid/themis/application/communication/email/Bundle");
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (!project.getSelectionManager().hasSelectedObservationIds()) {
            Dialogs.getInstance().showWarningDialog(bundle.getString("SendEmailAction.selectObs.text"));
            return;
        }
        String smtp = app.getConfiguration("system.email.smtp", null);
        String emailFrom = app.getConfiguration("system.email.from", null);
        String portConf = app.getConfiguration("system.email.port", "-1");
        int port = portConf == null || portConf.isEmpty() ? -1 : Integer.parseInt(portConf);
        String encryptConf = app.getConfiguration("system.email.encrypt", "-1");
        int encrypt = encryptConf == null || encryptConf.isEmpty() ? -1 : Integer.parseInt(encryptConf);
        openMailProgram = smtp == null || emailFrom == null || port == -1 || encrypt == -1;
        if (!openMailProgram) {
            openMailProgram = Dialogs.getInstance().showConfirmDialog(bundle.getString("mail-program.open.msg"), bundle.getString("mail-program.open.title"), new String[]{bundle.getString("mail-program.open.yes"), bundle.getString("mail-program.open.no")});
        }
        CmsReport rep = new CmsReport();
        rep.exportImages = CmsReport.ImageIntegration.ALL;
        rep.templatePdfLayout.clear();
        rep.setNumberOfImagesPerRow(3);
        rep.templatePdfLayout.add(new PdfContentHeading1().setText("THEMIS Information"));
        rep.templatePdfLayout.add(new PdfContentHeaderProject());
        rep.templatePdfLayout.add(new PdfContentHeading1().setText("Kontrollen und Feststellungen"));
        rep.templatePdfLayout.add(new PdfContentStandardTable());
        rep.contentType = CmsReport.Content.SELECTION;
        PdfLayoutExporter pdf = new PdfLayoutExporter(rep);
        pdf.setObservations(project.getSelectionManager().getSelectedObservationIds());
        File folder = project.getTempfileLocation();
        CmsProject projectEle = project.getProjectElement();
        UUID projectUUID = projectEle.getUUID();
        ArrayList obsIds = project.getSelectionManager().getSelectedObservationIds();
        if (openMailProgram) {
            BaseProgressUtils.showProgressDialogAndRun(() -> {
                try {
                    if (sendAllObsInOneEmail) {
                        ImapHelper.sendEmailWithMailProgram((PdfExportBase)pdf, rep, null, projectUUID, true);
                    } else {
                        Iterator iterator = obsIds.iterator();
                        while (iterator.hasNext()) {
                            long obsId = (Long)iterator.next();
                            CmsObservation obs = pdf.setSingleObservation(obsId);
                            try {
                                ImapHelper.sendEmailWithMailProgram((PdfExportBase)pdf, rep, obs, projectUUID, false);
                            }
                            catch (Exception e) {
                                ThemisLogger.logger.warning("Could not send email for obs " + obs.getId() + ": " + e.getLocalizedMessage());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    ThemisLogger.logger.warning("Could not send email: " + e.getLocalizedMessage());
                }
            }, (String)bundle.getString("email.sending.text"));
        } else if (ImapHelper.authenticate()) {
            BaseProgressUtils.showProgressDialogAndRun(() -> {
                try {
                    String recipient = null;
                    boolean manual = false;
                    Iterator iterator = obsIds.iterator();
                    while (iterator.hasNext()) {
                        long obsId = (Long)iterator.next();
                        if (recipient == null) {
                            recipient = Dialogs.getInstance().showInputDialogFilled(bundle.getString("email.recipient.msg"), ThemisApplication.getInstance().getSettings().getEmailRecipient());
                            ThemisApplication.getInstance().getSettings().setEmailRecipient(recipient);
                            manual = true;
                        }
                        if (recipient == null) {
                            return;
                        }
                        CmsObservation obs = pdf.setSingleObservation(obsId);
                        String filename = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)project.getTimeZone());
                        File pdffile = new File(folder, filename + "_" + obsId + ".pdf");
                        pdf.exportToPdf(pdffile, rep, project.getUser());
                        String fullnumber = "[" + obs.getLocation().getFullNumber() + "." + obs.getAttributeValue("number") + "]";
                        String obsTitle = fullnumber + " " + obs.getTitle();
                        String subject = "THEMIS - " + obsTitle;
                        String body = ImapHelper.generateMessageBody(projectUUID.toString(), obsId + "");
                        new EmailSendThread(subject, body).setServer(smtp, port, encrypt).addRecipient(recipient).setFrom(emailFrom).setAuthentication(MailAuthenticator.getInstance().getPasswordAuthentication()).addAttachment(pdffile).send(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, (String)bundle.getString("email.sending.text"));
        }
    }

    public static boolean authenticate() {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        if (!MailAuthenticator.getInstance().isAuthenticated()) {
            SecureEmailAuthenticationPanel panel = new SecureEmailAuthenticationPanel();
            if (Dialogs.getInstance().showDialog(panel, project.getResourceText("MailAuthenticator.dialog.text"), new String[]{project.getResourceText("core.text.ok"), project.getResourceText("core.text.cancel")}) == 0) {
                MailAuthenticator.getInstance().authenticate(panel.getUser(), panel.getPassword());
            }
        }
        return MailAuthenticator.getInstance().isAuthenticated();
    }

    private static void sendEmailWithMailProgram(PdfExportBase pdf, CmsReport rep, CmsObservation obs, UUID projectUUID, boolean allObsInOneEmail) throws MessagingException, IOException {
        boolean isSingle;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        File folder = project.getTempfileLocation();
        ArrayList elementIds = pdf.getElementList();
        if (elementIds == null || elementIds.isEmpty()) {
            return;
        }
        String recipient = null;
        long obsId = -1L;
        String obsIdString = "";
        boolean bl = isSingle = !allObsInOneEmail || elementIds.size() == 1;
        if (isSingle) {
            obsId = (Long)elementIds.get(0);
            recipient = ImapHelper.getEmailFromObservation(obsId);
            obsIdString = "_" + obsId;
        } else {
            recipient = ImapHelper.getEmailFromObservation(elementIds);
        }
        String filename = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)project.getTimeZone()) + obsIdString;
        File pdffile = new File(folder, filename + ".pdf");
        pdf.exportToPdf(pdffile, rep, project.getUser());
        String subject = "THEMIS - ";
        if (isSingle && obs != null) {
            String fullnumber = "[" + obs.getLocation().getFullNumber() + "." + obs.getAttributeValue("number") + "]";
            String obsTitle = fullnumber + " " + obs.getTitle();
            subject = "THEMIS - " + obsTitle;
        } else {
            subject = subject + project.getProjectElement().getTitle();
        }
        String body = "";
        body = isSingle ? ImapHelper.generateMessageBody(projectUUID.toString(), obsId + "") : "Informationen aus THEMIS.";
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject(subject);
        message.setHeader("X-Unsent", "1");
        if (recipient != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)body, "text/html");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(pdffile);
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName(pdffile.getName());
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
        File emailfile = new File(folder, filename + ".eml");
        FileOutputStream fos = new FileOutputStream(emailfile);
        message.writeTo((OutputStream)fos);
        fos.close();
        Desktop dt = Desktop.getDesktop();
        dt.open(emailfile);
    }

    private static String getEmailFromObservation(long obsId) {
        String email;
        long contactId;
        CmsCompany company;
        ThemisProject project = ThemisApplication.getInstance().getProject();
        CmsObservation obs = (CmsObservation)project.loadElement(obsId, project.getUser());
        RelationAttribute rel = obs.getRelationAttribute("responsible");
        if (rel != null && rel.hasValue() && (company = (CmsCompany)project.loadElement(contactId = rel.getFirstElementId(), project.getUser())) != null && (email = company.getAttributeValue("email")) != null && !email.isEmpty() && email.contains("@")) {
            return email;
        }
        return null;
    }

    private static String getEmailFromObservation(List<Long> ids) {
        ThemisProject project = ThemisApplication.getInstance().getProject();
        ArrayList companyIds = project.getDatastorage().getRelationIds(ids, "observationcompany", true);
        if (companyIds.size() == 1) {
            String email = project.getDatastorage().getElementAttribute(((Long)companyIds.get(0)).longValue(), "email");
            return email;
        }
        return null;
    }

    public static String generateMessageBody(String projectUUID, String obsId) {
        StringBuilder signature = new StringBuilder("");
        InputStream is = ImapHelper.class.getResourceAsStream("/at/grid/themis/email/media/signature.html");
        try (Scanner scanner = new Scanner(is, "UTF-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                signature.append(line);
            }
            scanner.close();
            is.close();
        }
        catch (Exception e) {
            ThemisLogger.logger.warning("Could not read THEMIS signature: " + e.getLocalizedMessage());
        }
        String body = signature.toString();
        body = body.replace("#!#project-uuid#!#", projectUUID);
        body = body.replace("#!#observation-id#!#", obsId);
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> readEmails(String imapServer, MailAuthenticator authenticator, int port) throws MessagingException, IOException {
        ArrayList<Message> themisMessages = null;
        Properties props = System.getProperties();
        props.setProperty("mail.store.protocol", "imaps");
        props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.imap.socketFactory.fallback", "false");
        props.setProperty("mail.imap.ssl.enable", "true");
        props.setProperty("mail.imap.socketFactory.port", port + "");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)authenticator);
        try (Store store = session.getStore("imaps");){
            System.out.println("Connecting to IMAP server: " + imapServer);
            try {
                store.connect(imapServer, port, null, null);
            }
            catch (AuthenticationFailedException ex) {
                authenticator.resetAuthentication();
                List<Message> list = null;
                store.close();
                return list;
            }
            Folder root = store.getDefaultFolder();
            Folder[] folders = root.list();
            System.out.println("Select a folder");
            for (int i = 0; i < folders.length; ++i) {
                System.out.println("\t" + folders[i].getName());
            }
            String folderName = "INBOX";
            IMAPFolder folder = (IMAPFolder)store.getFolder(folderName);
            long afterFolderSelectionTime = System.nanoTime();
            boolean totalNumberOfMessages = false;
            try {
                if (!folder.isOpen()) {
                    folder.open(1);
                }
                System.out.println("Anzahl Messages: " + folder.getMessageCount());
                Flags seen = new Flags(Flags.Flag.SEEN);
                FlagTerm unseenFlagTerm = new FlagTerm(seen, false);
                Message[] unseenMessages = folder.search((SearchTerm)unseenFlagTerm);
                themisMessages = new ArrayList<Message>();
                for (Message msg : unseenMessages) {
                    String subj = msg.getSubject();
                    System.out.println("\t" + folder.getUID(msg) + "\t" + Util.formatDate((Date)msg.getReceivedDate(), (String)Util.DATETIME_READ, (TimeZone)TimeZone.getDefault()) + "\t" + msg.getSubject());
                    if (subj == null) {
                        boolean bl = true;
                        continue;
                    }
                    if (!subj.contains("THEMIS")) continue;
                    themisMessages.add(msg);
                }
                themisMessages.sort(new Comparator<Message>(){

                    @Override
                    public int compare(Message o1, Message o2) {
                        if (o2 == null) {
                            return -1;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        try {
                            if (o2.getSentDate() == null) {
                                return -1;
                            }
                            if (o1.getSentDate() == null) {
                                return 1;
                            }
                            return o2.getSentDate().compareTo(o1.getSentDate());
                        }
                        catch (MessagingException messagingException) {
                            return 0;
                        }
                    }
                });
            }
            finally {
                if (folder.isOpen()) {
                    folder.close(true);
                }
            }
        }
        return themisMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveParts(Object content, String filename) throws IOException, MessagingException {
        OutputStream out = null;
        InputStream in = null;
        try {
            if (content instanceof Multipart) {
                Multipart multi = (Multipart)content;
                int parts = multi.getCount();
                for (int j = 0; j < parts; ++j) {
                    int k;
                    MimeBodyPart part = (MimeBodyPart)multi.getBodyPart(j);
                    if (part.getContent() instanceof Multipart) {
                        ImapHelper.saveParts(part.getContent(), part.getFileName());
                        continue;
                    }
                    String extension = "";
                    if (part.isMimeType("text/html")) {
                        extension = "html";
                        continue;
                    }
                    extension = part.isMimeType("text/plain") ? "txt" : part.getDataHandler().getName();
                    filename = filename + "." + extension;
                    filename = filename.replace(" ", "_");
                    System.out.println("... " + filename);
                    File outFile = new File(ThemisApplication.getInstance().getProject().getTempfileLocation(), filename);
                    out = new FileOutputStream(outFile);
                    System.out.println(outFile.getAbsolutePath());
                    in = part.getInputStream();
                    while ((k = in.read()) != -1) {
                        out.write(k);
                    }
                    out.flush();
                    out.close();
                    in.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static Email saveEmail(Message message, String downloadDir) {
        try {
            Address[] toArray;
            Email email = new Email();
            email.from = ((InternetAddress)message.getFrom()[0]).getAddress();
            for (Address to : toArray = message.getRecipients(Message.RecipientType.TO)) {
                email.to.add(to.toString());
            }
            Address[] ccArray = null;
            try {
                ccArray = message.getRecipients(Message.RecipientType.CC);
            }
            catch (Exception e) {
                ccArray = null;
            }
            if (ccArray != null) {
                for (Address c : ccArray) {
                    email.cc.add(c.toString());
                }
            }
            email.subject = message.getSubject();
            email.received = message.getReceivedDate() != null ? message.getReceivedDate() : new Date();
            email.body = "";
            Object content = message.getContent();
            if (content instanceof String) {
                email.body = (String)content;
            } else if (content instanceof Multipart) {
                Multipart mp = (Multipart)content;
                for (int j = 0; j < mp.getCount(); ++j) {
                    MimeBodyPart mbp;
                    String disposition;
                    BodyPart part = mp.getBodyPart(j);
                    String text = ImapHelper.getText((Part)part);
                    if (text != null) {
                        email.body = email.body + text;
                    }
                    if ((disposition = part.getDisposition()) == null || !disposition.equals("attachment") && !disposition.equals("inline") || (mbp = (MimeBodyPart)part).isMimeType("text/plain")) continue;
                    EmailAttachment attachment = new EmailAttachment();
                    attachment.name = ImapHelper.decodeName(part.getFileName());
                    File savedir = new File(downloadDir);
                    savedir.mkdirs();
                    File savefile = new File(downloadDir, attachment.name);
                    attachment.path = savefile.getAbsolutePath();
                    attachment.size = ImapHelper.saveFile(savefile, (Part)part);
                    email.attachments.add(attachment);
                }
            }
            try {
                message.setFlag(Flags.Flag.SEEN, true);
            }
            catch (Exception e) {
                ThemisLogger.logger.severe("Could not set email SEEN flag: " + e.getLocalizedMessage());
            }
            return email;
        }
        catch (Exception e) {
            ThemisLogger.logger.severe("Could not save email: " + e.getLocalizedMessage());
            return null;
        }
    }

    private static String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            return (String)p.getContent();
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                String s;
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text != null || (s = ImapHelper.getText((Part)bp)) == null) continue;
                    text = s;
                    continue;
                }
                if (bp.isMimeType("text/html")) {
                    s = ImapHelper.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return ImapHelper.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = ImapHelper.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public static String decodeName(String name) throws Exception {
        if (name == null || name.length() == 0) {
            return "unknown";
        }
        String ret = URLDecoder.decode(name, "UTF-8");
        ret = ret.replaceAll("=\\?utf-8\\?q\\?", "");
        ret = ret.replaceAll("\\?=", "");
        ret = ret.replaceAll("=20", " ");
        return ret;
    }

    public static int saveFile(File saveFile, Part part) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(saveFile));
        byte[] buff = new byte[2048];
        InputStream is = part.getInputStream();
        int ret = 0;
        int count = 0;
        while ((ret = is.read(buff)) > 0) {
            bos.write(buff, 0, ret);
            count += ret;
        }
        bos.close();
        is.close();
        return count;
    }
}

