/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentPagebreak;
import at.grid.themis.ontology.report.PdfContentParagraph;
import at.grid.themis.ontology.report.PdfContentSignature;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.PdfContentStandardTableOpen;
import at.grid.themis.ontology.report.PdfContentTitlepage;
import at.grid.themis.ontology.report.pdf.PdfLayoutExporter;
import java.io.File;
import java.util.Date;
import java.util.ResourceBundle;

public class ImapHelper2 {
    public static void sendEmail() {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        ResourceBundle bundle = ResourceBundle.getBundle("/at/grid/themis/email/Bundle");
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)ThemisApplication.getInstance()) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)ThemisApplication.getInstance())) {
            return;
        }
        if (!project.getSelectionManager().hasSelectedObservationIds()) {
            Dialogs.getInstance().showWarningDialog(bundle.getString("SendEmailAction.selectObs.text"));
            return;
        }
        CmsReport rep = new CmsReport();
        rep.exportImages = CmsReport.ImageIntegration.ALL;
        rep.planIconSize = 30;
        rep.templatePdfLayout.clear();
        rep.templatePdfLayout.add(new PdfContentTitlepage());
        rep.templatePdfLayout.add(new PdfContentHeading1().setText("Kontrollen und Feststellungen"));
        rep.templatePdfLayout.add(new PdfContentStandardTable());
        rep.templatePdfLayout.add(new PdfContentPagebreak());
        rep.templatePdfLayout.add(new PdfContentHeading1().setText("Offene M\u00e4ngel und Aufgaben"));
        rep.templatePdfLayout.add(new PdfContentStandardTableOpen());
        rep.templatePdfLayout.add(new PdfContentPagebreak());
        if (rep.hasSignature()) {
            rep.templatePdfLayout.add(new PdfContentHeading1().setText("Unterschriften"));
            rep.templatePdfLayout.add(new PdfContentParagraph().setText("Dieser Bericht wurde in bestem Wissen und Gewissen angefertigt und wird als vollst\u00e4ndig best\u00e4tigt."));
            rep.templatePdfLayout.add(new PdfContentSignature());
        }
        rep.contentType = CmsReport.Content.SELECTION;
        rep.exportImages = CmsReport.ImageIntegration.ALL;
        rep.planIconSize = 30;
        PdfLayoutExporter pdf = new PdfLayoutExporter(rep);
        File folder = project.getTempfileLocation();
        String filename = Long.toString(new Date().getTime()) + ".pdf";
        File pdffile = new File(folder, filename);
        pdf.exportToPdf(pdffile, rep, project.getUser());
    }
}

