/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.themis.application.communication.email.Email;
import at.grid.themis.application.communication.email.ImapHelper;
import at.grid.themis.application.communication.email.MailAuthenticator;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisLogger;
import com.sun.mail.imap.IMAPFolder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.openide.util.Exceptions;

public class ImapMessageLoader {
    private static final int NUM_MESSAGES = 20;
    private IMAPFolder folder;
    private Store store;
    private boolean isConnected = false;
    private Map<Long, Email> loadedMails = new HashMap<Long, Email>();
    private Map<Long, Message> unloadedMails = new HashMap<Long, Message>();
    private ThemisApplication app = ThemisApplication.getInstance();

    public ImapMessageLoader() {
        this.connect();
    }

    private void connect() {
        String imapServer = this.app.getConfiguration("system.email.imap");
        int port = Integer.parseInt(this.app.getConfiguration("system.email.imap.port", "993"));
        int encrypt = Integer.parseInt(this.app.getConfiguration("system.email.imap.encrypt", "0"));
        Properties props = System.getProperties();
        props.setProperty("mail.store.protocol", "imaps");
        props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.imap.socketFactory.fallback", "false");
        switch (encrypt) {
            case 0: {
                break;
            }
            case 1: {
                props.setProperty("mail.imap.starttls.enable", "true");
                break;
            }
            default: {
                props.setProperty("mail.imap.ssl.enable", "true");
            }
        }
        props.setProperty("mail.imap.socketFactory.port", port + "");
        Session session = Session.getInstance((Properties)props, (Authenticator)MailAuthenticator.getInstance());
        try {
            this.store = session.getStore("imaps");
            System.out.println("Connecting to IMAP server: " + imapServer);
            this.store.connect(imapServer, port, null, null);
            this.isConnected = true;
        }
        catch (AuthenticationFailedException ex) {
            MailAuthenticator.getInstance().resetAuthentication();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void disconnect() {
        try {
            if (this.folder != null && this.folder.isOpen()) {
                this.folder.close(true);
            }
            if (this.store != null) {
                this.store.close();
            }
        }
        catch (MessagingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Map<Long, Message> getMessages() {
        return this.getMessages(true);
    }

    public Map<Long, Message> getMessages(boolean seen) {
        if (!this.isConnected) {
            return null;
        }
        this.unloadedMails.clear();
        HashMap<Long, Object> themisMessages = new HashMap<Long, Message>();
        try {
            int msgCount;
            Folder root = this.store.getDefaultFolder();
            Folder[] folders = root.list();
            this.folder = (IMAPFolder)this.store.getFolder("INBOX");
            long afterFolderSelectionTime = System.nanoTime();
            boolean totalNumberOfMessages = false;
            if (!this.folder.isOpen()) {
                this.folder.open(1);
            }
            int end = msgCount = this.folder.getMessageCount();
            int start = Math.max(1, end - 20);
            Message[] messages = this.folder.getMessages(start, end);
            themisMessages = new HashMap();
            for (Message msg : messages) {
                long uid = this.folder.getUID(msg);
                this.unloadedMails.put(uid, msg);
                String subj = msg.getSubject();
                if (subj == null) {
                    boolean bl = true;
                    continue;
                }
                if (!subj.toLowerCase().contains("themis")) continue;
                themisMessages.put(uid, msg);
            }
        }
        catch (MessagingException ex) {
            ThemisLogger.logger.severe("Could not save email: " + ex.getLocalizedMessage());
        }
        return themisMessages;
    }

    public Comparator<Message> msgComparator() {
        return new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                if (o2 == null) {
                    return -1;
                }
                if (o1 == null) {
                    return 1;
                }
                try {
                    if (o2.getSentDate() == null) {
                        return -1;
                    }
                    if (o1.getSentDate() == null) {
                        return 1;
                    }
                    return o2.getSentDate().compareTo(o1.getSentDate());
                }
                catch (MessagingException messagingException) {
                    return 0;
                }
            }
        };
    }

    public Email saveMessage(long msgUID) {
        try {
            Message message;
            Email email;
            if (this.loadedMails.containsKey(msgUID)) {
                return this.loadedMails.get(msgUID);
            }
            if (!this.isConnected || !this.store.isConnected()) {
                this.connect();
            }
            if (!this.folder.isOpen()) {
                this.folder = (IMAPFolder)this.store.getFolder("INBOX");
                this.folder.open(1);
            }
            if ((email = ImapHelper.saveEmail(message = this.folder.getMessageByUID(msgUID), ThemisApplication.getInstance().getProject().getTempfileLocation().getAbsolutePath())) != null) {
                this.loadedMails.put(msgUID, email);
            }
            return email;
        }
        catch (Exception e) {
            ThemisLogger.logger.severe("Could not save email: " + e.getLocalizedMessage());
            return null;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }
}

