/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElementSummary;
import at.grid.themis.application.communication.email.ImapHelper;
import at.grid.themis.application.communication.email.MailAuthenticator;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.attribute.ThemisAttribute;
import at.grid.themis.ontology.element.CmsHistory;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.report.PdfContentHeaderProject;
import at.grid.themis.ontology.report.PdfContentHeading1;
import at.grid.themis.ontology.report.PdfContentStandardTable;
import at.grid.themis.ontology.report.PdfContentTitle;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.themis.ontology.report.pdf.PdfLayoutExporter;
import at.grid.themis.ontology.util.EmailSendThread;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.mail.EmailException;

public class ThemisEmailSender {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private boolean asHtml = false;
    boolean directDelivery = false;
    String subject = "THEMIS (#!#Projekttitel#!#)";
    String body = "Diese E-Mail wurde von THEMIS gesendet:\n\nProjekt: #!#Projekttitel#!# (#!#Projektdatei#!#)\n\nGegenstand: #!#G.Titel#!#\n#!#G.Attribute#!#\n\nBeobachtung: #!#B.Titel#!#\n#!#B.Attribute#!#";
    Placeholder placeholder = new Placeholder(null);
    ArrayList<String> recipients = new ArrayList();

    public ThemisEmailSender setAsHtml() {
        this.asHtml = true;
        return this;
    }

    public ThemisEmailSender setDirectDelivery() {
        this.directDelivery = true;
        return this;
    }

    public ThemisEmailSender setSubjectTemplate(String s) {
        this.subject = s;
        return this;
    }

    public ThemisEmailSender setBodyTemplate(String b) {
        this.body = b;
        return this;
    }

    public ThemisEmailSender addRecipient(String address) {
        this.recipients.add(address);
        return this;
    }

    public ThemisEmailSender addRecipients(List<String> addresses) {
        this.recipients.addAll(addresses);
        return this;
    }

    public void sendObservations(List<Long> ids, ProgressHandler ph) {
        if (!this.project.isOpen()) {
            return;
        }
    }

    public void sendObservationWithTemplate(long id, ProgressHandler ph) {
        if (!this.project.isOpen()) {
            return;
        }
        CmsObservation o = (CmsObservation)this.project.loadElement(id, this.project.getUser());
        CmsLocation l = o == null ? null : o.getLocation();
        CmsHistory h = o == null ? null : o.getLatestHistory();
        String subjectFilled = this.placeholder.apply(this.subject, l, o, h, null);
        String bodyFilled = this.placeholder.apply(this.body, l, o, h, null);
        if (this.asHtml) {
            bodyFilled = this.createHtml(bodyFilled);
        }
        this.sendMail(subjectFilled, bodyFilled, null, null);
    }

    public void sendObservation(long id, ProgressHandler ph) {
        if (!this.project.isOpen()) {
            return;
        }
        CmsObservation o = (CmsObservation)this.project.loadElement(id, this.project.getUser());
        String msgSubject = this.placeholder.apply(this.subject, o.getLocation(), o, o.getLatestHistory(), null);
        String msgBody = this.asHtml ? "<p>Diese Nachricht wurde aus THEMIS erzeugt</p>" + o.toHtml() : "Diese Nachricht wurde aus THEMIS erzeugt\n\n" + o.toString("", "\n", true);
        ArrayList<File> msgAttachments = new ArrayList<File>();
        msgAttachments.add(o.getLocation().createPlanSnippetFile());
        for (UploadItem item : o.getLatestUploads(true)) {
            msgAttachments.add(item.getFile());
        }
        Properties mailHeader = new Properties();
        mailHeader.setProperty("Summary", o.getSummary());
        mailHeader.setProperty("Component", o.getLocation().getTitle());
        this.sendMail(msgSubject, msgBody, msgAttachments, mailHeader);
    }

    private void sendMail(String msgSubject, String msgBody, ArrayList<File> msgAttachments, Properties mailHeader) {
        EmailSendThread email = this.app.getSettings().getEmailSender();
        if (this.asHtml) {
            email.setMessageType("text/html");
        }
        for (String recipient : this.recipients) {
            email.addRecipient(recipient);
        }
        email.setBcc(email.getFrom());
        if (msgAttachments != null) {
            for (File f : msgAttachments) {
                if (f == null || !f.isFile()) continue;
                email.addAttachment(f);
            }
        }
        email.addMailHeader(mailHeader);
        email.setSubject(msgSubject).setMessage(msgBody);
        if (this.directDelivery) {
            if (!ImapHelper.authenticate()) {
                return;
            }
            email.setAuthentication(MailAuthenticator.getInstance().getPasswordAuthentication()).send2(false);
        } else {
            File folder = this.project.getTempfileLocation();
            String filename = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone());
            File f = new File(folder, filename + ".eml");
            f.delete();
            email.saveToFile(f);
            if (f.isFile()) {
                Desktop dt = Desktop.getDesktop();
                try {
                    dt.open(f);
                }
                catch (IOException ex) {
                    this.app.getDialog().showErrorDialog("E-Mail konnte nicht geladen werden.");
                }
            } else {
                this.app.getDialog().showErrorDialog("E-Mail konnte nicht erstellt werden.");
            }
        }
    }

    public void sendSelectedObservations(ProgressHandler p, String ... recipients) throws EmailException, IOException, FileNotFoundException, MessagingException {
        if (!this.project.isOpen()) {
            return;
        }
        ArrayList obsIds = this.project.getSelectionManager().getSelectedObservationIds();
        if (obsIds == null || obsIds.isEmpty()) {
            return;
        }
        String subject = this.placeholder.apply(this.subject);
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(mailSession);
        message.setHeader("X-Unsent", "1");
        message.setSubject(subject);
        message.setRecipients(Message.RecipientType.TO, String.join((CharSequence)",", Arrays.asList(recipients)));
        MimeMultipart multipart = new MimeMultipart();
        if (this.asHtml) {
            MimeBodyPart body = new MimeBodyPart();
            String html = this.createHtml(obsIds);
            body.setContent((Object)html, "text/html");
            multipart.addBodyPart((BodyPart)body);
        } else {
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)"Anhang beachten!", "text/plain");
            multipart.addBodyPart((BodyPart)body);
            File pdfFile = this.createPdfReport(obsIds);
            FileDataSource source = new FileDataSource(pdfFile);
            MimeBodyPart pdfBodyPart = new MimeBodyPart();
            pdfBodyPart.setDataHandler(new DataHandler((DataSource)source));
            pdfBodyPart.setFileName(pdfFile.getName());
            multipart.addBodyPart((BodyPart)pdfBodyPart);
        }
        message.setContent((Multipart)multipart);
        this.openInMailProgram(p, message);
    }

    public void openInMailProgram(ProgressHandler p, MimeMessage email) throws FileNotFoundException, IOException, MessagingException {
        File folder = this.project.getTempfileLocation();
        String filename = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone());
        File file = new File(folder, filename + ".eml");
        try (FileOutputStream fos = new FileOutputStream(file);){
            email.writeTo((OutputStream)fos);
        }
        Desktop dt = Desktop.getDesktop();
        dt.open(file);
    }

    private File createPdfReport(ArrayList<Long> obsIds) {
        File folder = this.project.getTempfileLocation();
        String filename = Util.formatDate((Date)new Date(), (String)Util.DATETIME_FILE, (TimeZone)this.project.getTimeZone());
        File file = new File(folder, filename + ".pdf");
        CmsReport rep = new CmsReport();
        rep.setReportFromXml(this.app.getSettings().getDefaultReportLayout());
        rep.contentType = CmsReport.Content.SELECTION;
        rep.exportImages = CmsReport.ImageIntegration.ALL;
        rep.templatePdfLayout.add(new PdfContentTitle());
        rep.templatePdfLayout.add(new PdfContentHeaderProject());
        rep.templatePdfLayout.add(new PdfContentHeading1().setText("Kontrollen und Feststellungen"));
        rep.templatePdfLayout.add(new PdfContentStandardTable());
        PdfLayoutExporter pdf = new PdfLayoutExporter(rep);
        pdf.setObservations(obsIds);
        pdf.exportToPdf(file, rep, this.project.getUser());
        return file;
    }

    public String createHtml(String txt) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<style>");
        sb.append("table {\n  width: 100%;\n  text-align: left;\n  border-spacing: 0px;\n}\ntd, th {\n  border: 1px solid;\n  padding: 4px 8px;\n  vertical-align: top;\n}");
        sb.append("</style>");
        sb.append("<body>");
        sb.append("<pre>");
        sb.append(txt);
        sb.append("</pre>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private String createHtml(ArrayList<Long> obsIds) {
        ArrayList<ThemisAttribute> ignoreAtts = new ArrayList<ThemisAttribute>();
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("donedate"));
        ignoreAtts.add(this.app.getSettings().getObservationAttribute("type"));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<style>");
        sb.append("table {\n  width: 100%;\n  text-align: left;\n  border-spacing: 0px;\n}\ntd, th {\n  border: 1px solid;\n  padding: 4px 8px;\n  vertical-align: top;\n}");
        sb.append("</style>");
        sb.append("<body>");
        sb.append("Diese E-Mail wurde aus THEMIS erzeugt:<br><br><br>");
        sb.append("<table>");
        sb.append("<tr style=\"background-color: lightgrey;\">");
        sb.append("<th>Pos</th>");
        sb.append("<th>Gegenstand/Plan, Beobachtung</th>");
        sb.append("<th>Datum</th>");
        sb.append("<th>Plan</th>");
        sb.append("<th>Status</th>");
        sb.append("</tr>");
        for (Long id : obsIds) {
            CmsObservation o = (CmsObservation)this.project.loadElement(id.longValue(), this.project.getUser());
            CmsLocation l = (CmsLocation)o.getRelationAttribute("location").getElementByIndex(0).getElement();
            CmsPlan p = (CmsPlan)l.getRelationAttribute("plan").getElementByIndex(0).getElement();
            sb.append("<tr>");
            sb.append("<td style=\"width: 50px; text-align: center\">");
            sb.append(l.getAttributeValue("number") + "." + o.getAttributeValue("number"));
            sb.append("</td>");
            sb.append("<td>");
            sb.append("<b>" + l.getTitle() + " / " + p.getTitle() + ", " + o.getTitle() + "</b>");
            sb.append("<br>");
            sb.append("<br>");
            sb.append(o.toStringWithIgnore("<br>", "<br>", false, ignoreAtts));
            sb.append("</td>");
            sb.append("<td style=\"width: 200px;\">");
            sb.append("</td>");
            sb.append("<td style=\"width: 250px; text-align: center\">");
            String sImg = "";
            File snipped = new File(ThemisApplication.getInstance().getProject().getPlansnippetLocation(), l.getId() + "_" + 300 + ".jpg");
            if (snipped.exists()) {
                try {
                    byte[] bytes = Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)snipped));
                    String b64 = new String(bytes, StandardCharsets.US_ASCII);
                    sImg = "<img width=\"250px\" src=\"data:image/jpg;base64, " + b64 + "\"/>";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sb.append(sImg);
            sb.append("</td>");
            sb.append("<td style=\"width: 200px;\">");
            sb.append("</td>");
            sb.append("</tr>");
            String img = "";
            for (CmsElementSummary s : o.getRelationAttribute("histories").getElements()) {
                if (s == null) continue;
                CmsHistory h = (CmsHistory)s.getElement();
                for (UploadItem item : h.getUploadAttribute("files").getAllUploadItems()) {
                    File file;
                    if (item == null || !(file = item.getFile()).exists()) continue;
                    try {
                        byte[] bytes = Base64.getEncoder().encode(FileUtils.readFileToByteArray((File)file));
                        String b64 = new String(bytes, StandardCharsets.US_ASCII);
                        img = img + "<img style=\"padding-right: 10px;\" height=\"200px\" src=\"data:image/jpg;base64, " + b64 + "\"/>";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (img.trim().isEmpty()) continue;
            sb.append("<tr>");
            sb.append("<td colspan=\"5\">");
            sb.append(img);
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        sb.append("<br><br>");
        sb.append("</body>");
        sb.append("</html>");
        String html = sb.toString();
        return html;
    }
}

