/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.application.communication.email;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.communication.email.Email;
import at.grid.themis.application.communication.email.EmailAttachment;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.SoftBevelBorder;
import org.jsoup.Jsoup;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ViewEmailPanel
extends JPanel {
    ResourceBundle bundle = ResourceBundle.getBundle("/at/grid/themis/application/communication/email/Bundle");
    JDialog dlg;
    private JTextPane fldContent;
    private JLabel fldFrom;
    private JLabel fldSubject;
    private JLabel fldTime;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JLabel lblAttachments;
    private JLabel lblContent;
    private JLabel lblFrom;
    private JLabel lblSubject;
    private JLabel lblTime;
    private JList<EmailAttachment> lstAttachments;

    public static void showDialog(Email email) {
        JDialog dlg;
        ViewEmailPanel panel = new ViewEmailPanel(email);
        panel.dlg = dlg = new JDialog();
        THEMIS.setDialogIcon(dlg);
        dlg.setTitle(panel.bundle.getString("ViewEmailPanel.dialogTitle.text"));
        dlg.setModal(true);
        dlg.setContentPane(panel);
        dlg.setResizable(true);
        dlg.pack();
        dlg.setDefaultCloseOperation(2);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
    }

    public ViewEmailPanel(Email email) {
        this.initComponents();
        this.fldFrom.setText(email.from);
        this.fldTime.setText(email.received.toString());
        this.fldSubject.setText(email.subject);
        DefaultListModel<EmailAttachment> model = new DefaultListModel<EmailAttachment>();
        for (EmailAttachment at : email.attachments) {
            model.addElement(at);
        }
        this.lstAttachments.setModel(model);
        String content = ViewEmailPanel.getContentAsText(email.body);
        this.fldContent.getDocument().putProperty("__EndOfLine__", "\n");
        this.fldContent.setText(content);
    }

    public static String getContentAsText(String html) {
        String[] split;
        html = html.replaceAll("\r\n", "br2n");
        String htmlLB = Jsoup.parse(html.replaceAll("(?i)<br[^>]*>", "br2n")).text();
        htmlLB = Jsoup.parse(htmlLB.replaceAll("(?i)</p[^>]*>", "br2n")).text();
        htmlLB = Jsoup.parse(htmlLB.replaceAll("(?i)<div[^>]*>", "br2n")).text();
        String parsed = Jsoup.parse(htmlLB).text();
        if ((parsed = parsed.replaceAll("br2n", "\n")).contains("----")) {
            parsed = parsed.split("----")[0];
        }
        StringBuilder sb = new StringBuilder();
        for (String s : split = parsed.split("\n")) {
            if (s.startsWith(">")) continue;
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void initComponents() {
        this.lblFrom = new JLabel();
        this.fldFrom = new JLabel();
        this.lblTime = new JLabel();
        this.fldTime = new JLabel();
        this.lblSubject = new JLabel();
        this.fldSubject = new JLabel();
        this.lblAttachments = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstAttachments = new JList();
        this.lblContent = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.fldContent = new JTextPane();
        this.jButton1 = new JButton();
        this.setMinimumSize(new Dimension(500, 400));
        this.setPreferredSize(new Dimension(500, 400));
        this.setLayout(new GridBagLayout());
        this.lblFrom.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblFrom, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.lblFrom.text"));
        this.lblFrom.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.lblFrom, gridBagConstraints);
        this.fldFrom.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.fldFrom, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.fldFrom.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.fldFrom, gridBagConstraints);
        this.lblTime.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblTime, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.lblTime.text"));
        this.lblTime.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.lblTime, gridBagConstraints);
        this.fldTime.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.fldTime, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.fldTime.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.fldTime, gridBagConstraints);
        this.lblSubject.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblSubject, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.lblSubject.text"));
        this.lblSubject.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.lblSubject, gridBagConstraints);
        this.fldSubject.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.fldSubject, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.fldSubject.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.fldSubject, gridBagConstraints);
        this.lblAttachments.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblAttachments, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.lblAttachments.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.lblAttachments, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(150, 75));
        this.jScrollPane1.setPreferredSize(new Dimension(150, 75));
        this.lstAttachments.setFont(THEMIS.fontList);
        this.lstAttachments.setSelectionMode(0);
        this.lstAttachments.setMaximumSize(new Dimension(99999, 999999));
        this.lstAttachments.setMinimumSize(new Dimension(10, 10));
        this.lstAttachments.setPreferredSize(new Dimension(10, 10));
        this.lstAttachments.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ViewEmailPanel.this.lstAttachmentsMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstAttachments);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblContent.setFont(THEMIS.fontLabelBold);
        Mnemonics.setLocalizedText((JLabel)this.lblContent, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.lblContent.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.lblContent, gridBagConstraints);
        this.fldContent.setEditable(false);
        this.fldContent.setFont(THEMIS.fontLabel);
        this.jScrollPane3.setViewportView(this.fldContent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jButton1.setFont(THEMIS.fontLabel);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/application/media/confirm24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ViewEmailPanel.class, (String)"ViewEmailPanel.jButton1.text"));
        this.jButton1.setBorder(new SoftBevelBorder(0));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewEmailPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void lstAttachmentsMousePressed(MouseEvent evt) {
        EmailAttachment attachment;
        if (evt.getClickCount() == 2 && (attachment = this.lstAttachments.getSelectedValue()) != null) {
            Desktop dt = Desktop.getDesktop();
            try {
                dt.open(new File(attachment.path));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dlg.dispose();
    }
}

